proc AtAxis-type {} { return {creationCommand Widget}}
set wafeHelp(AtAxis) { The 'AtAxis' widget class is designed for numeric axes as part of
 the AtPlotter widget.  It provides simple linear spacing of tics
 and subtics and simple printf()-like tic labeling.  This class is
 only concerned with the user-space details of tic positions and tic
 labels.}

proc AtBarPlot-type {} { return {creationCommand Widget}}
set wafeHelp(AtBarPlot) { The AtBarPlot class provides simple bar plots. The X values of the
 bars are successive integers, and the Y values are given by
 application data.  Each bar on the plot can be outlined and/or
 filled.  The outlining is done using the resources inherited from
 the AtPlot class.  The filling can be in the same or a different
 colour, using one of 11 stipple patterns if required.}

proc AtBarPlotAttachData-type {} { return {function {} {in: AtBarPlotWidget} {in: [args]} {const: qBarPlotData} ## {bar plot widget} {floats}}}
set wafeHelp(AtBarPlotAttachData) { The command 'AtBarPlotAttachData' is used to specify the data
 points of an 'AtBarPlot' widget. Each data point is given as a
 single floating point value.}

proc AtBarPlotExtendData-type {} { return {function {} {in: AtBarPlotWidget} {in: [args]} {const: qBarPlotData} ## {bar plot widget} {floats}}}
set wafeHelp(AtBarPlotExtendData) { The command 'AtBarPlotExtendData' is used to add additional data
 points to an existing 'AtBarPlot' widget. Each data point is given
 as a single floating point value.}

proc AtLabelAxis-type {} { return {creationCommand Widget}}
set wafeHelp(AtLabelAxis) { The 'AtLabelAxis' widget class provides facilities for the
 application programmer to specify which integral values in the axis
 should have tics, and attach arbitrary labels to those tics.  The
 XtNticInterval resource will be set to 0, and no subtics will be
 generated.}

proc AtLabelAxisAttachData-type {} { return {function {void} {in: AtLabelAxisWidget} {in: [char *]} {const: sizeof(String)} {const: 1} {const: argc-2} ## {label axis wiget} {strings}}}
set wafeHelp(AtLabelAxisAttachData) { The command 'AtLabelAxisAttachData' us used to specify the labels
 of an 'AtLabelAxis' widget.}

proc AtLinePlot-type {} { return {creationCommand Widget}}
set wafeHelp(AtLinePlot) { The 'AtLinePlot' class is the simplest of the plotting classes in the
 AtPlotter widget set.  It's data points are drawn by connecting it
 with straight lines.}

proc AtLinePlotAttachData-type {} { return {function {} {in: AtLinePlotWidget} {in: [args]} {const: qLinePlotData} ## {line plot widget} {floats}}}
set wafeHelp(AtLinePlotAttachData) { The command 'AtLinePlotAttachData' can be used to specify the data
 points of an AtLinePlot widget. Each data point is specified as a
 single floating point number.}

proc AtLinePlotExtendData-type {} { return {function {} {in: AtLinePlotWidget} {in: [args]} {const: qLinePlotData} ## {bar plot widget} {floats}}}
set wafeHelp(AtLinePlotExtendData) { The command 'AtLinePlotExtendData' is used to add additional data
 points to an existing 'AtLinePlot' widget. Each data point is given
 as a single floating point value.}

proc AtPlotter-type {} { return {creationCommand Widget}}
set wafeHelp(AtPlotter) { The 'AtPlotter' widget class displays various plot types on a set
 of x-y axes.  Currently supported plots are line and bar plots.
 The axes are optionally labeled, the widget displays an optional
 title, and plots can be annotated with text.  There is an optional
 legend at the right or left hand side of the plot.  Two x axes and
 two y axes can be displayed each with a different range, and plots
 can be plotted against either x axis and either y axis.  The X axis
 is along the bottom, the X2 axis along the top.  The Y axis is
 along the left edge, the Y2 axis is along the right edge.
 Special percentcode subsititutions are performed for listed callbacks:
    %x: pixel x coordinate
        clickCallback, motionCallback
    %y: pixel y coordinate
        clickCallback, motionCallback
    %a: 1st axis x coordinate
        clickCallback, motionCallback
    %b: 1st axis y coordinate
        clickCallback, motionCallback
    %c: 2nd axis x coordinate
        clickCallback, motionCallback
    %d: 2nd axis y coordinate
        clickCallback, motionCallback
    %x: pixel x lower left
        dragCallback, slideCallback
    %y: pixel y lower left
        dragCallback, slideCallback
    %a: 1st axis x lower left
        dragCallback, slideCallback
    %b: 1st axis y lower left
        dragCallback, slideCallback
    %c: 2nd axis x lower left
        dragCallback, slideCallback
    %d: 2nd axis y lower left
        dragCallback, slideCallback
    %X: pixel x upper right
        dragCallback, slideCallback
    %Y: pixel y upper right
        dragCallback, slideCallback
    %A: 1st axis x upper right
        dragCallback, slideCallback
    %B: 1st axis y upper right
        dragCallback, slideCallback
    %C: 2nd axis x upper right
        dragCallback, slideCallback
    %D: 2nd axis y upper right
        dragCallback, slideCallback}

proc AtPlotterGeneratePostscript-type {} { return {function {void} {in: String} {in: (AtPlotterWidget)AtPlotterWidget} {in: String} {in: int} {in: int} {in: int} {in: int} {in: Boolean} ## {file name} {plotter widget} {title} {bounding box: x1} {bounding box: y1} {bounding box: x2} {bounding box: y2} {landscape}}}
set wafeHelp(AtPlotterGeneratePostscript) { The command 'AtPlotterGeneratePostscript' opens filename and writes
 the PostScript representation of plotter (2nd arguemnt) to the
 file.  The plotter will have a title as specified as the 3rd
 argument.  The representation will be drawn inside the bounding box
 described by (x1, y1) and (x2, y2).  If landscape is True, the
 plotter representation will be rotated and drawn in landscape mode.}

proc AtTextPlot-type {} { return {creationCommand Widget}}
set wafeHelp(AtTextPlot) { The 'AtTextPlot' widget class displays formatted text in an
 AtPlotter widget.  The text can be placed in the plotter widget in
 two ways: attached to a pair of real coordinates or attached to a
 pair of pixel coordinates.  When attached to a real point, the plot
 will "float" (i.e. if the coordinate scale changes, the plot will
 be drawn at the real points new location; this is controlled by the
 resource 'floatingPosition').  When attached to a pixel point, the
 plot will be drawn in that position even if the coordinate scale
 changes.  If the physical size of the plotter changes, the plot
 will be drawn such that it remains in the same relative position
 (percentage-wise).}

proc AtXYAxis-type {} { return {creationCommand Widget}}
set wafeHelp(AtXYAxis) { The 'AtXYAxis' widget class is designed for numeric axes as part of
 the AtPlotter widget.  It provides linear and logarithmic spacing
 of tics and subtics and simple printf()-like tic labeling.}

proc AtXYLinePlot-type {} { return {creationCommand Widget}}
set wafeHelp(AtXYLinePlot) { The 'AtXYLinePlot' widget class can be used to display an list of
 coordinate pairs in form of a line plot. 7 different line types, 12
 different line styles and 9 different marker types for the data
 points are supported.}

proc AtXYLinePlotAttachData-type {} { return {function {} {in: AtXYLinePlotWidget} {in: [args]} ## {AtXYLine plot widget} {pairs of floats (xfloat/yfloat)}}}
set wafeHelp(AtXYLinePlotAttachData) { The command 'AtXYLinePlotAttachData' can be used to set the plot
 data if the specified line plot widget. The specified coordinate
 pairs are of the form x-value/y-value. See also:
 'AtXYLinePlotExtendData'.}

proc AtXYLinePlotExtendData-type {} { return {function {} {in: AtXYLinePlotWidget} {in: [args]} ## {AtXYLine plot widget} {pairs of floats (xfloat/yfloat)}}}
set wafeHelp(AtXYLinePlotExtendData) { The command 'AtXYLinePlotExtendData' can be used to append the
 specified coordinate pairs (of the form x-value/y-value) to the
 plot data of the specified line plot widget and to update the
 plot. See also: AtXYLinePlotAttachData'.}

