proc isRealized-type {} { return {function {Boolean} {in: Widget} ## {Widget}}}
set wafeHelp(isRealized) {\
 The function 'isRealized' determines whether the specified widget
 has been realized (it is realized when it has a window assigned)}

proc isRealized {w} {
  return [string compare [window $w] 0]
}

proc isRealized-type {} { return {function {Boolean} {in: Widget} ## {Widget}}}
set wafeHelp(isRealized) {\
 The function 'isMapped' determines whether the specified widget
 is currently mapped to the screen (it might be viewable or not)}

proc isMapped {w} {
  return [string compare [mapState $w] IsUnmapped]
}


proc getDomainOfAttribute-type {} { return {function {String} {in: Widget} {in: String} ## {widget} {attribute}}}
set wafeHelp(getDomainOfAttribute) { \
 The function 'getDomainOfAttribute' returns the domain of the given
 attribute (2nd argument) for the specified widget (first
 argument). If the widget class does not have an attribute with the
 given name, or the domain cannot be obtained, an empty string is returned.}

proc getDomainOfAttribute {w attribute} {
  if [string compare "" [set type [getTypeOfAttribute $w $attribute]]] {
    return [getDomain $type]
  }
  return ""
}