/* treat me like a -*-c-*- program, treat me, treat me, treat me! */
#include <X11/Xaw/Panner.h>

/*      Function Name: PannerCallback
 *      Description: called when the panner has moved.
 *      Arguments: panner - the panner widget.
 *                 child - child to be moved.
 *                 report_ptr - the panner record.
 *      Returns: none.
 */

static void 
pannerCallbackProc(w, child, report_ptr)
Widget w;
XtPointer child, report_ptr;
    {
    Arg args[2];
    XawPannerReport *report = (XawPannerReport *) report_ptr;

    XtSetArg(args[0], XtNx, -report->slider_x);
    XtSetArg(args[1], XtNy, -report->slider_y);
    
    XtSetValues(child, args, 2);
    }


/*      Function Name: PortholeCallback
 *      Description: called when the porthole or its child has
 *                   changed 
 *      Arguments: porthole - the porthole widget.
 *                 panner_ptr - the panner widget.
 *                 report_ptr - the porthole record.
 *      Returns: none.
 */


static void 
portholeCallbackProc(w, panner_ptr, report_ptr)
Widget w;
XtPointer panner_ptr, report_ptr;
    {
    Arg args[10];
    Cardinal n = 0;
    XawPannerReport *report = (XawPannerReport *) report_ptr;
    Widget panner = (Widget) panner_ptr;

    XtSetArg(args[n], XtNsliderX, report->slider_x); n++;
    XtSetArg(args[n], XtNsliderY, report->slider_y); n++;
    if (report->changed != (XawPRSliderX | XawPRSliderY)) 
	{
        XtSetArg(args[n], XtNsliderWidth,  report->slider_width);  n++;
        XtSetArg(args[n], XtNsliderHeight, report->slider_height); n++;
        XtSetArg(args[n], XtNcanvasWidth,  report->canvas_width);  n++;
        XtSetArg(args[n], XtNcanvasHeight, report->canvas_height); n++; 
	}
    XtSetValues(panner, args, n);
    }


