#> The Commands described in this section are these introduced by
#> Motif Version 2.0. Note that in Wafe versions compiled with Motif 2.0
#> the commands from sections Motif 1.1 to 2.0 are available.

$PACKAGE = "MOTIF20";

#include <X11/Shell.h>
#include <Xm/RepType.h>
#include <Xm/Text.h>
#include <Xm/ScrolledW.h>

~handles 
	MOTIF20

~require
motif20.inc
	quark XmRSet
        quark XmRDynamicPixmap
	init wafeRegisterXpmTypeConverter(XmRDynamicPixmap, True);

# modifyVerify and valueChanged callback not handled bidirectionally yet for
# XmCSText, XmComboBox

~widgetClass 
XmCSText
	include <Xm/CSText.h>
        losingFocus|modifyVerify|motionVerify i XmTextPosition: \
                ((XmCSTextVerifyCallbackStruct *)callData)->currInsert \
			# position of insert cursor
        losingFocus|modifyVerify|motionVerify n XmTextPosition: \
                ((XmCSTextVerifyCallbackStruct *)callData)->newInsert \
			# new position of insert cursor
        losingFocus|modifyVerify f XmTextPosition: \
                ((XmCSTextVerifyCallbackStruct *)callData)->startPos \
			# startPos (from)
        losingFocus|modifyVerify t XmTextPosition: \
                ((XmCSTextVerifyCallbackStruct *)callData)-> endPos \
			# endPos (to)
        modifyVerify s EscapedString: \
                ((XmCSTextVerifyCallbackStruct *)callData)->text \
			# text

~pseudoWidgetClass 
XmScrolledCSText
	className XmCSText
	createCmd XmCreateScrolledCSText


~widgetClass 
XmComboBox
	include <Xm/ComboBox.h>
        selection s EscapedXmString: \
	    ((XmComboBoxCallbackStruct *)callData)->item_or_text # item or text
        selection p EscapedXmString: \
	    ((XmComboBoxCallbackStruct *)callData)->item_position # position


# widget list for container select callback struct not implemented yet

~widgetClass 
XmContainer
	include <Xm/Container.h>
        outlineChanged a WidgetID: \
	    (WidgetID)((XmContainerOutlineCallbackStruct *)callData)->item \
	                # widget id of affected item 

#define xmIconGadgetWidgetClass xmIconGadgetClass

~widgetClass 
XmIconGadget
	include <Xm/IconG.h>

~widgetClass 
XmNotebook
	include <Xm/Notebook.h>
        pageChanged p int: \
	    ((XmNotebookCallbackStruct *)callData)->page_number \
	                # page number of current page
        pageChanged i WidgetID: \
	    (WidgetID)((XmNotebookCallbackStruct *)callData)->page_widget \
	                # widget id of current page
        pageChanged P int: \
	    ((XmNotebookCallbackStruct *)callData)->prev_page_number \
	                # page number of previous page
        pageChanged I WidgetID: \
	    (WidgetID)((XmNotebookCallbackStruct *)callData)->prev_page_widget \
	                # widget id of previous page


~widgetClass 
XmSpinBox
	include <Xm/SpinB.h>
	modifyVerify|valueChanged s EscapedXmString: \
		((XmSpinBoxCallbackStruct *)callData)->value 	# string value
	modifyVerify|valueChanged a WidgetID: \
		(WidgetID) ((XmSpinBoxCallbackStruct *)callData)->widget \
			# widgetID of affected widget
	modifyVerify|valueChanged p int: \
		((XmSpinBoxCallbackStruct *)callData)->position \
			# position
	modifyVerify|valueChanged b int: \
		((XmSpinBoxCallbackStruct *)callData)->crossed_boundary \
			# crossed boundary

