$PACKAGE = "ATHENA"; $PREFIX = "Xaw";

~handles
	ATHENA
	XAW3D

~require
athena.inc
	quark jumpProc
	quark scrollProc
	quark radioData
	quark list
	quark longest
	conv XtREditMode  XtRString  None CvtEditTypeToString
	conv XtRAsciiType XtRString  None CvtAsciiTypeToString
	privateString AsciiTextWidget
	privateString ListWidget
	privateString PanedWidget
	privateString SimpleMenuWidget
	privateString TextSink
	privateString ToggleWidget
	privateString ViewportWidget
	privateString XawTextPosition
	privateString XawTextScanDirection
	privateString Left
	privateString left
	privateString Right
	privateString right
	privateString returnVar


#> The 'Text' widget class can be used to display and edit one or more
#> lines of text. Options are provided to add Scrollbars, search for a
#> specific string and to modify the text in the edit buffer.

~widgetClass 
Text
	include <X11/Xaw/AsciiText.h>

#> The command 'XawAsciiSave' saves the contents of the specified
#> Athena Text widget into a file and returns on success 1 and on
#> failure 0. This function only works, when the 'type' resource of
#> the specified Text widget is set to 'file', as filename the value
#> of the resource 'string' is taken. If the buffer has not been
#> changed, no action will be taken.

Boolean
XawAsciiSave
	in: XawTextGetSource(AsciiTextWidget)	# ascii text widget

#> The command 'XawAsciiSaveAsFile' saves the contents of the
#> specified Athena Text widget into a file and returns on success 1
#> and on failure 0. This function works, when the 'type' resource of
#> the specified Text widget is either set to 'string' or to 'file'.

Boolean
XawAsciiSaveAsFile
        in: XawTextGetSource(AsciiTextWidget)	# ascii text widget
        in: String			        # file name

#> The command 'XawAsciiSourceChanged' is used to figure out, whether
#> the text buffer has changed since it was saved the last time with
#> 'XawAsciiSave' or has been queried using XawAsciiSourceChanged.
#> The internal change flag is reset whenever the string is queried
#> via 'getValue' or the buffer is saved via XawAsciiSave.

Boolean
XawAsciiSourceChanged 
	in: XawTextGetSource(AsciiTextWidget)	# ascii text widget

#> The command 'XawAsciiSourceFreeString' can be used to free the
#> memory allocated by the Text widget explicitly during 'getValue'
#> for the 'string' resource or whenever the widget is saved. Note,
#> that this function is performed automatically whenever a next
#> 'getValue' for the 'string' resource is performed or when the
#> widget is destroyed. This function should only be called when the
#> resource 'useStringInPlace' is false.

void
XawAsciiSourceFreeString
	in: XawTextGetSource(AsciiTextWidget)	# ascii text widget

#> The 'Box' widget class is a geometry manager that packs its
#> children as tight as possible in non-overlapping rows and
#> columns. The children are rearranged when resizing events occur
#> either on the Box or its children or when children are managed or
#> unmanaged.

~widgetClass 
Box
	include <X11/Xaw/Box.h>

#> The 'Clock' widget class displays the current time either as analog
#> clock or as time string depending on the value of the 'analog' resource.

~widgetClass 
Clock
	include <X11/Xaw/Clock.h>

#> The 'Command' widget class is used for push buttons that, when
#> selected, may cause a specific action to take place. This widget
#> can display a multi-line string or a bitmap or pixmap image.

~widgetClass 
Command
	include <X11/Xaw/Command.h>

#> The 'Dialog' widget class is a commonly used composite widget to
#> prompt for auxiliary input from the user (such as a file name).

~widgetClass 
Dialog
	include <X11/Xaw/Dialog.h>

#> The function 'XawDialogGetValueString' returns the character string
#> from the text input field of a Dialog widget.

(String) VString
XawDialogGetValueString
	in: DialogWidget		# dialog widget

#> The 'Form' widget class is a more sophisticated geometry manager
#> that allows its children to specify their positions relative to
#> other children or to the edges of the form.

~widgetClass 
Form
	include <X11/Xaw/Form.h>

#> The command 'XawFormDoLayout' is used to force or defer a re-layout
#> of the Form widget.

void
XawFormDoLayout
	in: FormWidget			# form widget
	in: Boolean			# boolean

#> The 'Grip' widget class provides a rectangle that, when selected,
#> will cause an action to take place.

~widgetClass 
Grip
	include <X11/Xaw/Grip.h>

#> The 'Label' widget class provides a rectangle that can display a
#> multi-line string or a bitmap or pixmap image.

~widgetClass 
Label
	include <X11/Xaw/Label.h>

#> The 'List' widget class is used to display a list of text strings
#> in a row column format, where each text string can be individually
#> selected. When an element is selected, an action may be provided to
#> take place.

~widgetClass 
List
	include <X11/Xaw/List.h>
	createCmd listCreate
	callback i int: ((XawListReturnStruct *)callData)->list_index \
		# index
	callback s EscapedString: ((XawListReturnStruct *)callData)->string  \
		# selection

~bcAlias
list llist

#> The command 'XawListAppend' can be used to append one or more
#> list items to the elements already existing in a List widget.

void
listAppend vulgo XawListAppend
	in: ListWidget			# list widget
	in: [args]			# items 

#> The command 'XawListChange' changes the items of list widget. If
#> the number of items (2nd argument) or the length of the longest
#> item (3rd argument) contain a value less than one, the actual
#> values will be computed automatically. If the 4th argument is the
#> string 'List', a Tcl list of items is expected as next argument. If
#> it is 'Arg', following arguments are treated as list items. If the
#> 4th argument is 'File', the items are read from the file named by
#> the 5th argument.

void
listChange vulgo XawListChange
	in: ListWidget			# list widget
	in: int				# number of items
	in: int				# longest
	in: int				# resize
	in: [args]			# List list | Arg items | File filename

#> The command 'XawListHighlight' highlights (inverts) the nth list
#> item indicated by the 2nd argument.

void
XawListHighlight
	in: ListWidget			# list widget
	in: int				# item number

#> The function 'XawListShowCurrent' returns information about the
#> currently selected list item. The command returns a filename of an
#> associative array containing the element 'string' and 'list_index'.

XawListReturnStruct *
XawListShowCurrent
	in: ListWidget			# list widget

#> The command 'XawListUnhighlight' turns the highlight status of the
#> current selected item off.

void
XawListUnhighlight
	in: ListWidget			# list widget

#> The 'Logo' widget class can be used to display an X logo in various
#> sizes.

~widgetClass 
Logo
	include <X11/Xaw/Logo.h>

#> The 'Mailbox' widget class can be used to watch the status of a
#> file (typically the mailbox) and to change a bitmap, when it is
#> altered.

~widgetClass 
Mailbox
	include <X11/Xaw/Mailbox.h>

#> The 'MenuButton' widget class is used for push buttons that, when
#> selected, will pop up the menu named in the resource
#> 'menuName'. This widget can display a multi-line string or a bitmap
#> or pixmap image.

~widgetClass 
MenuButton
	include <X11/Xaw/MenuButton.h>

#> The 'Paned' widget class allows children to be tiled vertically or
#> horizontally. Controls are also provided to allow the user to
#> dynamically resize the individual parts.

~widgetClass 
Paned
	include <X11/Xaw/Paned.h>

#> The command 'XawPanedAllowResize' is used to enable to disable a
#> child's request for pane resizing. This command is equivalent to
#> changing the 'allowResize' constraint resource for the child.

void
XawPanedAllowResize
	in: Widget			# child of paned widget
	in: Boolean			# boolean

#> The command 'XawPanedGetMinMax' is used retrieve the minimum and
#> maximum height settings for a child pane.  This command is
#> equivalent to getting the 'min' and 'max' constraint resources for
#> the child.

void
XawPanedGetMinMax
	in: Widget			# child of paned widget
	out: int			# min
	out: int			# max

#> The function 'XawPanedGetNumSub' returns the number of panes in a
#> paned widget,

int
XawPanedGetNumSub
	in: PanedWidget			# paned widget

#> The command 'XawPanedSetMinMax' is used set the minimum and maximum
#> height settings for a child pane.  This command is equivalent to
#> setting the 'min' and 'max' constraint resources for the child.

void
XawPanedSetMinMax
	in: Widget			# child of a paned widget
	in: int				# min
	in: int				# max

#> The command 'XawPanedSetRefigureMode' enables or disables the
#> automatic calculation of pane sizes and pane positions (e.g., when
#> multiple changes are expected for child panes)

void 
XawPanedSetRefigureMode
	in: PanedWidget			# paned widget
	in: Boolean			# boolean

#> The 'Scrollbar' widget class provides a rectangular area containing
#> a thumb that when slid among one dimension may cause a specific
#> action to take place. The Scrollbar may be oriented horizontally or
#> vertically.

~widgetClass 
Scrollbar
	include <X11/Xaw/Scrollbar.h>
	createCmd scrollbarCreate
	scrollProc p int: (int)callData		# position of thumb (in pixel)
	jumpProc p float: *(float *)callData	# floating position (0.0-1.0)

#> The command 'XawScrollbarSetThumb' sets the position and length of
#> a Scrollbar thumb. The 2nd ('top') and 3rd ('shown') arguments are
#> floats in the range between 0.0 and 1.0 to change its
#> values. Either 'top' or 'shown' can be specified as -1.0 in which
#> case the current value is left unchanged.

void
XawScrollbarSetThumb
	in: ScrollbarWidget		# Scrollbar widget
	in: float			# top
	in: float			# shown

~alias
	scSet XawStripChartSet

#> The 'Simple' widget class provides a rectangular area with a
#> set-able mouse cursor and a special border. It is the base class of
#> most of the Athena simple widget classes.

~widgetClass 
Simple
	include <X11/Xaw/Simple.h>

#> The 'SimpleMenu' widget class provides a container for menu
#> entries. It is a direct subclass of Shell, is the only part of a
#> menu associated with a window and serves as a glue to bind
#> individual menu entries together.

~widgetClass 
SimpleMenu
	include <X11/Xaw/SimpleMenu.h>
	createCmd XtCreatePopupShell
	createsShell

#> The procedure 'XawSimpleMenuAddGlobalActions' registers the global
#> action routine 'XawPositionSimpleMenu' which can be used to
#> position a menu centered over the cursor. If the resource
#> 'popupOnEntry' of the SimpleMenuWidget is set, the menu will be
#> placed so that the pointer is centered over the specified menu entry. 
#> 
#>    Example translation: 
#>        !Ctrl<Btn1Down>: XawPositionSimpleMenu(myMenu) MenuPopup(myMenu)

void 
XawSimpleMenuAddGlobalActions
	const: wafeAppContext

#> The procedure 'XawSimpleMenuClearActiveEntry' is used to clear the
#> SimpleMenu widget's internal information about the currently
#> highlighted menu entry.

void 
XawSimpleMenuClearActiveEntry
	in: SimpleMenuWidget		# widget

#> The function 'XawSimpleMenuGetActiveEntry' returns the widget ID of
#> the currently active menu entry (or 0, if none is active)

WidgetID (WidgetID)
XawSimpleMenuGetActiveEntry
	in: SimpleMenuWidget		# widget

#> The object class 'Sme' is the base class of all menu entries. It
#> can be used as a menu entry itself to provide a blank space in a
#> menu. 'Sme' stands for 'Simple Menu Entry'.

~objectClass 
Sme
	include <X11/Xaw/Sme.h>

#> The object class 'SmeBSB' provides a select-able menu entry
#> containing a text string. A bitmap may also be placed in the left
#> and right margins.  'SmeBSB' stands for 'Simple Menu Entry Bitmap
#> String Bitmap'.

~objectClass 
SmeBSB
	include <X11/Xaw/SmeBSB.h>

#> The object class 'SmeLine' provides a non select-able menu entry
#> containing a separator line.

~objectClass 
SmeLine
	include <X11/Xaw/SmeLine.h>

#> The 'StripChart' widget class provides a real time data graph that
#> will automatically update and scroll.

~widgetClass 
StripChart
	include <X11/Xaw/StripChart.h>
	createCmd stripChartCreate

#> The command 'XawStripChartSet' is used to specify a StripChart
#> widget's current value. The widget will plot a graph of this value
#> every n seconds, where n is the value of the 'update' resource of
#> the StripChart widget.

void
stripChartSet vulgo XawStripChartSet
	in: StripChartWidget		# strip chart widget
	in: double			# value

#> The command 'XawTextDisableRedisplay' causes all changes to be
#> batched until either XawTextDisplay or XawTextEnableRedisplay is
#> called.

void
XawTextDisableRedisplay
	in: AsciiTextWidget		# ascii text widget

#> The command 'XawTextDisplay' forces all accumulated updates to be
#> displayed (see also: XawTextDisableRedisplay).

void
XawTextDisplay
	in: AsciiTextWidget		# ascii text widget

#> The command 'XawTextDisplayCaret' is used to enable and disable the
#> display of the insertion point marker. The same functionality can
#> be achieved by setting the resource 'displayCaret' or by the action
#> routine 'display-caret'.

void
XawTextDisplayCaret
	in: AsciiTextWidget		# ascii text widget
	in: Boolean			# boolean

#> The command 'XawTextEnableRedisplay' is used to enable display of
#> changes in the specified Text widget.

void
XawTextEnableRedisplay
	in: AsciiTextWidget		# ascii text widget

#> The function 'XawTextGetInsertionPoint' returns the current
#> position of the insertion point. The same functionality can be
#> achieved by retrieving the resource value for 'insertPosition' via
#> getValue.

XawTextPosition
XawTextGetInsertionPoint
	in: AsciiTextWidget		# ascii text widget

#> The procedure 'XawTextGetSelectionPos' returns the start and end
#> position of the current selection of the specified text widget in
#> the variables given in the second and third argument. If the
#> returned values are equal, no text is currently selected.

void 
XawTextGetSelectionPos
        in: AsciiTextWidget 		# ascii text widget
        out: XawTextPosition		# variable name for start position
        out: XawTextPosition 		# variable name for end position

#> The procedure 'XawTextInvalidate' causes the text in the specified
#> range to be redisplayed immediately (if redisplay is disabled,
#> this will happen when redisplay is enabled again; see also:
#> XawTextDisableRedisplay);

void
XawTextInvalidate
	in: AsciiTextWidget		# ascii text widget
	in: XawTextPosition		# start position
	in: XawTextPosition		# end position

#> The function 'XawTextSearch' searches from the position of the
#> current insertion point for the text string passed in the text
#> block (last argument) in the specified direction (2nd argument). If
#> the search was successful, a value greater or equal 0 is
#> returned. if the search was not successful, a negative value is returned.

XawTextPosition
XawTextSearch
	in: AsciiTextWidget		# ascii text widget
	in: XawTextScanDirection	# scan direction ('left' or 'right')
	in: XawTextBlock		# text block

#> The procedure 'XawTextSetInsertionPoint' moved the insertion point
#> to the specified location.  The same functionality can be achieved
#> by setting the resource 'insertPosition' via setValues.

void
XawTextSetInsertionPoint
	in: AsciiTextWidget		# ascii text widget
	in: XawTextPosition		# position

#> The procedure 'XawTextSetSelection' highlights the text between the
#> specified positions and makes it as well the PRIMARY
#> selection. This procedure has no effect on CUT_BUFFER0.

void 
XawTextSetSelection
        in: AsciiTextWidget 		# ascii text widget
        in: XawTextPosition		# begin position
        in: XawTextPosition 		# end position

#> The procedure 'XawTextSetSelectionArray' sets the selection array
#> for the specified Text widget. The selection array determines the
#> selection behavior on single, double, triple and so on clicks with
#> the left mouse button in the text widget. The nth position in this
#> array determines the behavior on the nth click. Possible values in
#> this array are: 'selectAll', 'selectChar', 'selectLine',
#> 'selectParagraph', 'selectPosition', 'selectWord' and
#> 'selectNull'. The selection array is always terminated by
#> selectNull. 
#> 
#> Example:    XawTextSetSelectionArray $w selectLine selectPosition selectNull

void
XawTextSetSelectionArray
	in: AsciiTextWidget		# ascii text widget
	in: [XawTextSelectType]		# selection array

#> The procedure 'XawTextSinkFindDistance' returns the position between
#> text positions of the specified widget.

void
XawTextSinkFindDistance
	in: (Widget)TextSink		# ascii text widget
	in: XawTextPosition		# from position
        in: int				# reference location (in pixel)
	in: XawTextPosition		# to position
	out: int			# resulting width (in pixel)
	out: XawTextPosition		# distance in positions
	out: int			# resulting height (in pixel)

#> The function 'XawTextSinkMaxHeight' returns the height in pixel
#> that will be taken up by the specified number of lines (2nd
#> argument)

int
XawTextSinkMaxHeight
	in: (Widget)TextSink 		# ascii text widget
	in: int				# lines

#> The function 'XawTextSinkMaxLines' returns the number of lines that
#> will fit into the specified height.

int
XawTextSinkMaxLines
	in: (Widget)TextSink		# ascii text widget
	in: Dimension			# height

#> The procedure 'XawTextSinkSetTabs' sets the tab stops of the
#> specified widget.

void
XawTextSinkSetTabs
	in: (Widget)TextSink		# ascii text widget
	const: argc-2
	in: [int]			# tabs

#> The function 'XawTextSourceRead' is used to retrieve a portion of
#> the text displayed by a ascii text widget. The 2nd argument
#> specified the start position, the 4th argument the desired length
#> of the text portion. The function returns the actual number of
#> characters retrieved (which might be less the desired length, in
#> which case another XawTextSourceRead request must be issued). The
#> third argument returns the retrieved text block (the fields 'ptr',
#> 'length' and 'firstPos' of the specified array name are filled
#> out).

XawTextPosition
XawTextSourceRead 
	in: XawTextGetSource(AsciiTextWidget)	# ascii text widget
	in: XawTextPosition		# position
	out: XawTextBlock		# variable name for text block
	in: int				# length

#> The function 'XawTextSourceScan' is used to search the text for
#> boundary types ('position', 'whiteSpace', 'EOL', 'paragraph',
#> 'all') in the specified direction ('left' or 'right'). The 4th
#> argument specified the number of boundaries to scan for, the 5th
#> argument specifies, whether the boundary itself should be included
#> in the scan. The function returns the text position of the desired
#> boundary or the closest valid text position.

XawTextPosition
XawTextSourceScan
	in: XawTextGetSource(AsciiTextWidget)	# ascii text widget
	in: XawTextPosition		# position
	in: XawTextScanType		# boundary type
	in: XawTextScanDirection	# scan direction
	in: int				# count
	in: Boolean			# include (boolean)

#> The function 'XawTextTopPosition' returns the character position of
#> the left most character of the first line displayed in the
#> specified widget. The same functionality can be achieved by
#> retrieving the resource value for 'displayPosition' via getValue.

XawTextPosition
XawTextTopPosition
	in: AsciiTextWidget		# ascii text widget

#> The function 'XawTextReplace' is used to modify edit-able text. The
#> text of the widget between the start and the end position (2nd and
#> third argument) will be replaced by the text form the specified
#> text block (4th argument). The function returns 'editDone' when it
#> was successful, 'positionError' when the editMode is 'append' and
#> the from position is not the last position of the text or
#> 'editError' on other errors.

(int) ReplaceVal 
XawTextReplace
        in: AsciiTextWidget		# ascii text widget
        in: XawTextPosition 		# from position
        in: XawTextPosition 		# to position
        in: XawTextBlock		# text block

#> The procedure 'XawTextUnsetSelection' un-highlights previously
#> highlighted text in the specified widget.

void 
XawTextUnsetSelection
        in: AsciiTextWidget 		# ascii text widget

#> The 'Toggle' widget class is used for push buttons that,contain a
#> state information (pressed or un-pressed). When a Toggle is
#> selected a specific action may take place. Toggles may also be used
#> as 'radio buttons' to implement 'one of many' or 'zero or one of
#> many' groups of buttons. This widget can display a multi-line
#> string or a bitmap or pixmap image.

~widgetClass 
Toggle
	include <X11/Xaw/Toggle.h>

#> The procedure 'XawToggleChangeRadioGroup' can be used to change the
#> radio group of a Toggle widget, to add a Toggle widget to a radio
#> group or to remove a Toggle widget from a radio group (second
#> argument NULL)

void
XawToggleChangeRadioGroup
	in: ToggleWidget	   # toggle widget
	in: NULL | ToggleWidget    # NULL | any toggle widget of a radio group

#> The function 'XawToggleGetCurrent' returns the radio data of the
#> currently active widget of the specified radio group.

XrmQuark (XrmQuark)
XawToggleGetCurrent
	in: ToggleWidget	   # any toggle widget of a radio group

#> The procedure 'XawToggleSetCurrent' locates the toggle widget to be
#> set by matching the specified radio data for each toggle in the
#> radio group. If more than one widget matches, one toggle widget
#> will be chosen arbitrarily. If this procedure causes any toggle
#> widget to change its state, the corresponding callback routines
#> will be called. The callback routines for unset will be called
#> before the routines for set.

void
XawToggleSetCurrent
	in: ToggleWidget	   # any toggle widget of a radio group
	in: (XtPointer)XrmQuark		   # radio data

#> The procedure 'XawToggleSetRadioData' sets the radio data for 
#> the specified widget.

#define toggleSetRadioData(w, q) \
	XtVaSetValues(w, XtNradioData, q, NULL)

void
toggleSetRadioData vulgo XawToggleSetRadioData
	in: ToggleWidget	   # toggle widget
        in: XrmQuark	   	   # radio data

#> The procedure 'XawToggleUnsetCurrent' unsets all toggles in a radio
#> group. If this procedure causes any toggle widget to change its state,
#> the corresponding callback routines will be called

void
XawToggleUnsetCurrent
	in: ToggleWidget	   #  any toggle widget of a radio group

#> The 'Viewport' widget class provides means to view a larger window
#> in a smaller area. It consists of a frame, one or two Scrollbars
#> and an inner window. The inner window will be clipped by the frame
#> with the Scrollbars controlling which section of the inner window
#> is current visible.

~widgetClass 
Viewport
	include <X11/Xaw/Viewport.h>

#> The procedure 'XawViewportSetCoordinates' is used to set the x and
#> y position in a Viewport widget. argument two and three are pixel
#> coordinate values.

hint: R5|XAW3D
void
XawViewportSetCoordinates
	in: ViewportWidget		# Viewport Widget
	in: Position			# x position
	in: Position			# y position

#> The procedure 'XawViewportSetLocation' is used to set Viewport
#> location.  the specified values are in the range between 0.0 and
#> 1.0, where 0.0 is the minimum value (pixel value 0) and 1.0 is the
#> maximum value (maximum pixel height or width).

hint: R5|XAW3D
void
XawViewportSetLocation
	in: ViewportWidget		# Viewport Widget
	in: double			# x offset 
	in: double			# y offset

