.TH xwafemc 1
.SH NAME
.PP
xwafemc \- an X-based multiple choice test program 

.ad
.SH SYNOPSIS
.PP
\f3xwafemc\f1 [\f3-c \f2colormode\f1] 
[\f3-3\f1]
[\f3-f\f2 source file\f1] 
[\f3-l\f2 language\f1] 

.SH DESCRIPTION
.PP
xwafemc processes an input file containing multiple choice questions,
lets them be answered by the user and  finally evaluates the user's
input.

.SH OPTIONS
.PP
In addition to the standard toolkit options 
such as -display, -name, -geometry, -iconic, -xrm etc. (see manual
page X) xwafemc accepts the following options:

.TP
\f3-c \f2colormode\f1
start xwafemc using the given color-mode (for details see manual page
wafeapp); color modes are for example \fImono\fP, \fIblueish\fP or \fIwheat-ish\fP.

.TP
\f3-3\f1
do not use 3 dimensional widgets. This option depends of the configuration 
in the system.waferc file (see manual page wafeapp).

.TP
\f3-s \f2 source file
Use this option to specify the input file. Default value is a short
demonstration file located in $WAFELIB.

.TP
\f3-l \f2 language
Specify \fIenglish\fP or \fIgerman\fP, default value is german.


.SH "LAYOUT and INTERACTION" 

Each question is presented with the proposed time and the maximum
number of points. The mouse is used to answer the questions: Left
button (Btn1) marks as true, right button (Btn3) as wrong and the
middle button (Btn2) cancels the answer of the current question.
Alternatively the characacters "r", "f" and "?" may be used. Input
refers always to the question currently displayed under the pointer.
For alternative key bindings please refer to the next section. The
button <Quit> at the bottom of the application's window is used to
exit without evaluation.  After all questions are answered, the button
<Evaluation> becomes sensitive and can be pressed to view the results
and the achieved grade.

.SH "KEY BINDINGS"
.TP 13
<Btn1>
mark current question as right
.TP
<Btn2>
mark current question as unanswered
.TP
<Btn3>
mark current question as false
.TP
<Key>Up
move about one line up
.TP
<Key>Down
move about one line down
.TP
<Key>Prior
move about a half page up
.TP
<Key>Next
move about a half page down
.TP
Meta<Key>Prior
move to the begin of the test
.TP
Meta<Key>Next
move to the end of the test
.TP
<Key>r
mark current question as right
.TP
<Key>f
mark current question as false
.TP
<Key>?
mark current question as unanswered

.SH "ENVIRONMENT VARIABLES"
.PP
.TP 13
WAFELIB
location of the wafe library (typically /usr/lib/X11/wafe)

.SH "PERL VARIABLES"
.PP
Wafe (Perl-) Variables from $WAFELIB/system.waferc or $HOME/.waferc:
.TP 13
$boldFont
used for bold labels
.TP
$normalFont
used to display the text of the questions
.TP
$textFont
fixed spaced text font
.TP
$buttonFont
used as font for buttons
.TP
$buttonAtts
attributes used for buttons
.TP
$backGround
background color

.SH "FILES" 
.PP
.EX 0
$WAFELIB/system.waferc
$WAFELIB/test.mini.german
$WAFELIB/test.mini.english
$HOME/.waferc
.EE

.SH "SEE ALSO"
.PP
wafe(n),
wafeapp(n),
X(1),
xwafemail(n),
xwafenews(n),
xwafeftp(n),
xwafeora(n),
xwafetel(n),
xdirtree(n),
xdirtree(n),
xprojektor(n),
xbm(n),
xwafemc(n),
xruptimes(n),
xnetstats(n),
xiostats(n),
xvmstats(n),
xwafeping(n),
xwafecf(n)

.SH COPYRIGHT
.PP
 Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
.EX 0
    Wirtschaftsuniversitaet Wien, 
    Abteilung fuer Wirtschaftsinformatik
    Augasse 2-6, 
    A-1090 Vienna, Austria
    neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
.EE
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appears in all copies and that both that
copyright notice and this permission notice appear in all supporting
documentation.  This software is provided "as is" without expressed or
implied warranty.
.PP
.SH AUTHORS
.PP
Gustaf Neumann, Stefan Nusser
