
#define MAIN
#include <wafe.h>

/* the following includes will redefine 
 *   - None
 *   - False
 *   - True
 * but this should not hurt ..
 */

#include "allobjects.h"
#include "modsupport.h"
#include "import.h"     /* for add_module */
#include "pythonrun.h"  /* for run_string */
#include "graminit.h"   /* for file_input*/

static object *
wafe_cmd(self, args)
     object *self; /* Not used */
     object *args;
{
  char *cmd, *result;

  if (!getargs(args, "s", &cmd))
    return NULL;

  if (wafeEval(wafeInterpreter,cmd,"python") == TCL_ERROR)
      {
      err_setstr(SystemError, "Wafe function ended with error condition");
      return NULL;
      }

  return mkvalue("s",wafeInterpreter->result);
}

static object *
wafe_set(self, args)
     object *self; /* Not used */
     object *args;
{
  char *name, *value;

  if (!getargs(args, "(ss)", &name, &value))
    return NULL;
  Tcl_SetVar(wafeInterpreter, name, value, TCL_GLOBAL_ONLY);

  INCREF(None);
  return None;
}

static object *
wafe_process_events(self, args)
     object *self; /* Not used */
     object *args;
{
#ifdef RDD
  rddAppMainLoop(wafeAppContext);
#else
  XtAppMainLoop(wafeAppContext);
#endif
  INCREF(None);
  return None;
}

#ifdef NEVER
static object *callback = NULL;
static object *
set_callback(self, args)
     object *self; /* Not used */
     object *args;
{
  char *cmd, *result;
  XDECREF(callback);
  callback = args;
  XINCREF(callback);
  INCREF(None);
  return None;
}
#endif

static int
com_pythonE(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     object *m, *d, *v, *t, *func;
     char *result;
     int startSymbol;

     DBUG_ENTER("python");  

     if (argc != 2) 
         {
	 wafeArgcError(argc,argv,"",1);
         DBUG_RETURN (TCL_ERROR);
         }

     m = add_module("__main__");
     if (m == NULL)
         DBUG_RETURN (TCL_ERROR);
     d = getmoduledict(m);

     startSymbol = strcmp(argv[0],"pythonF") ? file_input : eval_input;
     v = run_string(argv[1], startSymbol, d, d);
     if (v == NULL) 
         {
	 print_error();
         DBUG_RETURN (TCL_ERROR);
         }
     /*fprintf(stderr,"start=%d, type %s\n",startSymbol, v->ob_type->tp_name);*/
     if (startSymbol == eval_input) 
	 {
	 t = reprobject(v);
	 DECREF(v);
	 result = getstringvalue(t);
	 Tcl_SetResult(comInterpreter, result, TCL_VOLATILE);
	 XDECREF(t);
	 }
     else
	 DECREF(v);
     
     DBUG_RETURN (TCL_OK);
     }



static int
com_pythonS(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     object *func, *arglist, *v, *m, *d, *t;
     char *resultString;
     int i;

     DBUG_ENTER("python");  
     if (argc < 2) 
         {
	 wafeArgcError(argc,argv,"at least ",1);
         DBUG_RETURN (TCL_ERROR);
         }

     m = add_module("__main__");
     if (m == NULL)
         DBUG_RETURN (TCL_ERROR);
     d = getmoduledict(m);
   
     func = dictlookup(d,argv[1]);
     if (func == NULL) 
       {
       Tcl_SetResult(wafeInterpreter, 
		     "unknown python function", TCL_VOLATILE);
       DBUG_RETURN (TCL_ERROR);
       }

     arglist = newtupleobject(argc-2);
     if (arglist == NULL)
	 DBUG_RETURN(TCL_ERROR); /* Exception */

     for (i = 2; i < argc; i++) 
	 {
	 object *w;
	 w = newstringobject(argv[i]);
	 if ( w == NULL) 
	     {
	     DECREF(arglist);
	     DBUG_RETURN(TCL_ERROR); /* Exception */
	     }
	 settupleitem(arglist, i-2, w); /* "eats" reference count */
	 }

     v = call_object(func,arglist);
     DECREF(arglist);
     if (v == NULL) 
         {
	 print_error();
         DBUG_RETURN (TCL_ERROR);
         }
/*     fprintf(stderr,"type=%s\n",v->ob_type->tp_name);*/
     t = strobject(v);
     DECREF(v);

     resultString = getstringvalue(t);
     Tcl_SetResult(comInterpreter, resultString, TCL_VOLATILE);
     DECREF(t);

     DBUG_RETURN (TCL_OK);
     }


static struct methodlist wafe_methods[] = {
        {"cmd",            wafe_cmd},
        {"set",            wafe_set},
	{"process_events", wafe_process_events},
#ifdef NEVER
        {"callback",       set_callback},
#endif
        {NULL,             NULL}           /* sentinel */
};



void
initwafe()
{
  object *m, *d, *x;

  int argc = 0;
  char **argv = NULL;

  /* Create the module and add the functions */
  m = initmodule("wafe", wafe_methods);

  /* Add some symbolic constants to the module */
  d = getmoduledict(m);
  x = newstringobject("wafe.error");
  dictinsert(d, "error", x);
  x = newintobject(42L);
  dictinsert(d, "magic", x);

  /* Check for errors */
  if (err_occurred())
    fatal("can't initialize module wafe");

  wafeScriptName = "python";
  wafeTopLevel = XtVaAppInitialize(&wafeAppContext, 
				   "Python", NULL, 0, 
				   &argc, argv, NULL, NULL);
  MOTIF_EDITRES_HANDLER(wafeTopLevel);

  wafeInit(argc,argv, 
	   (Boolean)0 /* inputMode */,  
	   (Boolean)0 /* promptMode */
	   );
  Tcl_CreateCommand(wafeInterpreter, "pythonE", com_pythonE, NULL, NULL);
  Tcl_CreateCommand(wafeInterpreter, "pythonF", com_pythonE, NULL, NULL);
  Tcl_CreateCommand(wafeInterpreter, "pythonS", com_pythonS, NULL, NULL);
}







