/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Fri Dec  2 12:54:52 EST 1994 on mohegan
 * Author: genc
 * Version: 1.0.6


 */
#define MOTIF11_C
#include <wafe.h>
#ifdef MOTIF11
#include <X11/Shell.h>
#include <Xm/RowColumn.h>

 static XrmQuark qXmStringTable;
 static XrmQuark qitems;
 static XrmQuark qselectedItems;
 extern XrmQuark qXmString;
 extern XrmQuark qWindow;
 extern XrmQuark qMenuWidget;
 extern XrmQuark qHorizontalDimension;
 extern XrmQuark qVerticalDimension;
 extern XrmQuark qShellHorizDim;
 extern XrmQuark qShort;
 extern XrmQuark qShellVertDim;
 extern XrmQuark qTextPosition;
 extern XrmQuark qVerticalPosition;
 extern XrmQuark qHorizontalPosition;
 extern XrmQuark qPrimForegroundPixmap;
 extern XrmQuark qsource;
/* 
 * ******* begin required file <motif.inc> *******
 */

/* make emcas happy -*-C-*-  make emacs happy */

#include <ctype.h>
#include <Xm/AtomMgr.h>
#include <Xm/List.h>
#include <X11/IntrinsicP.h>

#define MAX_STRING_SEGMENT 4096
#define MAX_FORMAT_LEN 50

static XmStringCharSet defaultCharSet;

/*
#define defaultCharSet XmSTRING_DEFAULT_CHARSET
*/

#define	Done(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}


/*
 * Initialize the default character Set variable!
 */

void
wafeMotifInit()
    {
    XmStringContext   strContext;
    char              *text;
    XmStringCharSet   tmpCharSet;
    XmStringDirection dummyDir;
    Boolean           dummySep;
    XmString          dummy = XmStringCreateSimple("dummy");

    if (!XmStringInitContext(&strContext, dummy))
	wafeFatal("motif","Could not create String Context",NULL);

    XmStringGetNextSegment(strContext, &text, &tmpCharSet,
			   &dummyDir, &dummySep);

    defaultCharSet = XtNewString(tmpCharSet);

    XtFree(text);
    XmStringFree(dummy);
    XmStringFreeContext(strContext);

    DBUG_PRINT("motif",("defaultCharSet is <%s> Xm='%s'",
			defaultCharSet,XmSTRING_DEFAULT_CHARSET));
    wafeRegisterXpmTypeConverter("XmBackgroundPixmap", True);
    }



/*
 * Utility function: Creates a new compound string segment, appends it
 * to an existing XmString. Does NOT create a segement if the string is empty!
 */

static XmString
compStringAppend(oldCompStr, text, charSet, dir, sep)
XmString           oldCompStr;
char              *text;
XmStringCharSet    charSet;
XmStringDirection  dir;
Boolean            sep;
    {
    XmString  addSeg, newString;

    if (*text == '\0' && sep)
	return(oldCompStr);

/*
    fprintf(stderr, "Generated segment with <%s>\n", text);
 */

    if (!oldCompStr)
	return(XmStringSegmentCreate(text, charSet, dir, sep));
    else
	{
	addSeg = XmStringSegmentCreate(text, charSet, dir, sep);
	newString = XmStringConcat(oldCompStr, addSeg);
	XmStringFree(addSeg);
	XmStringFree(oldCompStr);
	return(newString);
	}
    }

XmString
wafeCvtStringToXmString(inString)
char  *inString;
    {
    char               segBuf[MAX_STRING_SEGMENT];
    char               formatBuf[MAX_FORMAT_LEN];
    XmStringCharSet    charSet = XmSTRING_DEFAULT_CHARSET;
    XmStringDirection  dir = XmSTRING_DIRECTION_L_TO_R;
    XmString           result = NULL;
    char              *segPtr = segBuf;
    char              *ptr = inString;
    char              *top;

/*
    fprintf(stderr, "Converting string <%s>\n", inString);
*/
    top = ptr + strlen(inString);
    *segPtr = '\0';
    while (ptr < top)
	{
	switch (*ptr)
	    {
	    case '\n':
	    /* NewLine: Finish current segment */

	    *segPtr = '\0';
            result = compStringAppend(result, segBuf, charSet, dir, True);
	    segPtr = segBuf;
	    ptr++;
	    break;
	
	    case '^':
            /* Enter command mode */
	    ptr++;

	    if (ptr == top)
		{
		wafeWarn("XmString", "Cannot handle trailing '^'",
			 NULL,NULL,NULL);
		return NULL;
		}

	    if (*ptr == '^')
		{
		/* Two ^ => leave command mode, insert one ^ */
		*segPtr++ = '^';
		ptr++;
		}
	    else
		if (!isalpha(*ptr))
		    {
                    /* ^ + whatever not alphabetic => ignore ^ */
		    *segPtr++ = *ptr++;
		    }
		else
		    {
		    char   *comPtr = formatBuf;
		
		    /* Terminate current segment */
		    *segPtr = '\0';
		    result = compStringAppend(result, segBuf,
					      charSet, dir, False);
		    segPtr = segBuf;
				
		    /* Extract command */
		    while ((isalnum(*ptr)
			    || (*ptr == '-')
			    || (*ptr == '_'))
			   && (ptr <= top))
			*comPtr++ = *ptr++;

		    *comPtr = '\0';
/*
		    fprintf(stderr, "Parsed command <%s>\n", formatBuf);
 */
		    if (!strcmp(formatBuf, "lr"))
			dir = XmSTRING_DIRECTION_L_TO_R;		
		    else
			if (!strcmp(formatBuf, "rl"))
			    dir = XmSTRING_DIRECTION_R_TO_L;
			else
			    charSet = XtNewString(formatBuf);

		    if (*ptr == ' ')
			ptr++;
		    }
	    break;
	    	
	    default:
	    *segPtr++ = *ptr++;
	    break;

	    } /* switch */	
	} /* while */

    *segPtr = '\0';
    result = compStringAppend(result, segBuf, charSet, dir, False);
    return result;
    }


static XmStringTable
wafeCvtStringToXmStringTable(inString)
char * inString;
    {
    int argc;
    char ** argv;
    XmString *strTable, *t;
    int i;

    Tcl_SplitList(wafeInterpreter,inString, &argc,&argv);
    t = strTable = (XmString *)XtMalloc((argc+1)*sizeof(XmString));

    for ( i = 0; i < argc; i++, t++ )
	if (!(*t = wafeCvtStringToXmString(argv[i])))
	    {
	    wafeConvWarn("wafeCvtStringToXmStringTable", argv[i],"XmString");
	    XtFree((char *)argv);
	    return NULL;
	    }
    *t = NULL;

    XtFree((char *)argv);
    return (XmStringTable) strTable;
    }


/* Queries a XmString Value and translates it to a valid input string */

char *
wafeCvtXmString2String(buffer,compStr)
char          * buffer;
XmString      compStr;
    {
    XmStringContext    strContext;
    char               *text;
    XmStringCharSet    charSet,
                       lastCharSet = defaultCharSet;
    XmStringDirection  dir,
                       lastDir = 
#ifdef MOTIF20
			 XmSTRING_DIRECTION_UNSET;
#else
			 XmSTRING_DIRECTION_L_TO_R;
#endif
    Boolean            sep;
    Boolean            fontChange;
    char               *returnString, *ptr;

    DBUG_ENTER("wafeCvtXmString2String");

    if (!XmStringInitContext(&strContext, compStr))
	{
	wafeWarn("motif", "Could not obtain String Context", NULL,NULL,NULL);
	return(NULL);
	}

    if (!buffer)
	{
	ptr = returnString = XtMalloc(XmStringLength(compStr)+100); /* hack  for now */
/*	fprintf(stderr, "buffer new allocated %p, size=%d\n",
		ptr,XmStringLength(compStr));
 */
	}
    else
	{
	/* fprintf(stderr, "using provided buffer %p\n", buffer); */
	ptr = returnString = buffer;	
	}


    while (XmStringGetNextSegment(strContext, &text, &charSet, &dir, &sep))
	{
	char *textPtr = text;

	fontChange = strcmp(charSet, lastCharSet);

	DBUG_PRINT("motif", 
		   ("comparing last charset '%s' current '%s' and tag '%s'",
		    lastCharSet, charSet, XmFONTLIST_DEFAULT_TAG));

	DBUG_PRINT("motif", 
		   ("comparing last dir %d dir %d lr %d, and default dir %d",
		    lastDir, dir, XmSTRING_DIRECTION_L_TO_R, 
		    XmSTRING_DIRECTION_DEFAULT));
		   
	/* This means: If there are no changes in charSet or direction,
	 * just make a newline but don't do it, if this is the first segment
	 */
	if (   (!fontChange)
	    && (dir == lastDir)
	    && (returnString != ptr))
	    *ptr++ = '\n';

	if (fontChange
#ifdef XmFONTLIST_DEFAULT_TAG
	    /* Motif 1.2 seems to want it that way ... */
	    && strcmp(charSet,XmFONTLIST_DEFAULT_TAG)
#endif
	    )
	    {
            *ptr++ = '^';
	    strcpy(ptr, charSet);
	    ptr+= strlen(charSet);
	    *ptr++ = ' ';
	    lastCharSet = charSet;
	    }

	if (dir != lastDir)
	    {
	    if (dir == XmSTRING_DIRECTION_L_TO_R)
		strcpy(ptr, "^lr ");
	    else
		strcpy(ptr, "^rl ");		
	    ptr+=4;
	    lastDir = dir;
	    }	

	while (*textPtr != '\0')
	    {
	    if (*textPtr == '^')
		{
		strcpy(ptr, "^^");
		ptr +=2;
		textPtr++;
		}
	    else
		*ptr++ = *textPtr++;
	    }
	}
    *ptr = '\0';
    XmStringFreeContext(strContext);
/*
    fprintf(stderr,"xmString2String returns <%s> size=%d\n",
	    returnString,strlen(returnString));
*/
    DBUG_RETURN(returnString);
    }

void
wafeEscapedXmString2String(buffer,compStr)
char          * buffer;
XmString      compStr;
    {
    char *p = wafeCvtXmString2String(NULL,compStr);
    wafeEscapedStrcpy(buffer,p);
    XtFree(p);
    }



char *
wafeCvtXmStringTable2String(count,strTable)
int           count;
XmStringTable strTable;
    {
    char     **temp, **cPtr;
    XmString  *ptr;
    char      *result;
    int        i;

    DBUG_ENTER("wafeCvtXmStringTable2String");
    
    if (count == -1)
	{
	if (wafeCurrentWidget && wafeCurrentAttrib)
	    {
	    /* try hard to figure out what the length of the XmStringTable is.
	     *
	     * i have tried before the following code, which was not reliable; 
	     * if somebody knows a better way, how to determine the number of 
	     * items in a XmStringTable please, let me know
	     *
	     *  for (; strTable[count] && 
	     *         ((unsigned)strTable[count] & 0xffff0000) && 
	     *       *strTable[count] == 0xdf; count++) 
	     */
	
	    count = 0;  /* if one of the following tests fails */
	 
	    if (XtClass(wafeCurrentWidget) == xmListWidgetClass)
		{
		if (wafeCurrentAttrib == qitems)
		    XtVaGetValues(wafeCurrentWidget, 
				  XmNitemCount, &count, NULL);
		else 
		    if (wafeCurrentAttrib == qselectedItems)
			XtVaGetValues(wafeCurrentWidget, 
				      XmNselectedItemCount, &count, NULL);
		}
	    else
		wafeWarn("XmString",
			 "No XmStringTables known for class %s",
			 (XtClass(wafeCurrentWidget)->core_class.class_name),
			 NULL,NULL);
	    }
	else
	    wafeWarn("XmString","Cannot determine size of XmStringTable",
		     NULL,NULL,NULL);
	}

    temp = (char **)XtMalloc(count*sizeof(char *));
    for (ptr=strTable, cPtr=temp, i=count; i>0; ptr++, cPtr++, i--)
	*cPtr = wafeCvtXmString2String(NULL,*ptr);

    result = Tcl_Merge(count, temp);
    for (cPtr = temp, i=count; i>0; cPtr++, i--)
	XtFree(*cPtr);

    XtFree((char *)temp);
    DBUG_RETURN (result);
    }

/*
 * Two converter function wrappers for the *2String functions, which are
 * called by getValues
 */

static Boolean
CvtXmStringToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    static char *result;
    DBUG_ENTER("CvtXmStringToString");
    result = wafeCvtXmString2String(NULL,(XmString)(fromVal->addr));
    toVal->addr = result;
    toVal->size = 1; /* if nobody else uses this converter it shouldn't matter anyway */
    DBUG_RETURN(True);
    }


static Boolean
CvtXmStringTableToString(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static char *result;
    DBUG_ENTER("CvtXmStringTableToString");
    result = wafeCvtXmStringTable2String(-1,(XmStringTable)(fromVal->addr));
    toVal->addr = result;
    toVal->size = 1; /* it should not matter either */
    DBUG_RETURN(True);
    }


static void
freeXmStringTable(table)
XmStringTable  table;
    {
    XmStringTable t = table;
    while (*t != NULL)
	XmStringFree(*t++);
    XtFree((char *)table);
    }	


Boolean
CvtStringToXmStrings(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    int               argc, count;
    char            **argv;
    XmString         *ptr;
    static XmString  *result;

    DBUG_ENTER("CvtStringToXmStrings");

    if (Tcl_SplitList(wafeInterpreter,(char*)fromVal->addr, &argc, &argv)
	!= TCL_OK)
	{
	wafeWarn("CvtStringToXmStrings", wafeInterpreter->result,
		 NULL,NULL,NULL);
	return False;
	}


    result = (XmString *)XtMalloc(argc*sizeof(XmString));
    for(count = 0, ptr = result; count < argc; count++, ptr++)
	if ((*ptr = wafeCvtStringToXmString(argv[count],NULL,0)) == NULL)
	    {
	    XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr,
					     "XmString");
	    XtFree((char *)result);
	    XtFree((char *)argv);
	    return False;
	    }
    XtFree((char *)argv);

    if (toVal->addr)
	{
	wafeWarn("CvtStringToXmStrings", 
		 "somebody else called CvtStringToXmStrings",
		 NULL,NULL,NULL);
	
	if (toVal->size < sizeof(XmString *))
	    {
	    toVal->size = sizeof(XmString *);
	    XtFree((char *)result);
	    DBUG_RETURN(False);
	    }

	toVal->size = sizeof(XmString *);
	*(XmString **)(toVal->addr) = result;
	DBUG_RETURN(True);
	}

	
    toVal->size = sizeof(XmString **);
    toVal->addr = (caddr_t)&result;

    wafeMMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)result, freeXmStringTable);

    DBUG_RETURN(True);
    }


Boolean
CvtStringToXmString(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static XmString  result;
    DBUG_ENTER("CvtStringToXmString");

/*    fprintf(stderr, "CvtStringToXmString: <%s> %p\n",
	    fromVal->addr, toVal->addr);
 */

    if ((result = wafeCvtStringToXmString((char *)fromVal->addr, NULL, 0)) == NULL)
	{
	XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr,
					 "XmString");
	DBUG_RETURN(False);
	}

    if (toVal->addr)
	{
	if (toVal->size < sizeof(XmString))
	    {
	    toVal->size = sizeof(XmString);
	    XmStringFree(result);
	    DBUG_RETURN(False);
	    }

	toVal->size = sizeof(XmString);
	*(XmString *)(toVal->addr) = result;
	DBUG_RETURN(True);
	}

    toVal->size = sizeof(XmString *);
    toVal->addr = (XtPointer)result;

    wafeMMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)result, (freeProc)XmStringFree);
    DBUG_RETURN(True);
    }


static Boolean
CvtStringToLong(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    long result;

    if (sscanf((char *)fromVal->addr, "%ld", &result) == 1)
	{
	Done(long, result);
	}
    else
	return False;
    }


#include <Xm/Protocols.h>
static void
wafeAddProtocol(w, property, protocol)
Widget   w;
Atom     property, protocol;
    {
    XmAddProtocols(w,property,&protocol,1);
    }

static void
protocolCallbackProc(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
    {
    DBUG_ENTER("protocolCallbackProc");
    wafeExecCallbackProc(w, clientData, callData);
    DBUG_VOID_RETURN;
    }

static void
wafeAddProtocolCallback(w, property, protocol, string)
Widget   w;
Atom     property, protocol;
String   string;
    {
    char *charp = XtMalloc(strlen(string)+1+sizeof(XrmQuark));

    *(XrmQuark *)charp = (XrmQuark)0;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)string);
    XmAddProtocolCallback(w, property, protocol, 
			  protocolCallbackProc, 
			  (XtPointer)charp);
    }

int
wafeModifyVerifyCBset(doit, currInsert, startPos, endPos, string)
Boolean doit;
long currInsert, startPos, endPos;
String string;
    {
    XmTextVerifyCallbackStruct *cbs = 
	(XmTextVerifyCallbackStruct *)wafeCurrentCallData;
    int newLength =  strlen(string);

    DBUG_ENTER("wafeModifyVerifyCBset");
    
    if (!cbs || cbs->reason !=  XmCR_MODIFYING_TEXT_VALUE) 
	DBUG_RETURN(wafeSetError("calling wafeModifyVerifyCBset is only valid from a modifyVerifyCallback",NULL,NULL,NULL));

    cbs->doit = doit;

    if (doit)
	{
	if (currInsert>=0) cbs->currInsert   = currInsert;
	if (startPos>=0)   cbs->startPos     = startPos;
	if (endPos>=0)     cbs->endPos       = endPos;

	if (newLength>0) 
	    {
	    if (newLength >= cbs->text->length) 
		cbs->text->ptr = XtRealloc(cbs->text->ptr,newLength+1);
	    
	    strcpy(cbs->text->ptr, string);
	    cbs->text->length = newLength;
	    }
	else 
	    {
	    if (cbs->text->length>0) 
		XtFree(cbs->text->ptr);
	    cbs->text->ptr    = NULL;
	    cbs->text->length = 0;
	    }
	}

    DBUG_RETURN(TCL_OK);
    }

/* 
 * ******* end required file <motif.inc> *******
 */
/* 
 * void
 * XmAddTabGroup
 * 	in: Widget     		# widget to be added
 */

static int 
cmd_XmAddTabGroup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     XmAddTabGroup(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
/* 
 * void 
 * XmCascadeButtonGadgetHighlight
 * 	in: XmCascadeButtonGadget   	# cascadeButtonGadget to be highlighted
 * 	in: Boolean          	    	# highlight (bool)
 */

static int 
cmd_XmCascadeButtonGadgetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCascadeButtonGadgetClass,"XmCascadeButton")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmCascadeButtonGadget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XmCascadeButtonGadgetHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XmCascadeButtonHighlight
 * 	in: XmCascadeButtonGadget   	# widget to be highlighted
 * 	in: Boolean          	    	# highlight (bool)
 */

static int 
cmd_XmCascadeButtonHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCascadeButtonGadgetClass,"XmCascadeButton")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmCascadeButtonGadget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XmCascadeButtonHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/Command.h>
/* 
 * void
 * XmCommandAppendValue
 * 	in: XmCommandWidget          	# command widget 
 * 	in: XmString         		# command string
 */

static int 
cmd_XmCommandAppendValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCommandWidgetClass,"XmCommand")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmCommandWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmString");
         DBUG_RETURN (TCL_ERROR);
         }

     XmCommandAppendValue(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmCommandError
 * 	in: XmCommandWidget           	# command widget 
 * 	in: XmString         		# error message
 */

static int 
cmd_XmCommandError(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCommandWidgetClass,"XmCommand")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmCommandWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmString");
         DBUG_RETURN (TCL_ERROR);
         }

     XmCommandError(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * WidgetID (WidgetID)
 * XmCommandGetChild
 * 	in: XmCommandWidget	        # command widget
 * 	in: (unsigned char)XmChild 	# child reference
 */

static int 
cmd_XmCommandGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmCommandWidgetClass,"XmCommand")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmCommandWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[2], "DIALOG_CANCEL_BUTTON")) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DEFAULT_BUTTON")) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_HELP_BUTTON")) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_OK_BUTTON")) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_SEPARATOR")) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], "DIALOG_SYMBOL_LABEL")) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_MESSAGE_LABEL")) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_APPLY_BUTTON")) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST")) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST_LABEL")) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_LABEL")) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_TEXT")) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_LIST")) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_LIST_LABEL")) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_SELECTION_LABEL")) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_TEXT")) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_WORK_AREA")) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
     if (!strcmp(argv[2], "DIALOG_COMMAND_TEXT")) 
         localVar2 = XmDIALOG_COMMAND_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_PROMPT_LABEL")) 
         localVar2 = XmDIALOG_PROMPT_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_HISTORY_LIST")) 
         localVar2 = XmDIALOG_HISTORY_LIST;
     else
         {
         wafeConvError(argc,argv, 2,NULL, "XmChild");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = (WidgetID) XmCommandGetChild(localVar1,localVar2);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
/* 
 * WidgetID (WidgetID)
 * XmFileSelectionBoxGetChild
 * 	in: XmFileSelectionBoxWidget		# file selection box widget
 * 	in: (unsigned char)XmChild 		# child reference
 */

static int 
cmd_XmFileSelectionBoxGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmFileSelectionBoxWidgetClass,"XmFileSelectionBox")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmFileSelectionBoxWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[2], "DIALOG_CANCEL_BUTTON")) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DEFAULT_BUTTON")) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_HELP_BUTTON")) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_OK_BUTTON")) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_SEPARATOR")) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], "DIALOG_SYMBOL_LABEL")) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_MESSAGE_LABEL")) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_APPLY_BUTTON")) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST")) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST_LABEL")) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_LABEL")) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_TEXT")) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_LIST")) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_LIST_LABEL")) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_SELECTION_LABEL")) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_TEXT")) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_WORK_AREA")) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
     if (!strcmp(argv[2], "DIALOG_COMMAND_TEXT")) 
         localVar2 = XmDIALOG_COMMAND_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_PROMPT_LABEL")) 
         localVar2 = XmDIALOG_PROMPT_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_HISTORY_LIST")) 
         localVar2 = XmDIALOG_HISTORY_LIST;
     else
         {
         wafeConvError(argc,argv, 2,NULL, "XmChild");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = (WidgetID) XmFileSelectionBoxGetChild(localVar1,localVar2);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmFileSelectionDoSearch
 * 	in: XmFileSelectionBoxWidget		# file selection box
 * 	in: XmString				# directory mask
 */

static int 
cmd_XmFileSelectionDoSearch(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmFileSelectionBoxWidgetClass,"XmFileSelectionBox")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmFileSelectionBoxWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmString");
         DBUG_RETURN (TCL_ERROR);
         }

     XmFileSelectionDoSearch(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/Form.h>
#include <Xm/Frame.h>
/* 
 * WidgetID (WidgetID)
 * XmGetDestination
 * 	in: XtDisplay(Widget)	        # any widget
 */

static int 
cmd_XmGetDestination(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = (WidgetID) XmGetDestination(XtDisplay(localVar1));

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
/* 
 * void
 * XmListAddItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to add
 * 	in: int			# Position
 */

static int 
cmd_XmListAddItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmString");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListAddItem(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListAddItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# items
 * 	in: int			# number of items
 * 	in: int			# position
 */

static int 
cmd_XmListAddItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmStringTable) wafeCvtStringToXmStringTable(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmStringTable");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[4], "%d", &localVar4)))
         {
         wafeConvError(argc, argv, 4 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListAddItems(localVar1,localVar2,localVar3,localVar4);
     freeXmStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListAddItemUnselected
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to add
 * 	in: int			# Position
 */

static int 
cmd_XmListAddItemUnselected(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmString");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListAddItemUnselected(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteAllItems
 * 	in: XmListWidget	# List Widget
 */

static int 
cmd_XmListDeleteAllItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListDeleteAllItems(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item to delete
 */

static int 
cmd_XmListDeleteItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmString");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListDeleteItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# items
 * 	in: int			# number of items
 */

static int 
cmd_XmListDeleteItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmStringTable) wafeCvtStringToXmStringTable(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmStringTable");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListDeleteItems(localVar1,localVar2,localVar3);
     freeXmStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeleteItemsPos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# number of items
 * 	in: int			# position of first item to be deleted
 */

static int 
cmd_XmListDeleteItemsPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListDeleteItemsPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeletePos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# position of item
 */

static int 
cmd_XmListDeletePos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListDeletePos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeselectAllItems
 * 	in: XmListWidget	# List Widget
 */

static int 
cmd_XmListDeselectAllItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListDeselectAllItems(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeselectItem
 * 	in: XmListWidget	# List Widget	
 * 	in: XmString		# item
 */

static int 
cmd_XmListDeselectItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmString");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListDeselectItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListDeselectPos
 * 	in: XmListWidget	# List Widget	
 * 	in: int			# position of item
 */

static int 
cmd_XmListDeselectPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListDeselectPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean                          
 * XmListGetMatchPos
 * 	in: XmListWidget	# List Widget   
 * 	in: XmString		# item
 * 	out: list(int*,int)	# list of positions
 */

static int 
cmd_XmListGetMatchPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int* localVar3list;
     int localVar3count;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmString");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmListGetMatchPos(localVar1,localVar2,&localVar3list, &localVar3count);
     XmStringFree(localVar2);

     
     Tcl_SetVar(wafeInterpreter, argv[3], wafeCvtIntsToTcl(NULL,localVar3count,localVar3list), 0);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmListGetSelectedPos
 * 	in: XmListWidget	# List Widget
 * 	out: list(int*,int)     # list of highlighted items
 */

static int 
cmd_XmListGetSelectedPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int* localVar2list;
     int localVar2count;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmListGetSelectedPos(localVar1,&localVar2list, &localVar2count);

     
     Tcl_SetVar(wafeInterpreter, argv[2], wafeCvtIntsToTcl(NULL,localVar2count,localVar2list), 0);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmListItemExists
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item
 */

static int 
cmd_XmListItemExists(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmString");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmListItemExists(localVar1,localVar2);
     XmStringFree(localVar2);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XmListItemPos
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# Item
 */

static int 
cmd_XmListItemPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmString");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmListItemPos(localVar1,localVar2);
     XmStringFree(localVar2);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListReplaceItems
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# Items to be replaced
 * 	in: int			# number of items to be replaced
 * 	in: XmStringTable	# new items
 */

static int 
cmd_XmListReplaceItems(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     XmStringTable localVar4;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmStringTable) wafeCvtStringToXmStringTable(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmStringTable");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar4 = (XmStringTable) wafeCvtStringToXmStringTable(argv[4])))
         {
         wafeConvError(argc, argv, 4 ,NULL, "XmStringTable");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListReplaceItems(localVar1,localVar2,localVar3,localVar4);
     freeXmStringTable(localVar2);
     freeXmStringTable(localVar4);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListReplaceItemsPos
 * 	in: XmListWidget	# List Widget
 * 	in: XmStringTable	# New items
 * 	in: int			# number of items to be replaced
 * 	in: int 		# first Pos of items to be replaced
 */

static int 
cmd_XmListReplaceItemsPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmStringTable localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmStringTable) wafeCvtStringToXmStringTable(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmStringTable");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[4], "%d", &localVar4)))
         {
         wafeConvError(argc, argv, 4 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListReplaceItemsPos(localVar1,localVar2,localVar3,localVar4);
     freeXmStringTable(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSelectItem
 * 	in: XmListWidget	# List Widget
 * 	in: XmString		# item to highlight
 * 	in: Boolean		# Invoke callback yes/no
 */

static int 
cmd_XmListSelectItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;
     Boolean localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmString");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[3],&localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListSelectItem(localVar1,localVar2,localVar3);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSelectPos
 * 	in: XmListWidget	# List Widget
 * 	in: int			# Position of item 
 * 	in: Boolean		# Invoke callback yes/no
 */

static int 
cmd_XmListSelectPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     Boolean localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[3],&localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListSelectPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetAddMode
 * 	in: XmListWidget 	# List Widget
 * 	in: Boolean		# Use Add Mode yes/no
 */

static int 
cmd_XmListSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetBottomItem	
 * 	in: XmListWidget 	# List Widget
 * 	in: XmString		# item to be displayed as last item
 */

static int 
cmd_XmListSetBottomItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmString");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListSetBottomItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetBottomPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# item to be displayed as last item
 */

static int 
cmd_XmListSetBottomPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListSetBottomPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetHorizPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# horizontal Position
 */

static int 
cmd_XmListSetHorizPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListSetHorizPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetItem
 * 	in: XmListWidget 	# List Widget
 * 	in: XmString		# item
 */

static int 
cmd_XmListSetItem(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar2 = (XmString) wafeCvtStringToXmString(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmString");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListSetItem(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmListSetPos
 * 	in: XmListWidget 	# List Widget
 * 	in: int			# Position
 */

static int 
cmd_XmListSetPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmListWidgetClass,"XmList")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmListWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XmListSetPos(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/MainW.h>
/* 
 * void
 * XmMainWindowSetAreas
 * 	in: NULL | Widget	# main window widget
 * 	in: NULL | Widget	# menu bar widget
 * 	in: NULL | Widget	# command window widget
 * 	in: NULL | Widget	# horizontal scrollbar widget
 * 	in: NULL | Widget	# vertical scrollbar widget
 * 	in: NULL | Widget	# work region widget
 */

static int 
cmd_XmMainWindowSetAreas(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     Widget localVar3;
     Widget localVar4;
     Widget localVar5;
     Widget localVar6;

     DBUG_ENTER(argv[0]);  

     if (argc != 7) 
	 {
	 wafeArgcError(argc,argv,"",6);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[1], "NULL")) 
         localVar1 = NULL;
     else
         if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[2], "NULL")) 
         localVar2 = NULL;
     else
         if (!(localVar2 = (Widget) name2Widget(argv[2])))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[3], "NULL")) 
         localVar3 = NULL;
     else
         if (!(localVar3 = (Widget) name2Widget(argv[3])))
         {
         wafeConvError(argc, argv, 3 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[4], "NULL")) 
         localVar4 = NULL;
     else
         if (!(localVar4 = (Widget) name2Widget(argv[4])))
         {
         wafeConvError(argc, argv, 4 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[5], "NULL")) 
         localVar5 = NULL;
     else
         if (!(localVar5 = (Widget) name2Widget(argv[5])))
         {
         wafeConvError(argc, argv, 5 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[6], "NULL")) 
         localVar6 = NULL;
     else
         if (!(localVar6 = (Widget) name2Widget(argv[6])))
         {
         wafeConvError(argc, argv, 6 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     XmMainWindowSetAreas(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/MenuShell.h>
/* 
 * void
 * XmMenuPosition
 * 	in: Widget		# menu widget
 * 	const: (XButtonPressedEvent *) wafeCurrentEvent
 */

static int 
cmd_XmMenuPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     XmMenuPosition(localVar1,(XButtonPressedEvent *) wafeCurrentEvent);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/MessageB.h>
/* 
 * WidgetID (WidgetID)
 * XmMessageBoxGetChild
 * 	in: XmMessageBoxWidget		# message box widget
 * 	in: (unsigned char)XmChild 	# child reference
 */

static int 
cmd_XmMessageBoxGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmMessageBoxWidgetClass,"XmMessageBox")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmMessageBoxWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[2], "DIALOG_CANCEL_BUTTON")) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DEFAULT_BUTTON")) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_HELP_BUTTON")) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_OK_BUTTON")) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_SEPARATOR")) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], "DIALOG_SYMBOL_LABEL")) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_MESSAGE_LABEL")) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_APPLY_BUTTON")) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST")) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST_LABEL")) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_LABEL")) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_TEXT")) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_LIST")) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_LIST_LABEL")) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_SELECTION_LABEL")) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_TEXT")) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_WORK_AREA")) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
     if (!strcmp(argv[2], "DIALOG_COMMAND_TEXT")) 
         localVar2 = XmDIALOG_COMMAND_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_PROMPT_LABEL")) 
         localVar2 = XmDIALOG_PROMPT_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_HISTORY_LIST")) 
         localVar2 = XmDIALOG_HISTORY_LIST;
     else
         {
         wafeConvError(argc,argv, 2,NULL, "XmChild");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = (WidgetID) XmMessageBoxGetChild(localVar1,localVar2);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/PanedW.h>
/* 
 * Boolean
 * XmProcessTraversal
 * 	in: Widget		# Widget for which to traverse hierarchy
 * 	in: (int) XmTravDir	# direction in which to traverse widget hierarchy
 */

static int 
cmd_XmProcessTraversal(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[2], "TRAVERSE_CURRENT")) 
         localVar2 = XmTRAVERSE_CURRENT;
     else
     if (!strcmp(argv[2], "TRAVERSE_NEXT")) 
         localVar2 = XmTRAVERSE_NEXT;
     else
     if (!strcmp(argv[2], "TRAVERSE_PREV")) 
         localVar2 = XmTRAVERSE_PREV;
     else
     if (!strcmp(argv[2], "TRAVERSE_HOME")) 
         localVar2 = XmTRAVERSE_HOME;
     else
     if (!strcmp(argv[2], "TRAVERSE_NEXT_TAB_GROUP")) 
         localVar2 = XmTRAVERSE_NEXT_TAB_GROUP;
     else
     if (!strcmp(argv[2], "TRAVERSE_PREV_TAB_GROUP")) 
         localVar2 = XmTRAVERSE_PREV_TAB_GROUP;
     else
     if (!strcmp(argv[2], "TRAVERSE_UP")) 
         localVar2 = XmTRAVERSE_UP;
     else
     if (!strcmp(argv[2], "TRAVERSE_DOWN")) 
         localVar2 = XmTRAVERSE_DOWN;
     else
     if (!strcmp(argv[2], "TRAVERSE_LEFT")) 
         localVar2 = XmTRAVERSE_LEFT;
     else
     if (!strcmp(argv[2], "TRAVERSE_RIGHT")) 
         localVar2 = XmTRAVERSE_RIGHT;
     else
         {
         wafeConvError(argc,argv, 2,NULL, "XmTravDir");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XmProcessTraversal(localVar1,localVar2);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
/* 
 * void
 * XmScrollBarGetValues 
 * 	in: XmScrollBarWidget		# scrollbar widget
 * 	out: int	      		# value (slider position)
 *         out: int              		# slider size
 * 	out: int              		# increment (smallest movement)
 * 	out: int              		# page increment
 */

static int 
cmd_XmScrollBarGetValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;
     int localVar5;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 6) 
	 {
	 wafeArgcError(argc,argv,"",5);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmScrollBarWidgetClass,"XmScrollBar")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmScrollBarWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XmScrollBarGetValues(localVar1,&localVar2,&localVar3,&localVar4,&localVar5);

     sprintf(conversionBuffer, "%d", localVar2);

     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar3);

     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar4);

     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar5);

     Tcl_SetVar(wafeInterpreter, argv[5], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmScrollBarSetValues 
 * 	in: XmScrollBarWidget 		# scrollbar widget
 * 	in: int	              		# value (slider position)
 *         in: int               		# slider size
 * 	in: int               		# increment (smallest movement)
 * 	in: int               		# page increment 
 * 	in: Boolean           		# notify
 */

static int 
cmd_XmScrollBarSetValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;
     int localVar5;
     Boolean localVar6;

     DBUG_ENTER(argv[0]);  

     if (argc != 7) 
	 {
	 wafeArgcError(argc,argv,"",6);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmScrollBarWidgetClass,"XmScrollBar")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmScrollBarWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[4], "%d", &localVar4)))
         {
         wafeConvError(argc, argv, 4 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[5], "%d", &localVar5)))
         {
         wafeConvError(argc, argv, 5 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[6],&localVar6)))
         {
         wafeConvError(argc, argv, 6 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XmScrollBarSetValues(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
/* 
 * WidgetID (WidgetID)
 * XmSelectionBoxGetChild
 * 	in: XmSelectionBoxWidget	# selection box widget
 * 	in: (unsigned char)XmChild 	# child reference
 */

static int 
cmd_XmSelectionBoxGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmSelectionBoxWidgetClass,"XmSelectionBox")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmSelectionBoxWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[2], "DIALOG_CANCEL_BUTTON")) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DEFAULT_BUTTON")) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_HELP_BUTTON")) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_OK_BUTTON")) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_SEPARATOR")) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], "DIALOG_SYMBOL_LABEL")) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_MESSAGE_LABEL")) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_APPLY_BUTTON")) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST")) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST_LABEL")) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_LABEL")) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_TEXT")) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_LIST")) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_LIST_LABEL")) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_SELECTION_LABEL")) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_TEXT")) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_WORK_AREA")) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
     if (!strcmp(argv[2], "DIALOG_COMMAND_TEXT")) 
         localVar2 = XmDIALOG_COMMAND_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_PROMPT_LABEL")) 
         localVar2 = XmDIALOG_PROMPT_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_HISTORY_LIST")) 
         localVar2 = XmDIALOG_HISTORY_LIST;
     else
         {
         wafeConvError(argc,argv, 2,NULL, "XmChild");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = (WidgetID) XmSelectionBoxGetChild(localVar1,localVar2);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/Separator.h>
#include <Xm/SeparatoG.h>
#include <Xm/Text.h>
/* 
 * void
 * XmTextClearSelection
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextClearSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XmTextClearSelection(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextCopy
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextCopy(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextCopy(localVar1,time(NULL));

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextCut
 * 	in: XmTextWidget 	# Text widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextCut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextCut(localVar1,time(NULL));

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/TextF.h>
/* 
 * void
 * XmTextFieldClearSelection
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextFieldClearSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XmTextFieldClearSelection(localVar1,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldCopy
 * 	in: XmTextFieldWidget 		# Text field widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextFieldCopy(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextFieldCopy(localVar1,time(NULL));

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldCut
 * 	in: XmTextFieldWidget 		# Text field widget
 * 	const: time(NULL)
 */

static int 
cmd_XmTextFieldCut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextFieldCut(localVar1,time(NULL));

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XmTextFieldGetBaseline
 * 	in: XmTextFieldWidget 		# Text field widget
 */

static int 
cmd_XmTextFieldGetBaseline(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextFieldGetBaseline(localVar1);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XmTextPosition
 * XmTextFieldGetLastPosition
 * 	in: XmTextFieldWidget 		# Text field widget
 */

static int 
cmd_XmTextFieldGetLastPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextFieldGetLastPosition(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (String) DString
 * XmTextFieldGetSelection
 * 	in: XmTextFieldWidget 		# Text field widget
 */

static int 
cmd_XmTextFieldGetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextFieldGetSelection(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldGetSelectionPosition
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	out: XmTextPosition	# left boundary
 * 	out: XmTextPosition     # right boundary
 */

static int 
cmd_XmTextFieldGetSelectionPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextFieldGetSelectionPosition(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", localVar2);

     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%ld", localVar3);

     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (String) DString
 * XmTextFieldGetString
 * 	in: XmTextFieldWidget	# Text field widget
 */

static int 
cmd_XmTextFieldGetString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextFieldGetString(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldInsert
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position
 * 	in: String              # text string to be inserted
 */

static int 
cmd_XmTextFieldInsert(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     XmTextFieldInsert(localVar1,localVar2,argv[3]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldPaste
 * 	in: XmTextFieldWidget 	# Text field widget
 */

static int 
cmd_XmTextFieldPaste(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextFieldPaste(localVar1);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldPosToXY
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position
 * 	out: Position		# x coord relative to top left
 * 	out: Position		# y coord relative to top left
 */

static int 
cmd_XmTextFieldPosToXY(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     Position localVar3;
     Position localVar4;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextFieldPosToXY(localVar1,localVar2,&localVar3,&localVar4);

     sprintf(conversionBuffer, "%hd", localVar3);

     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar4);

     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextFieldRemove
 * 	in: XmTextFieldWidget 	# Text field widget
 */

static int 
cmd_XmTextFieldRemove(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextFieldRemove(localVar1);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldReplace
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: String 		# insert string
 */

static int 
cmd_XmTextFieldReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     XmTextFieldReplace(localVar1,localVar2,localVar3,argv[4]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldSetAddMode
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: Boolean		# true | false
 */

static int 
cmd_XmTextFieldSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XmTextFieldSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldSetHighlight
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: XmHighlightMode	# HIGHLIGHT_NORMAL | HIGHLIGHT_SELECTED | HIGHLIGHT_SECONDARY_SELECTED
 */

static int 
cmd_XmTextFieldSetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     XmHighlightMode localVar4;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[4], "HIGHLIGHT_NORMAL")) 
         localVar4 = XmHIGHLIGHT_NORMAL;
     else
     if (!strcmp(argv[4], "HIGHLIGHT_SELECTED")) 
         localVar4 = XmHIGHLIGHT_SELECTED;
     else
     if (!strcmp(argv[4], "HIGHLIGHT_SECONDARY_SELECTED")) 
         localVar4 = XmHIGHLIGHT_SECONDARY_SELECTED;
     else
         {
         wafeConvError(argc,argv, 4,NULL, "XmHighlightMode");
         DBUG_RETURN (TCL_ERROR);
        }


     XmTextFieldSetHighlight(localVar1,localVar2,localVar3,localVar4);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldSetSelection
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	const: time(NULL)
 */

static int 
cmd_XmTextFieldSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     XmTextFieldSetSelection(localVar1,localVar2,localVar3,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldShowPosition
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: XmTextPosition	# character position to display
 */

static int 
cmd_XmTextFieldShowPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     XmTextFieldShowPosition(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextFieldXYToPos
 * 	in: XmTextFieldWidget 	# Text field widget
 * 	in: Position		# x coord relative to top left
 * 	in: Position		# y coord relative to top left
 */

static int 
cmd_XmTextFieldXYToPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Position");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "Position");
         DBUG_RETURN (TCL_ERROR);
         }

     XmTextFieldXYToPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XmTextGetBaseline
 * 	in: XmTextWidget 	# Text widget
 */

static int 
cmd_XmTextGetBaseline(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextGetBaseline(localVar1);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XmTextPosition
 * XmTextGetLastPosition
 * 	in: XmTextWidget 	# Text widget
 */

static int 
cmd_XmTextGetLastPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextGetLastPosition(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (String) DString
 * XmTextGetSelection
 * 	in: XmTextWidget 	# Text widget
 */

static int 
cmd_XmTextGetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextGetSelection(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextGetSelectionPosition
 * 	in: XmTextWidget 	# Text widget
 * 	out: XmTextPosition	# left boundary
 * 	out: XmTextPosition     # right boundary
 */

static int 
cmd_XmTextGetSelectionPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextGetSelectionPosition(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", localVar2);

     Tcl_SetVar(wafeInterpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%ld", localVar3);

     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (String) DString
 * XmTextGetString
 * 	in: XmTextWidget	# Text widget
 */

static int 
cmd_XmTextGetString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextGetString(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextInsert
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position
 * 	in: String              # text string to be inserted
 */

static int 
cmd_XmTextInsert(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     XmTextInsert(localVar1,localVar2,argv[3]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextPaste
 * 	in: XmTextWidget 	# Text widget
 */

static int 
cmd_XmTextPaste(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextPaste(localVar1);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextPosToXY
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position
 * 	out: Position		# x coord relative to top left
 * 	out: Position		# y coord relative to top left
 */

static int 
cmd_XmTextPosToXY(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     Position localVar3;
     Position localVar4;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextPosToXY(localVar1,localVar2,&localVar3,&localVar4);

     sprintf(conversionBuffer, "%hd", localVar3);

     Tcl_SetVar(wafeInterpreter, argv[3], conversionBuffer, 0);

     sprintf(conversionBuffer, "%hd", localVar4);

     Tcl_SetVar(wafeInterpreter, argv[4], conversionBuffer, 0);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XmTextRemove
 * 	in: XmTextWidget 	# Text widget
 */

static int 
cmd_XmTextRemove(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmTextRemove(localVar1);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextReplace
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: String 		# insert string
 */

static int 
cmd_XmTextReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     XmTextReplace(localVar1,localVar2,localVar3,argv[4]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextScroll
 * 	in: XmTextWidget 	# Text widget
 * 	in: int			# number of lines to scroll
 */

static int 
cmd_XmTextScroll(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XmTextScroll(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextSetAddMode
 * 	in: XmTextWidget 	# Text widget
 * 	in: Boolean		# true | false
 */

static int 
cmd_XmTextSetAddMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XmTextSetAddMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextSetHighlight
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	in: XmHighlightMode	# HIGHLIGHT_NORMAL | HIGHLIGHT_SELECTED | HIGHLIGHT_SECONDARY_SELECTED
 */

static int 
cmd_XmTextSetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;
     XmHighlightMode localVar4;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[4], "HIGHLIGHT_NORMAL")) 
         localVar4 = XmHIGHLIGHT_NORMAL;
     else
     if (!strcmp(argv[4], "HIGHLIGHT_SELECTED")) 
         localVar4 = XmHIGHLIGHT_SELECTED;
     else
     if (!strcmp(argv[4], "HIGHLIGHT_SECONDARY_SELECTED")) 
         localVar4 = XmHIGHLIGHT_SECONDARY_SELECTED;
     else
         {
         wafeConvError(argc,argv, 4,NULL, "XmHighlightMode");
         DBUG_RETURN (TCL_ERROR);
        }


     XmTextSetHighlight(localVar1,localVar2,localVar3,localVar4);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextSetSelection
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# from character position
 * 	in: XmTextPosition	# to character position
 * 	const: time(NULL)
 */

static int 
cmd_XmTextSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;
     XmTextPosition localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     XmTextSetSelection(localVar1,localVar2,localVar3,time(NULL));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextShowPosition
 * 	in: XmTextWidget 	# Text widget
 * 	in: XmTextPosition	# character position to display
 */

static int 
cmd_XmTextShowPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextPosition localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "XmTextPosition");
         DBUG_RETURN (TCL_ERROR);
         }

     XmTextShowPosition(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmTextXYToPos
 * 	in: XmTextWidget 	# Text widget
 * 	in: Position		# x coord relative to top left
 * 	in: Position		# y coord relative to top left
 */

static int 
cmd_XmTextXYToPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Position");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "Position");
         DBUG_RETURN (TCL_ERROR);
         }

     XmTextXYToPos(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ToggleB.h>
/* 
 * Boolean
 * XmToggleButtonGetState
 * 	in: XmToggleButtonWidget	# toggle button widget
 */

static int 
cmd_XmToggleButtonGetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonWidgetClass,"XmToggleButton")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmToggleButtonWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmToggleButtonGetState(localVar1);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmToggleButtonSetState
 * 	in: XmToggleButtonWidget	# toggle button widget
 * 	in: Boolean			# state (bool)
 * 	in: Boolean             	# notify (bool)
 */

static int 
cmd_XmToggleButtonSetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     Boolean localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonWidgetClass,"XmToggleButton")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmToggleButtonWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[3],&localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XmToggleButtonSetState(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ToggleBG.h>
/* 
 * Boolean
 * XmToggleButtonGadgetGetState
 * 	in: XmToggleButtonGadget	# toggle button widget
 */

static int 
cmd_XmToggleButtonGadgetGetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonGadgetClass,"XmToggleButton")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmToggleButtonGadget");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XmToggleButtonGadgetGetState(localVar1);

     Tcl_SetResult(comInterpreter, returnVar ? "1" : "0", TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmToggleButtonGadgetSetState
 * 	in: XmToggleButtonGadget	# toggle button gadget
 * 	in: Boolean			# state (bool)
 * 	in: Boolean             	# notify (bool)
 */

static int 
cmd_XmToggleButtonGadgetSetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     Boolean localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmToggleButtonGadgetClass,"XmToggleButton")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmToggleButtonGadget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[3],&localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XmToggleButtonGadgetSetState(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmUpdateDisplay
 * 	in: Widget			# widget to determine display
 */

static int 
cmd_XmUpdateDisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

     XmUpdateDisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/Protocols.h>

#define name2AtomNdsp(s) wafeStringToAtom(localVar1,s)

/* 
 * void
 * wafeAddProtocol vulgo XmAddProtocol
 * 	in: Widget			# widget associated with protocol
 * 	in: name2AtomNdsp(String)	# property atom 
 * 	in: name2AtomNdsp(String)	# protocol atom
 */

static int 
cmd_XmAddProtocol(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     wafeAddProtocol(localVar1,name2AtomNdsp(argv[2]),name2AtomNdsp(argv[3]));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * wafeAddProtocolCallback vulgo XmAddProtocolCallback
 * 	in: Widget			# widget associated with protocol
 * 	in: name2AtomNdsp(String)	# property atom 
 * 	in: name2AtomNdsp(String)	# protocol atom 
 * 	in: String			# command to be executed
 */

static int 
cmd_XmAddProtocolCallback(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     wafeAddProtocolCallback(localVar1,name2AtomNdsp(argv[2]),name2AtomNdsp(argv[3]),argv[4]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmActivateProtocol
 * 	in: Widget			# widget associated with protocol
 * 	in: name2AtomNdsp(String)	# property atom 
 * 	in: name2AtomNdsp(String)	# protocol atom
 */

static int 
cmd_XmActivateProtocol(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     XmActivateProtocol(localVar1,name2AtomNdsp(argv[2]),name2AtomNdsp(argv[3]));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmDeactivateProtocol
 * 	in: Widget			# widget associated with protocol
 * 	in: name2AtomNdsp(String)	# property atom 
 * 	in: name2AtomNdsp(String)	# protocol atom
 */

static int 
cmd_XmDeactivateProtocol(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Widget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     XmDeactivateProtocol(localVar1,name2AtomNdsp(argv[2]),name2AtomNdsp(argv[3]));

     DBUG_RETURN (TCL_OK);
     }     


#define wafeTextSetSelectionArray(w,argc,array) XtVaSetValues(w, XmNselectionArray,array,XmNselectionArrayCount, argc)

/* 
 * void
 * wafeTextSetSelectionArray vulgo XmTextSetSelectionArray
 * 	in: XmTextWidget		# motif text widget
 *         const: argc-2
 * 	in: [XmTextScanType]		# selection array
 */

static int 
cmd_XmTextSetSelectionArray(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextScanType * localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 {
	 wafeArgcError(argc,argv,"at least ",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextWidgetClass,"XmText")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     {    XmTextScanType *ptr;
          argv += 2;
          localVar2 = ptr =
             (XmTextScanType *)XtMalloc((argc-2)*sizeof(XmTextScanType));

          while (*argv)
             {
             if (!strcmp(*argv, "SELECT_POSITION")) 
                 *ptr = XmSELECT_POSITION;
             else
             if (!strcmp(*argv, "SELECT_WHITESPACE")) 
                 *ptr = XmSELECT_WHITESPACE;
             else
             if (!strcmp(*argv, "SELECT_WORD")) 
                 *ptr = XmSELECT_WORD;
             else
             if (!strcmp(*argv, "SELECT_LINE")) 
                 *ptr = XmSELECT_LINE;
             else
             if (!strcmp(*argv, "SELECT_ALL")) 
                 *ptr = XmSELECT_ALL;
             else
             if (!strcmp(*argv, "SELECT_PARAGRAPH")) 
                 *ptr = XmSELECT_PARAGRAPH;
             else
                 {
                 wafeConvError(argc,argv, 2,NULL, "XmTextScanType");
                 DBUG_RETURN (TCL_ERROR);
                }


          ptr ++; argv++;
          }
     }
     wafeTextSetSelectionArray(localVar1,argc-2,localVar2);
     wafeMMreplace(wafeMMgetAttribList(localVar1,True),WafePermStringToQuark("XmTextSetSelectionArray"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * wafeTextSetSelectionArray vulgo XmTextFieldSetSelectionArray
 * 	in: XmTextFieldWidget		# motif text field widget
 *         const: argc-2
 * 	in: [XmTextScanType]		# selection array
 */

static int 
cmd_XmTextFieldSetSelectionArray(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmTextScanType * localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 {
	 wafeArgcError(argc,argv,"at least ",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmTextFieldWidgetClass,"XmTextField")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XmTextFieldWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     {    XmTextScanType *ptr;
          argv += 2;
          localVar2 = ptr =
             (XmTextScanType *)XtMalloc((argc-2)*sizeof(XmTextScanType));

          while (*argv)
             {
             if (!strcmp(*argv, "SELECT_POSITION")) 
                 *ptr = XmSELECT_POSITION;
             else
             if (!strcmp(*argv, "SELECT_WHITESPACE")) 
                 *ptr = XmSELECT_WHITESPACE;
             else
             if (!strcmp(*argv, "SELECT_WORD")) 
                 *ptr = XmSELECT_WORD;
             else
             if (!strcmp(*argv, "SELECT_LINE")) 
                 *ptr = XmSELECT_LINE;
             else
             if (!strcmp(*argv, "SELECT_ALL")) 
                 *ptr = XmSELECT_ALL;
             else
             if (!strcmp(*argv, "SELECT_PARAGRAPH")) 
                 *ptr = XmSELECT_PARAGRAPH;
             else
                 {
                 wafeConvError(argc,argv, 2,NULL, "XmTextScanType");
                 DBUG_RETURN (TCL_ERROR);
                }


          ptr ++; argv++;
          }
     }
     wafeTextSetSelectionArray(localVar1,argc-2,localVar2);
     wafeMMreplace(wafeMMgetAttribList(localVar1,True),WafePermStringToQuark("XmTextFieldSetSelectionArray"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * TCL_RETURN_CODE
 * wafeModifyVerifyCBset vulgo XmModifyVerifyCBset
 *         in: Boolean     		# doit
 *         in: long        		# currInsert
 *         in: long        		# startPos
 *         in: long        		# endPos
 *         in: String        		# String

 */

static int 
cmd_XmModifyVerifyCBset(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Boolean localVar1;
     long localVar2;
     long localVar3;
     long localVar4;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 6) 
	 {
	 wafeArgcError(argc,argv,"",5);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[1],&localVar1)))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "long");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "long");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[4], "%ld", &localVar4)))
         {
         wafeConvError(argc, argv, 4 ,NULL, "long");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar5 = argv[5] >>  */ 

     returnVar = wafeModifyVerifyCBset(localVar1,localVar2,localVar3,localVar4,argv[5]);

     DBUG_RETURN (returnVar);
     }     


#endif  /* of ifdef MOTIF11 */

void
wafeInitialize_MOTIF11()
{
#ifdef MOTIF11
 wafeCreateWidgetCommand("XmArrowButton",xmArrowButtonWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmArrowButtonGadget",xmArrowButtonGadgetClass,NULL,False);
 wafeCreateWidgetCommand("XmBulletinBoard",xmBulletinBoardWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmBulletinBoardDialog",xmBulletinBoardWidgetClass,XmCreateBulletinBoardDialog,True);
 wafeCreateWidgetCommand("XmCascadeButton",xmCascadeButtonWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmCascadeButtonGadget",xmCascadeButtonGadgetClass,NULL,False);
 wafeCreateWidgetCommand("XmCommand",xmCommandWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmDialogShell",xmDialogShellWidgetClass,NULL,True);
 wafeCreateWidgetCommand("XmDrawingArea",xmDrawingAreaWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmDrawnButton",xmDrawnButtonWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmErrorDialog",xmMessageBoxWidgetClass,XmCreateErrorDialog,True);
 wafeCreateWidgetCommand("XmFileSelectionBox",xmFileSelectionBoxWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmFileSelectionDialog",xmFileSelectionBoxWidgetClass,XmCreateFileSelectionDialog,True);
 wafeCreateWidgetCommand("XmForm",xmFormWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmFormDialog",xmFormWidgetClass,XmCreateFormDialog,True);
 wafeCreateWidgetCommand("XmFrame",xmFrameWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmInformationDialog",xmMessageBoxWidgetClass,XmCreateInformationDialog,True);
 wafeCreateWidgetCommand("XmLabel",xmLabelWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmLabelGadget",xmLabelGadgetClass,NULL,False);
 wafeCreateWidgetCommand("XmList",xmListWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmMainWindow",xmMainWindowWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmMenuBar",xmRowColumnWidgetClass,XmCreateMenuBar,False);
 wafeCreateWidgetCommand("XmMenuShell",xmMenuShellWidgetClass,NULL,True);
 wafeCreateWidgetCommand("XmMessageBox",xmMessageBoxWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmMessageDialog",xmMessageBoxWidgetClass,XmCreateMessageDialog,True);
 wafeCreateWidgetCommand("XmOptionMenu",xmRowColumnWidgetClass,XmCreateOptionMenu,False);
 wafeCreateWidgetCommand("XmPanedWindow",xmPanedWindowWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmPopupMenu",xmRowColumnWidgetClass,XmCreatePopupMenu,False);
 wafeCreateWidgetCommand("XmPromptDialog",xmSelectionBoxWidgetClass,XmCreatePromptDialog,True);
 wafeCreateWidgetCommand("XmPulldownMenu",xmRowColumnWidgetClass,XmCreatePulldownMenu,False);
 wafeCreateWidgetCommand("XmPushButton",xmPushButtonWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmPushButtonGadget",xmPushButtonGadgetClass,NULL,False);
 wafeCreateWidgetCommand("XmQuestionDialog",xmMessageBoxWidgetClass,XmCreateQuestionDialog,True);
 wafeCreateWidgetCommand("XmRadioBox",xmRowColumnWidgetClass,XmCreateRadioBox,False);
 wafeCreateWidgetCommand("XmRowColumn",xmRowColumnWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmScale",xmScaleWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmScrollBar",xmScrollBarWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmScrolledList",xmListWidgetClass,XmCreateScrolledList,False);
 wafeCreateWidgetCommand("XmScrolledText",xmTextWidgetClass,XmCreateScrolledText,False);
 wafeCreateWidgetCommand("XmScrolledWindow",xmScrolledWindowWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmSelectionBox",xmSelectionBoxWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmSelectionDialog",xmSelectionBoxWidgetClass,XmCreateSelectionDialog,True);
 wafeCreateWidgetCommand("XmSeparator",xmSeparatorWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmSeparatorGadget",xmSeparatorGadgetClass,NULL,False);
 wafeCreateWidgetCommand("XmSimpleCheckBox",xmRowColumnWidgetClass,XmCreateSimpleCheckBox,False);
 wafeCreateWidgetCommand("XmSimpleMenuBar",xmRowColumnWidgetClass,XmCreateSimpleMenuBar,False);
 wafeCreateWidgetCommand("XmSimpleOptionMenu",xmRowColumnWidgetClass,XmCreateSimpleOptionMenu,False);
 wafeCreateWidgetCommand("XmSimplePopupMenu",xmRowColumnWidgetClass,XmCreateSimplePopupMenu,False);
 wafeCreateWidgetCommand("XmSimplePulldownMenu",xmRowColumnWidgetClass,XmCreateSimplePulldownMenu,False);
 wafeCreateWidgetCommand("XmSimpleRadioBox",xmRowColumnWidgetClass,XmCreateSimpleRadioBox,False);
 wafeCreateWidgetCommand("XmText",xmTextWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmTextField",xmTextFieldWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmToggleButton",xmToggleButtonWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XmToggleButtonGadget",xmToggleButtonGadgetClass,NULL,False);
 wafeCreateWidgetCommand("XmWarningDialog",xmMessageBoxWidgetClass,XmCreateWarningDialog,True);
 wafeCreateWidgetCommand("XmWorkingDialog",xmMessageBoxWidgetClass,XmCreateWorkingDialog,True);
#ifdef MOTIF11
 Tcl_SetVar(wafeInterpreter,"PACKAGES","MOTIF11",TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT);
#endif
 XtSetTypeConverter(XtRString, "XmString",
	(XtTypeConverter)CvtStringToXmString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "XmStringTable",
	(XtTypeConverter)CvtStringToXmStrings, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "Window",
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "MenuWidget",
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter("XmString", XtRString,
	(XtTypeConverter)CvtXmStringToString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter("XmStringTable", XtRString,
	(XtTypeConverter)CvtXmStringTableToString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "TextPosition",
	(XtTypeConverter)CvtStringToLong, 
	NULL, 0, XtCacheNone, NULL);
 wafeMotifInit();
 qXmStringTable = WafePermStringToQuark("XmStringTable");
 qitems = WafePermStringToQuark("items");
 qselectedItems = WafePermStringToQuark("selectedItems");
 qXmString = WafePermStringToQuark("XmString");
 qWindow = WafePermStringToQuark("Window");
 qMenuWidget = WafePermStringToQuark("MenuWidget");
 qHorizontalDimension = WafePermStringToQuark("HorizontalDimension");
 qVerticalDimension = WafePermStringToQuark("VerticalDimension");
 qShellHorizDim = WafePermStringToQuark("ShellHorizDim");
 qShort = WafePermStringToQuark("Short");
 qShellVertDim = WafePermStringToQuark("ShellVertDim");
 qTextPosition = WafePermStringToQuark("TextPosition");
 qVerticalPosition = WafePermStringToQuark("VerticalPosition");
 qHorizontalPosition = WafePermStringToQuark("HorizontalPosition");
 qPrimForegroundPixmap = WafePermStringToQuark("PrimForegroundPixmap");
 qsource = WafePermStringToQuark("source");
 XtAddConverter (XmRString, XmRUnitType, XmCvtStringToUnitType, NULL, 0);
 Tcl_CreateCommand(wafeInterpreter, "XmAddTabGroup", cmd_XmAddTabGroup, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmCascadeButtonGadgetHighlight", cmd_XmCascadeButtonGadgetHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmCascadeButtonHighlight", cmd_XmCascadeButtonHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmCommandAppendValue", cmd_XmCommandAppendValue, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmCommandError", cmd_XmCommandError, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmCommandGetChild", cmd_XmCommandGetChild, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmFileSelectionBoxGetChild", cmd_XmFileSelectionBoxGetChild, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmFileSelectionDoSearch", cmd_XmFileSelectionDoSearch, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmGetDestination", cmd_XmGetDestination, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListAddItem", cmd_XmListAddItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListAddItems", cmd_XmListAddItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListAddItemUnselected", cmd_XmListAddItemUnselected, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeleteAllItems", cmd_XmListDeleteAllItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeleteItem", cmd_XmListDeleteItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeleteItems", cmd_XmListDeleteItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeleteItemsPos", cmd_XmListDeleteItemsPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeletePos", cmd_XmListDeletePos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeselectAllItems", cmd_XmListDeselectAllItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeselectItem", cmd_XmListDeselectItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListDeselectPos", cmd_XmListDeselectPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListGetMatchPos", cmd_XmListGetMatchPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListGetSelectedPos", cmd_XmListGetSelectedPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListItemExists", cmd_XmListItemExists, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListItemPos", cmd_XmListItemPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListReplaceItems", cmd_XmListReplaceItems, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListReplaceItemsPos", cmd_XmListReplaceItemsPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSelectItem", cmd_XmListSelectItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSelectPos", cmd_XmListSelectPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetAddMode", cmd_XmListSetAddMode, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetBottomItem", cmd_XmListSetBottomItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetBottomPos", cmd_XmListSetBottomPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetHorizPos", cmd_XmListSetHorizPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetItem", cmd_XmListSetItem, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmListSetPos", cmd_XmListSetPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmMainWindowSetAreas", cmd_XmMainWindowSetAreas, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmMenuPosition", cmd_XmMenuPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmMessageBoxGetChild", cmd_XmMessageBoxGetChild, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmProcessTraversal", cmd_XmProcessTraversal, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmScrollBarGetValues", cmd_XmScrollBarGetValues, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmScrollBarSetValues", cmd_XmScrollBarSetValues, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmSelectionBoxGetChild", cmd_XmSelectionBoxGetChild, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextClearSelection", cmd_XmTextClearSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextCopy", cmd_XmTextCopy, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextCut", cmd_XmTextCut, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldClearSelection", cmd_XmTextFieldClearSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldCopy", cmd_XmTextFieldCopy, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldCut", cmd_XmTextFieldCut, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldGetBaseline", cmd_XmTextFieldGetBaseline, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldGetLastPosition", cmd_XmTextFieldGetLastPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldGetSelection", cmd_XmTextFieldGetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldGetSelectionPosition", cmd_XmTextFieldGetSelectionPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldGetString", cmd_XmTextFieldGetString, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldInsert", cmd_XmTextFieldInsert, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldPaste", cmd_XmTextFieldPaste, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldPosToXY", cmd_XmTextFieldPosToXY, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldRemove", cmd_XmTextFieldRemove, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldReplace", cmd_XmTextFieldReplace, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldSetAddMode", cmd_XmTextFieldSetAddMode, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldSetHighlight", cmd_XmTextFieldSetHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldSetSelection", cmd_XmTextFieldSetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldShowPosition", cmd_XmTextFieldShowPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldXYToPos", cmd_XmTextFieldXYToPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextGetBaseline", cmd_XmTextGetBaseline, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextGetLastPosition", cmd_XmTextGetLastPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextGetSelection", cmd_XmTextGetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextGetSelectionPosition", cmd_XmTextGetSelectionPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextGetString", cmd_XmTextGetString, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextInsert", cmd_XmTextInsert, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextPaste", cmd_XmTextPaste, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextPosToXY", cmd_XmTextPosToXY, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextRemove", cmd_XmTextRemove, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextReplace", cmd_XmTextReplace, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextScroll", cmd_XmTextScroll, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextSetAddMode", cmd_XmTextSetAddMode, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextSetHighlight", cmd_XmTextSetHighlight, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextSetSelection", cmd_XmTextSetSelection, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextShowPosition", cmd_XmTextShowPosition, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextXYToPos", cmd_XmTextXYToPos, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmToggleButtonGetState", cmd_XmToggleButtonGetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmToggleButtonSetState", cmd_XmToggleButtonSetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmToggleButtonGadgetGetState", cmd_XmToggleButtonGadgetGetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmToggleButtonGadgetSetState", cmd_XmToggleButtonGadgetSetState, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmUpdateDisplay", cmd_XmUpdateDisplay, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmAddProtocol", cmd_XmAddProtocol, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmAddProtocolCallback", cmd_XmAddProtocolCallback, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmActivateProtocol", cmd_XmActivateProtocol, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmDeactivateProtocol", cmd_XmDeactivateProtocol, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextSetSelectionArray", cmd_XmTextSetSelectionArray, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmTextFieldSetSelectionArray", cmd_XmTextFieldSetSelectionArray, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XmModifyVerifyCBset", cmd_XmModifyVerifyCBset, NULL, NULL);

#else
#endif /* of ifdef MOTIF11 */
}
