
proc wafeHelp {cmd {errorType {}} args} {
#  puts stderr "<$cmd> <$errorType> <$args>" 
  if [catch {set cmdTypeArgs [$cmd-type]}] {
    puts stderr "No Help available for command $cmd!"
    return
  }
  set cmdType [lindex $cmdTypeArgs 0]

  if ![string compare $cmdType alias] {
    set alias $cmd
    set cmd [lindex $cmdTypeArgs 1]
    if [catch {set cmdTypeArgs [$cmd-type]}] {
      puts stderr "No Help available for command $cmd!"
      return
    }
    set cmdType [lindex $cmdTypeArgs 0]
  } else {
    set alias ""
  }

  global wafeHelp  
  set cmdArgs [lindex $cmdTypeArgs 1]
#  puts stderr cmdTypeArgs=$cmdTypeArgs.
#  puts stderr cmdTypeArgs(1)=[lindex $cmdTypeArgs 0].

  switch $cmdType {
    creationCommand {
      set willCreate $cmdArgs
      set syntax "<widgetId>\n\
	  $cmd <widgetName> <parentWidget> <unmanaged>? <resource value>*"
      set text "\
	  The command $cmd creates on successful completion a $willCreate\n\
	  with the name specified in the second argument as child of the\n\
	  already existing <parentWidget>. Unless the constant 'unmanaged'\n\
	  is given as 3rd argument, the created $willCreate will be managed.\n\n"
    }
    function {
      # puts stderr cmdArgs=$cmdTypeArgs
      regexp {^(.*)##(.*)$} $cmdTypeArgs all arguments argdoc
      set returnValue [lindex $arguments 1]
      set arguments   [lrange $arguments 1 end]
      if ![string compare $returnValue void] {
	set returnValue ""
      } else {
	set returnValue \n\ $returnValue
      }
      set text [set argList [set where [set multiple ""]]]
      set i 0;set j -1
      foreach arg $arguments {
	# puts stderr arg=$arg
	if [regexp {[Ii]n: *([^ ].*)} $arg m argType] {
	  append argList \ [wafeHelpArgParse $argType]
	  if [string match "" $multiple] {
	    set argt "input arg [incr i]"
	  } else {
	    append argList +
	    set argt $multiple
	  }
	  append where "\n   $argt: [lindex $argdoc [incr j]]"
	} elseif [regexp {[Oo]ut: *([^ ].*)} $arg m argType] {
	  append argList \ [wafeHelpArgParse $argType]
	  if [string match "" $multiple] {
	    set argt "output arg [incr i]"
	  } else {
	    append argList +
	    set argt $multiple
	  }
	  append where "\n   $argt: [lindex $argdoc [incr j]]"
	} elseif [regexp {[Cc]allmultiple} $arg m ] {
	  set multiple "multiple arguments"
	}
      }
      set syntax " $returnValue\n\
	  $cmd$argList$where"
    }
  }
  if [info exists wafeHelp($cmd)] { append text $wafeHelp($cmd) }

  switch $errorType {
    "" {
      if [string compare "" $alias] {
	puts stderr "$alias is an alias for the command $cmd."
      }
      puts stderr "\nSyntax:$syntax"
      puts stderr "\nDescription:\n$text\n"
    }
    argc {
      set quant  [lindex $args 0]
      set expect [lindex $args 1]
      set count  [lindex $args 2]
      set fullCmd  [wafeHelpAbbrevCmd [lindex $args 3]]
      set es [expr {$expect==1 ? "" : "s"}]
      set cs [expr {$count==1 ? "" : "s"}]
      set ws [expr {$count==1 ? "was" : "were"}]
      set reason "\n\
	    Argument count error occured in command:\n\
	    \ \ \ $fullCmd\n"
      if [string match "balanced *" $quant] {
	return "$reason\
	    Command '$cmd' expects the same number of attributes and values,\n\
	    more attributes were given.\n\nSyntax:$syntax\n"
      } else {
	return "$reason\
	    Command '$cmd' expects $quant$expect argument$es, $count argument$cs $ws given.\n\nSyntax:$syntax\n"
      }
    }
    convert {
      set arg  [lindex $args 0]
      set pos  [lindex $args 1]
      set type [lindex $args 2]
      set fullCmd  [wafeHelpAbbrevCmd [lindex $args 3]]
      return "\n\
	  Conversion error occured in command:\n\
	  \ \ $fullCmd\n\
	  Could not convert argument $pos '$arg' to type $type.\n\nSyntax:\n$syntax"
    }
    varComp {
      set comp  [lindex $args 0]
      set array [lindex $args 1]
      set fullCmd  [wafeHelpAbbrevCmd [lindex $args 3]]
      return "\n\
	  Tcl array component error occured in command:\n\
	  \ \ $fullCmd\n\
	  The Tcl array '$array' does not contain a component '$comp'.\n\nSyntax:\n$syntax"
    }
  }
}

proc wafeHelpArgParse {argType} {
  if ![string compare {[args avp]} $argType] {
    return "<attribute value>+"
  }
  regexp {^\(.*\)(.*)$} $argType m argType; #cast
  regexp {\((.*)\)}     $argType m argType; #macro|function
  return <$argType>
}


proc wafeHelpAbbrevCmd {fullCmd} {
  set result {}
  set nrToken 0
  foreach token $fullCmd {
    if {[incr nrToken]>15} {
      lappend result ...
      break
    }
    if {[string length $token]>15} {
      lappend result [string range $token 0 15]...
    } else {
      lappend result $token
    }
  }
  return $result
}

