proc addTimeOut-type {} { return {function {XtIntervalId} {const: wafeAppContext} {in: unsigned long} {const: timerProc} {in: XtNewString(String)} ## {time interval in ms} {Tcl command}}}
set wafeHelp(addTimeOut) { The command 'addTimeOut' creates a timeout and returns an identifier
 for it.  The timeout interval is set in ms.  The callback procedure
 (the specified Tcl command) is called when the time interval
 elapses, and then the timeout is removed.}

proc action-type {} { return {function {void} {in: Widget} {in: (int)TranslationModifier} {in: XtTranslations} ## {widget} {override | augment | replace} {translation table}}}
set wafeHelp(action) { The command 'action' calls depending on its 2nd argument the Xt
 functions XtAugmentTranslations, XtOverrideTranslations or
 XtSetValues to update the translation table of the specified
 widget.
 
 If "augment" is specified the function nondestructively merges the
 new translations into the existing widget translations.  If the new
 translations contain an event or event sequence that already exists
 in the widget's translations, the new translation is ignored.
 
 If "override" is specified the function destructively merges the
 new translations into the existing widget translations.  If the new
 translations contain an event or event sequence that already exists
 in the widget's translations, the new translation is merged in and
 override the widget's translation.
 
 If "replace" is specified the function replaces the existing
 translation table completely with the specified table.}

proc ApplicationShell-type {} { return {creationCommand Widget}}
set wafeHelp(ApplicationShell) { The ApplicationShell widget class is a subclass of TopLevelShell
 that is used for normal top level application window. Instead of
 the parent diget the third argument is interpreted as display
 string (eg unix:0.0).}

proc bell-type {} { return {function {void} {in: XtDisplay(Widget)} {in: int} ## {widget to determine display} {percent (-100 = off, 0 .. 100)}}}
set wafeHelp(bell) { The command 'bell' rings the bell on the keyboard of the display of
 the specified widget, if possible.  The specified volume is
 relative to the base volume for the keyboard.  If the value for the
 percent argument is not in the range -100 to 100 inclusive, a
 BadValue error results.  The volume at which the bell rings when
 the percent argument is nonnegative is:

             base - [(base * percent) / 100] + percent

 The volume at which the bell rings when the percent argument is
 negative is:

               base + [(base * percent) / 100]}

proc callActionProc-type {} { return {function {void} {in: Widget} {in: String} {in: String} {in: [args opt]} ## {widget} {event structure} {name of action procedure} {parameters of action procedure}}}
set wafeHelp(callActionProc) { The command 'callActionProc' can be used to call explicitely the
 specified action procedure of the given widget. CallActionProc
 searches for the named action routine in the same manner and order
 as translation tables are bound.  If found, the action routine is
 invoked with the specified widget, event pointer, and parameters.
 Certain parts of the event structure can be specified via the 2nd
 argument.}

proc callCallbacks-type {} { return {function {void} {in: Widget} {in: String} {in: [args opt]} ## {widget} {callback} {optional float and value}}}
set wafeHelp(callCallbacks) { The command 'callCallbacks' calls each procedure that is registered
 in the specified widget's callback list. The optional constant
 "float" and value should be used only for callback procedures that
 expect this in their CallData arguments (eg. the "jumpProc"
 callback in the athena Scrollbar widget class).}

proc callback-type {} { return {function {void} {in: Widget} {in: String} {in: XtCallbackProc} {in: String} ## {widget} {callback resource} {none | exclusive | nonexclusive | popdown | position | positionCursor} {string (depends on third argument, widget reference for none | exclusive | nonexclusive | popdown)}}}
set wafeHelp(callback) { The command 'callback' can be used to set the callback resource of
 the named widget to one of Wafe's predefined toolkit function. For
 the predefined types refer to the following table. Note that the
 execution of a Wafe command can be registered with the callback
 resource of a widget with the setValues command.

   none             realize a popup-shell, grab-type none
   exclusive        realize a popup-shell, grab-type exclusive
   nonexclusive     realize a popup-shell, grab-type nonexclusive
   popdown          unrealize a popup-shell
   position         position a popup-shell relative to its parent
   positionCursor   position a popup-shell under the cursor
 
 The contents of 4th argument depend on the predefined callback
 types and is a widget reference, if the 3rd argment is "none",
 "exclusive", "nonexclusive" or "popdown". if the 3rd argument is
 "position", the 4th argument has the form
 "widgetreference:xoffset/yoffset", where the offsets are
 optional. If the 3rd argument is "positionCursor" the 4th argument
 will be treated as a relative position. If it is 0 the widget will
 pop up centered over the cursor if possible.}

proc combineFileDatabase-type {} { return {function {Status} {in: String} {in: Widget} {in: Bool} ## {filename} {widget to determine database} {override}}}
set wafeCmdNeeds(combineFileDatabase) {R5 }

proc destroyWidget-type {} { return {function {void} {callmultiple} {in: wafeMMfreeGarbage(Widget)} ## {widgets}}}
set wafeHelp(destroyWidget) { The command 'destroyWidget' takes any number of widget references
 as arguments, destroys these and releases all widget specific
 allocated resources.}

proc fallbackResources-type {} { return {function {void} {in: Widget} {in: [args avp]} ## {widget to determine database} {resource-specification  value pairs}}}
set wafeCmdNeeds(fallbackResources) {R5 }

proc fontHeight-type {} { return {function {int} {pre: \{XFontStruct *font; XtVaGetValues(localVar1, argv[2], &font, NULL);} {in: Widget} {in: String} {post: \}} ## {Widget} {fontResource}}}
set wafeHelp(fontHeight) { The function 'fontHeight' returns the height of a font in
 pixels. The font is taken is taken from the given 'fontResource'
 (2nd argument) of the given widget (first argument).}

proc flush-type {} { return {function {void} {in: XtDisplay(Widget)} ## {Widget to determine display}}}
set wafeHelp(flush) { The command 'flush' flushes the output buffer from the client to X
 server connection.  Most client applications need not use this
 function because the output buffer is automatically flushed as
 needed by calls to XPending, XNextEvent, and XWindowEvent.  Events
 generated by the server may be enqueued into the library's event
 queue.}

proc getApplicationResource-type {} { return {function {String} {in: Widget} {in: String} {in: String} ## {base widget} {resource name} {resource class}}}
set wafeHelp(getApplicationResource) { The function 'getApplicationResource' can be used to obtain values
 from the Xt's resource database from the screen of the specified
 widget (1st argument). The provided resourceName (2nd argument) and
 resourceClass (3rd argument) can be arbitrary, application specific
 strings different from with the widget's resources provided by the
 toolkit.  On success the return value is the fetched resource
 value, on failure, an empty string is returned. For Boolean
 resources (the specified resource class is "Boolean"), 0 or 1 is
 returned.}

proc getClass-type {} { return {function {String} {in: Widget} ## {widget}}}
set wafeHelp(getClass) { The function 'getClass' returns the class of the specified widget
 in form of a string.}

proc getResourceList-type {} { return {function {int} {in: Widget} {out: String *} {end: XtFree((String)localVar2);} ## {widget} {variable name for output of list of resources}}}
set wafeHelp(getResourceList) { The command  'getResourceList' returns the number of
 resources for a specified widget instance and the list of resources
 in the variable specified as third argument. Note that the returned
 list might contain inherited geometry constraint resources and the
 like.}

proc getTypeOfAttribute-type {} { return {function {String} {in: XtClass(Widget)} {const: ParentWidget(localVar1)} {in: XrmStringToQuark(String)} ## {widget} {attribute}}}
set wafeHelp(getTypeOfAttribute) { The function 'getTypeOfAttribute' returns the type of the given
 attribute (2nd argument)for the specified widget (first
 argument). If the widgetclass does not have an attribute with the
 given name, an empty string is returned.}

proc getValue-type {} { return {function {String} {in: Widget} {in: XrmQuark} {free: freeProc} ## {widget} {attribute}}}
set wafeHelp(getValue) { The function 'getValue' returns the resource value for a resource
 (2nd argument) of the the specified widget (first argument).  Note
 that Wafe tries to convert the result to the best possible string
 representation suitable for Tcl; however, some attributes cannot
 be converted into a string.}

proc grabKeyboard-type {} { return {function {int} {in: Widget} {in: Boolean} {in: (int) SyncAsync} {in: (int) SyncAsync} {const: CurrentTime} ## {widget} {true | false} {pointer mode (sync | async)} {keyboard mode (sync | async)}}}
set wafeHelp(grabKeyboard) { The function 'grabKeyboard' establishes an active keyboard grab
 with the specified widget's window as the grab window. It returns
 on success "success" or on failure "alreadyGrabbed", "notViewable"
 or "frozen". When the keyboard is grabbed, all key events will be
 delivered to the specified widget, regardless of the location of
 the pointer. If the second argument 'owner events' is false, all
 generated key events are reported. If the 2nd argument is true, the
 events are reported as usual. 
 
 The 3rd argument controls pointer processing during the grab, the
 4th keyboard processing. If the 'pointer mode' (3rd argument) is
 "async" key event processing continues as usual, if it is 'sync'
 the state of the pointer as seen by the application appears to be
 frozen.  If the 'keyboard mode' (4th argument) is 'async', keyboard
 event processing is unaffected by the activation of the grab, if it
 is 'sync', the state of the keyboard as seen by the application
 appears to be frozen.
 
 The 5th argument 'confine widget' can be 'None' or a widget
 reference. In the latter case, the pointer is restricted to stay in
 the window of the specified widget.}

proc grabPointer-type {} { return {function {int} {in: Widget} {in: Boolean} {const: NoEventMask} {in: (int) SyncAsync} {in: (int) SyncAsync} {in: None | XtWindow(Widget)} {const: None} {const: CurrentTime} ## {widget} {owner events} {pointer mode (sync | async)} {keyboard mode (sync | async)} {None | confine widget}}}
set wafeHelp(grabPointer) { The function 'grabPointer' establishes an active pointer grab with
 the specified the widget's window as the grab window. It returns on
 success "success" or on failure "alreadyGrabbed", "notViewable" or
 "frozen". When the pointer is grabbed, all pointer events will be
 delivered to the specified widget, regardless of the location of
 the pointer. If the second argument 'owner events' is false, all
 generated pointer events are reported.If the 2nd argument is true,
 the events are reported as usual.
 
 The 3rd argument controls pointer processing during the grab, the
 4th keyboard processing. If the 'pointer mode' (3rd argument) is
 "async" pointer event processing continues as usual, if it is
 'sync' the state of the pointer as seen by the application appears
 to be frozen.  If the 'keyboard mode' (4th argument) is 'async',
 keyboard event processing is unaffected by the activation of the
 grab, if it is 'sync', the state of the keyboard as seen by the
 application appears to be frozen.
 
 The 5th argument 'confine widget' can be 'None' or a widget
 reference. In the latter case, the pointer is restricted to stay in
 the window of the specified widget.}

proc heightOfScreen-type {} { return {function {int} {in: XtScreen(Widget)} ## {widget to determine screen}}}
set wafeHelp(heightOfScreen) { The function 'heightOfScreen' returns the height of the screen (on
 which the specified widget is displayed) in pixels.}

proc installAccelerators-type {} { return {function {void} {in: Widget} {in: Widget} ## {destination} {source}}}
set wafeHelp(installAccelerators) { The command 'installAccelerators' merges the accelerator table from
 'source' (2nd argument) to 'destination' (1st argument).
 Accelerators provide a facility by which actions defined in one
 widget can be triggered by events in another widget.  The resource
 named 'accelerators' of the 'source' widget should be set to the
 accelerator table before this command is issued (eg. via the
 application default file or sV etc.). After this call events in the
 'destination' widget will trigger actions in the 'source' widget.}

proc installAllAccelerators-type {} { return {function {void} {in: Widget} {in: Widget} ## {destination} {source}}}
set wafeHelp(installAllAccelerators) { The command 'installAllAccelerators' installs the accelerators from
 'source' (2nd argument) and its children to 'destination' (1st
 argument).  Accelerators provide a facility by which actions
 defined in one widget can be triggered by events in another widget.
 The resource named 'accelerators' of the 'source' widget should be
 set to the accelerator table before this command is issued (eg. via
 the application default file or sV etc.). After this call events in
 the 'destination' widget will trigger actions in the 'source'
 widget.}

proc isWidget-type {} { return {function {WidgetID} {in: String} ## {widget name}}}
set wafeHelp(isWidget) { The function 'isWidget' returns 0 if no widget with the widget
 reference exists currently, otherwise non-zero.}

proc Layout-type {} { return {creationCommand Widget}}
set wafeCmdNeeds(Layout) {LAYOUT }

proc lowerWindow-type {} { return {function {void} {pre: if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")} {in: XtDisplay(Widget)} {const: XtWindow(localVar1)} ## {Widget to be lowered}}}
set wafeHelp(lowerWindow) { The command 'lowerWindow' lowers the window of the specified widget
 in the stacking hierarchy of the window manager. The specified
 widget must be realized (it must have already a window assigned).}

proc manageChild-type {} { return {function {void} {in: [Widget]} {const: argc -1} ## {widgets}}}
set wafeHelp(manageChild) { The command 'manageChild' takes any number of widgets as arguments
 and brings them under parental (geometry) management. This is only
 necessary, when the widget creating command are used with the
 'unmanaged' argument or the widget has been set explicitely to
 unmanaged. All widgets specified in the argument list have to have
 the same parent widget.}

proc mapWidget-type {} { return {function {void} {callmultiple} {in: Widget} ## {widgets}}}
set wafeHelp(mapWidget) { The command 'mapWidget' maps all specified widgets to the
 associated display.}

proc mergeResources-type {} { return {function {void} {in: Widget} {in: [args avp]} ## {widget to determine database} {resource-specification  value pairs}}}
set wafeHelp(mergeResources) { The command 'mergeResources' can be used to specify resource values
 within a Wafe application. The first argument is used to determine
 the resource database, the following arguments are attribute
 (resource specifications)/value pairs.
 
 If a matching ressource entry is already available in the resource
 database, it will be replaced by the specified entry.

 Note that with 'mergeResources' one can specify class names as well
 as instance names in resource specifications, the same syntax as in
 an application default files can be used. Therefore the resource
 specification can, in contrast to the 'setValues' command, be
 applied to several widgets. Note as well, that the resources will
 be evaluated typically when a widget is created; therefore
 'mergeResources' does not change resources of already created
 widgets.}

proc nameToWidget-type {} { return {function {WidgetID} {in: Widget} {in: String} ## {reference widget} {partial widget name path}}}
set wafeHelp(nameToWidget) { The function 'nameToWidget' returns the widget-ID of a widget with
 the name (widget path) specified in the 2nd argument in the widget
 tree under the specified widget (1st argument). If no such widget
 exists the command returns 0.}

proc OverrideShell-type {} { return {creationCommand Widget}}
set wafeHelp(OverrideShell) { The widget class 'OverrideShell' is a subclass of the 'Shell'
 widget class that performs no interaction with the window
 manager. It is used for widgets (such as popup menues) that should
 bypass the window manager. If you want a shell that can be
 iconified, use a TopLevelShell. If you do want window manager
 interaction use a TransientShell.}

proc parent-type {} { return {function {WidgetID} {in: Widget} ## {child widget}}}
set wafeHelp(parent) { The function 'parent' returns the widget-ID of the parent widget of
 the specified widget.}

proc popdown-type {} { return {function {void} {in: ShellWidget} ## {shell widget}}}
set wafeHelp(popdown) { The command 'popdown' pops a previously created and mapped
 popup shell down.}

proc popup-type {} { return {function {void} {in: ShellWidget} {in: XtGrabKind} ## {widget} {none | nonexclusive | exclusive}}}
set wafeHelp(popup) { The command 'popup' pops an existing TransientShell or
 OverrideShel up. The kind of grab used is specified with the 2nd
 argument which is the way how user events are constrained to the
 popup shell or its children. It can be one of the constants 'none',
 'nonexclusive' or 'exclusive'.}

proc popupChildren-type {} { return {function {String} {in: Widget} ## {}}}
set wafeHelp(popupChildren) { The command 'popupChildren' is similar to [gV Widget children] of a
 composite widget, but it returns the list of popup Shells which are
 created as children of the given widget. Popup shells are not
 required to be children of composite widgets. If a widget has no
 popup children an empty list is returned.}

proc popupSpringLoaded-type {} { return {function {void} {in: ShellWidget} ## {shell widget}}}
set wafeHelp(popupSpringLoaded) { The command 'popupSpringLoaded' displays the specified and
 previously created shell widget as a spring-loaded popup. This
 means that the shell is invisible to the window manager and
 disables user input to all windows except to the popup itself.}

proc processPendingEvents-type {} { return {function {void} {} ## {}}}
set wafeHelp(processPendingEvents) { The command 'processPendingEvents' processes all currently pending
 events before continuing with the next tcl command. This can be
 useful for refreshing the screen while computing heavily in
 Tcl. Another application area for this command is wafeperl/mofeperl
 where the use can force screen refresh etc. while computing in
 Perl.
 
 Note, that by procedding pending events also callback or actions
 procedures might be triggered by this command, which might issue
 arbitrary Tcl commands and alter global variables etc.}

proc raiseWindow-type {} { return {function {void} {pre: if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")} {in: XtDisplay(Widget)} {const: XtWindow(localVar1)} ## {widget to be raised}}}
set wafeHelp(raiseWindow) { The command 'raiseWindow' raises the window of the specified widget
 in the stacking hierarchy of the window manager. The specified
 widget must be realized (it must have already a window assigned).}

proc realize-type {} { return {function {void} {} ## {}}}
set wafeHelp(realize) { The command 'realize' realizes all top level application shells
 (which is at least the automatically created main shell of the
 application with the name 'topLevel').}

proc realizeWidget-type {} { return {function {void} {callmultiple} {in: Widget} ## {widgets}}}
set wafeHelp(realizeWidget) { The command 'realizeWidget' realizes all specified widgets. This
 command should only be used in cases where it is necessary to
 realize widgets separately (sometimes needed for geometry
 management).}

proc removeAllCallbacks-type {} { return {function {void} {in: Widget} {in: String} ## {widget} {callback name}}}
set wafeHelp(removeAllCallbacks) { The command 'removeAllCallbacks' is used to un-register all
 callback procedures currently associated with the specified
 callback resource (2nd argument) of the specified widget (1st
 argument).}

proc removeTimeOut-type {} { return {function {void} {in: XtIntervalId} ## {interval ID}}}
set wafeHelp(removeTimeOut) { The command 'removeTimeOut' removes an timeout command specified by
 the specified interval ID. The interval ID was obtained by addTimeOut.}

proc resolvePathname-type {} { return {function {String} {in: XtDisplay(Widget)} {in: NULL | String} {in: NULL | String} {in: NULL | String} {in: NULL | String} {const: NULL} {const: 0} {const: NULL} ## {widget to determine display} {type} {filename} {suffix} {path} {substitutions} {number of Substitutions} {XtFilePredicate}}}
set wafeHelp(resolvePathname) { The command 'resolvePathName' returns the fully qualified filename
 of a readable file of a certain type (2nd argument) with the
 specified filename (3rd argument) and the specified suffix (4th
 argument) on the given path (5th argument). The type specifies the
 kind of file (eg. 'bitmap' or 'help') and can be referred to via
 percent code '%T', or it can be empty. If no matching file can
 be located at the given path, an empty string is returned.}

proc setBusy-type {} { return {function {void} {in: Widget} {in: Boolean} ## {shell widget} {sensitive true | false}}}
set wafeHelp(setBusy) { The command 'setBusy' sets the given widget (typically a shell
 widget) and its children busy or not, depending on the boolean
 'state' argument (2nd argument). If a widget is set busy a
 busy-cursor is set and input is inhibited for all children
 widgets. The appearance of the children widgets will not change.
 If a shell is set busy and set non-busy some time later, all the
 sensitivity states before the setBusy command are reestablished.}

proc setKeyboardFocus-type {} { return {function {void} {in: Widget} {in: None|Widget} ## {from widget tree} {to widget | None}}}
set wafeHelp(setKeyboardFocus) { The command 'setKeyboardFocus' causes keyboard events that occur in
 the widget hierarchy rooted by the first argument to be be
 dispatched in the widget specified as 2nd argument.}

proc setSensitive-type {} { return {function {void} {in: Widget} {in: Boolean} ## {widget} {sensitive true | false}}}
set wafeHelp(setSensitive) { The command 'setSensitive' sets a widget and its children sensitive
 or insensitive depending on the boolean state argument (2nd argument)}

proc setValues-type {} { return {function {void} {in: Widget} {in: [args avp]} ## {widget} {attribute value pairs}}}
set wafeHelp(setValues) { The command 'setValues' changes one or more attribute-value pairs
 of the specified widget. According to the argument type, Wafe has
 to perform different type conversions. Note that some attributes of
 some widgets cannot be set by this command (for example, there is
 no string representation of a Colormap). Wafe allows to set
 attributes of type Callback to be set to Tcl commands.}

proc setWMProtocols-type {} { return {function {Boolean} {pre: if (!(XtWindow(localVar1))) returnTclError(argv[0],"Shell widget must be realized")} {const: XtDisplay(localVar1)} {in: XtWindow(ShellWidget)} {in: ADDRESS_OF((Atom)WM_PROTOCOLS)} {const: 1} ## {Shell Widget} {WM_TAKE_FOCUS | WM_SAVE_YOURSELF | WM_DELETE_WINDOW}}}
set wafeHelp(setWMProtocols) { The function 'setWMProtocols' sets the WM_PROTOCOLS property of the
 specified widget's window (usually a shell widget) to one of the
 three predefined values listed (2nd argument). The specified widget
 (1st argument) must be realized.
  
 The following example binds the close action of the mwm or similar
 window managers to a Tcl (Wafe) command.

   setWMProtocols topLevel WM_DELETE_WINDOW
   action topLevel override {<Message>WM_PROTOCOLS: exec(puts "hello world")}}

proc sync-type {} { return {function {void} {in: XtDisplay(Widget)} {in: Boolean} ## {Widget to determine display} {Discard (Boolean)}}}
set wafeHelp(sync) { The command 'sync' flushes the request buffer of the x server on
 the display of the specified widget. If the 2nd argument is set to
 true, all events in the input queue are discarded.}

proc textWidth-type {} { return {function {int} {pre: \{XFontStruct *font; XtVaGetValues(localVar1, argv[2], &font, NULL);} {in: Widget} {in: String} {in: String} {post: \}} ## {Widget} {fontResource} {String}}}
set wafeHelp(textWidth) { The function 'textWidth' returns width of given string (3rd
 argument) in pixels using font from the specified fontResource (2nd
 argument) of the specified widget (1st argument).}

proc TopLevelShell-type {} { return {creationCommand Widget}}
set wafeHelp(TopLevelShell) { The widget class 'TopLevelShell' is used for additional shells in
 applications having more than one top-level window (one of which
 serves as the root of a widget tree instance). The created shell
 can be separately iconified. If you do not want window manager
 interaction use a OverrideShell.}

proc TransientShell-type {} { return {creationCommand Widget}}
set wafeHelp(TransientShell) { The widget class 'TransientShell' is used for pop up shell widgets
 such as dialog boxes that do not bypass window management. Most
 window managers will not allow to iconify instances of the
 TransientShell widget class on it own, and may iconify it
 automatically if the window, for which the shell is transient for,
 is iconified. If you want a shell that can be iconified, use a
 TopLevelShell. If you do not want window manager interaction use a
 OverrideShell.}

proc translateCoords-type {} { return {function {void} {in: Widget} {in: Position} {in: Position} {out: Position} {out: Position} ## {widget} {x coordinate in widget} {y coordinate in widget} {variable name for root window x} {variable name for root window y}}}
set wafeHelp(translateCoords) { The command 'translateCoords' translates the coordinates 'x' and
 'y' coordinates in the given widget into root window
 coordinates. After the execution the Tcl variables specified in the
 4th and 5th argument will be bound with the resulting values.}

proc ungrabPointer-type {} { return {function {void} {in: Widget} {const: CurrentTime} ## {widget with active pointer grab}}}
set wafeHelp(ungrabPointer) { The command 'ungrabPointer' releases an active pointer grab.}

proc ungrabKeyboard-type {} { return {function {void} {in: Widget} {const: CurrentTime} ## {widget with active keyboard grab}}}
set wafeHelp(ungrabKeyboard) { The command 'ungrabKeyboard' releases an active keyboard grab.}

proc unmanageChild-type {} { return {function {void} {in: [Widget]} {const: argc -1} ## {widgets}}}
set wafeHelp(unmanageChild) { The command 'unmanageChild' takes any number of widgets as
 arguments and removes them from parental management.  All widgets
 specified in the argument list have to have the same parent widget.}

proc unmapWidget-type {} { return {function {void} {callmultiple} {in: Widget} ## {widgets}}}
set wafeHelp(unmapWidget) { The command 'unmapWidget' takes any number of widgets as arguments
 and unmaps them.}

proc unrealizeWidget-type {} { return {function {void} {callmultiple} {in: Widget} ## {widgets}}}
set wafeHelp(unrealizeWidget) { The command 'unrealizeWidget' takes any number of widgets as arguments
 and unrelaizes them.}

proc waitForVariable-type {} { return {function {String} {in: String} ## {variable name}}}
set wafeHelp(waitForVariable) { The function 'waitForVariable' can be used to "wait" in a Tcl
 command until a Tcl variable is set (eg. from a callback or action
 routine). While Wafe is waiting, other events can be processed. If
 the variable is set, 'waitForVariable' returns the variables value.
 
 In a first step, waitForVariable unsets the specified GLOBAL Tcl
 variable and enters a new event loop. This "inner" event loop will
 be left, when the specified variable is set. 
 
 'waitForVariable' is commonly used for synchronization tasks.}

proc widgetId-type {} { return {alias isWidget}}

proc widgetName-type {} { return {function {Widget} {in: String} ## {widget reference}}}
set wafeHelp(widgetName) { The function 'widgetName' returns the name of the specified widget.}

proc widthOfScreen-type {} { return {function {int} {in: XtScreen(Widget)} ## {widget to determine screen}}}
set wafeHelp(widthOfScreen) { The function 'widthOfScreen' returns the width of the screen on
 which the specified widget is displayed in pixels.}

proc window-type {} { return {function {long} {in: Widget} ## {widget whose window you want}}}
set wafeHelp(window) { The function 'window' returns the window id of the specified widget.}

proc disownSelection-type {} { return {function {void} {pre: if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")} {in: Widget} {const: XA_PRIMARY} {const: CurrentTime} ## {widget making the request}}}
set wafeHelp(disownSelection) { The command 'disownSelection' can be used if a widget explicitly
 wants to disclaim its ownership of the PRIMARY selection
 buffer. Note that the widget automatically looses the ownership,
 whenever an other widget claims to be the owner. The specified
 widget must be realized.}

proc getSelectionValue-type {} { return {function {void} {pre: if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")} {in: Widget} {const: XA_PRIMARY} {const: XA_STRING} {const: wafeGetSelectionValueProc} {in: XtNewString(String)} {const: CurrentTime} ## {widget making the request} {Tcl command}}}
set wafeHelp(getSelectionValue) { The command 'getSelectionValue' is used if a widget wants to
 retrieve the current contents of the PRIMARY selection buffer. The
 registered command string will be executed as soon as the selection
 data is availaible. The global Tcl variable PRIMARY will be set to
 pass the requested information. The specified widget must be realized}

proc ownSelection-type {} { return {function {Boolean} {pre: if (!(XtWindow(localVar1))) returnTclError(argv[0],"Widget must be realized")} {in: Widget} {in: XtNewString(String)} {in: NULL | String} {in: NULL | String} ## {widget that whiches to become owner of the selection} {string to be put into selection} {NULL | loseSelection TCL-command} {NULL | doneSelection TCL-command}}}
set wafeHelp(ownSelection) { The function 'ownSelection' claims ownership of the current PRIMARY
 selection buffer for the specifeid widget (1st argument) and places
 the specified string (2nd argument) into the selection buffer, such
 it can be "pasted" into another window.  The function returns true,
 if the specified widget successfully became selection owner.
 
 This function takes two additional arguments, both of them valid
 Wafe-commands or the constant 'NULL'. The 3rd argument is a Wafe
 command to be executed, when the widget looses the ownership of the
 PRIMARY buffer. The 4th argument is a Wafe command which will be
 executed when the selection transfer process is completed
 (typically, when a a paste action is completed). The constant
 'NULL' means that no callback function is to be executed on these
 conditions.}

proc fetchBuffer-type {} { return {function {String} {in: XtDisplay(Widget)} {const: &nbytes} {in: int} {pre: \{int nbytes;} {post: \}} ## {widget to determine display} {buffer number (1-7)}}}
set wafeHelp(fetchBuffer) { The function 'fetchBuffer' retrieves the contents of the specified
 cut buffer of the display of the specified widget and returns it.}

proc fetchBytes-type {} { return {function {String} {pre: \{ int bytes; XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, XA_STRING, XA_CUT_BUFFER0, DefaultRootWindow(XtDisplay(localVar1)), CurrentTime);} {in: XtDisplay(Widget)} {const:  &bytes} {post: \}} ## {widget to determine display}}}
set wafeHelp(fetchBytes) { The function 'fetchBytes' is a conveniance routine used to put the
 PRIMARY selection of the display of the specified widget into CUT
 BUFFER 0 and to returns it.}

proc convertSelection-type {} { return {function {void} {in: XtDisplay(Widget)} {const: XA_PRIMARY} {const: XA_STRING} {in: Atom} {const: DefaultRootWindow(XtDisplay(wafeTopLevel))} {const: CurrentTime} ## {widget to determine display} {target buffer number (0 to 6)}}}
set wafeHelp(convertSelection) { The command 'convertSelection' requests the current value of the
 PRIMARY selection and places it into the specified cut buffer
 for further use.}

proc storeBuffer-type {} { return {function {void} {in: XtDisplay(Widget)} {in: String} {const: strlen(argv[2])} {in: int} ## {widget to determine display} {String} {buffer number (1-7)}}}
set wafeHelp(storeBuffer) { The command 'storeBuffer' stores the specified string (2nd
 argument) into the specified cut buffer (3rd arguemnt) on the
 display of the given widget (1st argument).}

proc sV-type {} { return {alias setValues}}

proc gV-type {} { return {alias getValue}}

proc changePixmap-type {} { return {function {} {in: Widget} {in: String} {in: String} ## {widget} {resource} {pixmap file}}}
set wafeCmdNeeds(changePixmap) {XPM }

proc hooksOfDisplay-type {} { return {function {WidgetID} {in: XtDisplay(Widget)} {post: wafeCurrentAttribList=wafeMMgetAttribList((Widget)returnVar,True); wafeMMsetAttribList((Widget)returnVar); wafeCurrentAttribList = NULL;} ## {widget to determine display}}}
set wafeCmdNeeds(hooksOfDisplay) {R6 }

proc mapState-type {} { return {function {MapState} {in: Widget} ## {any widget}}}
set wafeHelp(mapState) { The function 'mapState' returns the map state of the specified
 widget, which is either 'IsUnmapped', 'IsUnviewable' or
 'IsViewable'. A return value of 'IsUnviewable' indicates that the
 window of the specified widget is mapped but some ancestor is
 unmapped.}

proc addWorkProc-type {} { return {function {XtWorkProcId} {const: wafeAppContext} {const: workProc} {in: XtNewString(String)} ## {Tcl command}}}
set wafeHelp(addWorkProc) { The function 'addWorkProc' adds the specified Wafe command as work
 procedure and returns its ID. Work procedures can be used to
 implement a simple form of backckground processing. Most
 application spend most of its time waiting for input. A work
 procedure can be registered which will be executed whenever Xt is
 idle.  Unless the specified Wafe function returns 1, it will be
 restarted automatically when Xt is idle again. See Xt Intrinsics
 Manual for more details (XtAppAddWorkProc, XtWorkProc)}

proc removeWorkProc-type {} { return {function {void} {in: XtWorkProcId} ## {work proc ID}}}
set wafeHelp(removeWorkProc) { The command 'removeWorkProc' removes a work procedure with the
 specified ID, which was returned by the function 'addWorkProc'.}

proc isShell-type {} { return {function {Boolean} {in: Widget} ## {widget}}}
set wafeHelp(isShell) { The function 'isShell' test whether the specified widget is a shell
 widget and returns the boolean value 0 or 1.}

proc getActionList-type {} { return {function {String} {in: XtClass(Widget)} ## {widget}}}
set wafeCmdNeeds(getActionList) {R5 }

proc atomName-type {} { return {function {String} {in: XtDisplay(Widget)} {in: name2AtomLV1chk(String)} ## {widget to determine display} {atom}}}
set wafeHelp(atomName) { The function 'atomName' return the name of an atom. It never
 creates a new atom. If the atom does not exist an empty string is
 returned. Currently, this function cannot be used to obtain names
 for invalid atom ids.}

proc atomId-type {} { return {function {AtomID} {in: Widget} {in: String} ## {widget to determine display} {atom}}}
set wafeHelp(atomId) { The function 'atomId' returns the atom ID of an atom. If the atom
 does not exist, a new atom with the given name is created.}

proc isAtom-type {} { return {function {AtomID} {in: Widget} {in: String} ## {widget to determine display} {atom}}}
set wafeHelp(isAtom) { The function 'isAtomId' checks, whether an atom with the specified
 name exists. On failure the function returns 0. Currently, isAtomId
 function cannot be used to check invalid atom ids.}

