/* make emcas happy -*-C-*-  make emacs happy */

#include <ctype.h>
#include <Xm/AtomMgr.h>

#include <Xm/DragDrop.h>

extern XmString wafeCvtStringToXmString(
#if NeedFunctionPrototypes
    char *
#endif
);

extern char * wafeCvtXmString2String(
#if NeedFunctionPrototypes
    char *, XmString
#endif
);

static Widget currentDragContext;

#define	Done(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}

static void
callbackProc(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
    {
    XmAnyCallbackStruct *cbs = (XmAnyCallbackStruct *)callData;

    DBUG_ENTER("callbackProc");
    if (cbs->reason == XmCR_DROP_MESSAGE)
	{
	XmDropProcCallbackStruct *drop_cbs =
	    (XmDropProcCallbackStruct *)callData;
	char *cmd;
	/*fprintf(stderr,"dropProc: getting attriblist of <%s>\n",XtName(w));*/
	cmd = (char *)wafeMMgetValue(wafeMMgetAttribList(w,True), qdropProc);
	/*fprintf(stderr,"in callbackProc, dropProc, widget = %p <%s> cmd=<%s>\n",
		w,XtName(w),cmd+sizeof(XrmQuark));
         */
	wafeExecCallbackProc(drop_cbs->dragContext, (XtPointer)cmd, callData);
	}
    DBUG_VOID_RETURN;
    }


static Boolean
convertSelectionIncrProc(w, selection, target, type, value, length, format,
			 max_length, client_data, request_id)
Widget        w;
Atom          *selection;
Atom          *target;
Atom          *type;
XtPointer     *value;
unsigned long *length;
int           *format;
unsigned long *max_length;
XtPointer     client_data;
XtRequestId   *request_id;
    {
    Boolean result;
    DBUG_ENTER("convertSelectionIncrProc");

    if (XtClass(w) == xmDragContextClass)
	{
	Display *dpy       = XtDisplay(w);
	Atom COMPOUND_TEXT = XmInternAtom(dpy, "COMPOUND_TEXT", False);
	Atom DELETE        = XmInternAtom(dpy, "DELETE", False);
	Atom TARGETS       = XmInternAtom(dpy, "TARGETS", False);
	char *cd, *cmd, *targetName = NULL;
	
	if (!(*selection == XmInternAtom(dpy, "_MOTIF_DROP", False)))
	    DBUG_RETURN(False);  /* it looks as if this was not for us! */

	/* if there is a command for the convert procedure registered,
	   call it and provide the target as callData; this is necessary
	   for the DELETE target in DROP_MOVE command
	 */
	if ((cmd = (char *)wafeMMgetValue(wafeMMgetAttribList(w,True), 
					  qconvertProc)))
	    {
	    targetName = XGetAtomName(dpy,*target);
	    wafeExecCallbackProc(w, (XtPointer)cmd, targetName);
	    }
	    
	if (*target == COMPOUND_TEXT)
	    {
	    XmString tmpString;

	    /* we pass the text via the clientData resource */
	    XtVaGetValues(w, XmNclientData, &cd, NULL);
	    
	    if (!cd)
		{
		wafeWarn("convertSelectionIncrProc", "invalid clientData",
			 NULL,NULL,NULL);
		if (targetName) XFree(targetName);
		DBUG_RETURN(False);  
		}

	    tmpString = wafeCvtStringToXmString(cd);
	    /* it is wierd that the returned compound text is of type
               char* since - as it looks to me - CT can have inbedded
               nulls, which will cause truncations on strlen etc 
             */
	    *type = *target;
	    *value = (XtPointer)XmCvtXmStringToCT(tmpString);
	    *length = (unsigned long)(strlen(*value)+1);

	    XmStringFree(tmpString);
	    *format = 8;
	    result = True;
	    }
	else 
	if (*target == DELETE)
	    {
	    if (!cmd) 
		wafeWarn("convertSelectionIncrProc", 
			 "no convertProc registered for a DROP_MOVE operation",
			 NULL,NULL,NULL);

	    *type = XmInternAtom(dpy, "NULL", False);
	    *value = NULL;
	    *length = 0;
	    *format = 8;
	    result = True;
	    }
	else 
        if (*target == TARGETS)  /* This target is required by ICCC */
	    {
	    int target_count = 0;
	    Atom *targs = (Atom *)XtMalloc((unsigned) (6 * sizeof(Atom)));
	    *value = (XtPointer) targs;

	    /* if targets are added, increase the constant in malloc! */
	    *targs++ = COMPOUND_TEXT;
	    target_count++;
	    *targs++ = DELETE;
	    target_count++;
	    *targs++ = TARGETS;
	    target_count++;
	    *targs++ = XmInternAtom(dpy, "MULTIPLE", False);
	    target_count++;  /* supported in the Intrinsics */
	    *targs++ = XmInternAtom(dpy, "TIMESTAMP", False);
	    target_count++; /* supported in the Intrinsics */
	    
	    *type = XA_ATOM;
	    *length = (target_count * sizeof(Atom)) >> 2;
	    *format = 32;
            }
	else
	    {
	    if (!targetName) targetName = XGetAtomName(dpy,*target);
	    wafeWarn("convertSelectionIncrProc","unknown target %s",
		     targetName,NULL,NULL);
	    result = False;
	    }

	if (targetName) XFree(targetName);
	}
    DBUG_RETURN(result);  
    }

static void
selectionCallbackProc (w, closure, selection, type, value, length, format)
Widget          w;
XtPointer       closure;
Atom*           selection;
Atom*           type;
XtPointer       value;
unsigned long*  length;
int*            format;
    {
    DBUG_ENTER("selectionCallbackProc");

    if (XtClass(w) == xmDropTransferObjectClass)
	{
	dropTransferCallbackStruct dtCbs;
	Atom COMPOUND_TEXT, TEXT, FILE_NAME, A_NULL;
	XmDropTransferEntryRec *dropTransferEntries;
	char *cmd;
	Display *dpy;

	if (!currentDragContext)
	    DBUG_VOID_RETURN;   /* to avoid surprises... */
	
	dpy = XtDisplay(currentDragContext);
	if (! *selection == XmInternAtom(dpy, "_MOTIF_DROP", False))
	    DBUG_VOID_RETURN;   /* to avoid surprises... */

	if (!(cmd = (char *)wafeMMgetValue(wafeMMgetAttribList(w,True), 
					   qtransferProc)))
	    {
	    wafeWarn("selectionCallbackProc","no transferProc registered",
		     NULL,NULL,NULL);
	    DBUG_VOID_RETURN;
	    }

	XtVaGetValues(w, XmNdropTransfers,&dropTransferEntries, NULL);
	
	COMPOUND_TEXT = XInternAtom(dpy,"COMPOUND_TEXT", False);
	TEXT          = XInternAtom(dpy,"TEXT", False);
	FILE_NAME     = XInternAtom(dpy,"FILE_NAME", False);
	A_NULL        = XInternAtom(dpy,"NULL", False);
	dtCbs.dest    = (String)dropTransferEntries->client_data;

	if (*type == COMPOUND_TEXT)
	    {
	    XmString t = XmCvtCTToXmString(value);
	    dtCbs.value = wafeCvtXmString2String(NULL,t);
/*
	    fprintf(stderr,"+ in callbackProc, transferProc, widget = %p <%s> cmd=<%s>, <%s> <%s>\n",
		    w,XtName(w),cmd+sizeof(XrmQuark),dtCbs.value,value);
 */
	    wafeExecCallbackProc(w, (XtPointer)cmd, &dtCbs);
	    XtFree(dtCbs.value);
	    XmStringFree(t);
	    }
	else 
	if ((*type == XA_STRING) || (*type == TEXT) || (*type == FILE_NAME))
	    {
	    dtCbs.value = XtMalloc(*length + 1);
	    memcpy((char *)dtCbs.value, (char *)value, *length);
	    *((char*)(dtCbs.value) + *length) = '\0';
 	    }
	else
	if (*type == XT_CONVERT_FAIL)
	    wafeWarn("selectionCallbackProc","conversion failed",
		     NULL,NULL,NULL);
	else 
	if (*type != A_NULL && (*type != 0))
	    {
	    char *p;
            p = XGetAtomName(dpy,*type);
	    wafeWarn("selectionCallbackProc", "unknown type %s",
		     p,NULL,NULL);
	    if (p) XFree(p);
	    }
	}
    }


Boolean
CvtStringToCallbackProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);

    wafeMMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)charp, XtFree);
    Done(XtCallbackProc, callbackProc);
    }


Boolean
CvtStringToDragOperations(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    unsigned char result = '\0';
    char *p=strtok(fromVal->addr,"|");
    do
	{
	if (!strcmp("DROP_COPY",p))
	    result |= XmDROP_COPY;
	else 
	if (!strcmp("DROP_MOVE",p))
	    result |= XmDROP_MOVE;
	else 
	if (!strcmp("DROP_LINK",p))
	    result |= XmDROP_LINK;
	else 
	if (!strcmp("DROP_NOOP",p))
	    result = XmDROP_NOOP;
	else
	    return False;
	}
    while ((p = strtok(NULL,"|")));
    Done(unsigned char, result);
    }

Boolean
CvtStringToTransferStatus(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    unsigned char result = '\0';
    char *p = fromVal->addr;

    if (!strcmp("TRANSFER_SUCCESS",p))
	result = XmTRANSFER_SUCCESS;
    else 
    if (!strcmp("TRANSFER_FAILURE",p))
	result = XmTRANSFER_FAILURE;
    else
	return False;

    Done(unsigned char, result);
    }


Boolean
CvtStringToConvertSelectionIncrProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);

    wafeMMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)charp, XtFree);
    Done(XtConvertSelectionIncrProc, convertSelectionIncrProc);
/*    return True; */
    }


Boolean
CvtStringToSelectionCallbackProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));

    *(XrmQuark *)charp = wafeCurrentAttrib;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);

    wafeMMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)charp, XtFree);
    Done(XtCallbackProc, selectionCallbackProc);
    }

static XmDropTransferEntryRec *
string2transferEntryRec(string,dpy)
char * string;
Display *dpy;
    {
    char **argv, **p, **innerArgv;
    int argc, count, n;
    XmDropTransferEntryRec *entries, *dropRecs;
    
    DBUG_ENTER("string2transferEntryRec");

    if (Tcl_SplitList(wafeInterpreter, string, &argc, &argv) == TCL_ERROR)
	{
	wafeWarn("CvtToDropTransfer", wafeInterpreter->result,
		 NULL,NULL,NULL);
	DBUG_RETURN(NULL);
	}
    count = argc;

    dropRecs = entries = (XmDropTransferEntryRec*)XtMalloc(sizeof(XmDropTransferEntryRec)*count);
    for (p = argv; count>0; count--,p++)
	{
	if (Tcl_SplitList(wafeInterpreter, *p, &n, &innerArgv) == TCL_ERROR)
	    {
	    wafeWarn("CvtToDropTransferArg", wafeInterpreter->result,
		     NULL,NULL,NULL);
	    DBUG_RETURN(NULL);
	    }
	if (n != 2)
	    {
	    wafeWarn("CvtToDropTransferArg", 
		    "DropTransferRec should have two elements",
		     NULL,NULL,NULL);
	    XtFree((char *)argv);
	    DBUG_RETURN(NULL);
	    }
	entries->target = XInternAtom(dpy, innerArgv[0], False);
	entries->client_data = 
	  (XtPointer)wafeCvtName2Widget(innerArgv[1],True,NULL,NULL);
	entries++;
	XtFree((char *)innerArgv);
	}
    XtFree((char *)argv);
    DBUG_RETURN(dropRecs);
    }


Boolean
CvtStringToDropTransfers(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    XmDropTransferEntryRec *dropRecs;
    if (!(dropRecs = string2transferEntryRec(fromVal->addr,dpy)))
	return False;
    
    wafeMMreplace(wafeCurrentAttribList, wafeCurrentAttrib,
	      (char *)dropRecs, XtFree);
    Done(XmDropTransferEntryRec*, dropRecs);
    }



static void
CBfreeAttribs(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
    {
    (void)wafeMMfreeGarbage(w);
    }


static void
xmChangeColor(w, colorName)
Widget w;
String colorName;
    {
    XrmValue input, output;
    input.size  = strlen(colorName);
    input.addr  = (XtPointer)colorName;
    output.addr = NULL;
    IFCONVERTANDSTORE(w, XtRString, input, XtRPixel, output)
	XmChangeColor(w,*(Pixel *)output.addr);
    }
