/* das ist ein -*- C -*- Programm */
#include <X11/cursorfont.h>
#include "wafe_quarks.h"

#ifdef MOTIF11
#include <Xm/Xm.h>
#endif

#ifdef RDD
extern Boolean rddDeliverMessageEvent(
#if NeedFunctionPrototypes
    XEvent
#endif
);
#endif

extern Boolean wafeOwnSelectionCmd(
#if NeedFunctionPrototypes
     Widget, String, String, String
#endif
);

extern void callback (
#if NeedFunctionPrototypes
     Widget, char *, XtCallbackProc, char *
#endif
);

extern Cardinal wafeGetResourcesOfClass(
#if NeedFunctionPrototypes
     WidgetClass, QTypeList *
#endif
);

extern Cardinal wafeGetConstraintsOfClass(
#if NeedFunctionPrototypes
     WidgetClass, QTypeList *
#endif
);

extern void wafeCallbackCmd(
#if NeedFunctionPrototypes
     int, char**, Widget, XtCallbackProc
#endif
);

#ifdef ATHENA
#include <X11/Xaw/List.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/AsciiText.h>
#endif


static void
action(w, TranslationModifier, translationTable)
Widget	w;
int	TranslationModifier;
XtTranslations translationTable;
    {
    switch (TranslationModifier) 
        {
	case 1: XtOverrideTranslations(w, translationTable);
		break;
	case 2: XtAugmentTranslations(w, translationTable);
		break;
	case 3: XtVaSetValues (w, XtNtranslations, translationTable, NULL);
		break;
        }
    }


static void
realizeWidgets()
    {
    WidgetListPtr ptr = wafeWidgetTrees;
    while(ptr) 
	{
	XtRealizeWidget(ptr->widget);
	ptr = ptr->next;
	}
    }

static void
callCallbacks(w, callback, argc,argv)
Widget   w;
String   callback;
int      argc;
char   **argv;
    {
    if (argc == 0) 
	{
#ifdef MOTIF
	XmAnyCallbackStruct callData;
	callData.reason = XmCR_NONE;
	callData.event  = wafeCurrentEvent;
	XtCallCallbacks(w, callback, (XtPointer)&callData);
#else
	XtCallCallbacks(w, callback, NULL);
#endif
	}
    else
    if (!strcmp(argv[0], "float"))
	{
	float   f;
	sscanf(argv[1], "%f", &f);
	XtCallCallbacks(w, callback, (XtPointer)&f);
	}
    else
	wafeWarn("callCallbacks","Wrong type: %s", argv[1], NULL,NULL);
    }


static void
callActionProc(w, eventType, action, argc, argv)
Widget         w;
String         eventType;
String         action;
int            argc;
char         **argv;
    {
    char          *token;
    XEvent         event;
    Display       *display = XtDisplay(wafeTopLevel);
    Window         win = XtWindow(w), root, child;
    int            x, y, xR, yR;
    unsigned int   state, button, keycode;
    char *procName = "callActionProc";

    if (!strcmp(eventType, ""))
	{
	event.type = 0;
	event.xany.display = display;
	event.xany.window = win;
	}
    else
	{
	token = strtok(eventType, " ");
	if (strcmp(token, "type"))
	    {
	    wafeWarn(procName,"Missing type; aborting command",
		      NULL,NULL,NULL);
	    return;
	    }

	XQueryPointer(display, win, &root, &child, &xR, &yR, &x, &y, &state);

	token = strtok(NULL, " ");
	if (!strcmp(token, "buttonEvent"))
	    {
	    token = strtok(NULL, " ");
	    if (!strcmp(token, "button"))
		{
		token = strtok(NULL, " ");
		if (!strcmp(token, "button1"))
		    button = Button1;
		else
                if (!strcmp(token, "button2"))
		    button = Button2;
                else
                if (!strcmp(token, "button3"))
		    button = Button3;
		else
                if (!strcmp(token, "button4"))
		    button = Button4;
		else
                if (!strcmp(token, "button5"))
		    button = Button5;
		else
		    {
		    wafeWarn(procName,"Unknown Button, %s", 
			     token,NULL,NULL);
		    return;
		    }
		}
	    else
		{
		wafeWarn(procName,
			 "This event field (%s) can't be specified\n", 
			 token,NULL,NULL);
		return;
		}

	    event.type = ButtonPress;
	    event.xbutton.display = display;
	    event.xbutton.window = win;
	    event.xbutton.root = root;
	    event.xbutton.subwindow = child;
	    event.xbutton.x = x;
	    event.xbutton.y = y;
	    event.xbutton.x_root = xR;
	    event.xbutton.y_root = yR;
	    event.xbutton.state = state;
	    event.xbutton.button = button;
	    }
	else if(!strcmp(token, "keyEvent"))
	    {
	    token = strtok(NULL, " ");
	    if (!strcmp(token, "key"))
		{                   
		token = strtok(NULL, " ");
		keycode = XKeysymToKeycode(display, XStringToKeysym(token));
		}
	    else
		{
		wafeWarn(procName,
			 "This event field (%s) can't be specified", 
			 token,NULL,NULL);
		return;
		}

	    event.type = KeyPress;
	    event.xkey.display = display;
	    event.xkey.window = win;
	    event.xkey.root = root;
	    event.xkey.subwindow = child;
	    event.xkey.x = x;
	    event.xkey.y = y;
	    event.xkey.x_root = xR;
	    event.xkey.y_root = yR;
	    event.xkey.state = state;
	    event.xkey.keycode = keycode;
	    }
	else
	    {
	    wafeWarn(procName,
		     "This event field (%s) can't be specified", 
		     token,NULL,NULL);
	    return;
	    }                    
	}

    XtCallActionProc(w, action, &event, argv, argc);
    return;
    }

/* used by addTimeOut */
static void
timerProc(command, junk)
XtPointer        command;
XtIntervalId     *junk;
    {
    DBUG_ENTER("timerProc");
    (void) wafeEval(wafeInterpreter, (char *)command, "timerProc");
    XtFree((char *)command);
    DBUG_VOID_RETURN;
    }

/* used by addTimeOut */
static Boolean
workProc(command)
XtPointer command;
    {
    char *r;
    int  rc;

    DBUG_ENTER("workProc");
    rc = wafeEval(wafeInterpreter, (char *)command, "workProc");
    r = wafeInterpreter->result;
    if ( rc || ( r && *r++ == '1' && *r == '\0' ) ) /* don't do it again */
	{
	XtFree((char *)command);
	DBUG_RETURN(True);
	}
    DBUG_RETURN(False);
    }


static char *
cvtToString(clientData, quarkOfType, freeProcPtr)
XtPointer     clientData;
XrmQuark      quarkOfType;
freeProc      *freeProcPtr;
    {
    XrmValue   input,output;
    
    DBUG_PRINT("cvtToString", ("Converting to <%s>", 
			       XrmQuarkToString(quarkOfType)));

    input.addr  =  clientData;            /* ??? */
    input.size  =  sizeof(XtPointer);     /* ??? */
    output.addr =  NULL;

    IFCONVERTANDSTORE(wafeTopLevel, 
		      XrmQuarkToString(quarkOfType),input, 
		      XtRString, output)
	{
	*freeProcPtr = XtFree;
	return output.addr;
	}
    else
	return NULL;
    }



static String
getValue(w, Qname, freeProcPtr)
Widget      w;
XrmQuark    Qname;
freeProc   *freeProcPtr;
    {
    char        *result;
    XrmQuark     Qtype;
    XtPointer    value;
    Arg          arg;
    WidgetClass  wClass   = XtClass(w);
    char        *procName = "getValue";
    char        *resName  = XrmQuarkToString(Qname);

    DBUG_PRINT(procName, ("widget is %p resource is <%s>", w, resName)); 

    if (!(Qtype = wafeGetQTypeOfAttribute(wClass, ParentWidget(w), Qname)))
	{
	wafeWarn(procName,"Unknown Attribute %s", resName,NULL,NULL);
	*freeProcPtr = TCL_STATIC;
	return NULL;
	}

    if (Qtype == qString)
	{
	String    valueString;
	*freeProcPtr = TCL_VOLATILE;
	XtVaGetValues(w, resName, &valueString, NULL);
	return valueString;
	}

    /* this is the Default value for the following types 
     * assuming that dense code is better than one instruction more
     */ 
    *freeProcPtr = XtFree;
	
    if (Qtype == qInt) 
	{
	int valueInt;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valueInt, NULL);
	sprintf(result, "%d", (int)valueInt);
	return result;
	}

    if (Qtype == qPosition
#ifdef MOTIF11
	|| Qtype == qVerticalPosition
	|| Qtype == qHorizontalPosition
#endif
       )
	{
	Position    valuePosition;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valuePosition, NULL);
	sprintf(result, "%hd", valuePosition);
	return result;
        }
#ifdef MOTIF11
    if (Qtype == qTextPosition) 
	{
	XmTextPosition    valuePosition;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valuePosition, NULL);
	sprintf(result, "%ld", valuePosition);
	return result;
        }
#endif

    if (Qtype == qDimension
#ifdef MOTIF11
	|| Qtype == qVerticalDimension
	|| Qtype == qHorizontalDimension
	|| Qtype == qShellHorizDim
	|| Qtype == qShellVertDim
#endif
	) 
	{
	Dimension    valueDimension;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valueDimension, NULL);
	sprintf(result, "%hu", valueDimension);
	return result;
        }

    if (Qtype == qCardinal)
	{
	Cardinal    valueCardinal;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valueCardinal, NULL);
	sprintf(result, "%u", valueCardinal);	
	return result;
	}

    if (Qtype == qBoolean)
	{
	Boolean    valueBoolean;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, resName, &valueBoolean, NULL);
	return valueBoolean ? "1" : "0";   
	}


    if (Qtype == qFloat) 
	{
	float    valueFloat;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, resName, &valueFloat, NULL);
	sprintf(result, "%f", valueFloat);
	return result;
	}

    if (Qtype == qDouble) 
	{
	double    valueDouble;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, resName, &valueDouble, NULL);
	sprintf(result, "%f", valueDouble);
	return result;
	}

    if (Qtype == qPixel) 
	{
	XColor  c;
	Display *dpy = XtDisplay(w);
	result = XtMalloc(8); /* "#RRGGBB" */
	XtVaGetValues(w, resName, &(c.pixel), NULL);
	XQueryColor(dpy,DefaultColormap(dpy, DefaultScreen(dpy)),&c);
	sprintf(result, "#%02X%02X%02X", 
		(int)(c.red>>8), (int)(c.green>>8), (int)(c.blue>>8));
	return result;
	}

     /* Callbacks sind ... anders: die String-Information 
	kommt aus wafe's privatem Memory-Management und nicht 
	ber getValues!
      */
    if (Qtype == qCallback) 
	{
	MMattribListPtr ptr = *wafeMMgetAttribList(w,True);
	
	*freeProcPtr = TCL_STATIC;
	result = NULL;
	/* try to get callback through memory management */
	while(ptr) 
	    {
	    if (ptr->attribute == Qname) 
		{
		result = ((char*)ptr->value) +
		    sizeof(XtCallbackList)*2 +
		    sizeof(XtCallbackRec[2]) +
		    sizeof(XrmQuark);
		break;
		}
	    ptr = ptr->next;
	    }
	/* try to get callback from callback list */
	if (!result) 
	    {
	    XtCallbackList cbl;
	    XtVaGetValues(w, resName, &cbl, NULL);
	    for (; cbl->callback; cbl++)
		{
		if ( cbl->callback == wafeExecCallbackProc ) 
		    {
		    result = ((char*)cbl->closure) + sizeof(XrmQuark);
		    break;
		    }
		}
	    }
	if (!result) 
	    result = "";
	return result;
	}

    if (Qtype == qWidget
#ifdef MOTIF11
	|| Qtype == qWindow
	|| Qtype == qMenuWidget
#endif
	)
	{
	Widget valueWidget;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valueWidget, NULL);
	sprintf(result, "%ld", (long)valueWidget);
	return result;
	}

    if (Qtype == qWidgetList) 
        {
	WidgetList children;
        Cardinal   numChildren;
        XtVaGetValues(w, XtNnumChildren, &numChildren,
                         XtNchildren,    &children,    NULL);
	return wafeCvtWidgetListToList(NULL, numChildren, children);
        }


    if (Qtype == qPointer) 
	{
#ifdef ATHENA
	if (wClass == listWidgetClass && Qname == qlist)
	    {
	    char **argv;
	    int argc;
	    XtVaGetValues(w, XtNnumberStrings, &argc,
			  XtNlist,          &argv,    NULL);
	    return Tcl_Merge(argc, argv);
	    }
	else
	if (wClass == toggleWidgetClass && Qname == qradioData)
	    {
	    XtPointer p;
	    *freeProcPtr = TCL_STATIC;
	    XtVaGetValues(w, resName, &p, NULL);
	    return XrmQuarkToString((XrmQuark)p);
	    }
	else
#endif
	    {
	    XtPointer p;
	    *freeProcPtr = TCL_STATIC;
	    XtVaGetValues(w, resName, &p, NULL);
	    return (String)p;
	    }
	}
    else 
	{
	/*
	 * warning: cvtToString assumes, you can free the result 
	 * using XtFree
	 */
	XrmQuark oldAttrib = wafeCurrentAttrib;
	Widget   oldWidget = wafeCurrentWidget;

	XtSetArg(arg, resName, &value);
	XtGetValues(w, &arg, (Cardinal)1);

	wafeCurrentAttrib = Qname;
	wafeCurrentWidget = w;
	result = cvtToString(value, Qtype, freeProcPtr);
	wafeCurrentAttrib = oldAttrib;
	wafeCurrentWidget = oldWidget;

	if (!result)
	    {
	    wafeWarn(procName, "Couldn't convert value for %s to string",
		     resName,NULL,NULL);
	    return NULL;
	    }
	return result;
      }
    }

static int
getResourceList(w, resultPtr)
char    ***resultPtr; 
Widget   w;
    {
    int numTotal, count;
    char **result;
    int rNum = 0;
    int cNum = 0;
    QTypeList rList, cList;

    rNum = wafeGetResourcesOfClass(XtClass(w), &rList);

    if (XtIsConstraint(ParentWidget(w)))   /* If parentWidget is constrain widget => fetch constraints */
	cNum =  wafeGetConstraintsOfClass(XtClass(ParentWidget(w)), &cList);

    numTotal = rNum + cNum;

    *resultPtr = result = (char **)XtMalloc(numTotal *sizeof(char *));       

    for ( count = 0; count < rNum; count++)
	*result++ = XrmQuarkToString(rList[count].qName);

    for ( count = 0; count < cNum; count++)
	*result++ = XrmQuarkToString(cList[count].qName);

    return(numTotal);
    }



typedef struct _busyStruct
    {
    Window                busyWindow;
    Boolean               state;
    } busyStruct, *busyStructPtr;


static void
setBusy(w,sensitive)
Widget w;
Boolean sensitive;
    {
    unsigned long valuemask;
    XSetWindowAttributes attributes;
    MMattribListPtr *al = wafeMMgetAttribList(w,True);
    busyStructPtr bs = (busyStructPtr) wafeMMgetValue(al, qbusyWindow);
    Display *dpy = XtDisplay(w);

    if (sensitive)
	{
	if (!bs)
	    {
	    Screen *scr = XtScreen(w);
	    
	    bs = (busyStructPtr) XtMalloc(sizeof(busyStruct));
	    wafeMMreplace(al,qbusyWindow,(char*)bs,XtFree);
            bs->state = False;

	    /* Ignore device events while the busy cursor is displayed. */
	    valuemask = CWDontPropagate | CWCursor;
	    attributes.do_not_propagate_mask =  
		(KeyPressMask | KeyReleaseMask |
		 ButtonPressMask | ButtonReleaseMask | PointerMotionMask);
	    attributes.cursor = XCreateFontCursor(dpy, XC_watch);

	  /* The window will be as big as the display screen, and clipped by
	   * its own parent window, so we never have to worry about resizing
	   */

	    bs->busyWindow = 
		XCreateWindow(dpy, XtWindow(w), 0, 0,
			      HeightOfScreen(scr)*2, WidthOfScreen(scr)*2, 
			      0, 0, InputOnly, CopyFromParent, 
			      valuemask, &attributes);
	    }
	if (!bs->state) 
	     {
	     XMapRaised(dpy, bs->busyWindow);
	     bs->state = True;
	     }
        }
    else
	{
	if (bs && bs->state)
	    {
	    XUnmapWindow(dpy, bs->busyWindow);
	    bs->state = False;
	    }
	}
    }


static String
waitForVariable(varName)
String varName;
    {
    String result = NULL;
    Tcl_UnsetVar(wafeInterpreter,varName,TCL_GLOBAL_ONLY);
    wafeInnerEventLoop ++;
    while (!(result = Tcl_GetVar(wafeInterpreter,varName,TCL_GLOBAL_ONLY)))
	XtAppProcessEvent(wafeAppContext, XtIMAll);
    wafeInnerEventLoop --;
    return result;
    }


static void
processPendingEvents()
    {
    while (XtAppPending(wafeAppContext))
       {
       XEvent event;
       XtAppNextEvent(wafeAppContext,&event);
#ifdef RDD
       if (rddDeliverMessageEvent(event))
	   continue;
#endif
       wafeInnerEventLoop ++;
       XtDispatchEvent(&event);
       wafeInnerEventLoop --;
       }
    }

typedef int MapState;

static MapState
mapState(w)
Widget w;
    {
    XWindowAttributes wattr;
    Window win = XtWindow(w);
    
    if (!win) return 0;
    if (!XGetWindowAttributes(XtDisplay(w), win, &wattr)) return 0;
    return wattr.map_state;
    }

#ifndef PRER5
static Status
combineFileDatabase(fname,w,override)
String fname;
Widget w;
Bool override;
    {
    XrmDatabase dispDb = XtDatabase(XtDisplay(w)); 
    return XrmCombineFileDatabase(fname, &dispDb, override);
    }
#endif

static Boolean
motifWMRunning(shell)
Widget shell;
    {
#ifdef MOTIF
    return XmIsMotifWMRunning(shell);
#else
    Display  *dpy         = XtDisplay(shell);
    Window    root        = RootWindowOfScreen(XtScreen(shell));
    Atom      motifWmInfo = XInternAtom(dpy, "_MOTIF_WM_INFO", False);

    Atom      actual_type;
    int       actual_format;
    unsigned long nitems, bytes_after;
    unsigned char* prop;

    XGetWindowProperty(dpy, root, motifWmInfo, 0,0, FALSE,motifWmInfo,
		       &actual_type,&actual_format,&nitems,&bytes_after,
		       &prop);
    return (actual_type == motifWmInfo && actual_format == 32);
#endif
    }

static Boolean
wafeGetBool(string,boolPtr)
String string;
Bool *boolPtr;
    {
    int tclBool;
    if (TCL_OK == Tcl_GetBoolean(wafeInterpreter,string,&tclBool))
	{
	*boolPtr = (Bool)(tclBool);
	return True;
	}
    else 
	return False;
    }

#ifndef PRER5
static int
getActionList(wClass) 
WidgetClass wClass;
    {
    Cardinal num;
    XtActionList al,a;

#ifdef ATHENA
    /* only the textWidgetList has the action list :( */
    if (wClass == asciiTextWidgetClass) 
	wClass = textWidgetClass;
#endif    
    XtGetActionList(wClass, &al, &num);
    for(a=al; num; num--, a++) 
	Tcl_AppendElement(wafeInterpreter, a->string);

    if (al) XtFree((char *)al);
    return TCL_OK;
    }
#endif

/* convert string to pointer, ATHENA widget version, where Quark or lists
   are set; there is also another version which only sets strings...
 */
static Boolean
CvtStringToPointer(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
#ifdef ATHENA
    WidgetClass wClass = 
      wafeCurrentWidget ? XtClass(wafeCurrentWidget) : NULL;
#endif

    DBUG_ENTER("CvtStringToPointer");
#ifdef ATHENA
    if ((!wafeCurrentAttrib) || (!wafeCurrentWidget)) 
	{
	wafePointerResourceValue = True;
	DBUG_RETURN(True);
	}

    if (wafeCurrentAttrib == qradioData && wClass == toggleWidgetClass)
	{
	static XrmQuark value;

	value = XrmStringToQuark((char *)fromVal->addr);
	if (toVal->addr) 
	    *(XtPointer *)(toVal->addr) = (XtPointer)value;
	else
	    toVal->addr = (caddr_t)&value;
	toVal->size = sizeof(XtPointer);
	} 
    else 
    if (wafeCurrentAttrib == qlist && wClass == listWidgetClass)
	{
	static int argc;
	static char ** argv;

	Tcl_SplitList(wafeInterpreter,(char *)fromVal->addr, &argc,&argv);
	if (toVal->addr) 
	    {
	    if (toVal->size < sizeof(String *)) 
		{
		toVal->size = sizeof(String *);
		XtFree((char *)argv);
		return False;
		}
	    *(String **)(toVal->addr) = (String *)argv;
	    }
	else
	    {
	    toVal->addr = (caddr_t)&argv;
	    wafeMMreplace(wafeCurrentAttribList, wafeCurrentAttrib, 
			  (char *)argv, XtFree);
	    }
	toVal->size = sizeof(String *);

	if (wafeCurrentWidget)
	    XtVaSetValues(wafeCurrentWidget,
			  XtNnumberStrings,argc,
			  NULL);
	
	}
    else
#endif
	{
	static char* p;
	
	if (toVal->addr) 
	    {
	    *(String *)(toVal->addr) = (String)fromVal->addr;
	    }
	else
	    {
	    p = XtNewString(fromVal->addr);
	    toVal->addr = (caddr_t)&p;
	    wafeMMreplace(wafeCurrentAttribList, wafeCurrentAttrib, 
			  (char *)p, XtFree);
	    }
	toVal->size = sizeof(String);
	}
    
    DBUG_RETURN(True);
    }
