$PACKAGE = "ATHENAR5";
$generateWarnings = 1;

~handles 
	XAWR5

#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>
#include <X11/Xaw/Tree.h>
#include <X11/Xaw/Repeater.h>

~require
	athena5.inc

#> The 'Panner' widget class provides a retangular area containing a
#> slider that may be moved in two dimensions. The notification of
#> changes may be continuous or discrete.

~widgetClass 
Panner

#> The 'Porthole' widget class allows viewing of a managed child which
#> is as large as or larger than its parent, typically under the
#> control of a Panner widget.

~widgetClass 
Porthole

#> The command 'XawTalk' is used to put a typically large window (3rd
#> argument) under the control of a Panner (1st argument) and Porthole
#> widget (2nd argument), where the Panner functions as two
#> dimensional scrollbar.

extern void portholeCallbackProc();
extern void pannerCallbackProc();

#define XawTalk(pa, po, ch) XtAddCallback(po, XtNreportCallback, \
                            portholeCallbackProc, (XtPointer) pa); \
                         XtAddCallback(pa, XtNreportCallback, \
                            pannerCallbackProc, (XtPointer) ch)

void
XawTalk
	in: PannerWidget	# panner
	in: PortholeWidget	# porthole
	in: Widget		# managed widget

#> The 'Repeater' widget class is used for push buttons that tigger an
#> action at an increasing rate when selected. This widget can display
#> a multi-line string or a bitmap or pixmap image.

~widgetClass 
Repeater

#> The 'Tree' widget class provides geometry management of widgets
#> arranged in a tree structure.

~widgetClass 
Tree

#> The command 'XawTreeForceLayout' is used to force a re-layout of
#> the Tree widget. This command should be used when the resource
#> 'autoReconfigure' of the Tree widget is set to false.

void
XawTreeForceLayout
	in: TreeWidget		# tree Widget

