/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Tue Oct 18 03:13:11 EDT 1994 on mohegan
 * Author: genc
 * Version: 1


 */
#define PLOTTER_C
#include <wafe.h>
typedef int TCL_RETURN_CODE;
#ifdef PLOTTER

#include <X11/At/Axis.h>
#include <X11/At/BarPlot.h>
#include <X11/At/LabelAxis.h>
#include <X11/At/LinePlot.h>
#include <X11/At/Plot.h>
#include <X11/At/Plotter.h>
#include <X11/At/TextPlot.h>
#include <X11/At/XYAxis.h>
#include <X11/At/XYLinePlot.h>
#define castXtPointer(x) (XtPointer)(x)

/* 
 * void
 * AtBarPlotAttachData
 *         in: AtBarPlotWidget		# bar plot widget
 * 	in: castXtPointer([float])	# floats
 * 	const: AtFloat
 * 	const: sizeof(float)
 * 	const: 1
 * 	const: argc-2
 */

static int 
cmd_AtBarPlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float * localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 {
	 wafeArgcError(argc,argv,"at least ",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],atBarPlotWidgetClass,"AtBarPlot")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "AtBarPlotWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     {    float *ptr;
          argv += 2;
          localVar2 = ptr =
             (float *)XtMalloc((argc-2)*sizeof(float));

          while (*argv)
             {
             if (!(sscanf(*argv, "%f", &*ptr)))
                 {
                 wafeConvError(argc, argv, 2 ,NULL, "float");
                 DBUG_RETURN (TCL_ERROR);
                 }

          ptr ++; argv++;
          }
     }
     AtBarPlotAttachData(localVar1,castXtPointer(localVar2),AtFloat,sizeof(float),1,argc-2);
     wafeMMreplace(wafeMMgetAttribList(localVar1,True),WafePermStringToQuark("AtBarPlotAttachData"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * AtLabelAxisAttachData
 *         in: AtLabelAxisWidget		# label axis wiget
 * 	in: [char *]			# strings
 * 	const: sizeof(String)
 * 	const: 1
 * 	const: argc-2
 */

static int 
cmd_AtLabelAxisAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * * localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 {
	 wafeArgcError(argc,argv,"at least ",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],atLabelAxisWidgetClass,"AtLabelAxis")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "AtLabelAxisWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     {    char * *ptr;
          argv += 2;
          localVar2 = ptr =
             (char * *)XtMalloc((argc-2)*sizeof(char *));

          while (*argv)
             {
             *ptr = XtNewString(*argv);
          ptr ++; argv++;
          }
     }
     AtLabelAxisAttachData(localVar1,localVar2,sizeof(String),1,argc-2);
     wafeMMreplace(wafeMMgetAttribList(localVar1,True),WafePermStringToQuark("AtLabelAxisAttachData"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * AtLinePlotAttachData
 *         in: AtLinePlotWidget		# line plot widget
 * 	in: castXtPointer([float])	# floats
 * 	const: AtFloat
 * 	const: sizeof(float)
 * 	const: 1
 * 	const: argc-2
 */

static int 
cmd_AtLinePlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float * localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 {
	 wafeArgcError(argc,argv,"at least ",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],atLinePlotWidgetClass,"AtLinePlot")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "AtLinePlotWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     {    float *ptr;
          argv += 2;
          localVar2 = ptr =
             (float *)XtMalloc((argc-2)*sizeof(float));

          while (*argv)
             {
             if (!(sscanf(*argv, "%f", &*ptr)))
                 {
                 wafeConvError(argc, argv, 2 ,NULL, "float");
                 DBUG_RETURN (TCL_ERROR);
                 }

          ptr ++; argv++;
          }
     }
     AtLinePlotAttachData(localVar1,castXtPointer(localVar2),AtFloat,sizeof(float),1,argc-2);
     wafeMMreplace(wafeMMgetAttribList(localVar1,True),WafePermStringToQuark("AtLinePlotAttachData"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


#include <Plotter.h>
/* 
 * void
 * AtPlotterGeneratePostscript
 *         in: String            		       # file name
 *         in: (AtPlotterWidget)AtPlotterWidget   # plotter widget
 * 	in: String            		       # title
 * 	in: int               		       # bounding box: x1
 * 	in: int              		       # bounding box: y1
 * 	in: int               		       # bounding box: x2
 * 	in: int               		       # bounding box: y2
 * 	in: Boolean           		       # landscape
 */

static int 
cmd_AtPlotterGeneratePostscript(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar2;
     int localVar4;
     int localVar5;
     int localVar6;
     int localVar7;
     Boolean localVar8;

     DBUG_ENTER(argv[0]);  

     if (argc != 9) 
	 {
	 wafeArgcError(argc,argv,"",8);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     if (!(localVar2 =  name2WidgetOfClass(argv[2],atPlotterWidgetClass,"AtPlotter")))
         {
         wafeConvError(argc, argv, 2 ,NULL, "AtPlotterWidget");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     if (!(sscanf(argv[4], "%d", &localVar4)))
         {
         wafeConvError(argc, argv, 4 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[5], "%d", &localVar5)))
         {
         wafeConvError(argc, argv, 5 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[6], "%d", &localVar6)))
         {
         wafeConvError(argc, argv, 6 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[7], "%d", &localVar7)))
         {
         wafeConvError(argc, argv, 7 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[8],&localVar8)))
         {
         wafeConvError(argc, argv, 8 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     AtPlotterGeneratePostscript(argv[1],localVar2,argv[3],localVar4,localVar5,localVar6,localVar7,localVar8);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * ******* begin required file <At.inc> *******
 */
/* yes, it is really  -*-C-*-  */

static void
xyLinePlotAttachData(w,argc,argv)
Widget    w;
int       argc;
char    **argv;
     {
     int count;
     float *x,*xarray, *y,*yarray;

     x = xarray = (float *)XtMalloc(sizeof(float)*argc);
     y = yarray = (float *)XtMalloc(sizeof(float)*argc);

     for (count = 0; count < argc; count++,x++,y++)
         {
         if (!(sscanf(argv[count],"%f/%f",x,y)))
              {
              wafeConvError(argc, argv, count,NULL, "x/y");
              return;
              }
          }

     AtXYLinePlotAttachData(w,
			    (XtPointer)xarray, AtFloat, sizeof(float),
			    (XtPointer)yarray, AtFloat, sizeof(float),
			    1,argc);

     wafeMMreplace(wafeMMgetAttribList(w,True),
		   WafePermStringToQuark("LinePlotXData"),
		   (char*)xarray,XtFree);
     wafeMMreplace(wafeMMgetAttribList(w,True),
		   WafePermStringToQuark("LinePlotYData"),
		   (char*)yarray,XtFree);
     }     



/* 
 * ******* end required file <At.inc> *******
 */
/* 
 * void
 * xyLinePlotAttachData vulgo AtXYLinePlotAttachData
 *         in: AtXYLinePlotWidget		# xyLine plot widget
 * 	in: [args]			# pairs of floats (xfloat/yfloat)

 */

static int 
cmd_AtXYLinePlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 {
	 wafeArgcError(argc,argv,"at least ",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],atXYLinePlotWidgetClass,"AtXYLinePlot")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "AtXYLinePlotWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     argc -= 2;
     xyLinePlotAttachData(localVar1,argc,&argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


#else
#endif

void
wafeInitialize_AtGen()
{
#ifdef PLOTTER
 wafeCreateWidgetCommand("AtAxis",atAxisWidgetClass,WafeDontManage,False);
 wafeCreateWidgetCommand("AtBarPlot",atBarPlotWidgetClass,WafeDontManage,False);
 wafeCreateWidgetCommand("AtLabelAxis",atLabelAxisWidgetClass,WafeDontManage,False);
 wafeCreateWidgetCommand("AtLinePlot",atLinePlotWidgetClass,WafeDontManage,False);
 wafeCreateWidgetCommand("AtPlotter",atPlotterWidgetClass,NULL,False);
 wafeCreateWidgetCommand("AtTextPlot",atTextPlotWidgetClass,WafeDontManage,False);
 wafeCreateWidgetCommand("AtXYAxis",atXYAxisWidgetClass,WafeDontManage,False);
 wafeCreateWidgetCommand("AtXYLinePlot",atXYLinePlotWidgetClass,WafeDontManage,False);
#ifdef PLOTTER
 Tcl_SetVar(wafeInterpreter,"PACKAGES","PLOTTER",TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT);
#endif
 Tcl_CreateCommand(wafeInterpreter, "AtBarPlotAttachData", cmd_AtBarPlotAttachData, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "AtLabelAxisAttachData", cmd_AtLabelAxisAttachData, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "AtLinePlotAttachData", cmd_AtLinePlotAttachData, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "AtPlotterGeneratePostscript", cmd_AtPlotterGeneratePostscript, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "AtXYLinePlotAttachData", cmd_AtXYLinePlotAttachData, NULL, NULL);

#else
#endif
}
