#define XT

$PACKAGE = "XT"; 

~handles
	XPM
	LAYOUT

#include <X11/Shell.h>
#include <X11/Xatom.h>

~require 
	Xt.inc
	quark String
	quark Callback
	quark Pointer
	privateQuark busyWindow
	privateQuark xpmList
	privateQuark iconPixmap
	privateQuark Int
	privateQuark Dimension
	privateQuark Cardinal
	privateQuark Position
	privateQuark Float
	privateQuark Double
	privateQuark Pixel
	privateQuark Boolean
	privateQuark WidgetList
	privateQuark Widget
	conv XtRString XtRWidget     None CvtStringToWidget
	conv XtRString XtRCallback   None CvtStringToCallback
	conv XtRString XtRPointer    None CvtStringToPointer
	conv XtRString XtRWidgetList None CvtStringToWidgetList
	init #ifndef PRER5
	conv XtRString XtRCardinal   None XtCvtStringToInt
	init #endif

XtIntervalId
XtAppAddTimeOut 
	const: wafeAppContext 
	in: unsigned long		# time interval in ms
	const: timerProc
	in: XtNewString(String)		# tcl command

void
action
	in: Widget			# widget
	in: (int)TranslationModifier	# override | augment | replace
        in: XtTranslations		# translatontable

~widgetClass
ApplicationShell
	createCmd XtAppCreateShell

void
XBell
	in: XtDisplay(Widget)		# widget to determine display
	in: int				# percent (-100 = off, 0 .. 100)

void
callActionProc
	in: Widget			# widget
	in: String			# event type
	in: String			# action
	in: [args opt]			# args

void
callCallbacks
	in: Widget			# widget
	in: String			# callback
	in: [args opt]			# optional float and value 

extern wafePositionCallbackProc();
extern wafePositionCursorCallbackProc();

void
wafeCallbackCmd vulgo callback
	in: Widget			# widget
	in: String			# callback resource
        in: XtCallbackProc		# none | exclusive | nonexclusive | popdown | position | positionCursor
        in: XtNewString(String)		# string


hint: R5
Status
combineFileDatabase
	in: String			# filename
	in: Widget			# widget to determine database
	in: Bool			# override

void
XtDestroyWidget
	callmultiple
		in: wafeMMfreeGarbage(Widget)	# widgets


#define fallbackResources(localVar1,argc,argv) { \
     XrmDatabase    dispDb, newDb = NULL; \
     int            i; \
     char         **v = argv; \
     dispDb = XtDatabase(XtDisplay(localVar1)); \
     for (i = 0; i < argc; i+=2)  \
          XrmPutStringResource(&newDb, v[i], v[i+1]); \
     XrmCombineDatabase(newDb, &dispDb, False);}

hint: R5
void 
fallbackResources
	in: Widget			# widget to determine database
	in: [args avp] 			# resource value pairs


#define fontHeight(w,resource) \
         (font->max_bounds.ascent + font->max_bounds.descent)

int
fontHeight
	pre: {XFontStruct *font; \
              XtVaGetValues(localVar1, argv[2], &font, NULL);
	in: Widget			# Widget
	in: String			# fontResource
        post: }


void
XFlush
	in: XtDisplay(Widget)		# Widget to determine display

String
getApplicationResource
	in: Widget			# base widget 
	in: String			# resource name
	in: String			# resource class

#include <X11/IntrinsicP.h>
#define getClass(widget) (XtClass(widget)->core_class.class_name)

String
getClass
	in: Widget			# widget | None

int
getResourceList
	in: Widget			# widget
	out: String *			# variable name for output of reslist
	end: XtFree((String)localVar2);

XrmQuark
wafeGetQTypeOfAttribute vulgo getTypeOfAttribute
	in: XtClass(Widget)		# widget
	const: ParentWidget(localVar1)
	in: XrmStringToQuark(String)	# attribute

String
getValue
	in: Widget			# widget
	in: XrmQuark			# attribute
	free: freeProc

(int) GrabReturns
XtGrabPointer
	in: Widget			# widget
	in: Boolean			# true | false
        const: NoEventMask
	in: (int) SyncAsync		# pointer mode (sync | async)
	in: (int) SyncAsync             # keyboard mode (sync | async)
	in: None | XtWindow(Widget)	# None | confine widget
	const: None
	const: CurrentTime

(int) GrabReturns
XtGrabKeyboard
	in: Widget			# widget
	in: Boolean			# true | false
	in: (int) SyncAsync		# pointer mode (sync | async)
	in: (int) SyncAsync		# keyboard mode (sync | async)
	const: CurrentTime

int
HeightOfScreen
	in: XtScreen(Widget)     	# widget to determine screen

void
XtInstallAccelerators
	in: Widget			# destination
	in: Widget			# source

void
XtInstallAllAccelerators
	in: Widget			# destination
	in: Widget			# source

WidgetID (WidgetID)
name2WidgetId vulgo isWidget
	in: String			# widget name 

hint: LAYOUT
~widgetClass 
Layout
	include "Layout.h"

void
XLowerWindow
	pre: if (!(XtWindow(localVar1))) \
		returnTclError(argv[0],"Widget must be realized")
	in: XtDisplay(Widget)           # Widget to be lowered
	const: XtWindow(localVar1)

void
XtManageChildren vulgo manageChild
	in: [Widget]		        # widgets
	const: argc -1

void
XtMapWidget
	callmultiple
		in: Widget		# widgets

#define mergeResources(localVar1,argc,argv) { \
     XrmDatabase    dispDb, newDb = NULL; \
     int            i; \
     char         **v = argv; \
     dispDb = XtDatabase(XtDisplay(localVar1)); \
     for (i = 0; i < argc; i+=2)  \
          XrmPutStringResource(&newDb, v[i], v[i+1]); \
     XrmMergeDatabases(newDb, &dispDb);}


void 
mergeResources
	in: Widget			# widget to determine database
	in: [args avp] 			# resource value pairs


WidgetID (WidgetID)
XtNameToWidget
	in: Widget			# reference widget
	in: String                      # partial widget name path

~widgetClass
OverrideShell
	createCmd XtCreatePopupShell
	createsShell

WidgetID (WidgetID)
ParentWidget vulgo parent
	in: Widget			# child widget

void
XtPopdown
        in: ShellWidget			# shell widget

void
XtPopup
        in: ShellWidget			# widget
        in: XtGrabKind			# none | nonexclusive | exclusive

#define popupChildren(w) wafeCvtWidgetListToList(NULL,(w)->core.num_popups,(w)->core.popup_list)

(String) DString
popupChildren
	in: Widget

void
XtPopupSpringLoaded
        in: ShellWidget			# shell widget

void
processPendingEvents


void
XRaiseWindow
	pre: if (!(XtWindow(localVar1))) \
		returnTclError(argv[0],"Widget must be realized")
	in: XtDisplay(Widget)		# widget to be raised
	const: XtWindow(localVar1)

void
realizeWidgets vulgo realize

void
XtRealizeWidget
	callmultiple
		in: Widget		# widgets

void
XtRemoveAllCallbacks
	in: Widget			# widget
	in: String			# callback name

void 
XtRemoveTimeOut 
	in: XtIntervalId		# interval ID

(String) DString
XtResolvePathname
	in: XtDisplay(Widget)
	in: NULL | String               # Type
	in: NULL | String               # File
	in: NULL | String               # Suffix
	in: NULL | String               # Path
	const: NULL                     # Substitutions
	const: 0                        # Number of Substitutions
	const: NULL                     # XtFilePredicate

void
setBusy
	in: Widget			# shell widget 
	in: Boolean			# sensitive true | false

void
XtSetKeyboardFocus
	in: Widget			# from widget tree
	in: None|Widget			# to widget | None

void
XtSetSensitive 
	in: Widget			# widget 
	in: Boolean			# sensitive true | false


#define setValues(w,argc,argv) {\
    ArgList           args; \
    int               numArgs; \
    if (wafeConvert(ParentWidget(w), XtClass(w), \
		argv, &argc, &args, &numArgs, w)) { \
	XtSetValues(w, args, numArgs); \
	wafeCurrentAttribList = NULL; \
	XtFree((String)args); \
	} \
    } 

void
setValues
	in: Widget			# widget
	in: [args avp]			# resource value pairs

#define ADDRESS_OF(w) &(w)

Boolean 
XSetWMProtocols
	pre: if (!(XtWindow(localVar1))) \
		returnTclError(argv[0],"Shell widget must be realized")
	const: XtDisplay(localVar1)
	in: XtWindow(ShellWidget)	# Shell Widget
	in: ADDRESS_OF((Atom)WM_PROTOCOLS)	# WM_TAKE_FOCUS | WM_SAVE_YOURSELF | WM_DELETE_WINDOW
	const: 1

void
XSync
	in: XtDisplay(Widget)		# Widget to determine display
	in: Boolean			# Discard (Boolean)

#define textWidth(w,resource,string) \
         XTextWidth(font, string, strlen(string))

int
textWidth
	pre: {XFontStruct *font; \
              XtVaGetValues(localVar1, argv[2], &font, NULL);
	in: Widget			# Widget
	in: String			# fontResource
	in: String			# String
        post: }


~widgetClass
TopLevelShell
	createCmd XtCreatePopupShell
	createsShell

~widgetClass
TransientShell
	createCmd XtCreatePopupShell
	createsShell

void
XtTranslateCoords
	in: Widget			# widget
	in: Position    		# widget x
	in: Position    		# widget y
	out: Position   		# variable name for root x
	out: Position   		# variable name for root y

void
XtUngrabPointer
	in: Widget			# widget with active pointer grab
	const: CurrentTime

void
XtUngrabKeyboard
	in: Widget			# widget with active keyboard grab
	const: CurrentTime

void
XtUnmanageChildren vulgo unmanageChild
	in: [Widget]		# widgets
	const: argc -1

void
XtUnmapWidget
	callmultiple
		in: Widget		# widgets

void
XtUnrealizeWidget
	callmultiple
		in: Widget		# widgets

String
waitForVariable
	in: String			# variable Name

~alias 
	widgetId isWidget

Widget
name2WidgetId vulgo widgetName
	in: String			# widget name 

int
WidthOfScreen
	in: XtScreen(Widget)     	# widget to determine screen

long (long)
XtWindow
        in: Widget     			# widget whose window you want










#####  selection handling #####

void
XtDisownSelection
	const: wafeTopLevel
	const: XA_PRIMARY
	const: CurrentTime

extern void wafeGetSelectionValueProc();

void
XtGetSelectionValue
	const: wafeTopLevel
	const: XA_PRIMARY
	const: XA_STRING
	const: wafeGetSelectionValueProc
	in: XtNewString(String)		# Tcl command
	const: CurrentTime


Boolean
wafeOwnSelectionCmd vulgo ownSelection
	in: XtNewString(String) # string to be put into selection
	in: NULL | String 	# NULL | loseSelection TCL-command
	in: NULL | String 	# NULL | doneSelection TCL-command


# get the PRIMARY selection, put it into Cut Buffer 0 and fetch it ...

(String) DString
XFetchBytes
	pre: { int bytes; \
		XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, \
			XA_STRING, XA_CUT_BUFFER0, \
			DefaultRootWindow(XtDisplay(localVar1)), \
			CurrentTime); 
	in: XtDisplay(Widget) 		# widget to determine display
        const:  &bytes
	post: }

void
XConvertSelection
	in: XtDisplay(Widget)		# widget to determine display
	const: XA_PRIMARY
	const: XA_STRING
	in: Atom			# target buffer number
	const: DefaultRootWindow(XtDisplay(wafeTopLevel))
	const: CurrentTime


void
XStoreBuffer
	in: XtDisplay(Widget)		# widget to determine display
	in: String			# String
	const: strlen(argv[2])
	in: int				# buffer number (1-7)


(String) DString
XFetchBuffer
	in: XtDisplay(Widget)		# widget to determine display
	const: &nbytes
	in: int				# buffer number (1-7)
	pre: {int nbytes;
	post: }

#	free: XtFree


~alias 
	sV setValues
	gV getValue

#####  XPM related commands #####

hint: XPM
~require 
xpm.inc
	init wafeRegisterXpmTypeConverter(XtRBitmap, False);
	init wafeRegisterXpmTypeConverter(XtRPixmap, True);

hint: XPM
TCL_RETURN_CODE
changePixmap
	in: Widget			# widget
	in: String			# resource
	in: String			# pixmap file


hint: !PRER6
WidgetID (WidgetID)
XtHooksOfDisplay
	in: XtDisplay(Widget)		# widget to determine display
        post: wafeCurrentAttribList=wafeMMgetAttribList((Widget)returnVar,True); \
              wafeMMsetAttribList((Widget)returnVar); \
	      wafeCurrentAttribList = NULL; 

MapState
mapState
	in: Widget

XtWorkProcId
XtAppAddWorkProc
	const: wafeAppContext 
	const: workProc
	in: XtNewString(String)		# tcl command

void 
XtRemoveWorkProc 
	in: XtWorkProcId		# work proc ID

Boolean
XtIsShell
	in: Widget			# widget
