$PACKAGE = "GHOSTVIEW";

~handles
           GHOSTVIEW

~widgetClass
Ghostview
	include <Ghostview.h>
	callback w int: \
	    ((GhostviewReturnStruct *)callData)->width 		# width
	callback h int: \
	    ((GhostviewReturnStruct *)callData)->height		# height
	callback x int: \
	    ((GhostviewReturnStruct *)callData)->psx	 	# ps x
	callback y int: \
	    ((GhostviewReturnStruct *)callData)->psy	 	# ps y
	callback X float: \
	    ((GhostviewReturnStruct *)callData)->xdpi	 	# x dpi
	callback Y float: \
	    ((GhostviewReturnStruct *)callData)->ydpi	 	# y dpi


# GhostviewEnableInterpreter:
# Allow an interpreter to start and start one if the widget is
# currently realized.

void
GhostviewEnableInterpreter
	in: ghostviewWidget		# ghostview widget


# GhostviewDisableInterpreter:
# Stop any interpreter and disable new ones from starting.

void
GhostviewDisableInterpreter
	in: ghostviewWidget		# ghostview widget


# GhostviewIsInterpreterReady:
# Returns true if the interpreter is ready for new input.

Boolean
GhostviewIsInterpreterReady
	in: ghostviewWidget		# ghostview widget


# GhostviewIsInterpreterRunning:
# Returns true if the interpreter is running.

Boolean
GhostviewIsInterpreterRunning
	in: ghostviewWidget		# ghostview widget


# GhostviewGetBackingPixmap:
# Returns the current backing pixmap.
 
long
GhostviewGetBackingPixmap
	in: ghostviewWidget		# ghostview widget


# GhostviewSendPS:
#   Queue a portion of a PostScript file for output to ghostscript.
#   fp: FILE * of the file in question.  NOTE: if you have several
#   Ghostview widgets reading from the same file.  You must open
#   a unique FILE * for each widget.
#   SendPS does not actually send the PostScript, it merely queues it
#   for output.
#   begin: position in file (returned from ftell()) to start.
#   len:   number of bytes to write.
#
#   If an interpreter is not running, nothing is queued and
#   False is returned.


#define readFilePtr(s) \
 ((Tcl_GetOpenFile(wafeInterpreter, (s), 0, 1, &f) != TCL_OK) ? NULL : f)

Boolean 
GhostviewSendPS 
	pre: { FILE* f;
	in: ghostviewWidget		# ghostview widget
    	in: readFilePtr(String)		# open file 
    	in: long			# begin
	in: unsigned int		# length
    	in: int				# boolean close 
	post: }


# GhostviewNextPage:
#    Tell ghostscript to start the next page.
#    Returns False if ghostscript is not running, or not ready to start
#    another page.
#    If another page is started.  Sets the busy flag and cursor.

Boolean 
GhostviewNextPage
	in: ghostviewWidget		# ghostview widget


