/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sun Jul  3 23:25:03 GMT 1994 on mohegan
 * Author: genc
 * Version: 0.96999999999999997335


 */
#define GHOSTVIEW_C
#include <wafe.h>
#ifdef GHOSTVIEW

#include <Ghostview.h>
/* 
 * void
 * GhostviewEnableInterpreter
 * 	in: ghostviewWidget		# ghostview widget
 */

static int 
cmd_GhostviewEnableInterpreter(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],ghostviewWidgetClass,"ghostview")))
          {
          wafeConvError(argv[0],"1",argv[1],"ghostviewWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     GhostviewEnableInterpreter(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * GhostviewDisableInterpreter
 * 	in: ghostviewWidget		# ghostview widget
 */

static int 
cmd_GhostviewDisableInterpreter(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],ghostviewWidgetClass,"ghostview")))
          {
          wafeConvError(argv[0],"1",argv[1],"ghostviewWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     GhostviewDisableInterpreter(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * GhostviewIsInterpreterReady
 * 	in: ghostviewWidget		# ghostview widget
 */

static int 
cmd_GhostviewIsInterpreterReady(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],ghostviewWidgetClass,"ghostview")))
          {
          wafeConvError(argv[0],"1",argv[1],"ghostviewWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = GhostviewIsInterpreterReady(localVar1);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * GhostviewIsInterpreterRunning
 * 	in: ghostviewWidget		# ghostview widget
 */

static int 
cmd_GhostviewIsInterpreterRunning(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],ghostviewWidgetClass,"ghostview")))
          {
          wafeConvError(argv[0],"1",argv[1],"ghostviewWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = GhostviewIsInterpreterRunning(localVar1);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Pixmap 
 * GhostviewGetBackingPixmap
 * 	in: ghostviewWidget		# ghostview widget
 */

static int 
cmd_GhostviewGetBackingPixmap(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Pixmap returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],ghostviewWidgetClass,"ghostview")))
          {
          wafeConvError(argv[0],"1",argv[1],"ghostviewWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = GhostviewGetBackingPixmap(localVar1);

     


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#define readFilePtr(s) ((Tcl_GetOpenFile(wafeInterpreter, (s), 0, 1, &f) != TCL_OK) ? NULL : f)

/* 
 * Boolean 
 * GhostviewSendPS 
 * 	pre: { FILE* f;
 * 	in: ghostviewWidget		# ghostview widget
 *     	in: readFilePtr(String)		# open file 
 *     	in: long			# begin
 * 	in: unsigned int		# length
 *     	in: int				# boolean close 
 * 	post: }
 */

static int 
cmd_GhostviewSendPS(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     long localVar3;
     unsigned int localVar4;
     int localVar5;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 6) 
	 {
	 wafeArgcError(argv[0],"",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],ghostviewWidgetClass,"ghostview")))
          {
          wafeConvError(argv[0],"1",argv[1],"ghostviewWidget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          wafeConvError(argv[0],"3",argv[3],"long");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%u", &localVar4)))
          {
          wafeConvError(argv[0],"4",argv[4],"unsigned int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[5], "%d", &localVar5)))
          {
          wafeConvError(argv[0],"5",argv[5],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     { FILE* f;
     returnVar = GhostviewSendPS(localVar1,readFilePtr(argv[2]),localVar3,localVar4,localVar5);
     }

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean 
 * GhostviewNextPage
 * 	in: ghostviewWidget		# ghostview widget

 */

static int 
cmd_GhostviewNextPage(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argv[0],"",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],ghostviewWidgetClass,"ghostview")))
          {
          wafeConvError(argv[0],"1",argv[1],"ghostviewWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = GhostviewNextPage(localVar1);

          if (returnVar == 0) 
          strcpy(conversionBuffer, "false");
     else
     if (returnVar == 1) 
          strcpy(conversionBuffer, "true");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#else
#endif

void
wafeInitialize_GsvGen()
{
#ifdef GHOSTVIEW
 wafeCreateWidgetCommand("Ghostview",ghostviewWidgetClass,NULL,False);
#ifdef GHOSTVIEW
 Tcl_SetVar(wafeInterpreter,"PACKAGES","GHOSTVIEW",TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT);
#endif
 Tcl_CreateCommand(wafeInterpreter, "GhostviewEnableInterpreter", cmd_GhostviewEnableInterpreter, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "GhostviewDisableInterpreter", cmd_GhostviewDisableInterpreter, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "GhostviewIsInterpreterReady", cmd_GhostviewIsInterpreterReady, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "GhostviewIsInterpreterRunning", cmd_GhostviewIsInterpreterRunning, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "GhostviewGetBackingPixmap", cmd_GhostviewGetBackingPixmap, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "GhostviewSendPS", cmd_GhostviewSendPS, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "GhostviewNextPage", cmd_GhostviewNextPage, NULL, NULL);

#else
#endif
}
