use ExtUtils::MakeMaker;

# home of wafe is...
$WAFE = "/goodies/src/wafe";

# add the following path to locate  x libraries
$XLIBS = "-L/usr/X386/lib";
# $XLIBS = "-L/ngoodies/X11R5/lib";

# use the static or shared motif library...
$XMLIB = '-lXm';
#$XMLIB = '/usr/lib/libXm.a';

# the following paths should be ok for most users...
@STDLIBS = (
	    "-L$WAFE/src", 
	    "-L$WAFE/lib/xpm-3.4a/lib",
	    "-L$WAFE/lib/tcl7.3",
	    "-L$WAFE/lib/dbug",
	    "-L$WAFE/lib/plotter/At",
	    "-L$WAFE/lib/libhtmlw",
	     $XLIBS
	    );

# these are the athena libraries...
@AWLIBS = (
	  "-L$WAFE/lib/Xaw3d",
	  @STDLIBS,
	  "-lwafe", "-lXpm", "-lAt", "-lhtmlw", 
	  "-lXaw3d", "-lXmu", "-lXt", "-lXext", "-lX11",
	  "-ltcl", "-ldbug", "-lm",
	  );


# and these are the motif libraries...
@MWLIBS = (
	  "-L$WAFE/lib/XmGraph", "-L$WAFE/lib/layout", 
          "-L$WAFE/lib/Xbae-3.8/src", 
	   @STDLIBS, "-lmofe", 
          "-lXpm", "-lAt", "-lm-htmlw", "-llayout", "-lgraph", "-lXbae",
	   $XMLIB, "-lXmu", "-lXt", "-lXext", "-lX11",
	  "-ltcl", "-ldbug", "-lm",
	  );

chop($cwd = `pwd`);
if ($cwd =~ m.wafe[^/]*$.) {
    # if you are in the wafe extension directory, build an Athena version
    &writeMakefile(
		   'potential_libs' => join(" ",@AWLIBS),
		   'INC'            => "-I$WAFE/src -I$WAFE/lib/dbug",  
		   'DISTNAME'       => 'mofe',
		   'VERSION'        => '0.3',
		   'OBJECT'         => 'wafe.o wafecmds.o',
		   );
} elsif ($cwd =~ m.mofe[^/]*$.) { 
    # if you are in the mofe extension directory, build a Motif version
    &writeMakefile(
		   'potential_libs' => join(" ",@MWLIBS),
		   'INC'            => "-I$WAFE/src -I$WAFE/lib/dbug",  
		   'DISTNAME'       => 'myname',
		   'VERSION'        => '0.3',
		   'OBJECT'         => 'mofe.o wafecmds.o',
		   'DEFINE'         => '-DMOTIF',
		   );
} else {
    # otherwise give up.
    die "oh god, what do you want from me now?\n";
}


