proc rddSetDropData-type {} { return {function {void} {in: XtNewString(String)} {const: strlen(argv[1])} ## {message string}}}
set wafeHelp(rddSetDropData) { The command 'rddSetDropData' sets the drop data (an arbitrary
 string) for the following drag and drop operation. The actual drag
 operation is started typically by the action routine
 'rddWafeStartAction shell dragShell' (where 'shell' indicates the
 type of the drag operation, and dragShell is a pre-existing shell,
 that is dragged around on the screen) or by 'rddWafeStartAction
 pixmap picture.xpm' where the given picture is used the visualize
 the drag operation.}

proc rddAddDropHandler-type {} { return {function {void} {in: Widget} {const: (XtCallbackProc)rddDropCallbackProc} {in: XtNewString(String)} ## {widget} {Tcl command for successful drop}}}
set wafeHelp(rddAddDropHandler) { The command 'rddAddDropHandler' allows to register a drop handler
 which is executed after a successful drop operation in the given
 widget (1st argument). The drop data, which was set previously
 using the command 'rddSetDropData' is passed in the global Tcl
 variable 'DROP', which is typically referenced in the given Tcl
 Command (2nd argument).
 
    Example: rddAddDropHandler clear {undoAssignment $DROP}
 
 If the the user released the button over a widget, that does not
 have a drop handler associated, a Tcl procedure with the name
 'rddDropFailHandler' with no arguments is called.}

