#! ../wafe --f
# This sample script serves two purposes:
#   1) show, how the Athena Repeater widget can be used
#   2) give an example, how a (global) variable can be linked
#      to various resource values. Simply setting the 
#      variable to a new value causes several resources
#      changed as well. In this example, when the global
#      variable bg is altered, the background resources of the
#      Form and Label widget are adjusted
# Gustaf Neumann                      Sun Apr 24 1994, Mohegan Lake
mergeResources topLevel \
    *.background turquoise \
    *.startCallback {set bg green}  \
    *.stopCallback {set bg aquamarine}  \
    *Repeater.label ""

set value 0

Form F topLevel
Repeater down F \
    callback {sV value label [incr value -1]} \
    bitmap ldblarrow 
Label value F \
    fromHoriz down \
    borderWidth 0 width 50 \
    label $value
Repeater up F \
    callback {sV value label [incr value]} \
    bitmap rdblarrow \
    fromHoriz value
Command Quit F \
    callback quit \
    fromVert down

trace variable bg w changeBg
proc changeBg {var args} {
  global $var
  sV F background [set $var]
  sV value background [set $var]
}

set bg aquamarine
realize