/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser, Gustaf Neumann
 * Version: 1.0
 */
#define SELECTION_C

#include "wafe.h"
#include <X11/Xatom.h>
#include <X11/Xmu/Atoms.h>

char *selected = NULL;
char *loseSelectionCommand = NULL;
char *doneSelectionCommand = NULL;

static Boolean
convertProc(owner, selection, target, typeReturn, valueReturn, 
            lengthReturn, formatReturn)
Widget          owner;
Atom           *selection;
Atom           *target;
Atom           *typeReturn;
XtPointer      *valueReturn;
unsigned long  *lengthReturn;
int            *formatReturn;
    {
    Display *dpy = XtDisplay(owner);
    Atom TARGETS = XA_TARGETS(dpy);

    DBUG_ENTER("ConvertProc");
    WAFE_UNUSED(selection);

    if (*target == XA_STRING)
	{
	*valueReturn = (XtPointer)XtNewString(selected);
	*typeReturn = XA_STRING;
	*formatReturn = 8;
	*lengthReturn = strlen(selected);
	}
    else
    if (*target == TARGETS)
	{
	int target_count = 0;
	Atom *targs = (Atom *)XtMalloc((unsigned) (4 * sizeof(Atom)));
	*valueReturn = (XtPointer) targs;

	/* if targets are added, increase the constant in malloc! */
	*targs++ = XA_STRING;
	target_count++;
	*targs++ = TARGETS;
	target_count++;
	*targs++ = XA_TARGETS(dpy);
	target_count++; /* supported in the Intrinsics */
	    
	*typeReturn = XA_ATOM;
	*lengthReturn = (target_count * sizeof(Atom)) >> 2;
	*formatReturn = 32;
	}
    else
	{
	char *targetType = XGetAtomName(dpy,*target);
	wafeWarn("ConverProc", 
		 "Requested target-type %s is unsupported",
		 targetType, NULL,NULL);
	if (targetType) XtFree(targetType);
	DBUG_RETURN(False);
	}
    DBUG_RETURN(True);
    }
           
static void
loseSelectionProc(w, selection)
Widget     w;
Atom      *selection;
    {
    DBUG_ENTER("loseSelectionProc");
    WAFE_UNUSED(w||selection);
    (void) wafeEval(wafeInterpreter, loseSelectionCommand, "loseSelectionProc");
    DBUG_VOID_RETURN;
    }

static void
doneSelectionProc(w, selection, target)
Widget     w;
Atom      *selection;
Atom      *target;
    {
    DBUG_ENTER("doneSelectionDoneProc");
    WAFE_UNUSED(w||selection||target);
    (void) wafeEval(wafeInterpreter, doneSelectionCommand,"doneSelectionProc");
    DBUG_VOID_RETURN;
    }

void
wafeGetSelectionValueProc(w, clientData, selection, type, value, length, format)
Widget         w;
XtPointer      clientData;
Atom          *selection;
Atom          *type;
XtPointer      value;
unsigned long *length;
int           *format;
    {
    char *command = (char *) clientData;
    char *primary = value ? (char *) value : wafe_EMPTY;

    DBUG_ENTER("getSelectionValueProc");
    WAFE_UNUSED(w||selection||type||length||format);
    
    Tcl_SetVar(wafeInterpreter, "PRIMARY", primary, TCL_GLOBAL_ONLY);
    (void) wafeEval(wafeInterpreter, command, "selectionProc");

    DBUG_VOID_RETURN;
    }


Boolean
wafeOwnSelectionCmd(w, string, loseSelection, doneSelection)
Widget      w;
String      string;
String      loseSelection;
String      doneSelection;
    {
    XtLoseSelectionProc   loseProc = NULL;
    XtSelectionDoneProc   doneProc = NULL;

    if (selected)
	XtFree(selected);
    selected = string;

    if (loseSelectionCommand) 
	{
	XtFree(loseSelectionCommand);
	loseSelectionCommand = NULL;
	}
    if (loseSelection) 
	{
	loseProc = loseSelectionProc;
	loseSelectionCommand = XtNewString(loseSelection);
	}
   

    if (doneSelectionCommand) 
	{
	XtFree(doneSelectionCommand);
	doneSelectionCommand = NULL;
	}
    if (doneSelection) 
	{
	doneProc = doneSelectionProc;
	doneSelectionCommand = XtNewString(doneSelection);
	}

    if (XtOwnSelection(w, XA_PRIMARY,  CurrentTime,
		       convertProc, loseProc, doneProc))
	return True;
    else  
	{
	wafeWarn("OwnSelection", 
		 "Couldn't get PRIMARY Buffer",
		 NULL, NULL,NULL);
	return False;
	}      
    }

