/* make emcas happy -*-C-*-  make emacs happy */

#include <ctype.h>
#include <Xm/AtomMgr.h>
#include <Xm/List.h>
#include <X11/IntrinsicP.h>

#include <wafe_quarks.h>

#ifdef MOTIF20
#define WAFE_FONTLIST_TAG XmSTRING_COMPONENT_FONTLIST_ELEMENT_TAG
#else
#define WAFE_FONTLIST_TAG XmSTRING_COMPONENT_CHARSET
#endif

static XmStringCharSet defaultCharSet;

extern Boolean wafeInstallImage(
#if NeedFunctionPrototypes
    Widget, String, String, Boolean, int *, Pixel
#endif
);

/*
 * Initialize the default character Set variable!
 */

void
wafeMotifInit()
    {
    XmStringContext   context;
    char              *text = NULL;
    XmString          dummy = XmStringCreateSimple(wafe_ONE);
    static String pixmapClasses[] = 
	{
	XmRBackgroundPixmap,
	XmRGadgetPixmap,
	XmRManBottomShadowPixmap,
	XmRManForegroundPixmap,
	XmRManHighlightPixmap,
	XmRManTopShadowPixmap,
	XmRPixmap,
	XmRPrimBottomShadowPixmap,
	XmRPrimForegroundPixmap,
	XmRPrimHighlightPixmap,
	XmRPrimTopShadowPixmap,
	XmRXmBackgroundPixmap,
#ifdef MOTIF20
	XmRDynamicPixmap,
#endif
#ifdef MOTIF12
# ifndef MOTIF20
	XmRBitmap,
# endif
#endif
	NULL
	};
    String *p = pixmapClasses;
    XmStringCharSet    tag;
    XmStringComponentType unknown_tag;
    XmStringComponentType type;
    unsigned short     unknown_length;
    unsigned char     *unknown_value;
    XmStringDirection  dir;

    if (!XmStringInitContext(&context, dummy))
	wafeFatal("motif","Could not create String Context",NULL);


    while ((type = XmStringGetNextComponent(context, &text, &tag, &dir, 
					    &unknown_tag,&unknown_length,
					    &unknown_value))
	   != XmSTRING_COMPONENT_END)
	{
	DBUG_PRINT("motif", 
		   ("type %d, textsegment '%s', tag '%s', dir %d, u_tag %d",
		    type, text, tag, dir, unknown_tag));
	if (type == WAFE_FONTLIST_TAG)
	    {
	    defaultCharSet = tag;
	    break;
	    }
	}

    if (text) XtFree(text);
    XmStringFree(dummy);
    XmStringFreeContext(context);

    DBUG_PRINT("motif",("defaultCharSet is <%s> Xm='%s'",
			defaultCharSet,XmSTRING_DEFAULT_CHARSET));

    while (*p) 
	wafeRegisterXpmTypeConverter(*p++, True);
    }

#ifndef MOTIF20
/* Motif 2.0 comes with such an procedure */
static XmString
XmStringConcatAndFree(s1, s2)
XmString s1;
XmString s2;
    {
    XmString result = XmStringConcat(s1, s2);
    XmStringFree(s1);
    XmStringFree(s2);
    return result;
    }
#endif /* !MOTIF20 */

#define ISALPHA(c) (((c)>='a' && (c)<='z') || ((c)>='A' && (c)<='Z'))
XmString
wafeCvtStringToXmString(inString)
String inString;
    {
    XmStringDirection  dir = XmSTRING_DIRECTION_L_TO_R;
    XmString           result = NULL;
    char              *start, *end, *next, *csv;
    Boolean            sep, readTag;
    
    wafeStringStruct cs_s;
    wafeString cs = &cs_s;   /* Char set */

    wafeStringInit(cs);
    wafeStringAppend(cs,XmSTRING_DEFAULT_CHARSET);
    csv = wafeStringValue(cs);

    
    /* fprintf(stderr, "Converting string <%s>\n", inString);*/
    for (start = inString; *start; start = next)
	{
	for (end = start; *end && *end != '\n' && *end != '^'; end++);
	readTag = sep = False;
	
	if (*end)
	    {
	    next = end+1;
	    if (*end == '^')
		{
		if (*next == '^')
		    {
		    end = next;
		    next++;
		    }
		else
		    readTag = True;
		}
	    else
		sep = True; /* must be (*end == '\n') */
	    }
	else
	    next = end;

	if (sep || start != end) 
	    {
	    /* terminate and create segment */
	    char lastChar = *end;
	    *end = '\0';
	    /* fprintf(stderr,"readTag=%d, segment='%s' tag='%s'\n",
	               readTag,start,csv);
	     */
	    result = result ?
		XmStringConcatAndFree(result, 
			 XmStringSegmentCreate(start, csv, dir, sep)) :
		         XmStringSegmentCreate(start, csv, dir, sep);
	    *end = lastChar;
	    }

	if (readTag)
	    {
	    char *tagStart,*tagEnd;
	    int tagLength;
	    
	    tagStart = ++end;

	    /* fprintf(stderr,"readTag=%d %c %d\n",
	               readTag, *end, ISALPHA(*end));
	     */
	    for (; ISALPHA(*end) || *end == '_'; end++);
	    /*
	       fprintf(stderr,"readTag=%d tagStart='%s' %p, tagEnd=%p\n",
	               readTag,tagStart,tagStart, end);
	     */
	    if (tagStart == end)
		{
		if (*end == ' ')
		    next = ++end;
		}
	    else
		{
		tagEnd = end;

		/* for (; *end && *end == ' '; end++);*/
		if (*end == ' ') end++;
		next = *end ? end++ : end;

		tagLength = tagEnd-tagStart;
		if (tagLength == 2 && *tagStart == 'l' && *(tagStart+1) == 'r')
		    dir = XmSTRING_DIRECTION_L_TO_R;
		else
		if (tagLength == 2 && *tagStart == 'r' && *(tagStart+1) == 'l')
		    dir = XmSTRING_DIRECTION_R_TO_L;
		else
		    {
		    wafeStringClear(cs);
		    wafeStringAppendN(cs,tagStart,tagLength);
		    csv = wafeStringValue(cs);
		    }
		}
	    }
	else
	  {
	  }
	} /* for */

    if (!result) 
       result = XmStringSegmentCreate(wafe_EMPTY, csv, dir, False);

    return result;
    }


static XmStringTable
wafeCvtStringToXmStringTable(inString)
char * inString;
    {
    int argc;
    char ** argv;
    XmString *strTable, *t;
    int i;

    Tcl_SplitList(wafeInterpreter,inString, &argc,&argv);
    t = strTable = (XmString *)XtMalloc((argc+1)*sizeof(XmString));

    for ( i = 0; i < argc; i++, t++ )
	if (!(*t = wafeCvtStringToXmString(argv[i])))
	    {
	    wafeConvWarn("wafeCvtStringToXmStringTable", argv[i],XmRXmString);
	    XtFree((char *)argv);
	    return NULL;
	    }
    *t = NULL;

    XtFree((char *)argv);
    return (XmStringTable) strTable;
    }


/* Queries a XmString Value and translates it to a valid input string */

void
wafeCvtXmString2String(ws,compStr,returnTags)
wafeString    ws;
XmString      compStr;
Boolean       returnTags;
    {
    XmStringContext    context;
    XmStringDirection  dir = XmSTRING_DIRECTION_L_TO_R,
                       lastTextDirection = dir;
    char               *ptr;
    Boolean            firstCharSet = True;
    char              *text;
    XmStringCharSet    tag;
    XmStringComponentType unknown_tag = 0;
    XmStringComponentType type;
    unsigned short     unknown_length;
    unsigned char     *unknown_value;

    DBUG_ENTER("wafeCvtXmString2String");

    if (!XmStringInitContext(&context, compStr))
	{
	wafeWarn("motif", "Could not obtain String Context", NULL,NULL,NULL);
	DBUG_VOID_RETURN;
	}

    while ((type = XmStringGetNextComponent(context, &text, &tag, &dir, 
					    &unknown_tag,&unknown_length,
					    &unknown_value))
	   != XmSTRING_COMPONENT_END)
	{

	DBUG_PRINT("motif", ("type %d, dir %d, u_tag %d",
			     type, dir, unknown_tag));

	switch (type)
	    {
	case XmSTRING_COMPONENT_TEXT:
#ifdef MOTIF12
	case XmSTRING_COMPONENT_LOCALE_TEXT:
#endif
	    if (returnTags)
		{
		char *t = text;
		DBUG_PRINT("motif", ("text segment '%s'", text));
		if (lastTextDirection != dir)
		    {
		    if (dir == XmSTRING_DIRECTION_L_TO_R)
			wafeStringAppend(ws, "^lr ");
		    else
			wafeStringAppend(ws, "^rl ");
		    lastTextDirection = dir;
		    }
		do
		    {
		    for (ptr = t; *ptr && *ptr != '^'; ptr++);
		    wafeStringAppendN(ws, t, ptr-t);
		    if (*ptr == '^') 
			{
			wafeStringAppend(ws, "^^");
			t = ++ptr;
			}
		    } while (*ptr);
		}
	    else
		wafeStringAppend(ws, text);

	    XtFree(text);
	    break;

	case XmSTRING_COMPONENT_SEPARATOR:
	    wafeStringAppendChar(ws, '\n');
	    break;

	case XmSTRING_COMPONENT_DIRECTION:
	    break;

        case WAFE_FONTLIST_TAG:
	    DBUG_PRINT("motif",
		       ("firstCharSet %d, tag='%s', defaultCharSet='%s'",
			firstCharSet,tag,defaultCharSet));
	    if (returnTags && !
		(firstCharSet && 
		  (!strcmp(tag, defaultCharSet) || 
		   !strcmp(tag, XmFONTLIST_DEFAULT_TAG) ||
		   !strcmp(tag, XmFALLBACK_CHARSET)
		   ))
		)
		{
		wafeStringAppendChar(ws, '^');
		wafeStringAppend(ws, tag);
		wafeStringAppendChar(ws, ' ');
		firstCharSet = False;
		}
	    XtFree(tag);
	    break;

	case XmSTRING_COMPONENT_UNKNOWN:
	    wafeWarn("motif", "Unknown component in XmString ignored!",
		     NULL,NULL,NULL);
	    break;
	    }
	
	}
    
    XmStringFreeContext(context);
    DBUG_VOID_RETURN;
    }


void
wafeStringAppendXmEscaped(ws,compStr)
wafeString ws;
XmString   compStr;
    {
    wafeStringStruct   ws0_struct;
    wafeString         ws0 = &ws0_struct;
    wafeStringInit(ws0);
    wafeCvtXmString2String(ws0,compStr,True);
    wafeStringAppendEscaped(ws,wafeStringValue(ws0),wafeStringLength(ws0));
    wafeStringClear(ws0);
    }


static String
cvtXmStringTable2String(count,strTable)
int           count;
XmStringTable strTable;
    {
    char     **temp, **cPtr;
    XmString  *ptr;
    char      *result;
    int        i;
    wafeStringStruct   ws_struct;
    wafeString         ws = &ws_struct;

    DBUG_ENTER("cvtXmStringTable2String");

    wafeStringInit(ws);
    
    temp = (char **)XtMalloc(count*sizeof(char *));
    for (ptr=strTable, cPtr=temp, i=count; i>0; ptr++, cPtr++, i--)
	{
	wafeCvtXmString2String(ws,*ptr,True);
	*cPtr = XtNewString(wafeStringValue(ws));
	wafeStringClear(ws);
	}

    result = Tcl_Merge(count, temp);
    for (cPtr = temp, i=count; i>0; cPtr++, i--)
	XtFree(*cPtr);

    XtFree((char *)temp);
    DBUG_RETURN (result);
    }

void
wafeStringAppendXmStringTableEscaped(ws,count,strTable)
wafeString    ws;
int           count;
XmStringTable strTable;
    {
    XmString  *ptr;
    int        i;
    wafeStringStruct   ws0_struct;
    wafeString         ws0 = &ws0_struct;

    DBUG_ENTER("wafeStringAppendXmStringTableEscaped");

    if (count>0)
	{
	wafeStringInit(ws0);    
	for (ptr=strTable, i=count; i>0; ptr++, i--)
	    {
	    wafeCvtXmString2String(ws0,*ptr,True);
	    wafeStringAppendListItemEscaped(ws,wafeStringValue(ws0));
	    wafeStringClear(ws0);
	    }

	ws->length--;
	ws->buffer[ws->length] = 0;
	}

    DBUG_VOID_RETURN;
    }


static void
freeXmStringTable(table)
XmStringTable  table;
    {
    XmStringTable t = table;
    while (*t != NULL)
	XmStringFree(*t++);
    XtFree((char *)table);
    }	


Boolean
CvtStringToXmStrings(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    int               argc, count;
    char            **argv;
    XmString         *ptr;
    static XmString  *result;

    DBUG_ENTER("CvtStringToXmStrings");

    WAFE_UNUSED(args||num_args||converter_data);

    if (Tcl_SplitList(wafeInterpreter,(char*)fromVal->addr, &argc, &argv)
	!= TCL_OK)
	{
	wafeWarn("CvtStringToXmStrings", wafeInterpreter->result,
		 NULL,NULL,NULL);
	return False;
	}


    result = (XmString *)XtMalloc((argc+1)*sizeof(XmString));
    for(count = 0, ptr = result; count < argc; count++, ptr++)
	{
	if ((*ptr = wafeCvtStringToXmString(argv[count],NULL,0)) == NULL)
	    {
	    XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr,
					     XmRString);
	    XtFree((char *)result);
	    XtFree((char *)argv);
	    return False;
	    }
	}
    *ptr = NULL;
    XtFree((char *)argv);

    if (toVal->addr)
	{
	wafeWarn("CvtStringToXmStrings", 
		 "somebody else called CvtStringToXmStrings",
		 NULL,NULL,NULL);
	
	if (toVal->size < sizeof(XmString *))
	    {
	    toVal->size = sizeof(XmString *);
	    XtFree((char *)result);
	    DBUG_RETURN(False);
	    }

	toVal->size = sizeof(XmString *);
	*(XmString **)(toVal->addr) = result;
	DBUG_RETURN(True);
	}

    toVal->size = sizeof(XmString **);
    toVal->addr = (caddr_t)&result;
    wafeMMreplace(NULL,NULL, wafeCurrentAttrib,
		  (char *)result, freeXmStringTable);
    DBUG_RETURN(True);
    }


Boolean
CvtStringToXmString(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static XmString  result;
    DBUG_ENTER("CvtStringToXmString");

    WAFE_UNUSED(args||num_args||converter_data);

    DBUG_PRINT("CvtStringToXmString",
	       ("CvtStringToXmString: <%s> (toval: %p %d)\n",
		fromVal->addr, toVal->addr, toVal->size));


    if ((result = wafeCvtStringToXmString((char *)fromVal->addr, NULL, 0)) == NULL)
	{
	XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr,
					 XmRXmString);
	DBUG_RETURN(False);
	}

    if (toVal->addr)
	{
	if (toVal->size < sizeof(XmString))
	    {
	    toVal->size = sizeof(XmString);
	    XmStringFree(result);
	    DBUG_RETURN(False);
	    }

	toVal->size = sizeof(XmString);
	*(XmString *)(toVal->addr) = result;
	DBUG_RETURN(True);
	}

    toVal->size = sizeof(XmString *);
    toVal->addr = (XtPointer)result;

    wafeMMreplace(NULL,NULL, wafeCurrentAttrib,
		  (char *)result, (freeProc)XmStringFree);
    DBUG_RETURN(True);
    }


static Boolean
CvtStringToLong(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    long result;

    WAFE_UNUSED(dpy);
    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

    if (sscanf((char *)fromVal->addr, "%ld", &result) == 1)
	WAFE_CONVERSION_DONE(long, result)
    else
	return False;
    }


#include <Xm/Protocols.h>
static void
wafeAddProtocol(w, property, protocol)
Widget   w;
Atom     property, protocol;
    {
    XmAddProtocols(w,property,&protocol,1);
    }

static void
protocolCallbackProc(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
    {
    DBUG_ENTER("protocolCallbackProc");
    wafeExecCallbackProc(w, clientData, callData);
    DBUG_VOID_RETURN;
    }

static void
wafeAddProtocolCallback(w, property, protocol, string)
Widget   w;
Atom     property, protocol;
String   string;
    {
    char *charp = XtMalloc(strlen(string)+1+sizeof(XrmQuark));

    *(XrmQuark *)charp = (XrmQuark)0;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)string);
    XmAddProtocolCallback(w, property, protocol, 
			  protocolCallbackProc, 
			  (XtPointer)charp);
    }

int
wafeModifyVerifyCBset(doit, currInsert, startPos, endPos, string)
Boolean doit;
long currInsert, startPos, endPos;
String string;
    {
    XmTextVerifyCallbackStruct *cbs = 
	(XmTextVerifyCallbackStruct *)wafeCurrentCallData;
    int newLength =  strlen(string);

    DBUG_ENTER("wafeModifyVerifyCBset");
    
    if (!cbs || cbs->reason !=  XmCR_MODIFYING_TEXT_VALUE) 
	DBUG_RETURN(wafeSetError("calling wafeModifyVerifyCBset is only valid from a modifyVerifyCallback",NULL,NULL,NULL));

    cbs->doit = doit;

    if (doit)
	{
	if (currInsert>=0) cbs->newInsert    = currInsert;
	if (startPos>=0)   cbs->startPos     = startPos;
	if (endPos>=0)     cbs->endPos       = endPos;

	if (newLength>0) 
	    {
	    if (newLength >= cbs->text->length) 
		cbs->text->ptr = XtRealloc(cbs->text->ptr,newLength+1);
	    
	    strcpy(cbs->text->ptr, string);
	    cbs->text->length = newLength;
	    }
	else 
	    {
	    if (cbs->text->length>0) 
		XtFree(cbs->text->ptr);
	    cbs->text->ptr    = NULL;
	    cbs->text->length = 0;
	    }
	}

    DBUG_RETURN(TCL_OK);
    }

#include <Xm/FileSB.h>

static void
fileSearchProc(w, searchData)
Widget  w;
XmFileSelectionBoxCallbackStruct *searchData;
    {
    char *cmd;
    DBUG_ENTER("fileSearchProc");
    if ((cmd = wafeMMgetValue(w, qfileSearchProc, NULL, False)))
	wafeExecCallbackProc(w, (XtPointer)cmd, searchData);

    DBUG_VOID_RETURN;
    }

static void
dirSearchProc(w, searchData)
Widget  w;
XmFileSelectionBoxCallbackStruct *searchData;
    {
    char *cmd;
    DBUG_ENTER("dirSearchProc");
    if ((cmd = wafeMMgetValue(w, qdirSearchProc, NULL, False)))
	wafeExecCallbackProc(w, (XtPointer)cmd, searchData);

    DBUG_VOID_RETURN;
    }



Boolean
CvtStringToFileSearchProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    WAFE_UNUSED(dpy||args||num_args||converter_data);
    if (wafeCurrentAttrib == qfileSearchProc || 
	wafeCurrentAttrib == qdirSearchProc   ) 
	{
	char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));
	XtPointer proc = (wafeCurrentAttrib == qfileSearchProc) ? 
		(XtPointer)fileSearchProc : 
                (XtPointer)dirSearchProc;

	*(XrmQuark *)charp = wafeCurrentAttrib;
	strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);
	wafeMMreplace(NULL, NULL, wafeCurrentAttrib,
		      (char *)charp, XtFree);

	WAFE_CONVERSION_DONE(XtPointer, proc)
	} 
    else 
	return False;
    }


int
XmGetString(w,resource)
Widget w;
String resource;
    {
    XrmQuark qResName   = XrmStringToQuark(resource);
    XrmQuark qType;
    
    if (!(qType = wafeGetQTypeOfAttribute(XtClass(w),
					  ParentWidget(w),qResName,NULL)))
	return wafeSetError("widget %s has no resource %s",
			    wafeWidgetToName(w), resource, NULL);

    if (qType == qXmString) 
	{
	XmString s;
	wafeStringStruct   ws_struct;
	wafeString         ws = &ws_struct;
	wafeStringInit(ws);
	XtVaGetValues(w,resource,&s,NULL);
	wafeCvtXmString2String(ws, s, False);
	Tcl_SetResult(wafeInterpreter, wafeStringValue(ws), TCL_VOLATILE);
	wafeStringClear(ws);
	}
    else 
    if (qType == qString) 
	{
	String returnString = NULL;
	XtVaGetValues(w,resource,&returnString,NULL);
	Tcl_SetResult(wafeInterpreter, returnString, TCL_VOLATILE);
	}
    else
	{
	return wafeSetError("resource %s is not of type String or XmString",
			    resource, NULL, NULL);
	/* maybe we should handle XmStringTables here as well */
	}
    return TCL_OK;
    }

#ifndef MOTIF12
void
XmChangeColor(w, background)
Widget w;
Pixel background;
    {
    Pixel foreground_ret;
    Pixel topshadow_ret;
    Pixel bottomshadow_ret;
    Arg args[5];
    
    XmGetColors(XtScreen(w), DefaultColormapOfScreen(XtScreen(w)), 
		background, &foreground_ret,
		&topshadow_ret, &bottomshadow_ret, NULL );
    
    XtSetArg (args[0], XmNbackground, (XtArgVal) background);
    XtSetArg (args[1], XmNforeground, (XtArgVal) foreground_ret);
    XtSetArg (args[2], XmNbottomShadowColor, (XtArgVal) bottomshadow_ret);
    XtSetArg (args[3], XmNhighlightColor, (XtArgVal) foreground_ret);
    XtSetValues (w, args, 4);
    }
#endif

Boolean
uninstallImage(imageName)
String imageName;
    {
    char *imagePointerString = Tcl_GetVar2(wafeInterpreter,"_imageCache",
					   imageName, TCL_GLOBAL_ONLY);
    if (imagePointerString) 
	{
	char *end;
	XImage *i = (XImage *)strtol(imagePointerString,&end,10);
	XmUninstallImage(i);
	XDestroyImage(i);
	Tcl_UnsetVar2(wafeInterpreter,"_imageCache",
		      imageName, TCL_GLOBAL_ONLY);
	return True;
	}
    return False;
    }
