/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 * 
 */

/*
 * This file was generated by genc.
 * Be aware that modifications of this file will be lost,
 * when genc is executed!

Creation: Wed Aug 16 14:26:02 EDT 1995 on mohegan
Author: genc
Version: 1.0.13

 */

#define XT_C
#include <wafe.h>
#ifdef LAYOUT
#include "Layout.h"
#endif
 static XrmQuark qLong;
 static XrmQuark qDouble;
 static XrmQuark qchildren;
 static XrmQuark qBoolean;
 static XrmQuark qCardinal;
 static XrmQuark qDimension;
 static XrmQuark qFloat;
 static XrmQuark qInt;
 static XrmQuark qPixel;
 static XrmQuark qPosition;
 static XrmQuark qWidget;
 static XrmQuark qWidgetList;
 extern XrmQuark qString;
 extern XrmQuark qCallback;
 extern XrmQuark qPointer;
 extern XrmQuark qcallback;

/* das ist ein -*- C -*- Programm */
#include "wafe_quarks.h"

#ifdef MOTIF
# include <Xm/Xm.h>
# include <Xm/Text.h>
# ifdef MOTIF20
#  include <Xm/RepType.h>
# endif
#endif

#ifdef RDD
extern Boolean rddDeliverMessageEvent(
#if NeedFunctionPrototypes
    XEvent
#endif
);
#endif

extern Boolean wafeOwnSelectionCmd(
#if NeedFunctionPrototypes
     Widget, String, String, String
#endif
);

extern void callback (
#if NeedFunctionPrototypes
     Widget, char *, XtCallbackProc, char *
#endif
);

extern Cardinal wafeGetResourcesOfClass(
#if NeedFunctionPrototypes
     WidgetClass, QTypeList *
#endif
);

extern Cardinal wafeGetConstraintsOfClass(
#if NeedFunctionPrototypes
     WidgetClass, QTypeList *
#endif
);

extern int wafeCallbackCmd(
#if NeedFunctionPrototypes
     int, char**, Widget, XtCallbackProc
#endif
);

#ifdef ATHENA
#include <X11/Xaw/Text.h>
#include <X11/Xaw/AsciiText.h>
#endif


static XtConvertArgRec pointerConvertArgs[] = {
    {XtWidgetBaseOffset, (XtPointer)0, sizeof(Widget)}
};

/***** BEGIN for color converter  */
#include <X11/IntrinsicP.h>

static XtConvertArgRec wafeColorConvertArgs[] = {
    {XtWidgetBaseOffset, (XtPointer)XtOffsetOf(WidgetRec, core.screen),
     sizeof(Screen *)},
    {XtWidgetBaseOffset, (XtPointer)XtOffsetOf(WidgetRec, core.colormap),
     sizeof(Colormap)}
};

static void FreePixel(app, toVal, closure, args, num_args)
    XtAppContext app;
    XrmValuePtr	toVal;
    XtPointer	closure;
    XrmValuePtr	args;
    Cardinal	*num_args;
{
    Screen	    *screen;
    Colormap	    colormap;

    if (*num_args != 2) {
     XtAppWarningMsg(app, "wrongParameters","freePixel","XtToolkitError",
	"Freeing a pixel requires screen and colormap arguments",
        (String *)NULL, (Cardinal *)NULL);
     return;
    }

    screen = *((Screen **) args[0].addr);
    colormap = *((Colormap *) args[1].addr);

    if (closure) {
	XFreeColors( DisplayOfScreen(screen), colormap,
		     (unsigned long*)toVal->addr, 1, (unsigned long)0
		    );
    }
}
/***** END for color converter  */



static void
action(w, TranslationModifier, translationTable)
Widget	w;
int	TranslationModifier;
XtTranslations translationTable;
    {
    switch (TranslationModifier) 
        {
	case 1: XtOverrideTranslations(w, translationTable);
		break;
	case 2: XtAugmentTranslations(w, translationTable);
		break;
	case 3: XtVaSetValues (w, XtNtranslations, translationTable, NULL);
		break;
        }
    }


static void
realizeWidgets()
    {
    WidgetListPtr ptr = wafeWidgetTrees;
    while(ptr) 
	{
	XtRealizeWidget(ptr->widget);
	ptr = ptr->next;
	}
#ifdef MOTIF12
# ifdef DROPSITEUPDATE
    if (wafeDropsiteUpdate)
	{
	XmDropSiteEndUpdate(wafeTopLevel);
	wafeDropsiteUpdate = False;
	}
# endif
#endif    
    }

static void
callCallbacks(w, callback, argc,argv)
Widget   w;
String   callback;
int      argc;
char   **argv;
    {
    if (argc == 0) 
	{
#ifdef MOTIF
	XmAnyCallbackStruct callData;
	callData.reason = XmCR_NONE;
	callData.event  = wafeCurrentEvent;
	XtCallCallbacks(w, callback, (XtPointer)&callData);
#else
	XtCallCallbacks(w, callback, NULL);
#endif
	}
    else
    if (!strcmp(argv[0], "float"))
	{
	float f;
	sscanf(argv[1], "%f", &f);
	XtCallCallbacks(w, callback, (XtPointer)&f);
	}
    else
	wafeWarn("callCallbacks","Wrong type: %s", argv[1], NULL,NULL);
    }


static void
callActionProc(w, eventType, action, argc, argv)
Widget         w;
String         eventType;
String         action;
int            argc;
char         **argv;
    {
    char          *token;
    XEvent         event;
    Display       *display = XtDisplay(wafeTopLevel);
    Window         win = XtWindow(w), root, child;
    int            x, y, xR, yR;
    unsigned int   state, button, keycode;
    static _Xconst String procName = "callActionProc";

    if (!strcmp(eventType, wafe_EMPTY))
	{
	event.type = 0;
	event.xany.display = display;
	event.xany.window = win;
	}
    else
	{
	token = strtok(eventType, wafe_SPACE);
	if (strcmp(token, "type"))
	    {
	    wafeWarn(procName,"Missing type; aborting command",
		      NULL,NULL,NULL);
	    return;
	    }

	XQueryPointer(display, win, &root, &child, &xR, &yR, &x, &y, &state);

	token = strtok(NULL, wafe_SPACE);
	if (!strcmp(token, "buttonEvent"))
	    {
	    token = strtok(NULL, wafe_SPACE);
	    if (!strcmp(token, "button"))
		{
		token = strtok(NULL, wafe_SPACE);
		if (!strcmp(token, "button1"))
		    button = Button1;
		else
                if (!strcmp(token, "button2"))
		    button = Button2;
                else
                if (!strcmp(token, "button3"))
		    button = Button3;
		else
                if (!strcmp(token, "button4"))
		    button = Button4;
		else
                if (!strcmp(token, "button5"))
		    button = Button5;
		else
		    {
		    wafeWarn(procName,"Unknown Button, %s", 
			     token,NULL,NULL);
		    return;
		    }
		}
	    else
		{
		wafeWarn(procName,
			 "This event field (%s) can't be specified\n", 
			 token,NULL,NULL);
		return;
		}

	    event.type = ButtonPress;
	    event.xbutton.display = display;
	    event.xbutton.window = win;
	    event.xbutton.root = root;
	    event.xbutton.subwindow = child;
	    event.xbutton.x = x;
	    event.xbutton.y = y;
	    event.xbutton.x_root = xR;
	    event.xbutton.y_root = yR;
	    event.xbutton.state = state;
	    event.xbutton.button = button;
	    }
	else if(!strcmp(token, "keyEvent"))
	    {
	    token = strtok(NULL, wafe_SPACE);
	    if (!strcmp(token, "key"))
		{                   
		token = strtok(NULL, wafe_SPACE);
		keycode = XKeysymToKeycode(display, XStringToKeysym(token));
		}
	    else
		{
		wafeWarn(procName,
			 "This event field (%s) can't be specified", 
			 token,NULL,NULL);
		return;
		}

	    event.type = KeyPress;
	    event.xkey.display = display;
	    event.xkey.window = win;
	    event.xkey.root = root;
	    event.xkey.subwindow = child;
	    event.xkey.x = x;
	    event.xkey.y = y;
	    event.xkey.x_root = xR;
	    event.xkey.y_root = yR;
	    event.xkey.state = state;
	    event.xkey.keycode = keycode;
	    }
	else
	    {
	    wafeWarn(procName,
		     "This event field (%s) can't be specified", 
		     token,NULL,NULL);
	    return;
	    }                    
	}

    XtCallActionProc(w, action, &event, argv, argc);
    return;
    }

/* used by addTimeOut */
static void
timerProc(command, junk)
XtPointer        command;
XtIntervalId     *junk;
    {
    DBUG_ENTER("timerProc");
    WAFE_UNUSED(junk);
    (void) wafeEval(wafeInterpreter, (char *)command, "timerProc");
    XtFree((char *)command);
    DBUG_VOID_RETURN;
    }

/* used by addTimeOut */
static Boolean
workProc(command)
XtPointer command;
    {
    char *r;
    int  rc;

    DBUG_ENTER("workProc");
    rc = wafeEval(wafeInterpreter, (char *)command, "workProc");
    r = wafeInterpreter->result;
    if ( rc || ( r && *r++ == '1' && *r == '\0' ) ) /* don't do it again */
	{
	XtFree((char *)command);
	DBUG_RETURN(True);
	}
    DBUG_RETURN(False);
    }


static char *
cvtToString(w,clientData, typeName)
Widget     w;
XtPointer  clientData;
String     typeName;
    {
    XrmValue   input,output;
    
    DBUG_PRINT("conv", ("Converting '%s' to String", typeName));

    input.addr  = clientData;        
    input.size  = sizeof(XtPointer);  /* ??? */
    output.addr = NULL;

    IFCONVERTANDSTORE(w, typeName,input, XtRString, output)
	return output.addr;
    else
	return NULL;
    }



static String
getValue(w, Qname, freeProcPtr)
Widget      w;
XrmQuark    Qname;
freeProc   *freeProcPtr;
    {
    String       result;
    XrmQuark     Qtype;
    WidgetClass  wClass  = XtClass(w);
    static _Xconst String procName = "getValue";
    String       resName = XrmQuarkToString(Qname);
    String       typeName;
#ifdef MOTIF20
    XmRepTypeId rip;
#endif 


    DBUG_PRINT(procName, ("widget is %p resource is <%s>", w, resName)); 

    if (!(Qtype = wafeGetQTypeOfAttribute(wClass,ParentWidget(w),Qname,NULL)))
	{
	wafeWarn(procName,"Unknown Attribute %s", resName,NULL,NULL);
	*freeProcPtr = TCL_STATIC;
	return NULL;
	}

    if (Qtype == qString)
	{
	String valueString;
	*freeProcPtr = TCL_VOLATILE;
	XtVaGetValues(w, resName, &valueString, NULL);
	return valueString;
	}

    /* this is the Default value for the following types 
     * assuming that dense code is better than one instruction more
     */ 
    *freeProcPtr = XtFree;

#ifdef MOTIF
    if (Qtype == qXmString) 
	{
	XmString value;
	String returnString;
	wafeStringStruct   ws_struct;
	wafeString         ws = &ws_struct;
	wafeStringInit(ws);
	XtVaGetValues(w, resName, &value, NULL);
	wafeCvtXmString2String(ws,value,True);
	returnString = XtNewString(wafeStringValue(ws));
	wafeStringClear(ws);
	XmStringFree(value);
	return returnString;
	}
#endif /* MOTIF */
	
    if (Qtype == qInt
#ifdef MOTIF
	|| Qtype == qVerticalInt
	|| Qtype == qHorizontalInt
#endif /* MOTIF */
	)
	{
	int valueInt;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valueInt, NULL);
	sprintf(result, "%d", (int)valueInt);
	return result;
	}

    if (Qtype == qPosition
#ifdef MOTIF
	|| Qtype == qVerticalPosition
	|| Qtype == qHorizontalPosition
	|| Qtype == qShort
#endif /* MOTIF */
       )
	{
	Position valuePosition;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valuePosition, NULL);
	sprintf(result, "%hd", valuePosition);
	return result;
        }

    if (Qtype == qLong
#ifdef MOTIF
	|| Qtype == qTextPosition
#endif
	) 
	{
	long value;
	result = XtMalloc(LONG_AS_STRING);
	XtVaGetValues(w, resName, &value, NULL);
	sprintf(result, "%ld", value);
	return result;
        }


    if (Qtype == qDimension
#ifdef MOTIF
	|| Qtype == qVerticalDimension
	|| Qtype == qHorizontalDimension
	|| Qtype == qShellHorizDim
	|| Qtype == qShellVertDim
#endif
	) 
	{
	Dimension valueDimension;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valueDimension, NULL);
	sprintf(result, "%hu", valueDimension);
	return result;
        }

    if (Qtype == qCardinal)
	{
	Cardinal valueCardinal;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valueCardinal, NULL);
	sprintf(result, "%u", valueCardinal);	
	return result;
	}

    if (Qtype == qBoolean)
	{
	Boolean valueBoolean;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, resName, &valueBoolean, NULL);
	return wafeStrings[(int)valueBoolean];
	}

#ifdef MOTIF20
    if (Qtype == qSet) 
	{
	unsigned char valueSet;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, resName, &valueSet, NULL);
	switch (valueSet) 
	    {
	case XmUNSET:         return wafe_ZERO;
	case XmSET:           return wafe_ONE;
	case XmINDETERMINATE: return "indeterminate";
	    }
        }
#endif

    if (Qtype == qFloat) 
	{
	float valueFloat;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, resName, &valueFloat, NULL);
	sprintf(result, "%f", valueFloat);
	return result;
	}

    if (Qtype == qDouble) 
	{
	double valueDouble;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, resName, &valueDouble, NULL);
	sprintf(result, "%f", valueDouble);
	return result;
	}

    if (Qtype == qPixel) 
	{
	XColor  c;
	Display *dpy = XtDisplay(w);
	result = XtMalloc(8); /* "#RRGGBB" */
	XtVaGetValues(w, resName, &(c.pixel), NULL);
	XQueryColor(dpy,DefaultColormap(dpy, DefaultScreen(dpy)),&c);
	sprintf(result, "#%02X%02X%02X", 
		(int)(c.red>>8), (int)(c.green>>8), (int)(c.blue>>8));
	return result;
	}

     /* Callbacks sind ... anders: die String-Information 
	kommt aus wafe's privatem Memory-Management und nicht 
	ber getValues!
      */
    if (Qtype == qCallback) 
	{
	MMattribListPtr ptr = *wafeMMgetAttribList(w,True);
	
	*freeProcPtr = TCL_STATIC;
	result = NULL;
	/* try to get callback through memory management */
	while(ptr) 
	    {
	    if (ptr->attribute == Qname) 
		{
		result = ((char*)ptr->value) +
		    sizeof(XtCallbackList)*2 +
		    sizeof(XtCallbackRec[2]) +
		    sizeof(XrmQuark);
		break;
		}
	    ptr = ptr->next;
	    }
	/* try to get callback from callback list */
	if (!result) 
	    {
	    XtCallbackList cbl;
	    XtVaGetValues(w, resName, &cbl, NULL);
	    for (; cbl->callback; cbl++)
		{
		if ( cbl->callback == wafeExecCallbackProc ) 
		    {
		    result = ((char*)cbl->closure) + sizeof(XrmQuark);
		    break;
		    }
		}
	    }
	if (!result) 
	    result = wafe_EMPTY;
	return result;
	}

    if (Qtype == qWidget
#ifdef MOTIF
	|| Qtype == qWindow
	|| Qtype == qMenuWidget
#endif
	)
	{
	Widget valueWidget;
	result = XtMalloc(LONG_AS_STRING);
	XtVaGetValues(w, resName, &valueWidget, NULL);
	sprintf(result, "%ld", (long)valueWidget);
	return result;
	}

    /* try to convert using registered name specific conversion routines
       (from .spec file)

       This must be before qPointer, since Xaw registers list 
       converter for type pointer
     */

    if ((result = wafeCvtNsToString(w,Qname,freeProcPtr)))
	return result;


    if (Qtype == qPointer) 
	{
	XtPointer p;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, resName, &p, NULL);
	return (String)p;
	}
    

    typeName = XrmQuarkToString(Qtype);
      
#ifdef MOTIF20
    if ( (rip = XmRepTypeGetId(typeName)) != XmREP_TYPE_INVALID )
	{
	unsigned  char value;
	Arg       arg;
	XrmValue  input;    
	XrmValue  output;   

	DBUG_PRINT(procName, ("using reverse rep converter for type '%s;", 
			      typeName)); 
	  
	XtSetArg(arg, resName, &value);
	XtGetValues(w, &arg, (Cardinal)1);

	/* it is cheaper to call this multiple times than to 
	   get a copy of the repTypeRecord; the converter is
	   actually installed only once */
	XmRepTypeAddReverse(rip);  
	
	input.addr = &value;
	input.size = sizeof(value);
	output.addr =  NULL;
	XtConvert(w, typeName, &input, XtRString, &output); 
	if (output.addr) 
	    result = *(String *)output.addr;
	else
	    result = NULL;
	}

#endif /* MOTIF20 */

    if (!result)
	{
	/*
	 * warning: cvtToString assumes, the get values result
	 * can be stored in a XtPointer and that the result 
	 * does not have to be freed! 
	 */

	XtPointer value = 0;
	XtPointer valuePtr = (XtPointer)&value;
	Cardinal  size;
	Arg       arg;
	XrmQuark  oldAttrib = wafeCurrentAttrib;
	Widget    oldWidget = wafeCurrentWidget;

	XtSetArg(arg, resName, valuePtr);
	XtGetValues(w, &arg, (Cardinal)1);
	    
	if (!(size = wafeGetRsize(typeName)))
	    size = sizeof(char);

	if (size == sizeof(char)) 
	    {
	    char v = *(char *)valuePtr;
	    value = (XtPointer)(int)v;
	    }
	else
	if (size == sizeof(short)) 
	    {
	    short v = *(short *)valuePtr;
	    value = (XtPointer)(int)v;
	    }
	else
	if (size == sizeof(int)) 
	    {
	    int v = *(int *)valuePtr;
	    value = (XtPointer)v;
	    }
	else
	    {
	    long v = *(long *)valuePtr;
	    value = (XtPointer)v;
	    }
	
	/* fprintf(stderr,"value=%08x\n", value); */
	wafeCurrentAttrib = Qname;
	wafeCurrentWidget = w;
	result = cvtToString(w, value, typeName);
	wafeCurrentAttrib = oldAttrib;
	wafeCurrentWidget = oldWidget;
	}

    if (!result)
	wafeWarn(procName, "Couldn't convert value for %s to string",
		 resName,NULL,NULL);

    *freeProcPtr = TCL_STATIC;	
    return result;
    }

static int
getResourceList(w, resultPtr)
char    ***resultPtr; 
Widget   w;
    {
    int numTotal, count;
    char **result;
    int rNum = 0;
    int cNum = 0;
    QTypeList rList, cList;

    rNum = wafeGetResourcesOfClass(XtClass(w), &rList);

    if (XtIsConstraint(ParentWidget(w)))   /* If parentWidget is constrain widget => fetch constraints */
	cNum =  wafeGetConstraintsOfClass(XtClass(ParentWidget(w)), &cList);

    numTotal = rNum + cNum;

    *resultPtr = result = (char **)XtMalloc(numTotal *sizeof(char *));       

    for ( count = 0; count < rNum; count++ )
	*result++ = XrmQuarkToString(rList[count].qName);

    for ( count = 0; count < cNum; count++ )
	*result++ = XrmQuarkToString(cList[count].qName);

    return(numTotal);
    }


static String
waitForVariable(varName)
String varName;
    {
    String result = NULL;
    Tcl_UnsetVar(wafeInterpreter,varName,TCL_GLOBAL_ONLY);
    wafeInnerEventLoop ++;
    while (!(result = Tcl_GetVar(wafeInterpreter,varName,TCL_GLOBAL_ONLY)))
	XtAppProcessEvent(wafeAppContext, XtIMAll);
    wafeInnerEventLoop --;
    return result;
    }


static void
processPendingEvents()
    {
    while (XtAppPending(wafeAppContext))
       {
       XEvent event;
       XtAppNextEvent(wafeAppContext,&event);
#ifdef RDD
       if (rddDeliverMessageEvent(event))
	   continue;
#endif
       wafeInnerEventLoop ++;
       XtDispatchEvent(&event);
       wafeInnerEventLoop --;
       }
    }

typedef int MapState;

static MapState
mapState(w)
Widget w;
    {
    XWindowAttributes wattr;
    Window win = XtWindow(w);
    
    if (!win) return 0;
    if (!XGetWindowAttributes(XtDisplay(w), win, &wattr)) return 0;
    return wattr.map_state;
    }

#ifndef PRER5
static Status
combineFileDatabase(fname,w,override)
String fname;
Widget w;
Bool override;
    {
    XrmDatabase dispDb = XtDatabase(XtDisplay(w)); 
    return XrmCombineFileDatabase(fname, &dispDb, override);
    }
#endif

Boolean
wafeMWMrunning(shell)
Widget shell;
    {
#ifdef MOTIF
    return XmIsMotifWMRunning(shell);
#else
    Display  *dpy         = XtDisplay(shell);
    Window    root        = RootWindowOfScreen(XtScreen(shell));
    Atom      motifWmInfo = XInternAtom(dpy, "_MOTIF_WM_INFO", False);

    Atom      actual_type;
    int       actual_format;
    unsigned long nitems, bytes_after;
    unsigned char* prop;

    XGetWindowProperty(dpy, root, motifWmInfo, 0,0, FALSE,motifWmInfo,
		       &actual_type,&actual_format,&nitems,&bytes_after,
		       &prop);
    return (actual_type == motifWmInfo && actual_format == 32);
#endif /* MOTIF */
    }

static Boolean
wafeGetBool(string,boolPtr)
String string;
Bool *boolPtr;
    {
    int tclBool;
    if (TCL_OK == Tcl_GetBoolean(wafeInterpreter,string,&tclBool))
	{
	*boolPtr = (Bool)(tclBool);
	return True;
	}
    else 
	return False;
    }

#ifndef PRER5
static int
getActionList(wClass) 
WidgetClass wClass;
    {
    Cardinal num;
    XtActionList al,a;

#ifdef ATHENA
    /* only the textWidgetList has the action list :( */
    if (wClass == asciiTextWidgetClass) 
	wClass = textWidgetClass;
#endif    
    XtGetActionList(wClass, &al, &num);
    for(a=al; num; num--, a++) 
	Tcl_AppendElement(wafeInterpreter, a->string);

    if (al) XtFree((char *)al);
    return TCL_OK;
    }
#endif

/* convert string to pointer, ATHENA widget version, where Quark or lists
   are set; there is also another version which only sets strings...
 */
static Boolean
CvtStringToPointer(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    Boolean canDoNameSpecificConversion = (wafeCurrentAttrib != 0);
    Widget w = *((Widget *) args[0].addr);
    WidgetClass wClass = canDoNameSpecificConversion ? XtClass(w) : NULL;
    static XtPointer value;
    freeProc freeGarbage;

    DBUG_ENTER("CvtStringToPointer");

    WAFE_UNUSED(dpy);
    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

#ifdef ATHENA
    if (canDoNameSpecificConversion == False)
	{
	/* delay conversion */
	wafePointerResourceValue = True;
	toVal->addr = NULL;
	DBUG_RETURN(True);
	}
#endif /* ATHENA */

#ifdef MOTIF    
    if (canDoNameSpecificConversion == False || toVal->addr) 
	{
	/* give up */
	toVal->addr = NULL;
	DBUG_RETURN(False);
	}
#endif

    if (wafeCvtNsFromString((String)fromVal->addr, wafeCurrentAttrib, wClass,
			    &value, &freeGarbage, &toVal->size))
	{
	if (toVal->addr) 
	    *(XtPointer *)(toVal->addr) = (XtPointer)value;
	else
	    toVal->addr = (caddr_t)&value;

	if (freeGarbage && freeGarbage != TCL_STATIC)
	    {
	    /* fprintf(stderr, "adding mmreplace\n"); */
	    wafeMMreplace(w, NULL, wafeCurrentAttrib, 
			  (char *)value, freeGarbage);
	    }
	}
    else
	{
	DBUG_PRINT("conv",("default"));
	/* store value like a string */

	if (toVal->addr) 
	    *(String *)(toVal->addr) = (String)fromVal->addr;
	else
	    {
	    static char* p;
	    p = XtNewString(fromVal->addr);
	    toVal->addr = (caddr_t)&p;
	    wafeMMreplace(w, NULL, wafeCurrentAttrib, 
			  (char *)p, XtFree);
	    }
	toVal->size = sizeof(String);
	}

    DBUG_RETURN(True);
    }



#ifdef MY_FONT_CONVERTER
static void 
FetchDisplayArg(widget, size, value)
Widget widget;
Cardinal *size;
XrmValue* value;
    {
    value->size = sizeof(Display*);
    value->addr = (XPointer)&DisplayOfScreen(XtScreenOfObject(widget));
    }

static XtConvertArgRec displayConvertArg[] = {
    {XtProcedureArg, (XtPointer)FetchDisplayArg, 0},
};

static Boolean
wafeCvtStringToFontStruct(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    return XtCvtStringToFontStruct(dpy, args, num_args, 
				   fromVal, toVal, converter_data);
    }
#endif

String
wafeGetDomain(typeString)
_Xconst String typeString;
    {
    Boolean freeStringList = False;
    String *strings = NULL;
    
#ifdef MOTIF20
    XmRepTypeId rip;
    
    if ( (rip = XmRepTypeGetId(typeString)) != XmREP_TYPE_INVALID )
	{
	strings = XmRepTypeGetNameList(rip,FALSE);
	freeStringList = True;
	}
#endif /* MOTIF 20 */    

    if (!strings)
	strings = wafeGetRdomain(typeString);

    if (strings)
	{
	String *s = strings;
	wafeStringStruct ws_s, *ws = &ws_s;

	wafeStringInit(ws);
	for(;s&&*s;s++) 
	    {
	    wafeStringAppend(ws,*s);
	    wafeStringAppendChar(ws,' ');
	    }
	if (ws->length)
	    ws->buffer[ws->length-1] = 0;
	
	if (freeStringList) 
	    {
	    for(s=strings;s&&*s;s++) XtFree(*s);
	    XtFree((char *)strings);
	    }
    
	return (ws->buffer == ws->sBuffer) ?
	    XtNewString(ws->buffer) : ws->buffer;
	}

    if (!strcmp(typeString,XtRBoolean))
	{
	return XtNewString("1 0 True False");
	}
    
    /*	wafeWarn("getDomain","cannot obtain domain for type '%s'",
	typeString,NULL,NULL);
	*/
    return XtNewString(wafe_EMPTY);
    }


int
screen(subCmd, w)
String subCmd;
Widget w;
    {
    char conversionBuffer[LONG_AS_STRING];
    int retcode = TCL_OK;
    Screen *s = XtScreen(w);
    
    DBUG_ENTER("screen");  

    if (*subCmd == 'n' && !strcmp(subCmd, "name")) 
	Tcl_SetResult(wafeInterpreter,DisplayString(DisplayOfScreen(s)), TCL_STATIC);
    else
    if (!strcmp(subCmd, "width")) 
	{
	sprintf(conversionBuffer, "%d", WidthOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'h' && !strcmp(subCmd, "height")) 
	{
	sprintf(conversionBuffer, "%d", HeightOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'w' && !strcmp(subCmd, "widthMM")) 
	{
	sprintf(conversionBuffer, "%d", WidthMMOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'h' && !strcmp(subCmd, "heightMM")) 
	{
	sprintf(conversionBuffer, "%d", HeightMMOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'p' && !strcmp(subCmd, "planes")) 
	{
	sprintf(conversionBuffer, "%d", PlanesOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'c' && !strcmp(subCmd, "cells")) 
	{
	sprintf(conversionBuffer, "%d", CellsOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'r' && !strcmp(subCmd, "rootWindow")) 
	{
	sprintf(conversionBuffer, "%ld", RootWindowOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'b' && !strcmp(subCmd, "blackPixel")) 
	{
	sprintf(conversionBuffer, "%ld", BlackPixelOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'w' && !strcmp(subCmd, "whitePixel")) 
	{
	sprintf(conversionBuffer, "%ld", WhitePixelOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
	DBUG_RETURN(wafeSetError("unknown subcommand '%s' for screen; valid: 'blackPixel', 'cells', 'height', 'heightMM', 'name', 'planes', 'rootWindow', 'whitePixel', 'width', widthMM'", subCmd, NULL, NULL));
    
    DBUG_RETURN (retcode);
    }

static int cmd_addTimeOut();
static int cmd_action();
static int cmd_bell();
static int cmd_callActionProc();
static int cmd_callCallbacks();
static int cmd_callback();
#ifndef PRER5
static int cmd_combineFileDatabase();
#else
#define cmd_combineFileDatabase NULL
#endif
static int cmd_destroyWidget();
#ifndef PRER5
static int cmd_fallbackResources();
#else
#define cmd_fallbackResources NULL
#endif
static int cmd_fontHeight();
static int cmd_xflush();
static int cmd_getApplicationResource();
static int cmd_getClass();
static int cmd_getResourceList();
static int cmd_getTypeOfAttribute();
static int cmd_getValue();
static int cmd_grabKeyboard();
static int cmd_grabPointer();
static int cmd_installAccelerators();
static int cmd_installAllAccelerators();
static int cmd_isWidget();
static int cmd_lowerWindow();
static int cmd_manageChild();
static int cmd_mapWidget();
static int cmd_mergeResources();
static int cmd_nameToWidget();
static int cmd_parent();
static int cmd_popdown();
static int cmd_popup();
static int cmd_popupChildren();
static int cmd_popupSpringLoaded();
static int cmd_processPendingEvents();
static int cmd_raiseWindow();
static int cmd_realize();
static int cmd_realizeWidget();
static int cmd_removeAllCallbacks();
static int cmd_removeTimeOut();
static int cmd_resolvePathname();
static int cmd_setKeyboardFocus();
static int cmd_setSensitive();
static int cmd_setValues();
static int cmd_setWMProtocols();
static int cmd_sync();
static int cmd_textWidth();
static int cmd_translateCoords();
static int cmd_ungrabPointer();
static int cmd_ungrabKeyboard();
static int cmd_unmanageChild();
static int cmd_unmapWidget();
static int cmd_unrealizeWidget();
static int cmd_waitForVariable();
static int cmd_widgetName();
static int cmd_window();
static int cmd_disownSelection();
static int cmd_getSelectionValue();
static int cmd_ownSelection();
static int cmd_fetchBuffer();
static int cmd_fetchBytes();
static int cmd_convertSelection();
static int cmd_storeBuffer();
#ifndef PRER6
static int cmd_hooksOfDisplay();
#else
#define cmd_hooksOfDisplay NULL
#endif
static int cmd_mapState();
static int cmd_addWorkProc();
static int cmd_removeWorkProc();
static int cmd_isShell();
#ifndef PRER5
static int cmd_getActionList();
#else
#define cmd_getActionList NULL
#endif
static int cmd_atomName();
static int cmd_atomId();
static int cmd_isAtom();
static int cmd_motifWMRunning();
static int cmd_reparentWindow();
static int cmd_isManaged();
static int cmd_getDomain();
static int cmd_screen();
#include <X11/Xatom.h>
#include <X11/Xmu/Converters.h>

extern wafePositionCallbackProc();
extern wafePositionCursorCallbackProc();

#define wafeCallbackCmdArgs(w,res,type,arg) wafeCallbackCmd(argc,argv,w,type)

#define fallbackResources(localVar1,argc,argv) { XrmDatabase    dispDb, newDb = NULL; int            i; char         **v = argv; dispDb = XtDatabase(XtDisplay(localVar1)); for (i = 0; i < argc; i+=2)  { if (*v[i] == '#') continue; XrmPutStringResource(&newDb, v[i], v[i+1]); } XrmCombineDatabase(newDb, &dispDb, False);}

#define fontHeight(w,resource) (font->max_bounds.ascent + font->max_bounds.descent)

#include <X11/IntrinsicP.h>
#define getClass(widget) (XtClass(widget)->core_class.class_name)

#define mergeResources(localVar1,argc,argv) { XrmDatabase    dispDb, newDb = NULL; int            i; char         **v = argv; dispDb = XtDatabase(XtDisplay(localVar1)); for (i = 0; i < argc; i+=2)  { if (*v[i] == '#') continue; XrmPutStringResource(&newDb, v[i], v[i+1]); } XrmMergeDatabases(newDb, &dispDb);}

#define popupChildren(w) wafeCvtWidgetListToList((w)->core.num_popups,(w)->core.popup_list)

#define ADDRESS_OF(w) &(w)

#define textWidth(w,resource,string) XTextWidth(font, string, strlen(string))

extern void wafeGetSelectionValueProc();

#define name2AtomLV1chk(s) wafeStringToAtomChk(localVar1,s)
#ifdef MOTIF
#include <Xm/AtomMgr.h>
#endif


 static _Xconst String int_strings[] = {
  "NormalState","IconicState",NULL };
 static _Xconst int int_values[] = {
  NormalState,IconicState,0 };
 static XtConvertArgRec int_args[] = { {XtAddress, NULL, 0} };





static _Xconst Proc_signature cmds[] = {
     { "addTimeOut", cmd_addTimeOut },
     { "action", cmd_action },
     { "bell", cmd_bell },
     { "callActionProc", cmd_callActionProc },
     { "callCallbacks", cmd_callCallbacks },
     { "callback", cmd_callback },
     { "combineFileDatabase", cmd_combineFileDatabase },
     { "destroyWidget", cmd_destroyWidget },
     { "fallbackResources", cmd_fallbackResources },
     { "fontHeight", cmd_fontHeight },
     { "xflush", cmd_xflush },
     { "getApplicationResource", cmd_getApplicationResource },
     { "getClass", cmd_getClass },
     { "getResourceList", cmd_getResourceList },
     { "getTypeOfAttribute", cmd_getTypeOfAttribute },
     { "getValue", cmd_getValue },
     { "grabKeyboard", cmd_grabKeyboard },
     { "grabPointer", cmd_grabPointer },
     { "installAccelerators", cmd_installAccelerators },
     { "installAllAccelerators", cmd_installAllAccelerators },
     { "isWidget", cmd_isWidget },
     { "lowerWindow", cmd_lowerWindow },
     { "manageChild", cmd_manageChild },
     { "mapWidget", cmd_mapWidget },
     { "mergeResources", cmd_mergeResources },
     { "nameToWidget", cmd_nameToWidget },
     { "parent", cmd_parent },
     { "popupChildren", cmd_popupChildren },
     { "processPendingEvents", cmd_processPendingEvents },
     { "raiseWindow", cmd_raiseWindow },
     { "realize", cmd_realize },
     { "realizeWidget", cmd_realizeWidget },
     { "removeAllCallbacks", cmd_removeAllCallbacks },
     { "removeTimeOut", cmd_removeTimeOut },
     { "resolvePathname", cmd_resolvePathname },
     { "setKeyboardFocus", cmd_setKeyboardFocus },
     { "setSensitive", cmd_setSensitive },
     { "setValues", cmd_setValues },
     { "setWMProtocols", cmd_setWMProtocols },
     { "sync", cmd_sync },
     { "textWidth", cmd_textWidth },
     { "translateCoords", cmd_translateCoords },
     { "ungrabPointer", cmd_ungrabPointer },
     { "ungrabKeyboard", cmd_ungrabKeyboard },
     { "unmanageChild", cmd_unmanageChild },
     { "unmapWidget", cmd_unmapWidget },
     { "unrealizeWidget", cmd_unrealizeWidget },
     { "waitForVariable", cmd_waitForVariable },
    { "widgetId", cmd_isWidget }, /* alias */
     { "widgetName", cmd_widgetName },
     { "window", cmd_window },
     { "disownSelection", cmd_disownSelection },
     { "getSelectionValue", cmd_getSelectionValue },
     { "ownSelection", cmd_ownSelection },
     { "fetchBuffer", cmd_fetchBuffer },
     { "fetchBytes", cmd_fetchBytes },
     { "convertSelection", cmd_convertSelection },
     { "storeBuffer", cmd_storeBuffer },
    { "sV", cmd_setValues }, /* alias */
    { "gV", cmd_getValue }, /* alias */
     { "hooksOfDisplay", cmd_hooksOfDisplay },
     { "mapState", cmd_mapState },
     { "addWorkProc", cmd_addWorkProc },
     { "removeWorkProc", cmd_removeWorkProc },
     { "isShell", cmd_isShell },
     { "getActionList", cmd_getActionList },
     { "atomName", cmd_atomName },
     { "atomId", cmd_atomId },
     { "isAtom", cmd_isAtom },
     { "reparentWindow", cmd_reparentWindow },
     { "isManaged", cmd_isManaged },
     { "getDomain", cmd_getDomain },
     { "screen", cmd_screen },
     { "popdown", cmd_popdown },
     { "popup", cmd_popup },
     { "popupSpringLoaded", cmd_popupSpringLoaded },
     { "motifWMRunning", cmd_motifWMRunning },
    { NULL, NULL }
    };

static WidgetCreate_signature wccs[] = {
    {"ApplicationShell",NULL,XtAppCreateShell,True,False,XtInitializeWidgetClass},
    {"Layout",NULL,NULL,False,False,XtInitializeWidgetClass},
    {"OverrideShell",NULL,XtCreatePopupShell,True,False,XtInitializeWidgetClass},
    {"TopLevelShell",NULL,XtCreatePopupShell,True,False,XtInitializeWidgetClass},
    {"TransientShell",NULL,XtCreatePopupShell,True,False,XtInitializeWidgetClass},
    { NULL,NULL,NULL,False,False,NULL }
    };

static _Xconst String pkgs[] = {
#ifdef LAYOUT
     "LAYOUT",
#endif
    NULL
     };



/* 
 * XtIntervalId
 * XtAppAddTimeOut 
 * 	const: wafeAppContext 
 * 	in: unsigned long		# time interval in ms
 * 	const: timerProc
 * 	in: XtNewString(String)		# Tcl command
 */

static int 
cmd_addTimeOut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     unsigned long localVar1;
     XtIntervalId returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(*argv[1] >= '0' && *argv[1] <= '9' && sscanf(argv[1], wafeStrings[10], &localVar1)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, "unsigned long"));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = XtAppAddTimeOut(wafeAppContext,localVar1,timerProc,XtNewString(argv[2]));

     sprintf(conversionBuffer, wafeStrings[10], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * action
 * 	in: Widget			# widget
 * 	in: (int)TranslationModifier	# override | augment | replace
 *         in: XtTranslations		# translation table
 */

static int 
cmd_action(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     XtTranslations localVar3;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     if (!strcmp(argv[2], "override")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "augment")) 
         localVar2 = 2;
     else
     if (!strcmp(argv[2], "replace")) 
         localVar2 = 3;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 2,NULL, "TranslationModifier"));


     if (!(localVar3 = (XtTranslations) XtParseTranslationTable(argv[3])))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, "XtTranslations"));

     action(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }


#define WS_ApplicationShell wccs[0].name
/* 
 * void
 * XBell
 *         in: XtDisplay(Widget{Display})	# widget to determine display
 * 	in: int				# percent (-100 = off, 0 .. 100)
 */

static int 
cmd_bell(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     XBell(XtDisplay(localVar1),localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * callActionProc
 * 	in: Widget			# widget
 * 	in: String			# event structure
 * 	in: String			# name of action procedure
 * 	in: [args opt]			# parameters of action procedure
 */

static int 
cmd_callActionProc(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],3));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     argc -= 4;
     callActionProc(localVar1,argv[2],argv[3],argc,&argv[4]);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * callCallbacks
 * 	in: Widget			# widget
 * 	in: String			# callback
 * 	in: [args opt]			# optional float and value
 */

static int 
cmd_callCallbacks(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     argc -= 3;
     callCallbacks(localVar1,argv[2],argc,&argv[3]);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * TCL_RETURN_CODE
 * wafeCallbackCmdArgs vulgo callback
 * 	in: Widget			# widget
 * 	in: String			# callback resource
 *         in: XtCallbackProc		# none | exclusive | nonexclusive | popdown | position | positionCursor
 *         in: String			# string (depends on third argument, widget reference for none | exclusive | nonexclusive | popdown)
 */

static int 
cmd_callback(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XtCallbackProc localVar3;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     if (!strcmp(argv[3], "exec")) 
         localVar3 = (XtCallbackProc)wafeExecCallbackProc;
     else
     if (!strcmp(argv[3], wafeStrings[24])) 
         localVar3 = XtCallbackNone;
     else
     if (!strcmp(argv[3], wafeStrings[23])) 
         localVar3 = XtCallbackExclusive;
     else
     if (!strcmp(argv[3], wafeStrings[25])) 
         localVar3 = XtCallbackNonexclusive;
     else
     if (!strcmp(argv[3], "popdown")) 
         localVar3 = XtCallbackPopdown;
     else
     if (!strcmp(argv[3], "position")) 
         localVar3 = (XtCallbackProc)wafePositionCallbackProc;
     else
     if (!strcmp(argv[3], "positionCursor")) 
         localVar3 = (XtCallbackProc)wafePositionCursorCallbackProc;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 3,NULL, "XtCallbackProc"));


    /* no need to assign  << localVar4 = argv[4] >>  */ 

     returnVar = wafeCallbackCmdArgs(localVar1,argv[2],localVar3,argv[4]);

     DBUG_RETURN (returnVar);
     }


/* 
 * hint: R5
 * Status
 * combineFileDatabase
 * 	in: String			# filename
 *         in: Widget{Display}		# widget to determine database
 * 	in: Bool			# override
 */
#ifndef PRER5

static int 
cmd_combineFileDatabase(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar2;
     Bool localVar3;
     Status returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     if (!(localVar2 =  name2Widget(argv[2])))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRWidget));
     if (!(XtIsWidget(localVar2)))
         wafeReturnTclError(argv[0],"Widget (arg 2) must have a display");

     if (!(wafeGetBool(argv[3],&localVar3)))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, XtRBool));

     returnVar = combineFileDatabase(argv[1],localVar2,localVar3);

     sprintf(conversionBuffer, wafeStrings[7], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }

#endif

/* 
 * void
 * XtDestroyWidget
 * 	callmultiple
 * 		in: wafeMMfreeGarbage(Widget)	# widgets
 */

static int 
cmd_destroyWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],1));

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
             DBUG_RETURN(wafeConvError(argc, argv, count, NULL, XtRWidget));

         XtDestroyWidget(wafeMMfreeGarbage(localVar1));
          }

     DBUG_RETURN (TCL_OK);
     }


/* 
 * hint: R5
 * void 
 * fallbackResources
 *         in: Widget{Display}		# widget to determine database
 * 	in: [args avp] 			# resource-specification  value pairs
 */
#ifndef PRER5

static int 
cmd_fallbackResources(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (wafeMergeArguments(argv[2],argv[0],&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN(wafeArgcError(argc+2, argv,"even number of attribute value pairs such as 2 or ",4));
        }

     fallbackResources(localVar1,argc,argvArg);
     if (freeArgv) XtFree((char *)argvArg);

     DBUG_RETURN (TCL_OK);
     }

#endif

/* 
 * int
 * fontHeight
 * 	pre: {XFontStruct *font; XtVaGetValues(localVar1, argv[2], &font, NULL);
 * 	in: Widget			# Widget
 * 	in: String			# fontResource
 *         post: }
 */

static int 
cmd_fontHeight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     {XFontStruct *font; XtVaGetValues(localVar1, argv[2], &font, NULL);
     returnVar = fontHeight(localVar1,argv[2]);
     }

     sprintf(conversionBuffer, wafeStrings[7], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XFlush vulgo xflush
 *         in: XtDisplay(Widget{Display})		# Widget to determine display
 */

static int 
cmd_xflush(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

     XFlush(XtDisplay(localVar1));

     DBUG_RETURN (TCL_OK);
     }


/* 
 * String
 * wafeGetApplicationResource vulgo getApplicationResource
 * 	in: Widget			# base widget 
 * 	in: String			# resource name
 * 	in: String			# resource class
 */

static int 
cmd_getApplicationResource(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     returnVar = wafeGetApplicationResource(localVar1,argv[2],argv[3]);

     Tcl_SetResult(comInterpreter, returnVar, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * String
 * getClass
 * 	in: Widget			# widget
 */

static int 
cmd_getClass(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     returnVar = getClass(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * int
 * getResourceList
 * 	in: Widget	     # widget
 * 	out: String *        # variable name for output of list of resources 
 * 	end: XtFree((String)localVar2);
 */

static int 
cmd_getResourceList(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String * localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     returnVar = getResourceList(localVar1,&localVar2);

     Tcl_SetVar(wafeInterpreter,argv[2],Tcl_Merge(returnVar,localVar2),0);

     sprintf(conversionBuffer, wafeStrings[7], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     XtFree((String)localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * XrmQuark
 * wafeGetQTypeOfAttribute vulgo getTypeOfAttribute
 * 	in: XtClass(Widget)		# widget
 * 	const: ParentWidget(localVar1)
 * 	in: XrmStringToQuark(String)	# attribute
 * 	const: NULL
 */

static int 
cmd_getTypeOfAttribute(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XrmQuark returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = wafeGetQTypeOfAttribute(XtClass(localVar1),ParentWidget(localVar1),XrmStringToQuark(argv[2]),NULL);

     Tcl_SetResult(comInterpreter, XrmQuarkToString(returnVar), TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * String
 * getValue
 * 	in: Widget			# widget
 * 	in: XrmQuark			# attribute
 * 	free: freeProc
 */

static int 
cmd_getValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XrmQuark localVar2;
     freeProc localVar3;
     String returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     if (!(localVar2 = (XrmQuark) XrmStringToQuark(argv[2])))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[26]));

     returnVar = getValue(localVar1,localVar2,&localVar3);

     Tcl_SetResult(comInterpreter, returnVar, localVar3);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * (int) GrabReturns
 * XtGrabKeyboard
 * 	in: Widget			# widget
 * 	in: Boolean			# true | false
 * 	in: (int) SyncAsync		# pointer mode (sync | async)
 * 	in: (int) SyncAsync		# keyboard mode (sync | async)
 * 	const: CurrentTime
 */

static int 
cmd_grabKeyboard(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     int localVar3;
     int localVar4;
     int returnVar;
     char *staticResultString;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRBoolean));

     if (!strcmp(argv[3], wafeStrings[21])) 
         localVar3 = GrabModeSync;
     else
     if (!strcmp(argv[3], wafeStrings[22])) 
         localVar3 = GrabModeAsync;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 3,NULL, wafeStrings[27]));


     if (!strcmp(argv[4], wafeStrings[21])) 
         localVar4 = GrabModeSync;
     else
     if (!strcmp(argv[4], wafeStrings[22])) 
         localVar4 = GrabModeAsync;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 4,NULL, wafeStrings[27]));


     returnVar = XtGrabKeyboard(localVar1,localVar2,localVar3,localVar4,CurrentTime);

     if (returnVar == GrabSuccess) 
         staticResultString = "success";
     else if (returnVar == AlreadyGrabbed) 
         staticResultString = "alreadyGrabbed";
     else if (returnVar == GrabNotViewable) 
         staticResultString = "notViewable";
     else if (returnVar == GrabFrozen) 
         staticResultString = "frozen";
     else 
         staticResultString = "UNKNOWN";

     Tcl_SetResult(comInterpreter, staticResultString, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * (int) GrabReturns
 * XtGrabPointer
 * 	in: Widget			# widget
 * 	in: Boolean			# owner events
 *         const: NoEventMask
 * 	in: (int) SyncAsync		# pointer mode (sync | async)
 * 	in: (int) SyncAsync             # keyboard mode (sync | async)
 * 	in: None | XtWindow(Widget)	# None | confine widget
 * 	const: None
 * 	const: CurrentTime
 */

static int 
cmd_grabPointer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     int localVar3;
     int localVar4;
     Widget localVar5;
     int returnVar;
     char *staticResultString;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 6) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],5));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRBoolean));

     if (!strcmp(argv[3], wafeStrings[21])) 
         localVar3 = GrabModeSync;
     else
     if (!strcmp(argv[3], wafeStrings[22])) 
         localVar3 = GrabModeAsync;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 4,NULL, wafeStrings[27]));


     if (!strcmp(argv[4], wafeStrings[21])) 
         localVar4 = GrabModeSync;
     else
     if (!strcmp(argv[4], wafeStrings[22])) 
         localVar4 = GrabModeAsync;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 5,NULL, wafeStrings[27]));


     if (!strcmp(argv[5], wafeStrings[4])) 
         localVar5 = None;
     else
         if (!(localVar5 = (Widget) name2Widget(argv[5])))
         DBUG_RETURN(wafeConvError(argc, argv, 5, NULL, XtRWidget));

     returnVar = XtGrabPointer(localVar1,localVar2,NoEventMask,localVar3,localVar4,XtWindow(localVar5),None,CurrentTime);

     if (returnVar == GrabSuccess) 
         staticResultString = "success";
     else if (returnVar == AlreadyGrabbed) 
         staticResultString = "alreadyGrabbed";
     else if (returnVar == GrabNotViewable) 
         staticResultString = "notViewable";
     else if (returnVar == GrabFrozen) 
         staticResultString = "frozen";
     else 
         staticResultString = "UNKNOWN";

     Tcl_SetResult(comInterpreter, staticResultString, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtInstallAccelerators
 * 	in: Widget			# destination
 * 	in: Widget			# source
 */

static int 
cmd_installAccelerators(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     if (!(localVar2 = (Widget) name2Widget(argv[2])))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRWidget));

     XtInstallAccelerators(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtInstallAllAccelerators
 * 	in: Widget			# destination
 * 	in: Widget			# source
 */

static int 
cmd_installAllAccelerators(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     if (!(localVar2 = (Widget) name2Widget(argv[2])))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRWidget));

     XtInstallAllAccelerators(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * WidgetID (WidgetID)
 * name2WidgetId vulgo isWidget
 * 	in: String			# widget name
 */

static int 
cmd_isWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     returnVar = (WidgetID) name2WidgetId(argv[1]);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


#define WS_Layout wccs[1].name
/* 
 * void
 * XLowerWindow
 * 	in: XtDisplay(Widget{Display,Window})	# widget to be lowered
 * 	const: XtWindow(localVar1)
 */

static int 
cmd_lowerWindow(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");
     if (!(XtWindow(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must be realized");

     XLowerWindow(XtDisplay(localVar1),XtWindow(localVar1));

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtManageChildren vulgo manageChild
 *         in: [Widget{Parent}]	        # widgets
 * 	const: argc -1
 */

static int 
cmd_manageChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget * localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],1));

     {    Widget *ptr;
          char **origArgv = argv;
          argv += 1;
          localVar1 = ptr =
             (Widget *)XtMalloc((argc-1)*sizeof(Widget));

          while (*argv)
             {
             if (!(*ptr =  name2Widget(*argv)))
                 DBUG_RETURN(wafeConvError(argc, origArgv, 1, NULL, XtRWidget));
             if (!(XtParent(*ptr)))
                 wafeReturnTclError(argv[0],"Widget (arg 1) must have a parent");

          ptr ++; argv++;
          }
     }
     XtManageChildren(localVar1,argc -1);
     XtFree((char *)localVar1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtMapWidget
 * 	callmultiple
 * 		in: Widget{Display}	# widgets
 */

static int 
cmd_mapWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],1));

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 =  name2Widget(argv[count])))
             DBUG_RETURN(wafeConvError(argc, argv, count, NULL, XtRWidget));
         if (!(XtIsWidget(localVar1)))
             wafeReturnTclError(argv[0],"Widget (arg count) must have a display");

         XtMapWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void 
 * mergeResources
 *         in: Widget{Display}		# widget to determine database
 * 	in: [args avp] 			# resource-specification  value pairs
 */

static int 
cmd_mergeResources(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (wafeMergeArguments(argv[2],argv[0],&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN(wafeArgcError(argc+2, argv,"even number of attribute value pairs such as 2 or ",4));
        }

     mergeResources(localVar1,argc,argvArg);
     if (freeArgv) XtFree((char *)argvArg);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * WidgetID (WidgetID)
 * XtNameToWidget
 * 	in: Widget			# reference widget
 * 	in: String                      # partial widget name path
 */

static int 
cmd_nameToWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = (WidgetID) XtNameToWidget(localVar1,argv[2]);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


#define WS_OverrideShell wccs[2].name
/* 
 * WidgetID (WidgetID)
 * ParentWidget vulgo parent
 * 	in: Widget			# child widget
 */

static int 
cmd_parent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     returnVar = (WidgetID) ParentWidget(localVar1);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtPopdown
 *         in: ShellWidget			# shell widget
 */

static int 
cmd_popdown(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, wafeStrings[30]));

     XtPopdown(localVar1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtPopup
 *         in: ShellWidget			# widget
 *         in: XtGrabKind			# none | nonexclusive | exclusive
 */

static int 
cmd_popup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XtGrabKind localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, wafeStrings[30]));

     if (!strcmp(argv[2], wafeStrings[24])) 
         localVar2 = XtGrabNone;
     else
     if (!strcmp(argv[2], wafeStrings[25])) 
         localVar2 = XtGrabNonexclusive;
     else
     if (!strcmp(argv[2], wafeStrings[23])) 
         localVar2 = XtGrabExclusive;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 2,NULL, "XtGrabKind"));


     XtPopup(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * (String) DString
 * popupChildren
 * 	in: Widget
 */

static int 
cmd_popupChildren(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     returnVar = popupChildren(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtPopupSpringLoaded
 *         in: ShellWidget			# shell widget
 */

static int 
cmd_popupSpringLoaded(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, wafeStrings[30]));

     XtPopupSpringLoaded(localVar1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * processPendingEvents
 */

static int 
cmd_processPendingEvents(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 1) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],0));

     processPendingEvents();

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XRaiseWindow
 * 	in: XtDisplay(Widget{Display,Window})	# widget to be raised
 * 	const: XtWindow(localVar1)
 */

static int 
cmd_raiseWindow(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");
     if (!(XtWindow(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must be realized");

     XRaiseWindow(XtDisplay(localVar1),XtWindow(localVar1));

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * realizeWidgets vulgo realize
 */

static int 
cmd_realize(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 1) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],0));

     realizeWidgets();

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtRealizeWidget
 * 	callmultiple
 * 		in: Widget		# widgets
 */

static int 
cmd_realizeWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],1));

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
             DBUG_RETURN(wafeConvError(argc, argv, count, NULL, XtRWidget));

         XtRealizeWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtRemoveAllCallbacks
 * 	in: Widget			# widget
 * 	in: String			# callback name
 */

static int 
cmd_removeAllCallbacks(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     XtRemoveAllCallbacks(localVar1,argv[2]);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void 
 * XtRemoveTimeOut 
 * 	in: XtIntervalId		# interval ID
 */

static int 
cmd_removeTimeOut(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     XtIntervalId localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(sscanf(argv[1], wafeStrings[10], &localVar1)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, "XtIntervalId"));

     XtRemoveTimeOut(localVar1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * (String) DString
 * XtResolvePathname
 *         in: XtDisplay(Widget{Display})  # widget to determine display
 * 	in: NULL | String               # type
 * 	in: NULL | String               # filename
 * 	in: NULL | String               # suffix
 * 	in: NULL | String               # path
 * 	const: NULL                     # substitutions
 * 	const: 0                        # number of Substitutions
 * 	const: NULL                     # XtFilePredicate
 */

static int 
cmd_resolvePathname(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;
     String localVar3;
     String localVar4;
     String localVar5;
     String returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 6) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],5));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

     if (!strcmp(argv[2], wafeStrings[3])) 
         localVar2 = NULL;
     else
         localVar2 = argv[2];
     if (!strcmp(argv[3], wafeStrings[3])) 
         localVar3 = NULL;
     else
         localVar3 = argv[3];
     if (!strcmp(argv[4], wafeStrings[3])) 
         localVar4 = NULL;
     else
         localVar4 = argv[4];
     if (!strcmp(argv[5], wafeStrings[3])) 
         localVar5 = NULL;
     else
         localVar5 = argv[5];
     returnVar = XtResolvePathname(XtDisplay(localVar1),localVar2,localVar3,localVar4,localVar5,NULL,0,NULL);

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtSetKeyboardFocus
 * 	in: Widget			# from widget tree
 * 	in: None|Widget			# to widget | None
 */

static int 
cmd_setKeyboardFocus(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     if (!strcmp(argv[2], wafeStrings[4])) 
         localVar2 = None;
     else
         if (!(localVar2 = (Widget) name2Widget(argv[2])))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRWidget));

     XtSetKeyboardFocus(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtSetSensitive 
 * 	in: Widget			# widget 
 * 	in: Boolean			# sensitive true | false
 */

static int 
cmd_setSensitive(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRBoolean));

     XtSetSensitive(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * setValues
 * 	in: Widget			# widget
 * 	in: [args avp]			# attribute value pairs
 */

static int 
cmd_setValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean freeArgv = False;
     char **argvArg;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     argc -= 2;
     argvArg = &argv[2];
     if (argc == 1)
        {
        if (wafeMergeArguments(argv[2],argv[0],&argc,&argvArg))
           freeArgv = True;
        else 
           DBUG_RETURN (TCL_ERROR);
        }
     if (argc%2)
        {
        if (freeArgv) XtFree((char*)argvArg);
        DBUG_RETURN(wafeArgcError(argc+2, argv,"even number of attribute value pairs such as 2 or ",4));
        }

     setValues(localVar1,argc,argvArg);
     if (freeArgv) XtFree((char *)argvArg);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * Boolean 
 * XSetWMProtocols
 * 	const: XtDisplay(localVar1)
 *         in: XtWindow(ShellWidget{Window})       # Shell Widget
 * 	in: ADDRESS_OF((Atom)WM_PROTOCOLS)	# WM_TAKE_FOCUS | WM_SAVE_YOURSELF | WM_DELETE_WINDOW
 * 	const: 1
 */

static int 
cmd_setWMProtocols(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Atom localVar2;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, wafeStrings[30]));
     if (!(XtWindow(localVar1)))
         wafeReturnTclError(argv[0],"ShellWidget (arg 1) must be realized");

     if (!strcmp(argv[2], "WM_TAKE_FOCUS")) 
         localVar2 = XInternAtom(XtDisplay(localVar1),"WM_TAKE_FOCUS",False);
     else
     if (!strcmp(argv[2], "WM_SAVE_YOURSELF")) 
         localVar2 = XInternAtom(XtDisplay(localVar1),"WM_SAVE_YOURSELF",False);
     else
     if (!strcmp(argv[2], "WM_DELETE_WINDOW")) 
         localVar2 = XInternAtom(XtDisplay(localVar1),"WM_DELETE_WINDOW",False);
     else
         DBUG_RETURN(wafeConvError(argc,argv, 3,NULL, "WM_PROTOCOLS"));


     returnVar = XSetWMProtocols(XtDisplay(localVar1),XtWindow(localVar1),ADDRESS_OF(localVar2),1);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XSync
 *         in: XtDisplay(Widget{Display})	# Widget to determine display
 * 	in: Boolean			# Discard (Boolean)
 */

static int 
cmd_sync(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRBoolean));

     XSync(XtDisplay(localVar1),localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * int
 * textWidth
 * 	pre: {XFontStruct *font; XtVaGetValues(localVar1, argv[2], &font, NULL);
 * 	in: Widget			# Widget
 * 	in: String			# fontResource
 * 	in: String			# String
 *         post: }
 */

static int 
cmd_textWidth(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     {XFontStruct *font; XtVaGetValues(localVar1, argv[2], &font, NULL);
     returnVar = textWidth(localVar1,argv[2],argv[3]);
     }

     sprintf(conversionBuffer, wafeStrings[7], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


#define WS_TopLevelShell wccs[3].name
#define WS_TransientShell wccs[4].name
/* 
 * void
 * XtTranslateCoords
 * 	in: Widget			# widget
 * 	in: Position    		# x coordinate in widget
 * 	in: Position    		# y coordinate in widget
 * 	out: Position   		# variable name for root window x
 * 	out: Position   		# variable name for root window y
 */

static int 
cmd_translateCoords(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;
     Position localVar4;
     Position localVar5;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 6) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],5));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     if (!(sscanf(argv[2], wafeStrings[8], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRPosition));

     if (!(sscanf(argv[3], wafeStrings[8], &localVar3)))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, XtRPosition));

     XtTranslateCoords(localVar1,localVar2,localVar3,&localVar4,&localVar5);

     sprintf(conversionBuffer, wafeStrings[8], localVar4);

     Tcl_SetVar(wafeInterpreter,argv[4],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[8], localVar5);

     Tcl_SetVar(wafeInterpreter,argv[5],conversionBuffer,0);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtUngrabPointer
 * 	in: Widget			# widget with active pointer grab
 * 	const: CurrentTime
 */

static int 
cmd_ungrabPointer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     XtUngrabPointer(localVar1,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtUngrabKeyboard
 * 	in: Widget			# widget with active keyboard grab
 * 	const: CurrentTime
 */

static int 
cmd_ungrabKeyboard(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     XtUngrabKeyboard(localVar1,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtUnmanageChildren vulgo unmanageChild
 *         in: [Widget{Parent}]		# widgets
 * 	const: argc -1
 */

static int 
cmd_unmanageChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget * localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],1));

     {    Widget *ptr;
          char **origArgv = argv;
          argv += 1;
          localVar1 = ptr =
             (Widget *)XtMalloc((argc-1)*sizeof(Widget));

          while (*argv)
             {
             if (!(*ptr =  name2Widget(*argv)))
                 DBUG_RETURN(wafeConvError(argc, origArgv, 1, NULL, XtRWidget));
             if (!(XtParent(*ptr)))
                 wafeReturnTclError(argv[0],"Widget (arg 1) must have a parent");

          ptr ++; argv++;
          }
     }
     XtUnmanageChildren(localVar1,argc -1);
     XtFree((char *)localVar1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtUnmapWidget
 * 	callmultiple
 * 		in: Widget{Display}	# widgets
 */

static int 
cmd_unmapWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],1));

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 =  name2Widget(argv[count])))
             DBUG_RETURN(wafeConvError(argc, argv, count, NULL, XtRWidget));
         if (!(XtIsWidget(localVar1)))
             wafeReturnTclError(argv[0],"Widget (arg count) must have a display");

         XtUnmapWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtUnrealizeWidget
 * 	callmultiple
 * 		in: Widget		# widgets
 */

static int 
cmd_unrealizeWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int count;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],1));

     for (count = 1; count < argc; count++)
          {
         if (!(localVar1 = (Widget) name2Widget(argv[count])))
             DBUG_RETURN(wafeConvError(argc, argv, count, NULL, XtRWidget));

         XtUnrealizeWidget(localVar1);
          }

     DBUG_RETURN (TCL_OK);
     }


/* 
 * String
 * waitForVariable
 * 	in: String			# variable name
 */

static int 
cmd_waitForVariable(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     String returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     returnVar = waitForVariable(argv[1]);

     Tcl_SetResult(comInterpreter, returnVar, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * Widget
 * name2WidgetId vulgo widgetName
 * 	in: String			# widget reference
 */

static int 
cmd_widgetName(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     returnVar = name2WidgetId(argv[1]);

     Tcl_SetResult(comInterpreter, wafeWidgetToName(returnVar), TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * long (long)
 * XtWindow
 *         in: Widget     			# widget whose window you want
 */

static int 
cmd_window(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     long returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     returnVar = (long) XtWindow(localVar1);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtDisownSelection
 *         in: Widget{Window}         # widget making the request
 * 	const: XA_PRIMARY
 * 	const: CurrentTime
 */

static int 
cmd_disownSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtWindow(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must be realized");

     XtDisownSelection(localVar1,XA_PRIMARY,CurrentTime);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XtGetSelectionValue
 * 	in: Widget{Window}              # widget making the request
 * 	const: XA_PRIMARY
 * 	const: XA_STRING
 * 	const: wafeGetSelectionValueProc
 * 	in: XtNewString(String)		# Tcl command
 * 	const: CurrentTime
 */

static int 
cmd_getSelectionValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtWindow(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must be realized");

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     XtGetSelectionValue(localVar1,XA_PRIMARY,XA_STRING,wafeGetSelectionValueProc,XtNewString(argv[2]),CurrentTime);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * Boolean
 * wafeOwnSelectionCmd vulgo ownSelection
 *         in: Widget{Window}      # widget that whiches to become owner of the selection
 * 	in: XtNewString(String) # string to be put into selection
 * 	in: NULL | String 	# NULL | loseSelection TCL-command
 * 	in: NULL | String 	# NULL | doneSelection TCL-command
 */

static int 
cmd_ownSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar3;
     String localVar4;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtWindow(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must be realized");

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     if (!strcmp(argv[3], wafeStrings[3])) 
         localVar3 = NULL;
     else
         localVar3 = argv[3];
     if (!strcmp(argv[4], wafeStrings[3])) 
         localVar4 = NULL;
     else
         localVar4 = argv[4];
     returnVar = wafeOwnSelectionCmd(localVar1,XtNewString(argv[2]),localVar3,localVar4);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * (String) DString
 * XFetchBuffer
 *         in: XtDisplay(Widget{Display})		# widget to determine display
 * 	const: &nbytes
 * 	in: int				# buffer number (1-7)
 * 	pre: {int nbytes;
 * 	post: }
 */

static int 
cmd_fetchBuffer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     String returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

     {int nbytes;
     returnVar = XFetchBuffer(XtDisplay(localVar1),&nbytes,localVar2);
     }

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * (String) DString
 * XFetchBytes
 * 	pre: { int bytes; XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, XA_STRING, XA_CUT_BUFFER0, DefaultRootWindow(XtDisplay(localVar1)), CurrentTime); 
 *         in: XtDisplay(Widget{Display}) 		# widget to determine display
 *         const:  &bytes
 * 	post: }
 */

static int 
cmd_fetchBytes(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

     { int bytes; XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, XA_STRING, XA_CUT_BUFFER0, DefaultRootWindow(XtDisplay(localVar1)), CurrentTime);
     returnVar = XFetchBytes(XtDisplay(localVar1),&bytes);
     }

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XConvertSelection
 * 	in: XtDisplay(Widget{Display})	# widget to determine display
 * 	const: XA_PRIMARY
 * 	const: XA_STRING
 * 	in: Atom			# target buffer number (0 to 6)
 * 	const: DefaultRootWindow(XtDisplay(wafeTopLevel))
 * 	const: CurrentTime
 */

static int 
cmd_convertSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Atom localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

     if (!strcmp(argv[2], wafeStrings[0])) 
         localVar2 = XA_CUT_BUFFER0;
     else
     if (!strcmp(argv[2], wafeStrings[1])) 
         localVar2 = XA_CUT_BUFFER1;
     else
     if (!strcmp(argv[2], "2")) 
         localVar2 = XA_CUT_BUFFER2;
     else
     if (!strcmp(argv[2], "3")) 
         localVar2 = XA_CUT_BUFFER3;
     else
     if (!strcmp(argv[2], "4")) 
         localVar2 = XA_CUT_BUFFER4;
     else
     if (!strcmp(argv[2], "5")) 
         localVar2 = XA_CUT_BUFFER5;
     else
     if (!strcmp(argv[2], "6")) 
         localVar2 = XA_CUT_BUFFER6;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 4,NULL, XtRAtom));


     XConvertSelection(XtDisplay(localVar1),XA_PRIMARY,XA_STRING,localVar2,DefaultRootWindow(XtDisplay(wafeTopLevel)),CurrentTime);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XStoreBuffer
 * 	in: XtDisplay(Widget{Display})	# widget to determine display
 * 	in: String			# String
 * 	const: strlen(argv[2])
 * 	in: int				# buffer number (1-7)
 */

static int 
cmd_storeBuffer(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar3;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, wafeStrings[14]));

     XStoreBuffer(XtDisplay(localVar1),argv[2],strlen(argv[2]),localVar3);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * hint: R6
 * WidgetID (WidgetID)
 * XtHooksOfDisplay
 * 	in: XtDisplay(Widget{Display})	# widget to determine display
 *         post: wafeCurrentAttribList=wafeMMgetAttribList((Widget)returnVar,True); wafeMMsetAttribList((Widget)returnVar); wafeCurrentAttribList = NULL;
 */
#ifndef PRER6

static int 
cmd_hooksOfDisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

     returnVar = (WidgetID) XtHooksOfDisplay(XtDisplay(localVar1));
     wafeCurrentAttribList=wafeMMgetAttribList((Widget)returnVar,True); wafeMMsetAttribList((Widget)returnVar); wafeCurrentAttribList = NULL;

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }

#endif

/* 
 * MapState
 * mapState
 *         in: Widget{Display}                     # any widget
 */

static int 
cmd_mapState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     MapState returnVar;
     char *staticResultString;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

     returnVar = mapState(localVar1);

     if (returnVar == 0) 
         staticResultString = "IsUnmapped";
     else if (returnVar == 1) 
         staticResultString = "IsUnviewable";
     else if (returnVar == 2) 
         staticResultString = "IsViewable";
     else 
         staticResultString = "UNKNOWN";

     Tcl_SetResult(comInterpreter, staticResultString, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * XtWorkProcId
 * XtAppAddWorkProc
 * 	const: wafeAppContext 
 * 	const: workProc
 * 	in: XtNewString(String)		# Tcl command
 */

static int 
cmd_addWorkProc(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     XtWorkProcId returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     returnVar = XtAppAddWorkProc(wafeAppContext,workProc,XtNewString(argv[1]));

     sprintf(conversionBuffer, wafeStrings[10], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void 
 * XtRemoveWorkProc 
 * 	in: XtWorkProcId		# work proc ID
 */

static int 
cmd_removeWorkProc(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     XtWorkProcId localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(sscanf(argv[1], wafeStrings[10], &localVar1)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, "XtWorkProcId"));

     XtRemoveWorkProc(localVar1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * Boolean
 * XtIsShell
 * 	in: Widget			# widget
 */

static int 
cmd_isShell(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     returnVar = XtIsShell(localVar1);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * hint: R5
 * String (TCL_RETURN_CODE)
 * getActionList
 * 	in: XtClass(Widget)		# widget
 */
#ifndef PRER5

static int 
cmd_getActionList(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     returnVar = (TCL_RETURN_CODE) getActionList(XtClass(localVar1));

     DBUG_RETURN (returnVar);
     }

#endif

/* 
 * (String) DString
 * wafeGetAtomName vulgo atomName
 * 	in: XtDisplay(Widget{Display})	# widget to determine display
 * 	in: name2AtomLV1chk(String)	# atom
 */

static int 
cmd_atomName(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = wafeGetAtomName(XtDisplay(localVar1),name2AtomLV1chk(argv[2]));

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * AtomID
 * wafeStringToAtom vulgo atomId
 * 	in: Widget			# widget to determine display
 * 	in: String			# atom
 */

static int 
cmd_atomId(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     AtomID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = wafeStringToAtom(localVar1,argv[2]);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * AtomID
 * wafeStringToAtomChk vulgo isAtom
 * 	in: Widget			# widget to determine display
 * 	in: String			# atom
 */

static int 
cmd_isAtom(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     AtomID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = wafeStringToAtomChk(localVar1,argv[2]);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * Boolean
 * wafeMWMrunning vulgo motifWMRunning
 *        in: ShellWidget                 	# any shell widget
 */

static int 
cmd_motifWMRunning(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],shellWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, wafeStrings[30]));

     returnVar = wafeMWMrunning(localVar1);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XReparentWindow
 *        const: XtDisplay(localVar1)
 *        in: XtWindow(Widget{Display,Window})  # widget to reparent
 *        in: XtWindow(Widget{Window})          # new parent
 *        in: int                          # x coordinate
 *        in: int                          # y coordinate
 */

static int 
cmd_reparentWindow(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");
     if (!(XtWindow(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must be realized");

     if (!(localVar2 =  name2Widget(argv[2])))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRWidget));
     if (!(XtWindow(localVar2)))
         wafeReturnTclError(argv[0],"Widget (arg 2) must be realized");

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, wafeStrings[14]));

     if (!(sscanf(argv[4], wafeStrings[7], &localVar4)))
         DBUG_RETURN(wafeConvError(argc, argv, 4, NULL, wafeStrings[14]));

     XReparentWindow(XtDisplay(localVar1),XtWindow(localVar1),XtWindow(localVar2),localVar3,localVar4);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * Boolean
 * XtIsManaged
 * 	in: Widget			# Widget
 */

static int 
cmd_isManaged(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     returnVar = XtIsManaged(localVar1);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * (String) DString
 * wafeGetDomain vulgo getDomain
 * 	in: String	# resource type
 */

static int 
cmd_getDomain(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     String returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     returnVar = wafeGetDomain(argv[1]);

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * TCL_RETURN_CODE
 * screen
 *        in: String			# sub command
 *        in: Widget{Display}		# widget to determine display

 */

static int 
cmd_screen(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar2;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     if (!(localVar2 =  name2Widget(argv[2])))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRWidget));
     if (!(XtIsWidget(localVar2)))
         wafeReturnTclError(argv[0],"Widget (arg 2) must have a display");

     returnVar = screen(argv[1],localVar2);

     DBUG_RETURN (returnVar);
     }



void
wafeInitialize_XT()
{
 wccs[0].wClass = applicationShellWidgetClass; /* not a C constant! */
#ifdef LAYOUT
 wccs[1].wClass = layoutWidgetClass; /* not a C constant! */
#endif
 wccs[2].wClass = overrideShellWidgetClass; /* not a C constant! */
 wccs[3].wClass = topLevelShellWidgetClass; /* not a C constant! */
 wccs[4].wClass = transientShellWidgetClass; /* not a C constant! */
 qLong = WafePermStringToQuark("Long");
 qDouble = WafePermStringToQuark("Double");
 qchildren = WafePermStringToQuark(XtNchildren);
 qBoolean = WafePermStringToQuark(XtRBoolean);
 qCardinal = WafePermStringToQuark(XtRCardinal);
 qDimension = WafePermStringToQuark(XtRDimension);
 qFloat = WafePermStringToQuark(XtRFloat);
 qInt = WafePermStringToQuark(XtRInt);
 qPixel = WafePermStringToQuark(XtRPixel);
 qPosition = WafePermStringToQuark(XtRPosition);
 qWidget = WafePermStringToQuark(XtRWidget);
 qWidgetList = WafePermStringToQuark(XtRWidgetList);
 qString = WafePermStringToQuark(XtRString);
 qCallback = WafePermStringToQuark(XtRCallback);
 qPointer = WafePermStringToQuark(XtRPointer);
 qcallback = WafePermStringToQuark(XtNcallback);
 XtSetTypeConverter(XtRString, XtRWidget,
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XtRCallback,
	(XtTypeConverter)CvtStringToCallback, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XtRWidgetList,
	(XtTypeConverter)CvtStringToWidgetList, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, XtRPointer,
	(XtTypeConverter)CvtStringToPointer, 
	pointerConvertArgs, XtNumber(pointerConvertArgs), XtCacheNone, NULL);
 wafeAddNsConv(qchildren,XtNnumChildren,NULL,NULL,sizeof(WidgetList),
	wafeCvtWidgetListToList,XtFree, 
	(pointerProc)NULL,NULL);

 int_args[0].address_id= (XtPointer)
   wafeAddRConv(XtRInitialState,sizeof(int),
		int_strings, (XtPointer)int_values);
 XtSetTypeConverter(XtRInitialState,XtRString,wafeCvtRToString,
		    int_args,XtNumber(int_args),
                    XtCacheNone,NULL);
#ifndef PRER5
 XtSetTypeConverter(XtRString, XtRCardinal,
	(XtTypeConverter)XtCvtStringToInt, 
	NULL, 0, XtCacheNone, NULL);
#endif
 XtSetTypeConverter(XtRString, XtRPixel,
	(XtTypeConverter)CvtStringToPixel, 
	wafeColorConvertArgs, XtNumber(wafeColorConvertArgs), XtCacheByDisplay, FreePixel);
 wafeCreateTclCmds(pkgs,wccs,cmds);
}
