/* das ist ein -*- C -*- Programm */
#include "wafe_quarks.h"

#ifdef MOTIF
# include <Xm/Xm.h>
# include <Xm/Text.h>
# ifdef MOTIF20
#  include <Xm/RepType.h>
# endif
#endif

#ifdef RDD
extern Boolean rddDeliverMessageEvent(
#if NeedFunctionPrototypes
    XEvent
#endif
);
#endif

extern Boolean wafeOwnSelectionCmd(
#if NeedFunctionPrototypes
     Widget, String, String, String
#endif
);

extern void callback (
#if NeedFunctionPrototypes
     Widget, char *, XtCallbackProc, char *
#endif
);

extern Cardinal wafeGetResourcesOfClass(
#if NeedFunctionPrototypes
     WidgetClass, QTypeList *
#endif
);

extern Cardinal wafeGetConstraintsOfClass(
#if NeedFunctionPrototypes
     WidgetClass, QTypeList *
#endif
);

extern int wafeCallbackCmd(
#if NeedFunctionPrototypes
     int, char**, Widget, XtCallbackProc
#endif
);

#ifdef ATHENA
#include <X11/Xaw/Text.h>
#include <X11/Xaw/AsciiText.h>
#endif


static XtConvertArgRec pointerConvertArgs[] = {
    {XtWidgetBaseOffset, (XtPointer)0, sizeof(Widget)}
};

/***** BEGIN for color converter  */
#include <X11/IntrinsicP.h>

static XtConvertArgRec wafeColorConvertArgs[] = {
    {XtWidgetBaseOffset, (XtPointer)XtOffsetOf(WidgetRec, core.screen),
     sizeof(Screen *)},
    {XtWidgetBaseOffset, (XtPointer)XtOffsetOf(WidgetRec, core.colormap),
     sizeof(Colormap)}
};

static void FreePixel(app, toVal, closure, args, num_args)
    XtAppContext app;
    XrmValuePtr	toVal;
    XtPointer	closure;
    XrmValuePtr	args;
    Cardinal	*num_args;
{
    Screen	    *screen;
    Colormap	    colormap;

    if (*num_args != 2) {
     XtAppWarningMsg(app, "wrongParameters","freePixel","XtToolkitError",
	"Freeing a pixel requires screen and colormap arguments",
        (String *)NULL, (Cardinal *)NULL);
     return;
    }

    screen = *((Screen **) args[0].addr);
    colormap = *((Colormap *) args[1].addr);

    if (closure) {
	XFreeColors( DisplayOfScreen(screen), colormap,
		     (unsigned long*)toVal->addr, 1, (unsigned long)0
		    );
    }
}
/***** END for color converter  */



static void
action(w, TranslationModifier, translationTable)
Widget	w;
int	TranslationModifier;
XtTranslations translationTable;
    {
    switch (TranslationModifier) 
        {
	case 1: XtOverrideTranslations(w, translationTable);
		break;
	case 2: XtAugmentTranslations(w, translationTable);
		break;
	case 3: XtVaSetValues (w, XtNtranslations, translationTable, NULL);
		break;
        }
    }


static void
realizeWidgets()
    {
    WidgetListPtr ptr = wafeWidgetTrees;
    while(ptr) 
	{
	XtRealizeWidget(ptr->widget);
	ptr = ptr->next;
	}
#ifdef MOTIF12
# ifdef DROPSITEUPDATE
    if (wafeDropsiteUpdate)
	{
	XmDropSiteEndUpdate(wafeTopLevel);
	wafeDropsiteUpdate = False;
	}
# endif
#endif    
    }

static void
callCallbacks(w, callback, argc,argv)
Widget   w;
String   callback;
int      argc;
char   **argv;
    {
    if (argc == 0) 
	{
#ifdef MOTIF
	XmAnyCallbackStruct callData;
	callData.reason = XmCR_NONE;
	callData.event  = wafeCurrentEvent;
	XtCallCallbacks(w, callback, (XtPointer)&callData);
#else
	XtCallCallbacks(w, callback, NULL);
#endif
	}
    else
    if (!strcmp(argv[0], "float"))
	{
	float f;
	sscanf(argv[1], "%f", &f);
	XtCallCallbacks(w, callback, (XtPointer)&f);
	}
    else
	wafeWarn("callCallbacks","Wrong type: %s", argv[1], NULL,NULL);
    }


static void
callActionProc(w, eventType, action, argc, argv)
Widget         w;
String         eventType;
String         action;
int            argc;
char         **argv;
    {
    char          *token;
    XEvent         event;
    Display       *display = XtDisplay(wafeTopLevel);
    Window         win = XtWindow(w), root, child;
    int            x, y, xR, yR;
    unsigned int   state, button, keycode;
    static _Xconst String procName = "callActionProc";

    if (!strcmp(eventType, wafe_EMPTY))
	{
	event.type = 0;
	event.xany.display = display;
	event.xany.window = win;
	}
    else
	{
	token = strtok(eventType, wafe_SPACE);
	if (strcmp(token, "type"))
	    {
	    wafeWarn(procName,"Missing type; aborting command",
		      NULL,NULL,NULL);
	    return;
	    }

	XQueryPointer(display, win, &root, &child, &xR, &yR, &x, &y, &state);

	token = strtok(NULL, wafe_SPACE);
	if (!strcmp(token, "buttonEvent"))
	    {
	    token = strtok(NULL, wafe_SPACE);
	    if (!strcmp(token, "button"))
		{
		token = strtok(NULL, wafe_SPACE);
		if (!strcmp(token, "button1"))
		    button = Button1;
		else
                if (!strcmp(token, "button2"))
		    button = Button2;
                else
                if (!strcmp(token, "button3"))
		    button = Button3;
		else
                if (!strcmp(token, "button4"))
		    button = Button4;
		else
                if (!strcmp(token, "button5"))
		    button = Button5;
		else
		    {
		    wafeWarn(procName,"Unknown Button, %s", 
			     token,NULL,NULL);
		    return;
		    }
		}
	    else
		{
		wafeWarn(procName,
			 "This event field (%s) can't be specified\n", 
			 token,NULL,NULL);
		return;
		}

	    event.type = ButtonPress;
	    event.xbutton.display = display;
	    event.xbutton.window = win;
	    event.xbutton.root = root;
	    event.xbutton.subwindow = child;
	    event.xbutton.x = x;
	    event.xbutton.y = y;
	    event.xbutton.x_root = xR;
	    event.xbutton.y_root = yR;
	    event.xbutton.state = state;
	    event.xbutton.button = button;
	    }
	else if(!strcmp(token, "keyEvent"))
	    {
	    token = strtok(NULL, wafe_SPACE);
	    if (!strcmp(token, "key"))
		{                   
		token = strtok(NULL, wafe_SPACE);
		keycode = XKeysymToKeycode(display, XStringToKeysym(token));
		}
	    else
		{
		wafeWarn(procName,
			 "This event field (%s) can't be specified", 
			 token,NULL,NULL);
		return;
		}

	    event.type = KeyPress;
	    event.xkey.display = display;
	    event.xkey.window = win;
	    event.xkey.root = root;
	    event.xkey.subwindow = child;
	    event.xkey.x = x;
	    event.xkey.y = y;
	    event.xkey.x_root = xR;
	    event.xkey.y_root = yR;
	    event.xkey.state = state;
	    event.xkey.keycode = keycode;
	    }
	else
	    {
	    wafeWarn(procName,
		     "This event field (%s) can't be specified", 
		     token,NULL,NULL);
	    return;
	    }                    
	}

    XtCallActionProc(w, action, &event, argv, argc);
    return;
    }

/* used by addTimeOut */
static void
timerProc(command, junk)
XtPointer        command;
XtIntervalId     *junk;
    {
    DBUG_ENTER("timerProc");
    WAFE_UNUSED(junk);
    (void) wafeEval(wafeInterpreter, (char *)command, "timerProc");
    XtFree((char *)command);
    DBUG_VOID_RETURN;
    }

/* used by addTimeOut */
static Boolean
workProc(command)
XtPointer command;
    {
    char *r;
    int  rc;

    DBUG_ENTER("workProc");
    rc = wafeEval(wafeInterpreter, (char *)command, "workProc");
    r = wafeInterpreter->result;
    if ( rc || ( r && *r++ == '1' && *r == '\0' ) ) /* don't do it again */
	{
	XtFree((char *)command);
	DBUG_RETURN(True);
	}
    DBUG_RETURN(False);
    }


static char *
cvtToString(w,clientData, typeName)
Widget     w;
XtPointer  clientData;
String     typeName;
    {
    XrmValue   input,output;
    
    DBUG_PRINT("conv", ("Converting '%s' to String", typeName));

    input.addr  = clientData;        
    input.size  = sizeof(XtPointer);  /* ??? */
    output.addr = NULL;

    IFCONVERTANDSTORE(w, typeName,input, XtRString, output)
	return output.addr;
    else
	return NULL;
    }



static String
getValue(w, Qname, freeProcPtr)
Widget      w;
XrmQuark    Qname;
freeProc   *freeProcPtr;
    {
    String       result;
    XrmQuark     Qtype;
    WidgetClass  wClass  = XtClass(w);
    static _Xconst String procName = "getValue";
    String       resName = XrmQuarkToString(Qname);
    String       typeName;
#ifdef MOTIF20
    XmRepTypeId rip;
#endif 


    DBUG_PRINT(procName, ("widget is %p resource is <%s>", w, resName)); 

    if (!(Qtype = wafeGetQTypeOfAttribute(wClass,ParentWidget(w),Qname,NULL)))
	{
	wafeWarn(procName,"Unknown Attribute %s", resName,NULL,NULL);
	*freeProcPtr = TCL_STATIC;
	return NULL;
	}

    if (Qtype == qString)
	{
	String valueString;
	*freeProcPtr = TCL_VOLATILE;
	XtVaGetValues(w, resName, &valueString, NULL);
	return valueString;
	}

    /* this is the Default value for the following types 
     * assuming that dense code is better than one instruction more
     */ 
    *freeProcPtr = XtFree;

#ifdef MOTIF
    if (Qtype == qXmString) 
	{
	XmString value;
	String returnString;
	wafeStringStruct   ws_struct;
	wafeString         ws = &ws_struct;
	wafeStringInit(ws);
	XtVaGetValues(w, resName, &value, NULL);
	wafeCvtXmString2String(ws,value,True);
	returnString = XtNewString(wafeStringValue(ws));
	wafeStringClear(ws);
	XmStringFree(value);
	return returnString;
	}
#endif /* MOTIF */
	
    if (Qtype == qInt
#ifdef MOTIF
	|| Qtype == qVerticalInt
	|| Qtype == qHorizontalInt
#endif /* MOTIF */
	)
	{
	int valueInt;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valueInt, NULL);
	sprintf(result, "%d", (int)valueInt);
	return result;
	}

    if (Qtype == qPosition
#ifdef MOTIF
	|| Qtype == qVerticalPosition
	|| Qtype == qHorizontalPosition
	|| Qtype == qShort
#endif /* MOTIF */
       )
	{
	Position valuePosition;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valuePosition, NULL);
	sprintf(result, "%hd", valuePosition);
	return result;
        }

    if (Qtype == qLong
#ifdef MOTIF
	|| Qtype == qTextPosition
#endif
	) 
	{
	long value;
	result = XtMalloc(LONG_AS_STRING);
	XtVaGetValues(w, resName, &value, NULL);
	sprintf(result, "%ld", value);
	return result;
        }


    if (Qtype == qDimension
#ifdef MOTIF
	|| Qtype == qVerticalDimension
	|| Qtype == qHorizontalDimension
	|| Qtype == qShellHorizDim
	|| Qtype == qShellVertDim
#endif
	) 
	{
	Dimension valueDimension;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valueDimension, NULL);
	sprintf(result, "%hu", valueDimension);
	return result;
        }

    if (Qtype == qCardinal)
	{
	Cardinal valueCardinal;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, resName, &valueCardinal, NULL);
	sprintf(result, "%u", valueCardinal);	
	return result;
	}

    if (Qtype == qBoolean)
	{
	Boolean valueBoolean;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, resName, &valueBoolean, NULL);
	return wafeStrings[(int)valueBoolean];
	}

#ifdef MOTIF20
    if (Qtype == qSet) 
	{
	unsigned char valueSet;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, resName, &valueSet, NULL);
	switch (valueSet) 
	    {
	case XmUNSET:         return wafe_ZERO;
	case XmSET:           return wafe_ONE;
	case XmINDETERMINATE: return "indeterminate";
	    }
        }
#endif

    if (Qtype == qFloat) 
	{
	float valueFloat;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, resName, &valueFloat, NULL);
	sprintf(result, "%f", valueFloat);
	return result;
	}

    if (Qtype == qDouble) 
	{
	double valueDouble;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, resName, &valueDouble, NULL);
	sprintf(result, "%f", valueDouble);
	return result;
	}

    if (Qtype == qPixel) 
	{
	XColor  c;
	Display *dpy = XtDisplay(w);
	result = XtMalloc(8); /* "#RRGGBB" */
	XtVaGetValues(w, resName, &(c.pixel), NULL);
	XQueryColor(dpy,DefaultColormap(dpy, DefaultScreen(dpy)),&c);
	sprintf(result, "#%02X%02X%02X", 
		(int)(c.red>>8), (int)(c.green>>8), (int)(c.blue>>8));
	return result;
	}

     /* Callbacks sind ... anders: die String-Information 
	kommt aus wafe's privatem Memory-Management und nicht 
	ber getValues!
      */
    if (Qtype == qCallback) 
	{
	MMattribListPtr ptr = *wafeMMgetAttribList(w,True);
	
	*freeProcPtr = TCL_STATIC;
	result = NULL;
	/* try to get callback through memory management */
	while(ptr) 
	    {
	    if (ptr->attribute == Qname) 
		{
		result = ((char*)ptr->value) +
		    sizeof(XtCallbackList)*2 +
		    sizeof(XtCallbackRec[2]) +
		    sizeof(XrmQuark);
		break;
		}
	    ptr = ptr->next;
	    }
	/* try to get callback from callback list */
	if (!result) 
	    {
	    XtCallbackList cbl;
	    XtVaGetValues(w, resName, &cbl, NULL);
	    for (; cbl->callback; cbl++)
		{
		if ( cbl->callback == wafeExecCallbackProc ) 
		    {
		    result = ((char*)cbl->closure) + sizeof(XrmQuark);
		    break;
		    }
		}
	    }
	if (!result) 
	    result = wafe_EMPTY;
	return result;
	}

    if (Qtype == qWidget
#ifdef MOTIF
	|| Qtype == qWindow
	|| Qtype == qMenuWidget
#endif
	)
	{
	Widget valueWidget;
	result = XtMalloc(LONG_AS_STRING);
	XtVaGetValues(w, resName, &valueWidget, NULL);
	sprintf(result, "%ld", (long)valueWidget);
	return result;
	}

    /* try to convert using registered name specific conversion routines
       (from .spec file)

       This must be before qPointer, since Xaw registers list 
       converter for type pointer
     */

    if ((result = wafeCvtNsToString(w,Qname,freeProcPtr)))
	return result;


    if (Qtype == qPointer) 
	{
	XtPointer p;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, resName, &p, NULL);
	return (String)p;
	}
    

    typeName = XrmQuarkToString(Qtype);
      
#ifdef MOTIF20
    if ( (rip = XmRepTypeGetId(typeName)) != XmREP_TYPE_INVALID )
	{
	unsigned  char value;
	Arg       arg;
	XrmValue  input;    
	XrmValue  output;   

	DBUG_PRINT(procName, ("using reverse rep converter for type '%s;", 
			      typeName)); 
	  
	XtSetArg(arg, resName, &value);
	XtGetValues(w, &arg, (Cardinal)1);

	/* it is cheaper to call this multiple times than to 
	   get a copy of the repTypeRecord; the converter is
	   actually installed only once */
	XmRepTypeAddReverse(rip);  
	
	input.addr = &value;
	input.size = sizeof(value);
	output.addr =  NULL;
	XtConvert(w, typeName, &input, XtRString, &output); 
	if (output.addr) 
	    result = *(String *)output.addr;
	else
	    result = NULL;
	}

#endif /* MOTIF20 */

    if (!result)
	{
	/*
	 * warning: cvtToString assumes, the get values result
	 * can be stored in a XtPointer and that the result 
	 * does not have to be freed! 
	 */

	XtPointer value = 0;
	XtPointer valuePtr = (XtPointer)&value;
	Cardinal  size;
	Arg       arg;
	XrmQuark  oldAttrib = wafeCurrentAttrib;
	Widget    oldWidget = wafeCurrentWidget;

	XtSetArg(arg, resName, valuePtr);
	XtGetValues(w, &arg, (Cardinal)1);
	    
	if (!(size = wafeGetRsize(typeName)))
	    size = sizeof(char);

	if (size == sizeof(char)) 
	    {
	    char v = *(char *)valuePtr;
	    value = (XtPointer)(int)v;
	    }
	else
	if (size == sizeof(short)) 
	    {
	    short v = *(short *)valuePtr;
	    value = (XtPointer)(int)v;
	    }
	else
	if (size == sizeof(int)) 
	    {
	    int v = *(int *)valuePtr;
	    value = (XtPointer)v;
	    }
	else
	    {
	    long v = *(long *)valuePtr;
	    value = (XtPointer)v;
	    }
	
	/* fprintf(stderr,"value=%08x\n", value); */
	wafeCurrentAttrib = Qname;
	wafeCurrentWidget = w;
	result = cvtToString(w, value, typeName);
	wafeCurrentAttrib = oldAttrib;
	wafeCurrentWidget = oldWidget;
	}

    if (!result)
	wafeWarn(procName, "Couldn't convert value for %s to string",
		 resName,NULL,NULL);

    *freeProcPtr = TCL_STATIC;	
    return result;
    }

static int
getResourceList(w, resultPtr)
char    ***resultPtr; 
Widget   w;
    {
    int numTotal, count;
    char **result;
    int rNum = 0;
    int cNum = 0;
    QTypeList rList, cList;

    rNum = wafeGetResourcesOfClass(XtClass(w), &rList);

    if (XtIsConstraint(ParentWidget(w)))   /* If parentWidget is constrain widget => fetch constraints */
	cNum =  wafeGetConstraintsOfClass(XtClass(ParentWidget(w)), &cList);

    numTotal = rNum + cNum;

    *resultPtr = result = (char **)XtMalloc(numTotal *sizeof(char *));       

    for ( count = 0; count < rNum; count++ )
	*result++ = XrmQuarkToString(rList[count].qName);

    for ( count = 0; count < cNum; count++ )
	*result++ = XrmQuarkToString(cList[count].qName);

    return(numTotal);
    }


static String
waitForVariable(varName)
String varName;
    {
    String result = NULL;
    Tcl_UnsetVar(wafeInterpreter,varName,TCL_GLOBAL_ONLY);
    wafeInnerEventLoop ++;
    while (!(result = Tcl_GetVar(wafeInterpreter,varName,TCL_GLOBAL_ONLY)))
	XtAppProcessEvent(wafeAppContext, XtIMAll);
    wafeInnerEventLoop --;
    return result;
    }


static void
processPendingEvents()
    {
    while (XtAppPending(wafeAppContext))
       {
       XEvent event;
       XtAppNextEvent(wafeAppContext,&event);
#ifdef RDD
       if (rddDeliverMessageEvent(event))
	   continue;
#endif
       wafeInnerEventLoop ++;
       XtDispatchEvent(&event);
       wafeInnerEventLoop --;
       }
    }

typedef int MapState;

static MapState
mapState(w)
Widget w;
    {
    XWindowAttributes wattr;
    Window win = XtWindow(w);
    
    if (!win) return 0;
    if (!XGetWindowAttributes(XtDisplay(w), win, &wattr)) return 0;
    return wattr.map_state;
    }

#ifndef PRER5
static Status
combineFileDatabase(fname,w,override)
String fname;
Widget w;
Bool override;
    {
    XrmDatabase dispDb = XtDatabase(XtDisplay(w)); 
    return XrmCombineFileDatabase(fname, &dispDb, override);
    }
#endif

Boolean
wafeMWMrunning(shell)
Widget shell;
    {
#ifdef MOTIF
    return XmIsMotifWMRunning(shell);
#else
    Display  *dpy         = XtDisplay(shell);
    Window    root        = RootWindowOfScreen(XtScreen(shell));
    Atom      motifWmInfo = XInternAtom(dpy, "_MOTIF_WM_INFO", False);

    Atom      actual_type;
    int       actual_format;
    unsigned long nitems, bytes_after;
    unsigned char* prop;

    XGetWindowProperty(dpy, root, motifWmInfo, 0,0, FALSE,motifWmInfo,
		       &actual_type,&actual_format,&nitems,&bytes_after,
		       &prop);
    return (actual_type == motifWmInfo && actual_format == 32);
#endif /* MOTIF */
    }

static Boolean
wafeGetBool(string,boolPtr)
String string;
Bool *boolPtr;
    {
    int tclBool;
    if (TCL_OK == Tcl_GetBoolean(wafeInterpreter,string,&tclBool))
	{
	*boolPtr = (Bool)(tclBool);
	return True;
	}
    else 
	return False;
    }

#ifndef PRER5
static int
getActionList(wClass) 
WidgetClass wClass;
    {
    Cardinal num;
    XtActionList al,a;

#ifdef ATHENA
    /* only the textWidgetList has the action list :( */
    if (wClass == asciiTextWidgetClass) 
	wClass = textWidgetClass;
#endif    
    XtGetActionList(wClass, &al, &num);
    for(a=al; num; num--, a++) 
	Tcl_AppendElement(wafeInterpreter, a->string);

    if (al) XtFree((char *)al);
    return TCL_OK;
    }
#endif

/* convert string to pointer, ATHENA widget version, where Quark or lists
   are set; there is also another version which only sets strings...
 */
static Boolean
CvtStringToPointer(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    Boolean canDoNameSpecificConversion = (wafeCurrentAttrib != 0);
    Widget w = *((Widget *) args[0].addr);
    WidgetClass wClass = canDoNameSpecificConversion ? XtClass(w) : NULL;
    static XtPointer value;
    freeProc freeGarbage;

    DBUG_ENTER("CvtStringToPointer");

    WAFE_UNUSED(dpy);
    WAFE_UNUSED(args);
    WAFE_UNUSED(num_args);
    WAFE_UNUSED(converter_data);

#ifdef ATHENA
    if (canDoNameSpecificConversion == False)
	{
	/* delay conversion */
	wafePointerResourceValue = True;
	toVal->addr = NULL;
	DBUG_RETURN(True);
	}
#endif /* ATHENA */

#ifdef MOTIF    
    if (canDoNameSpecificConversion == False || toVal->addr) 
	{
	/* give up */
	toVal->addr = NULL;
	DBUG_RETURN(False);
	}
#endif

    if (wafeCvtNsFromString((String)fromVal->addr, wafeCurrentAttrib, wClass,
			    &value, &freeGarbage, &toVal->size))
	{
	if (toVal->addr) 
	    *(XtPointer *)(toVal->addr) = (XtPointer)value;
	else
	    toVal->addr = (caddr_t)&value;

	if (freeGarbage && freeGarbage != TCL_STATIC)
	    {
	    /* fprintf(stderr, "adding mmreplace\n"); */
	    wafeMMreplace(w, NULL, wafeCurrentAttrib, 
			  (char *)value, freeGarbage);
	    }
	}
    else
	{
	DBUG_PRINT("conv",("default"));
	/* store value like a string */

	if (toVal->addr) 
	    *(String *)(toVal->addr) = (String)fromVal->addr;
	else
	    {
	    static char* p;
	    p = XtNewString(fromVal->addr);
	    toVal->addr = (caddr_t)&p;
	    wafeMMreplace(w, NULL, wafeCurrentAttrib, 
			  (char *)p, XtFree);
	    }
	toVal->size = sizeof(String);
	}

    DBUG_RETURN(True);
    }



#ifdef MY_FONT_CONVERTER
static void 
FetchDisplayArg(widget, size, value)
Widget widget;
Cardinal *size;
XrmValue* value;
    {
    value->size = sizeof(Display*);
    value->addr = (XPointer)&DisplayOfScreen(XtScreenOfObject(widget));
    }

static XtConvertArgRec displayConvertArg[] = {
    {XtProcedureArg, (XtPointer)FetchDisplayArg, 0},
};

static Boolean
wafeCvtStringToFontStruct(dpy, args, num_args, fromVal, toVal, converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    return XtCvtStringToFontStruct(dpy, args, num_args, 
				   fromVal, toVal, converter_data);
    }
#endif

String
wafeGetDomain(typeString)
_Xconst String typeString;
    {
    Boolean freeStringList = False;
    String *strings = NULL;
    
#ifdef MOTIF20
    XmRepTypeId rip;
    
    if ( (rip = XmRepTypeGetId(typeString)) != XmREP_TYPE_INVALID )
	{
	strings = XmRepTypeGetNameList(rip,FALSE);
	freeStringList = True;
	}
#endif /* MOTIF 20 */    

    if (!strings)
	strings = wafeGetRdomain(typeString);

    if (strings)
	{
	String *s = strings;
	wafeStringStruct ws_s, *ws = &ws_s;

	wafeStringInit(ws);
	for(;s&&*s;s++) 
	    {
	    wafeStringAppend(ws,*s);
	    wafeStringAppendChar(ws,' ');
	    }
	if (ws->length)
	    ws->buffer[ws->length-1] = 0;
	
	if (freeStringList) 
	    {
	    for(s=strings;s&&*s;s++) XtFree(*s);
	    XtFree((char *)strings);
	    }
    
	return (ws->buffer == ws->sBuffer) ?
	    XtNewString(ws->buffer) : ws->buffer;
	}

    if (!strcmp(typeString,XtRBoolean))
	{
	return XtNewString("1 0 True False");
	}
    
    /*	wafeWarn("getDomain","cannot obtain domain for type '%s'",
	typeString,NULL,NULL);
	*/
    return XtNewString(wafe_EMPTY);
    }


int
screen(subCmd, w)
String subCmd;
Widget w;
    {
    char conversionBuffer[LONG_AS_STRING];
    int retcode = TCL_OK;
    Screen *s = XtScreen(w);
    
    DBUG_ENTER("screen");  

    if (*subCmd == 'n' && !strcmp(subCmd, "name")) 
	Tcl_SetResult(wafeInterpreter,DisplayString(DisplayOfScreen(s)), TCL_STATIC);
    else
    if (!strcmp(subCmd, "width")) 
	{
	sprintf(conversionBuffer, "%d", WidthOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'h' && !strcmp(subCmd, "height")) 
	{
	sprintf(conversionBuffer, "%d", HeightOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'w' && !strcmp(subCmd, "widthMM")) 
	{
	sprintf(conversionBuffer, "%d", WidthMMOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'h' && !strcmp(subCmd, "heightMM")) 
	{
	sprintf(conversionBuffer, "%d", HeightMMOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'p' && !strcmp(subCmd, "planes")) 
	{
	sprintf(conversionBuffer, "%d", PlanesOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'c' && !strcmp(subCmd, "cells")) 
	{
	sprintf(conversionBuffer, "%d", CellsOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'r' && !strcmp(subCmd, "rootWindow")) 
	{
	sprintf(conversionBuffer, "%ld", RootWindowOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'b' && !strcmp(subCmd, "blackPixel")) 
	{
	sprintf(conversionBuffer, "%ld", BlackPixelOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
    if (*subCmd == 'w' && !strcmp(subCmd, "whitePixel")) 
	{
	sprintf(conversionBuffer, "%ld", WhitePixelOfScreen(s));
	Tcl_SetResult(wafeInterpreter, conversionBuffer, TCL_VOLATILE);
	}
    else
	DBUG_RETURN(wafeSetError("unknown subcommand '%s' for screen; valid: 'blackPixel', 'cells', 'height', 'heightMM', 'name', 'planes', 'rootWindow', 'whitePixel', 'width', widthMM'", subCmd, NULL, NULL));
    
    DBUG_RETURN (retcode);
    }
