/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 * 
 */

/*
 * This file was generated by genc.
 * Be aware that modifications of this file will be lost,
 * when genc is executed!

Creation: Thu Jun 29 03:51:23 EDT 1995 on mohegan
Author: genc
Version: 1.0.13

 */

#define MISC_C
#include <wafe.h>

/* das ist ein -*- C -*- Programm */

/* this definition is from tclInt.h 
 * the first FOUR entries match EXACT the Interp struct from 
 * tclInt.h; we can't include tclInt.h, since it conflicts with
 * Xt' Arg structure.
 */
typedef struct Interp {
    /*
     * Note:  the first three fields must match exactly the fields in
     * a Tcl_Interp struct (see tcl.h).  If you change one, be sure to
     * change the other.
     */

    char *result;               /* Points to result returned by last
                                 * command. */
    Tcl_FreeProc *freeProc;     /* Zero means result is statically allocated.
                                 * If non-zero, gives address of procedure
                                 * to invoke to free the result.  Must be
                                 * freed by Tcl_Eval before executing next
                                 * command. */
    int errorLine;              /* When TCL_ERROR is returned, this gives
                                 * the line number within the command where
                                 * the error occurred (1 means first line). */
    Tcl_HashTable commandTable; /* Contains all of the commands currently
                                 * registered in this interpreter.  Indexed
                                 * by strings; values have type (Command *). */
    } Interp;

extern void wafeRegisterCmd(
#if NeedFunctionPrototypes
    int, _Xconst String
#endif
);

extern void wafeUnregisterCmd(
#if NeedFunctionPrototypes
    int
#endif
);

extern void wafeSetCommunicationVariableCmd(
#if NeedFunctionPrototypes
    _Xconst String, int, String
#endif
);

extern XtInputId wafeAddInputCmd(
#if NeedFunctionPrototypes
    int, XtPointer, _Xconst String, _Xconst String
#endif
);

extern void wafeRemoveInputCmd(
#if NeedFunctionPrototypes
    XtInputId 
#endif
);



static int
alias(newCmdName,oldCmdName)
String newCmdName;
String oldCmdName;
    {
    XtPointer cmdPtr;
    Interp *iPtr = (Interp *) wafeInterpreter;
    Tcl_HashEntry *hPtr;
    int newEntry;    

    if ((hPtr = Tcl_FindHashEntry(&iPtr->commandTable, newCmdName)) != NULL)
	{
	wafeWarn("alias","can't alias to '%s': command already exists",
		 newCmdName, NULL,NULL);
        /* Tcl_AppendResult(wafeInterpreter, "can't alias to \"", newCmdName,
                "\": command already exists", (char *) NULL); */
        return 0;
	}
    
    if ((hPtr = Tcl_FindHashEntry(&iPtr->commandTable, oldCmdName)) == NULL)
	{
	wafeWarn("alias","can't alias '%s': command doesn't exist",
		 oldCmdName, NULL,NULL);
        /* Tcl_AppendResult(wafeInterpreter, "can't alias \"", oldCmdName,
                "\":  command doesn't exist", (char *) NULL); */
        return 0;
	}

    cmdPtr = (XtPointer) Tcl_GetHashValue(hPtr);
    hPtr = Tcl_CreateHashEntry(&iPtr->commandTable, newCmdName, &newEntry);
    Tcl_SetHashValue(hPtr, cmdPtr);
    return 1;
}

static int cmd_clock();
static int cmd_ctime();
static int cmd_echo();
static int cmd_getChannel();
static int cmd_quit();
static int cmd_kill();
static int cmd_register();
static int cmd_setCommunicationVariable();
static int cmd_unregister();
static int cmd_addInput();
static int cmd_removeInput();
static int cmd_fileno();
static int cmd_alias();
static int cmd_DBUG_PUSH();
static int cmd_DBUG_POP();
#include <time.h>
#define ref(a) &(a)

#define echo(x) {write(wafeToClient,x,strlen(x)); if (count+1 != argc) write(wafeToClient,wafe_SPACE,1);}

#define getChannel() wafeExtraClient

#include <signal.h>

#define fileNo(s,w) ((Tcl_GetOpenFile(wafeInterpreter, (s), w, 1, &f) != TCL_OK) ? -1 : fileno(f))






static _Xconst Proc_signature cmds[] = {
     { "clock", cmd_clock },
     { "ctime", cmd_ctime },
     { "echo", cmd_echo },
     { "getChannel", cmd_getChannel },
     { "quit", cmd_quit },
     { "kill", cmd_kill },
     { "register", cmd_register },
     { "setCommunicationVariable", cmd_setCommunicationVariable },
     { "unregister", cmd_unregister },
     { "addInput", cmd_addInput },
     { "removeInput", cmd_removeInput },
     { "fileno", cmd_fileno },
     { "alias", cmd_alias },
     { "DBUG_PUSH", cmd_DBUG_PUSH },
     { "DBUG_POP", cmd_DBUG_POP },
    { NULL, NULL }
    };

static WidgetCreate_signature wccs[] = {
    { NULL,NULL,NULL,False,False,NULL }
    };

static _Xconst String pkgs[] = {
    NULL
     };



/* 
 * time_t
 * time vulgo clock
 *         const: NULL
 */

static int 
cmd_clock(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     time_t returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 1) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],0));

     returnVar = time(NULL);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * String
 * ctime
 * 	in: ref(time_t)			# clock value
 */

static int 
cmd_ctime(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     time_t localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(sscanf(argv[1], wafeStrings[9], &localVar1)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, "time_t"));

     returnVar = ctime(ref(localVar1));

     Tcl_SetResult(comInterpreter, returnVar, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * echo
 * 	callmultiple
 * 	in: String			# strings 
 * 	post: write(wafeToClient, wafe_NL,1);
 */

static int 
cmd_echo(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     String localVar1;
     int count;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],1));

     for (count = 1; count < argc; count++)
          {
         localVar1 = argv[count];
         echo(localVar1);
          }
     write(wafeToClient, wafe_NL,1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * int
 * getChannel
 */

static int 
cmd_getChannel(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 1) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],0));

     returnVar = getChannel();

     sprintf(conversionBuffer, wafeStrings[7], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void 
 * kill vulgo quit 
 * 	const: wafeClientPid	
 * 	const: SIGTERM
 * 	pre: if (wafeClientPid)		# None
 * 	post: wafeExit(0);
 */

static int 
cmd_quit(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 1) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],0));

     if (wafeClientPid)
     kill(wafeClientPid,SIGTERM);
     wafeExit(0);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void 
 * kill
 *     pre: localVar2 -= HANDLERMAX;
 *     in: int                      		# process id
 *     in: (int) signalType	         	# signalType
 */

static int 
cmd_kill(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(sscanf(argv[1], wafeStrings[7], &localVar1)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, wafeStrings[14]));

     if (!strcmp(argv[2], "term")) 
         localVar2 = HANDLERMAX+SIGTERM;
     else
     if (!strcmp(argv[2], "quit")) 
         localVar2 = HANDLERMAX+SIGQUIT;
     else
     if (!strcmp(argv[2], wafeStrings[14])) 
         localVar2 = HANDLERMAX+SIGINT;
     else
     if (!strcmp(argv[2], "hup")) 
         localVar2 = HANDLERMAX+SIGHUP;
     else
     if (!strcmp(argv[2], "pipe")) 
         localVar2 = HANDLERMAX+SIGPIPE;
     else
     if (!strcmp(argv[2], "usr1")) 
         localVar2 = HANDLERMAX+SIGUSR1;
     else
     if (!strcmp(argv[2], "usr2")) 
         localVar2 = HANDLERMAX+SIGUSR2;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 2,NULL, "signalType"));


     localVar2 -= HANDLERMAX;
     kill(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * wafeRegisterCmd vulgo register
 * 	in: (int)handlerType	# stdin | stdout | stderr | xioerr | ..signal..
 * 	in: String		# tcl-command
 */

static int 
cmd_register(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!strcmp(argv[1], wafeStrings[18])) 
         localVar1 = STDIN;
     else
     if (!strcmp(argv[1], wafeStrings[19])) 
         localVar1 = STDOUT;
     else
     if (!strcmp(argv[1], wafeStrings[20])) 
         localVar1 = STDERR;
     else
     if (!strcmp(argv[1], "xioerr")) 
         localVar1 = XIOERR;
     else
     if (!strcmp(argv[1], "htmlVisited")) 
         localVar1 = HTMLVISITED;
     else
     if (!strcmp(argv[1], "term")) 
         localVar1 = HANDLERMAX+SIGTERM;
     else
     if (!strcmp(argv[1], "quit")) 
         localVar1 = HANDLERMAX+SIGQUIT;
     else
     if (!strcmp(argv[1], wafeStrings[14])) 
         localVar1 = HANDLERMAX+SIGINT;
     else
     if (!strcmp(argv[1], "hup")) 
         localVar1 = HANDLERMAX+SIGHUP;
     else
     if (!strcmp(argv[1], "pipe")) 
         localVar1 = HANDLERMAX+SIGPIPE;
     else
     if (!strcmp(argv[1], "usr1")) 
         localVar1 = HANDLERMAX+SIGUSR1;
     else
     if (!strcmp(argv[1], "usr2")) 
         localVar1 = HANDLERMAX+SIGUSR2;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 1,NULL, wafeStrings[28]));


    /* no need to assign  << localVar2 = argv[2] >>  */ 

     wafeRegisterCmd(localVar1,argv[2]);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * wafeSetCommunicationVariableCmd vulgo setCommunicationVariable
 * 	in: XtNewString(String)		# variable name
 * 	in: int				# length
 * 	in: XtNewString(String)		# tcl command to be executed
 */

static int 
cmd_setCommunicationVariable(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, wafeStrings[14]));

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     wafeSetCommunicationVariableCmd(XtNewString(argv[1]),localVar2,XtNewString(argv[3]));

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * wafeUnregisterCmd vulgo unregister
 * 	in: (int)handlerType		# stdin | stdout | stderr | xioerr
 */

static int 
cmd_unregister(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!strcmp(argv[1], wafeStrings[18])) 
         localVar1 = STDIN;
     else
     if (!strcmp(argv[1], wafeStrings[19])) 
         localVar1 = STDOUT;
     else
     if (!strcmp(argv[1], wafeStrings[20])) 
         localVar1 = STDERR;
     else
     if (!strcmp(argv[1], "xioerr")) 
         localVar1 = XIOERR;
     else
     if (!strcmp(argv[1], "htmlVisited")) 
         localVar1 = HTMLVISITED;
     else
     if (!strcmp(argv[1], "term")) 
         localVar1 = HANDLERMAX+SIGTERM;
     else
     if (!strcmp(argv[1], "quit")) 
         localVar1 = HANDLERMAX+SIGQUIT;
     else
     if (!strcmp(argv[1], wafeStrings[14])) 
         localVar1 = HANDLERMAX+SIGINT;
     else
     if (!strcmp(argv[1], "hup")) 
         localVar1 = HANDLERMAX+SIGHUP;
     else
     if (!strcmp(argv[1], "pipe")) 
         localVar1 = HANDLERMAX+SIGPIPE;
     else
     if (!strcmp(argv[1], "usr1")) 
         localVar1 = HANDLERMAX+SIGUSR1;
     else
     if (!strcmp(argv[1], "usr2")) 
         localVar1 = HANDLERMAX+SIGUSR2;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 1,NULL, wafeStrings[28]));


     wafeUnregisterCmd(localVar1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * XtInputId
 * wafeAddInputCmd vulgo addInput 
 * 	in: int				# fileno
 * 	in: (XtPointer)SourceInputMask	# read | write | except | none | accept
 * 	in: String    			# TclVariable 
 * 	in: String 			# TclCommand
 */

static int 
cmd_addInput(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar1;
     XtPointer localVar2;
     XtInputId returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(sscanf(argv[1], wafeStrings[7], &localVar1)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, wafeStrings[14]));

     if (!strcmp(argv[2], "read")) 
         localVar2 = (XtPointer)XtInputReadMask;
     else
     if (!strcmp(argv[2], "write")) 
         localVar2 = (XtPointer)XtInputWriteMask;
     else
     if (!strcmp(argv[2], "except")) 
         localVar2 = (XtPointer)XtInputExceptMask;
     else
     if (!strcmp(argv[2], wafeStrings[24])) 
         localVar2 = (XtPointer)XtInputNoneMask;
     else
     if (!strcmp(argv[2], "accept")) 
         localVar2 = (XtPointer)(1L<<3);
     else
         DBUG_RETURN(wafeConvError(argc,argv, 2,NULL, "SourceInputMask"));


    /* no need to assign  << localVar3 = argv[3] >>  */ 

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     returnVar = wafeAddInputCmd(localVar1,localVar2,argv[3],argv[4]);

     sprintf(conversionBuffer, wafeStrings[10], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * wafeRemoveInputCmd vulgo removeInput
 * 	in: XtInputId			# input id
 */

static int 
cmd_removeInput(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     XtInputId localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(sscanf(argv[1], wafeStrings[10], &localVar1)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, wafeStrings[29]));

     wafeRemoveInputCmd(localVar1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * int
 * fileNo vulgo fileno
 * 	pre: { FILE* f;
 * 	in: String			# string identifying file
 * 	in: (int)FileNoReadWrite 	# read | write
 * 	post: }
 */

static int 
cmd_fileno(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     if (!strcmp(argv[2], "read")) 
         localVar2 = 0;
     else
     if (!strcmp(argv[2], "write")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "r")) 
         localVar2 = 0;
     else
     if (!strcmp(argv[2], "w")) 
         localVar2 = 1;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 2,NULL, "FileNoReadWrite"));


     { FILE* f;
     returnVar = fileNo(argv[1],localVar2);
     }

     sprintf(conversionBuffer, wafeStrings[7], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * int 
 * alias
 * 	in: String			# new command
 * 	in: String			# old command
 */

static int 
cmd_alias(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

    /* no need to assign  << localVar1 = argv[1] >>  */ 

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = alias(argv[1],argv[2]);

     sprintf(conversionBuffer, wafeStrings[7], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * DBUG_PUSH
 * 	in: String			# new debug options
 */

static int 
cmd_DBUG_PUSH(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     DBUG_PUSH(argv[1]);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * DBUG_POP 

 */

static int 
cmd_DBUG_POP(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 1) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],0));

     DBUG_POP();

     DBUG_RETURN (TCL_OK);
     }



void
wafeInitialize_MISC()
{
 wafeCreateTclCmds(pkgs,wccs,cmds);
}
