/* yes emacs, it is really  -*-C-*-  */
#include <X11/At/XYPlot.h>
#include <X11/At/XYPlotP.h>
#include <X11/At/SPlotP.h>
#include <X11/At/AtConverters.h>

static int
xyLinePlotAttachData(w,argc,argv)
Widget    w;
int       argc;
char    **argv;
     {
     int count;
     float *x,*xarray, *y,*yarray;
     MMattribListPtr *al = wafeMMgetAttribList(w,True);

     x = xarray = (float *)XtMalloc(sizeof(float)*argc);
     y = yarray = (float *)XtMalloc(sizeof(float)*argc);
     wafeMMreplace(w, al, qLinePlotXData, (char*)xarray, XtFree);
     wafeMMreplace(w, al, qLinePlotYData, (char*)yarray, XtFree);

     for (count = 0; count < argc; count++,x++,y++)
         if (!(sscanf(argv[count],"%f/%f",x,y)))
              return wafeConvError(argc, argv, count,NULL, "x/y");

     AtXYLinePlotAttachData(w,
			    (XtPointer)xarray, AtFloat, sizeof(float),
			    (XtPointer)yarray, AtFloat, sizeof(float),
			    1,argc);
     return TCL_OK;
     }


static int
xyLinePlotExtendData(w,argc,argv)
Widget  w;
int       argc;
char    **argv;
     {
     int count;
     float *x,*xarray, *y,*yarray;
     MMattribListPtr *al = wafeMMgetAttribList(w,True);
     AtXYPlotWidget spw  = (AtXYPlotWidget)w;
     int old_num         = spw->lplot.num_points;
     int numPoints       = old_num + argc;

     if (old_num == 0) 
	 return xyLinePlotAttachData(w,argc,argv);
     
     xarray = (float *)XtRealloc(spw->lplot.xdata, sizeof(float)*numPoints);
     spw->lplot.xdata = (XtPointer)xarray;
     yarray = (float *)XtRealloc(spw->lplot.ydata, sizeof(float)*numPoints);
     spw->lplot.ydata = (XtPointer)yarray;

     wafeMMreplace(w, al, qLinePlotXData, (char *)xarray, NULL);
     wafeMMreplace(w, al, qLinePlotYData, (char *)yarray, NULL);

     x = xarray + old_num;
     y = yarray + old_num;
     for (count = 0; count < argc; count++,x++,y++)
         {
         if (!(sscanf(argv[count],"%f/%f",x,y)))
	     return wafeConvError(argc, argv, count,NULL, "x/y");
	 }

     AtXYLinePlotExtendData(w,numPoints);
     return TCL_OK;
     }


static int
plotAttachData(w,argc,argv,quark)
Widget  w;
int       argc;
char    **argv;
XrmQuark quark;
    {
    float *ptr, *points;
    WidgetClass wClass = XtClass(w);

    points = ptr = (float *)XtMalloc(argc*sizeof(float));
    wafeMMreplace(w,NULL,quark,(char*)points,XtFree);

    while (*argv)
	{
	if (!(sscanf(*argv, wafeStrings[13], &*ptr)))
	    return wafeConvError(argc, argv, 2 ,NULL, wafeStrings[15]);
	ptr ++; argv++;
	}
    
    if (wClass == atBarPlotWidgetClass) 
	AtBarPlotAttachData(w,(XtPointer)points,AtFloat,sizeof(float),1,argc);
    else if (wClass == atLinePlotWidgetClass) 
	AtLinePlotAttachData(w,(XtPointer)points,AtFloat,sizeof(float),1,argc);

    return TCL_OK;
    }


static int
plotExtendData(w,argc,argv,quark)
Widget  w;
int       argc;
char    **argv;
XrmQuark quark;
    {
    float *ptr, *points;
    AtSPlotWidget spw  = (AtSPlotWidget)w;
    int old_num        = spw->splot.num_points;
    int numPoints      = old_num + argc;
    WidgetClass wClass = XtClass(w);
    
    if (old_num == 0) 
	return plotAttachData(w,argc,argv,quark);

    points = (float *)XtRealloc(spw->splot.data, sizeof(float)*numPoints);
    spw->splot.data = (XtPointer)points;
    wafeMMreplace(w,NULL,quark,(char*)points,NULL);

    ptr = points + old_num;
    while (*argv)
	{
	if (!(sscanf(*argv, wafeStrings[13], &*ptr)))
	    return wafeConvError(argc, argv, 2 ,NULL, wafeStrings[15]);
	ptr ++; argv++;
	}

    if (wClass == atBarPlotWidgetClass)
	AtBarPlotExtendData(w,numPoints);
    else if (wClass == atLinePlotWidgetClass)
	AtLinePlotExtendData(w,numPoints);

    return TCL_OK;
    }

#define AtFontSize int
#define AtFontStyle int
#define AtJustify int
#define AtLinestyle AtPlotLineStyle
