/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 * 
 */

/*
 * This file was generated by genc.
 * Be aware that modifications of this file will be lost,
 * when genc is executed!

Creation: Thu Jun 29 03:36:38 EDT 1995 on mohegan
Author: genc
Version: 1.0.12

 */

#define XMGRAPH_C
#include <wafe.h>
#ifdef XMGRAPH
#include <Graph.h>
#include <Arc.h>
#include <Graph.h>


static String 
getArcs(w,f,t)
Widget w;
Widget f,t;
    {
    int numArcs; 
    String returnVar;
    WidgetList wl = XmGraphGetArcsBetweenNodes(w,f,t,&numArcs); 
    wafeStringStruct ws_s, *ws=&ws_s; 

    wafeStringInit(ws); 
    wafeStringAppendWidgetList(ws, numArcs, wl); 
    returnVar = ws->buffer==ws->sBuffer ? 
	XtNewString(ws->buffer) : ws->buffer;
    wafeStringClear(ws); 
    if (wl) XtFree((char*)wl);
    return returnVar;
    }

static int cmd_XmArcGetPos();
static int cmd_XmGraphInsertRoots();
static int cmd_XmGraphDestroyAllArcs();
static int cmd_XmGraphDestroyAllNodes();
static int cmd_XmGraphGetArcsBetweenNodes();
static int cmd_XmGraphCenterAroundWidget();
#define XmGraphArcDir unsigned char
#define XmGraphArcDrawMode unsigned char
#define XmGraphCapStyle unsigned char
#define XmGraphAutoLayoutType unsigned char

#define ARC(w) (XmArcWidget)(w)


 static _Xconst String XmGraphArcDir_strings[] = {
  "directed","bidirected","undirected",NULL };
 static _Xconst int XmGraphArcDir_values[] = {
  XmDIRECTED,XmBIDIRECTED,XmUNDIRECTED,0 };
 static XtConvertArgRec XmGraphArcDir_args[] = { {XtAddress, NULL, 0} };

 static _Xconst String XmGraphArcDrawMode_strings[] = {
  "position_fixed","position_relative",NULL };
 static _Xconst int XmGraphArcDrawMode_values[] = {
  XmPOSITION_FIXED,XmPOSITION_RELATIVE,0 };
 static XtConvertArgRec XmGraphArcDrawMode_args[] = { {XtAddress, NULL, 0} };

 static _Xconst String XmGraphCapStyle_strings[] = {
  "capNotLast","capButt","capRound","capProjecting",NULL };
 static _Xconst int XmGraphCapStyle_values[] = {
  XmCapNotLast,XmCapButt,XmCapRound,XmCapProjecting,0 };
 static XtConvertArgRec XmGraphCapStyle_args[] = { {XtAddress, NULL, 0} };

 static _Xconst String XmGraphAutoLayoutType_strings[] = {
  "never","always","arcs_only","nodes_only","partial",NULL };
 static _Xconst int XmGraphAutoLayoutType_values[] = {
  XmNEVER,XmALWAYS,XmARCS_ONLY,XmNODES_ONLY,XmPARTIAL,0 };
 static XtConvertArgRec XmGraphAutoLayoutType_args[] = { {XtAddress, NULL, 0} };


static void wafeClassInit_XmArc(wClass)
WidgetClass wClass;
{
 static _Xconst Proc_signature cmds[] = {
 { "XmArcGetPos", cmd_XmArcGetPos },
 { NULL, NULL }
 };
 XtInitializeWidgetClass(wClass);
 wafeCreateTclProcs(cmds);
}

static void wafeClassInit_XmGraph(wClass)
WidgetClass wClass;
{
 static _Xconst Proc_signature cmds[] = {
 { "XmGraphInsertRoots", cmd_XmGraphInsertRoots },
 { "XmGraphDestroyAllArcs", cmd_XmGraphDestroyAllArcs },
 { "XmGraphDestroyAllNodes", cmd_XmGraphDestroyAllNodes },
 { "XmGraphGetArcsBetweenNodes", cmd_XmGraphGetArcsBetweenNodes },
 { "XmGraphCenterAroundWidget", cmd_XmGraphCenterAroundWidget },
 { NULL, NULL }
 };
 XtInitializeWidgetClass(wClass);
 wafeCreateTclProcs(cmds);

 XmGraphArcDir_args[0].address_id= (XtPointer)
   wafeAddRConv(XmRArcDirection,sizeof(XmGraphArcDir),
		XmGraphArcDir_strings, (XtPointer)XmGraphArcDir_values);
 XtSetTypeConverter(XmRArcDirection,XtRString,wafeCvtRToString,
		    XmGraphArcDir_args,XtNumber(XmGraphArcDir_args),
                    XtCacheNone,NULL);

 XmGraphArcDrawMode_args[0].address_id= (XtPointer)
   wafeAddRConv(XmRArcDrawMode,sizeof(XmGraphArcDrawMode),
		XmGraphArcDrawMode_strings, (XtPointer)XmGraphArcDrawMode_values);
 XtSetTypeConverter(XmRArcDrawMode,XtRString,wafeCvtRToString,
		    XmGraphArcDrawMode_args,XtNumber(XmGraphArcDrawMode_args),
                    XtCacheNone,NULL);

 XmGraphCapStyle_args[0].address_id= (XtPointer)
   wafeAddRConv(XmRCapStyle,sizeof(XmGraphCapStyle),
		XmGraphCapStyle_strings, (XtPointer)XmGraphCapStyle_values);
 XtSetTypeConverter(XmRCapStyle,XtRString,wafeCvtRToString,
		    XmGraphCapStyle_args,XtNumber(XmGraphCapStyle_args),
                    XtCacheNone,NULL);

 XmGraphAutoLayoutType_args[0].address_id= (XtPointer)
   wafeAddRConv(XmRAutoLayoutType,sizeof(XmGraphAutoLayoutType),
		XmGraphAutoLayoutType_strings, (XtPointer)XmGraphAutoLayoutType_values);
 XtSetTypeConverter(XmRAutoLayoutType,XtRString,wafeCvtRToString,
		    XmGraphAutoLayoutType_args,XtNumber(XmGraphAutoLayoutType_args),
                    XtCacheNone,NULL);
}




static _Xconst Proc_signature *cmds = NULL; 

static WidgetCreate_signature wccs[] = {
    {"XmArc",NULL,NULL,False,False,wafeClassInit_XmArc},
    {"XmGraph",NULL,NULL,False,False,wafeClassInit_XmGraph},
    {"XmScrolledGraph",NULL,XmCreateScrolledGraph,False,False,wafeClassInit_XmGraph},
    { NULL,NULL,NULL,False,False,NULL }
    };

static _Xconst String pkgs[] = {
     "XMGRAPH",
    NULL
     };



#define WS_XmArc wccs[0].name
/* 
 * void
 * XmArcGetPos
 * 	in: ARC(XmArcWidget)	# name of arc Widget
 * 	out: Position		# out: from x-coordiante 
 * 	out: Position		# out: from y-corrdinate
 * 	out: Position		# out: to x-coordinate
 * 	out: Position		# out: to y-coordinate
 */

static int 
cmd_XmArcGetPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;
     Position localVar4;
     Position localVar5;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 6) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],5));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmArcWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, "XmArcWidget"));

     XmArcGetPos(ARC(localVar1),&localVar2,&localVar3,&localVar4,&localVar5);

     sprintf(conversionBuffer, wafeStrings[8], localVar2);

     Tcl_SetVar(wafeInterpreter,argv[2],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[8], localVar3);

     Tcl_SetVar(wafeInterpreter,argv[3],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[8], localVar4);

     Tcl_SetVar(wafeInterpreter,argv[4],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[8], localVar5);

     Tcl_SetVar(wafeInterpreter,argv[5],conversionBuffer,0);

     DBUG_RETURN (TCL_OK);
     }


#define WS_XmGraph wccs[1].name
#define WS_XmScrolledGraph wccs[2].name
/* 
 * void
 * XmGraphInsertRoots
 * 	in: XmGraphWidget   # XmGraphWidget
 * 	in: [Widget]        # nodes
 *         const: argc-2
 */

static int 
cmd_XmGraphInsertRoots(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget * localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmGraphWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, "XmGraphWidget"));

     {    Widget *ptr;
          char **origArgv = argv;
          argv += 2;
          localVar2 = ptr =
             (Widget *)XtMalloc((argc-2)*sizeof(Widget));

          while (*argv)
             {
             if (!(*ptr =  name2Widget(*argv)))
                 DBUG_RETURN(wafeConvError(argc, origArgv, 2, NULL, XtRWidget));

          ptr ++; argv++;
          }
     }
     XmGraphInsertRoots(localVar1,localVar2,argc-2);
     wafeMMreplace(localVar1,NULL,WafePermStringToQuark("XmGraphInsertRoots"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void 
 * XmGraphDestroyAllArcs
 *         in: XmGraphWidget   # XmGraphWidget
 */

static int 
cmd_XmGraphDestroyAllArcs(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmGraphWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, "XmGraphWidget"));

     XmGraphDestroyAllArcs(localVar1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * XmGraphDestroyAllNodes
 *         in: XmGraphWidget   # XmGraphWidget
 */

static int 
cmd_XmGraphDestroyAllNodes(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmGraphWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, "XmGraphWidget"));

     XmGraphDestroyAllNodes(localVar1);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * (String) DString
 * getArcs vulgo XmGraphGetArcsBetweenNodes
 *         in: XmGraphWidget   # XmGraph Widget
 *         in: Widget          # from node 
 *         in: Widget          # to node
 */

static int 
cmd_XmGraphGetArcsBetweenNodes(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     Widget localVar3;
     String returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmGraphWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, "XmGraphWidget"));

     if (!(localVar2 = (Widget) name2Widget(argv[2])))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRWidget));

     if (!(localVar3 = (Widget) name2Widget(argv[3])))
         DBUG_RETURN(wafeConvError(argc, argv, 3, NULL, XtRWidget));

     returnVar = getArcs(localVar1,localVar2,localVar3);

     Tcl_SetResult(comInterpreter, returnVar, XtFree);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void 
 * XmGraphCenterAroundWidget
 * 	in: XmGraphWidget   # XmGraph Widget
 * 	in: Widget 	    # node
 */

static int 
cmd_XmGraphCenterAroundWidget(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xmGraphWidgetClass)))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, "XmGraphWidget"));

     if (!(localVar2 = (Widget) name2Widget(argv[2])))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRWidget));

     XmGraphCenterAroundWidget(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }


#endif  /* of ifdef XMGRAPH */

void
wafeInitialize_XMGRAPH()
{
#ifdef XMGRAPH
 wccs[0].wClass = xmArcWidgetClass; /* not a C constant! */
 wccs[1].wClass = xmGraphWidgetClass; /* not a C constant! */
 wccs[2].wClass = xmGraphWidgetClass;
 wafeCreateTclCmds(pkgs,wccs,cmds);
#endif /* of ifdef XMGRAPH */
}
