/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser, Gustaf Neumann
 * Version: 0.9
 */

#define CONVERTERS_C

#include "wafe.h"
#include "wafe_quarks.h"

#include <X11/Xmu/Converters.h>
#include <X11/Xmu/Drawing.h>
#include <X11/Shell.h>

#include <X11/IntrinsicP.h>

#ifdef ATHENA
#include <X11/Xaw/List.h>
#endif

#ifdef MOTIF
# include <Xm/Text.h>
# ifdef MOTIF20
#  include <Xm/CSText.h>
# endif
#endif

#ifdef GHOSTVIEW
# include <Ghostview.h>
#endif

#define	CONVERSION_DONE(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}



/*
static Boolean
inTree(node,w)
Widget node;
Widget w;
    {
    WidgetList wl;
    Cardinal numChildren = 0;

    if (node == w)
	{
	return True;
	}

    XtVaGetValues(node, 
		  XtNchildren, &wl, 
		  XtNnumChildren, &numChildren,
		  NULL);
    
    for(;numChildren>0;numChildren--, wl++) 
	if (inTree(*wl,w))
	    return True;

    numChildren = node->core.num_popups;
    wl =  node->core.popup_list;

    for(;numChildren>0;numChildren--, wl++) 
	if (inTree(*wl,w))
	    return True;
    
    return False;
    }

Boolean
existingWidget(w)
Widget w;
    {
    WidgetListPtr ptr = wafeWidgetTrees;

#ifdef USECONTEXT
    MMattribListPtr al;
    if (!XFindContext(XtDisplay(w), (XID) w, wafeCtx, (XPointer *) &al)) 
	return True;

   fprintf(stderr, "existingWidget: Did NOT find widget! %p %p %p\n",
     XtDisplay(w), (XID) w, wafeCtx);    
#else
    if (MMgetAttribList(w,False) != NULL)
	return True;
#endif 

    while (ptr) 
	{
	if (inTree(ptr->widget, w))
	    return True;
	ptr = ptr->next;
	}
    return False;
    }

*/

#include <setjmp.h>
static jmp_buf sig_buf;

static void
segvHandler(sig)
int   sig;
    {
    fprintf(stderr,"caught signal %d\n",sig);
    siglongjmp(sig_buf,sig);
    }


/*****************************************************************************
 *    FUNCTION:  wafeCvtName2Widget
 *
 *    Arguments: string containing an instance's name, Boolean complain
 *               target widget class, print string for widget class
 *    Returns:   Widget on success, otherwise NULL
 *
 *    Used by:   nearly all tcl-commands dealing with widgets
 *****************************************************************************/
Widget
wafeCvtName2Widget(name,complain,wClass)
_Xconst String name;
Boolean        complain;
WidgetClass    wClass;
    {
    volatile Widget result;

    if (!name)
	return(NULL);

    if ((*name <= '9' && *name >= '0') || *name == '-')
	{
	char *end;
	if ((result = (Widget)strtol(name,&end,10)))
	    {
	    Boolean isObject;
    
	    signal(SIGSEGV,segvHandler);
	    if (sigsetjmp(sig_buf,1)) 
		isObject = False;
	    else
		isObject = XtIsObject(result);
	    signal(SIGSEGV,SIG_DFL);

	    if (isObject)
		{
		if (end && *end && end != name) 
		    result = XtNameToWidget(result,end);
		}
	    else 
		result = NULL;
	    }
	}
    else 
	{
	char starname[300];
	WidgetListPtr ptr = wafeWidgetTrees;

	result = NULL;
	*starname = '*';
	strcpy(&starname[1], name);
	while (ptr) 
	    {
	    if ((result = XtNameToWidget(ptr->widget, starname))
                || (result = XtNameToWidget(ptr->widget, name))
	        || (strcmp((char*)(ptr->info),name)==0 && (result=ptr->widget))
		)
		break;
	    ptr = ptr->next;
	    }
	}

    if (result) 
	{
	if (wClass) 
	    {
	    if (XtClass(result) == wClass 
		|| (wClass == compositeWidgetClass && XtIsComposite(result))
		|| (wClass == shellWidgetClass && XtIsShell(result))
		) {
		return result;
	      }
	    else 
		{
		if (complain)
		    wafeConvWarn(XtRWidget, name, 
				 wClass->core_class.class_name);
		return NULL;
		}
	    }
	DBUG_PRINT("conv",("widget <%s> is %p",name,result));
	return result;
	}

    if (complain) 
	wafeConvWarn(XtRWidget, name, XtRWidget);
    return (NULL);
    }





Boolean
CvtStringToWidget(dpy, args, num_args, fromVal, toVal, 
		  converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    Widget w = NULL;
    char *name = (char *)fromVal->addr;

    if (*name && !(w = name2Widget(name)))
	{
	XtDisplayStringConversionWarning(dpy, (String)name, XtRWidget);
	return False;
	}
    else
	CONVERSION_DONE(Widget, w);
    }


/* convert string to callback: gustaf Sat Jul 11 15:09:12 MET DST 1992 */
Boolean
CvtStringToCallback(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    XtCallbackList callback_list;

    char *charp = XtCalloc(
			    sizeof(XtCallbackList)*2 +
			    sizeof(XtCallbackRec[2]) +
			    sizeof(XrmQuark) +
			    strlen((char *)fromVal->addr) + 1,
			    1);

    *(XtCallbackList*)charp = (XtCallbackList)(charp+sizeof(XtCallbackList)*2);
    *(XtCallbackList*)(charp+sizeof(XtCallbackList)) = NULL;
    callback_list = *(XtCallbackList*)charp;
    callback_list->callback = (XtCallbackProc)wafeExecCallbackProc;
    callback_list->closure = 
	charp + sizeof(XtCallbackList)*2 + sizeof(XtCallbackRec[2]);

    /* remembering quark of current resource name to determine the type 
       of resource */

    *(XrmQuark *)callback_list->closure = wafeCurrentAttrib;
    strcpy((char *)callback_list->closure + sizeof(XrmQuark), 
	   (char *)fromVal->addr);

    if (toVal->addr) 
	{
	if (toVal->size < sizeof(XtCallbackList)) 
	    {
	    toVal->size = sizeof(XtCallbackList);
	    XtFree((char *)charp);
	    return False;
	    }
	
	*(XtCallbackList *)(toVal->addr) = callback_list;
	}
    else 
	{
	toVal->addr = (caddr_t)charp;
	wafeMMreplace(NULL, wafeCurrentAttribList, 
		      wafeCurrentAttrib, 
		      (char *)charp, XtFree);
	}

    toVal->size = sizeof(XtCallbackList);

/*
    {int i; char *p;
     for(p=charp,i=0; i<=
			    sizeof(XtCallbackList)*2 +
			    sizeof(XtCallbackRec[2]) +
			    sizeof(XrmQuark) +
			    strlen((char *)fromVal->addr) + 1 ;
	 i++,p++) fprintf(stderr,"%x[%c] ",*p & 0xff,*p & 0xff);
       fprintf(stderr,wafe_NL);
   }
*/
    return True;
    }


Boolean
CvtStringToWidgetList(dpy, args, num_args, fromVal, toVal,
		   converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    static int argc;
    static char ** argv;
    int i;

    Tcl_SplitList(wafeInterpreter,(char*)fromVal->addr, &argc,&argv);

    for ( i = 0; i < argc; i++ )   
	/* we assume that sizeof(char*) = sizeof(Widget) */
	if (!(argv[i] = (char *) name2Widget(argv[i])))
	    {
	    wafeConvWarn(XtRWidgetList,argv[i],XtRWidget);
	    XtFree((char *)argv);
	    return False;
	    }

    toVal->size = sizeof(char **);
    toVal->addr = (caddr_t)&argv;

    wafeMMreplace(NULL, wafeCurrentAttribList, wafeCurrentAttrib, 
		  (char *)argv, XtFree);
    return True;
    }


/*****************************************************************************
 *    FUNCTION:  convert                                                    
 *               Takes attribute/value pairs, both of them strings, and     
 *               constructs a proper X11 Arglist by converting the string   
 *               values to the requested data type.                         
 *                                                                          
 *    Arguments: parent widget                                              
 *               widgetClass of widget                                      
 *               argv and argc (containing the attribute/value pairs)       
 *               A Pointer to an Arglist and an int for passing the result,
 *               the actual widget (if available or NULL)
 *                                                                          
 *    Returns:   1 on success, 0 on error                                   
 *                                                                          
 *    Used by:   setValues, tclWidgetCommand                                
 *****************************************************************************/

int
wafeConvert(parent, wClass, argv, argcp, args, numArgs, widget)
Widget        parent;    
WidgetClass   wClass;    
char        **argv;      
int          *argcp;      
ArgList      *args;                /* RETURN */
int          *numArgs;             /* RETURN */
Widget        widget;
    {
    int               pairNum;  
    ArgList           argPtr;   
    XrmValue          input;    
    XrmValue          output;   
    XrmQuark          Qtype,Qname;
    int               count = 0; 
    int               delayedArgc = 0;
    char           ** returnArgvPtr = argv;
    int               argc = *argcp;
    static MMattribListPtr currentStrInfo;
    char *procName = "convert";
   
    DBUG_ENTER(procName);

    if (argc == 0)
	{
	/* nothing to convert */
	*numArgs = 0;
	*args =NULL;
	currentStrInfo = Nil(MMattribList);
        wafeCurrentAttribList = &currentStrInfo;
	DBUG_RETURN (1);
	}

    if (argc % 2)
	{
	/* error condition */
	wafeWarn(procName,"Wrong number of arguments", NULL,NULL,NULL);
        wafeCurrentAttribList = NULL;
	DBUG_RETURN (0);
	}
    
    argPtr = *args = (ArgList)XtMalloc((argc/2)*sizeof(Arg));

    if ((wafeCurrentWidget = widget)) /* we have a widget */
        {
	Boolean t = True;
	wafeCurrentAttribList = wafeMMgetAttribList(widget,t);
	currentStrInfo        = *wafeCurrentAttribList;
        }
    else /* we have no widget */
        {
        wafeCurrentAttribList = &currentStrInfo;
        currentStrInfo        = Nil(MMattribList);
        }

    for (pairNum = 1; pairNum <= argc/2; pairNum++)
	{
	Boolean isConstraint;

	/* ignore resources starting with a '#' character */
	if (**argv == '#')
	  continue;

	Qname = XrmStringToQuark(*argv); 
	Qtype = wafeGetQTypeOfAttribute(wClass, parent, Qname, &isConstraint);

	if(Qtype)
	    {
	    /* decide whether we have to delay conversion: 
               if the widget is given, there is no need to delay.
               if the resource is a constraint resource, delaying
                  could cause problems for motif widgets creating
                  on-the-fly parent widgets, for which the constraint 
                  resources must be set. So far, i found no constraint
                  resource that needs delaying...
	     */
	    if ( (!(widget || isConstraint)) && (
		Qtype == qCallback

#ifdef ATHENA
		|| Qtype == qPointer
		|| (Qname == qlongest && wClass == listWidgetClass)
		|| (Qname == qnumberStrings && wClass == listWidgetClass)
#endif
#ifdef MOTIF
# ifdef MOTIF20
		|| Qtype == qDynamicPixmap
# else
		|| Qtype == qHorizontalDimension
	 	|| Qtype == qVerticalDimension 
# endif
		|| Qtype == qPixmap
		|| Qtype == qBackgroundPixmap
		|| Qtype == qPrimForegroundPixmap
		|| Qtype == qPrimHighlightPixmap
		|| Qtype == qPrimBottomShadowPixmap
		|| Qtype == qPrimTopShadowPixmap
		|| Qtype == qManForegroundPixmap
		|| Qtype == qManHighlightPixmap
		|| Qtype == qManBottomShadowPixmap
		|| Qtype == qManTopShadowPixmap
		|| Qtype == qGadgetPixmap
		|| (Qtype == qPointer && 
		    (wClass == xmTextWidgetClass 
#ifdef MOTIF20
		     || wClass == xmCSTextWidgetClass
#endif
		     ) && Qname == qsource  )
#endif
	       ))
		{
		/* delay conversion until widget is created
		 */ 
		  DBUG_PRINT("conv", ("delayed: %s of type %s", 
				      *argv, XrmQuarkToString(Qtype)));
		*(returnArgvPtr++) = *(argv++);
		*(returnArgvPtr++) = *(argv++);
		delayedArgc += 2;
	        }
            else
                {
		  DBUG_PRINT("conv", ("N: %s, T: %s", 
				      *argv, XrmQuarkToString(Qtype))); 
	    
		  argPtr->name = *argv;         /* Name of attrib */  
		  wafeCurrentAttrib = Qname;    /* Remember quark */
		  input.addr = *(++argv);       /* Den Wert konvertieren.. */
		  input.size = strlen(*argv)+1;
		  output.addr =  NULL;
		  
		  DBUG_PRINT("conv", ("Input: String %s, size %d", 
				      input.addr, input.size));
		  
		  IFCONVERTANDSTORE(widget?widget:parent, XtRString, input, 
				    XrmQuarkToString(Qtype), output)
		      {
		      DBUG_PRINT("conv", ("Konv OK, Gr: %u", output.size));

		      if (Qtype == qString) 
			  {
#ifdef MOTIF
			  Boolean keepACopy = False;
#else
			  Boolean keepACopy = True;
#endif /* MOTIF */
#ifdef GHOSTVIEW
			  if (wClass == ghostviewWidgetClass)
			      {
			      if (Qname == qfilename && *output.addr == '\0')
				  {
				  output.addr = NULL;
				  keepACopy = False;
				  }
			      else 
				  keepACopy = True;
			      }
#endif /* GHOSTVIEW */

			  if (keepACopy)
			      {
			      argPtr->value=(XtArgVal)XtNewString(output.addr);
			      wafeMMreplace(NULL, wafeCurrentAttribList, 
					    wafeCurrentAttrib,
					    (char *)(argPtr->value), XtFree);
			      }
			  else
			      argPtr->value = (XtArgVal)output.addr;
			  }
#ifdef MOTIF
		      else
		      if (Qtype == qXmString) 
			  argPtr->value = (XtArgVal)output.addr;
#endif
		      else 
		      if (output.size == sizeof(int))
			  argPtr->value = (XtArgVal) *(int *)output.addr;
		      else
		      if (output.size == sizeof(long))
			  argPtr->value = (XtArgVal) *(long *)output.addr;
		      else
		      if (output.size == sizeof(short))
			  argPtr->value = (XtArgVal) *(short *)output.addr;
		      else 
		      if (output.size == sizeof(double))
			  {
			  /* we have to copy doubles to allow multiple 
			   * doubles in one widget creation or setValue 
			   * command 
			   */
			  argPtr->value = (XtArgVal)XtMalloc(sizeof(double));
			  *(double *)(argPtr->value) = *(double *)(output.addr);
			  wafeMMreplace(NULL, wafeCurrentAttribList, 
					wafeCurrentAttrib,
					(char *)(argPtr->value), XtFree);
			  }
		      else 
		      if (output.size == sizeof(char))
			  argPtr->value = (XtArgVal) *(char *)output.addr;
		      else
		      if (output.size == sizeof(XtArgVal)) 
			  argPtr->value = *(XtArgVal *)output.addr;
		      else
			  wafeWarn(procName,
				   "converter for StringTo%s returns unreasonable size",
				   XrmQuarkToString(Qtype),NULL,NULL);
		      argPtr++; 
		      count++; 
		      }
		  argv++;
		  }
	    }
	else 
	    {
	    wafeWarn(procName,"Attribute unknown: %s", *argv,NULL,NULL);
	    argv += 2; 
	    }
	}

    *argcp = delayedArgc;
    *numArgs = count;
    wafeCurrentAttrib = 0;
    DBUG_RETURN (1); 
    }

/*
String
wafeTopLevelWidget(w)
Widget w;
    {
    WidgetListPtr ptr;
    for(ptr = wafeWidgetTrees; ptr; ptr = ptr->next)
	if (w == ptr->widget)
	    return (String)ptr->info;
    return NULL;
    }
*/

String
wafeWidgetToName(w)
Widget w;
    {
    WidgetListPtr ptr;
    String result = NULL;

    if (w) 
	{
	if (XtParent(w) == NULL) 
	    {
	    for(ptr = wafeWidgetTrees; ptr; ptr = ptr->next)
		if (w == ptr->widget)
		    {
		    result = (String)ptr->info;
		    break;
		    }
	    }
	else 
	    result = XtName(w);
	}

    return result;
    }
    

Boolean
wafeGetBoolean(string,boolPtr)
_Xconst String string;
Boolean *boolPtr;
    {
    int tclBool;
    if (TCL_OK == Tcl_GetBoolean(wafeInterpreter,string,&tclBool))
	{
	*boolPtr = (Boolean)(tclBool);
	return True;
	}
    else 
	return False;
    }

#ifdef MOTIF
#include <Xm/Protocols.h>
#endif

Atom
wafeCvtStringToAtom(w,string,only_if_exists)
Widget         w;
_Xconst String string;
Boolean        only_if_exists;
    {
    Atom     result;
    char    *p;
    Display *dsp = XtDisplay(w);

    if (!string)
	return(0);

    if ((*string <= '9' && *string >= '0') || *string == '-')
	{
	result = (Atom) strtol(string, &p, 10);

	/* we should test here, whether the atom id exists ...
	if (only_if_exists) 
	    {
	    if ((p = wafeGetAtomName(dsp,result))) 
		{
		if (!*p) 
		    result = 0;
		XtFree(p);
		}
	    else
		result = 0;
	    }
        */
	}
    else 
	result = wafeInternAtom(dsp,string,only_if_exists);

    return result;
    }



Pixel
wafeCvtStringToPixel(w,colorName)
Widget w;
_Xconst String colorName;
    {
    XrmValue input, output;
    Pixel    pixel = 0;

    input.size  = strlen(colorName);
    input.addr  = (XtPointer)colorName;
    output.addr = NULL;
    IFCONVERTANDSTORE(w, XtRString, input, XtRPixel, output)
	pixel = *(Pixel *)output.addr;

    return pixel;
    }


/***** BEGIN color converter  */
#if 1

#include	<X11/keysym.h>

static int CompareISOLatin1 (first, second)
    char *first, *second;
{
    register unsigned char *ap, *bp;

    for (ap = (unsigned char *) first, bp = (unsigned char *) second;
	 *ap && *bp; ap++, bp++) {
	register unsigned char a, b;

	if ((a = *ap) != (b = *bp)) {
	    /* try lowercasing and try again */

	    if ((a >= XK_A) && (a <= XK_Z))
	      a += (XK_a - XK_A);
	    else if ((a >= XK_Agrave) && (a <= XK_Odiaeresis))
	      a += (XK_agrave - XK_Agrave);
	    else if ((a >= XK_Ooblique) && (a <= XK_Thorn))
	      a += (XK_oslash - XK_Ooblique);

	    if ((b >= XK_A) && (b <= XK_Z))
	      b += (XK_a - XK_A);
	    else if ((b >= XK_Agrave) && (b <= XK_Odiaeresis))
	      b += (XK_agrave - XK_Agrave);
	    else if ((b >= XK_Ooblique) && (b <= XK_Thorn))
	      b += (XK_oslash - XK_Ooblique);

	    if (a != b) break;
	}
    }
    return (((int) *bp) - ((int) *ap));
}

Boolean CvtStringToPixel(dpy, args, num_args, fromVal, toVal, closure_ret)
    Display*    dpy;
    XrmValuePtr args;
    Cardinal    *num_args;
    XrmValuePtr fromVal;
    XrmValuePtr toVal;
    XtPointer   *closure_ret;
{
    String          str = (String)fromVal->addr;
    XColor          screenColor;
    XColor          exactColor;
    Screen          *screen;
    /* XtPerDisplay    pd = _XtGetPerDisplay(dpy);*/
    Colormap        colormap;
    Status          status;
    String          params[1];
    Cardinal        num_params=1;

    if (*num_args != 2) 
	{
	/*
	XtDisplayStringConversionWarning(dpy,(String)fromVal->addr,XtRPixel);
	*/
    
	XtAppWarningMsg(wafeAppContext, "wrongParameters", "cvtStringToPixel",
	      /*XtCXtToolkitError*/ "XtToolkitError",
	      "String to pixel conversion needs screen and colormap arguments",
	      (String *)NULL, (Cardinal *)NULL);
	return False;
    }

    screen = *((Screen **) args[0].addr);
    colormap = *((Colormap *) args[1].addr);

    if (CompareISOLatin1(str, XtDefaultBackground) == 0) {
        *closure_ret = False;
        /* if (pd->rv) done(Pixel, BlackPixelOfScreen(screen))
        else        */
	CONVERSION_DONE(Pixel, WhitePixelOfScreen(screen));
    }
    if (CompareISOLatin1(str, XtDefaultForeground) == 0) {
        *closure_ret = False;
        /* if (pd->rv) done(Pixel, WhitePixelOfScreen(screen))
        else      */
	CONVERSION_DONE(Pixel, BlackPixelOfScreen(screen));
    }

    status = XAllocNamedColor(DisplayOfScreen(screen), colormap,
                              (char*)str, &screenColor, &exactColor);
    if (status == 0) {
        String msg, type;
        params[0] = str;
        /* Server returns a specific error code but Xlib discards it.  Ugh */
        if (XLookupColor(DisplayOfScreen(screen), colormap, (char*)str,
                         &exactColor, &screenColor))
	    {
	    Visual *visual   = DefaultVisual(dpy, DefaultScreen(dpy));
	    int    ncols     = visual->map_entries, 
	           i, 
	           best_i    = -1;
	    long   best_closeness = 65535*4, 
	           wanted_bn = exactColor.red+exactColor.green+exactColor.blue;
	    XColor *cols     = (XColor *)XtCalloc(ncols, sizeof(XColor));

	    for (i = 0; i < ncols; ++i)
		cols[i].pixel = i;

	    DBUG_PRINT("color",("colormap is full, we have %d colors",ncols));
	    XQueryColors(dpy, colormap, cols, ncols);

	    for (i = 0; i < ncols; ++i)
		{
		long c = /* color closeness */
		    (abs(exactColor.red   - cols[i].red) +
		     abs(exactColor.green - cols[i].green) +
		     abs(exactColor.blue  - cols[i].blue)) * 3
		    + /* brightness closeness */
		    abs((cols[i].red + cols[i].green + cols[i].blue) -
                        wanted_bn);

		if (c < best_closeness) 
		    {
		    best_closeness = c;
		    best_i = i;
		    }
		}

	    DBUG_PRINT("color",("best closeness %ld, minimal closeness %d\n",
				best_closeness, wafeColorCloseness*4));



	    if (best_i != -1 && best_closeness < (wafeColorCloseness*4)) 
		{
		Pixel best_pixel = cols[best_i].pixel;
		XAllocColor(DisplayOfScreen(screen), 
			    colormap, &cols[best_i]);
		DBUG_PRINT("color",("best color: %d %d %d",
				    cols[best_i].red,
				    cols[best_i].green,
				    cols[best_i].blue));
		XtFree((char *)cols);
		*closure_ret = (char*)True;
		CONVERSION_DONE(Pixel, best_pixel);
		}
	    else
		{
		XtFree((char *)cols);
		type = "noColormap";
		msg = "Cannot allocate colormap entry for \"%s\"";
		}
        }
        else {
            type = "badValue";
            msg = "Color name \"%s\" is not defined";
        }

	/*XtDisplayStringConversionWarning(dpy,(String)fromVal->addr,XtRPixel);
	  */

        XtAppWarningMsg(wafeAppContext, type, "cvtStringToPixel",
                        /*XtCXtToolkitError*/ "XtToolkitError", 
			msg, params, &num_params);

        *closure_ret = False;
        return False;
    } else {
        *closure_ret = (char*)True;
        CONVERSION_DONE(Pixel, screenColor.pixel);
    }
}
#endif
/***** END color converter  */


/* make the pointer array in a tcl-splitted list NULL terminated 
   (what a hack!)
*/
void
wafeFixSplittedList(argc,listPtr)
int argc;
String **listPtr;
    {
    String *argv = *listPtr;
    String *newArgv;
    char *list  = (char *)argv;
    char *last, *newString, *p, *q;
    int i,offset;
    Cardinal size;
    
    if (argc<1) 
	return;
    
    last = argv[argc-1];
    size = (last - list) + strlen(last)+1;
    newString = XtRealloc(list,size+4);
    newArgv = (String *)newString;

    offset = newString+4-list;
    for (i=0; i<argc; i++) 
	newArgv[i] += offset;

    last = newString + sizeof(String)*(argc+1) -1;
    for(p = newString+size-1, q = p+4;  p > last; p--,q--)
	*q = *p;

    newArgv[argc] = NULL;
    /*fprintf(stderr,"moved %d characters\n",i);*/

    /* fprintf(stderr,"[0]= %p %s, [1] %p %s [argc-1] %p %s\n",
	    newArgv[0], newArgv[0],
	    newArgv[1], newArgv[1],
	    newArgv[argc-1], newArgv[argc-1]); */
    *listPtr = (String *)newString;
    
    }
