/* make emcas happy -*-C-*-  make emacs happy */

#include <ctype.h>
#include <Xm/AtomMgr.h>
#include <Xm/List.h>
#include <X11/IntrinsicP.h>

#include <wafe_quarks.h>

#ifdef MOTIF20
#define WAFE_FONTLIST_TAG XmSTRING_COMPONENT_FONTLIST_ELEMENT_TAG
#else
#define WAFE_FONTLIST_TAG XmSTRING_COMPONENT_CHARSET
#endif

static XmStringCharSet defaultCharSet;

#define	CONVERSION_DONE(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}

extern Boolean wafeInstallImage(
#if NeedFunctionPrototypes
    Display *, String, String, Boolean, int *
#endif
);

/*
 * Initialize the default character Set variable!
 */

void
wafeMotifInit()
    {
    XmStringContext   context;
    char              *text = NULL;
    XmString          dummy = XmStringCreateSimple(wafe_ONE);
    String            pixmapClasses[] = 
	{
	XmRBackgroundPixmap,
	XmRGadgetPixmap,
	XmRManBottomShadowPixmap,
	XmRManForegroundPixmap,
	XmRManHighlightPixmap,
	XmRManTopShadowPixmap,
	XmRPixmap,
	XmRPrimBottomShadowPixmap,
	XmRPrimForegroundPixmap,
	XmRPrimHighlightPixmap,
	XmRPrimTopShadowPixmap,
	XmRXmBackgroundPixmap,
#ifdef MOTIF20
	XmRDynamicPixmap,
#endif
	NULL
	}, *p = pixmapClasses;

    XmStringCharSet    tag;
    XmStringComponentType unknown_tag;
    XmStringComponentType type;
    unsigned short     unknown_length;
    unsigned char     *unknown_value;
    XmStringDirection  dir;

    if (!XmStringInitContext(&context, dummy))
	wafeFatal("motif","Could not create String Context",NULL);


    while ((type = XmStringGetNextComponent(context, &text, &tag, &dir, 
					    &unknown_tag,&unknown_length,
					    &unknown_value))
	   != XmSTRING_COMPONENT_END)
	{
	DBUG_PRINT("motif", 
		   ("type %d, textsegment '%s', tag '%s', dir %d, u_tag %d",
		    type, text, tag, dir, unknown_tag));
	if (type == WAFE_FONTLIST_TAG)
	    {
	    defaultCharSet = tag;
	    break;
	    }
	}

    if (text) XtFree(text);
    XmStringFree(dummy);
    XmStringFreeContext(context);

    DBUG_PRINT("motif",("defaultCharSet is <%s> Xm='%s'",
			defaultCharSet,XmSTRING_DEFAULT_CHARSET));

    while (*p) 
	wafeRegisterXpmTypeConverter(*p++, True);
    }

#ifndef MOTIF20
/* Motif 2.0 comes with such an procedure */
static XmString
XmStringConcatAndFree(s1, s2)
XmString s1;
XmString s2;
    {
    XmString result = XmStringConcat(s1, s2);
    XmStringFree(s1);
    XmStringFree(s2);
    return result;
    }
#endif /* !MOTIF20 */


XmString
wafeCvtStringToXmString(inString)
String inString;
    {
    XmStringDirection  dir = XmSTRING_DIRECTION_L_TO_R;
    XmString           result = NULL;
    char              *start, *end, *next, *csv, lastChar;
    Boolean            sep, readTag;
    
    wafeStringStruct cs_s;
    wafeString cs = &cs_s;   /* Char set */

    wafeStringInit(cs);
    wafeStringAppend(cs,XmSTRING_DEFAULT_CHARSET);
    csv = wafeStringValue(cs);

    /*
       fprintf(stderr, "Converting string <%s>\n", inString);
    */

    for (start = inString; *start; start = next)
	{
	for (end = start; *end && *end != '\n' && *end != '^'; end++);
	readTag = sep = False;
	
	if (*end)
	    {
	    next = end+1;
	    if (*end == '^')
		{
		if (*next == '^')
		    {
		    end = next;
		    next++;
		    }
		else
		    readTag = True;
		}
	    else
		sep = True; /* must be (*end == '\n') */
	    }
	else
	    next = end;

	/* terminate and create segment */
	lastChar = *end;
	*end = '\0';
	result = result ?
	    XmStringConcatAndFree(result, 
			  XmStringSegmentCreate(start, csv, dir, sep)) :
			  XmStringSegmentCreate(start, csv, dir, sep);
	*end = lastChar;
	
	if (readTag)
	    {
	    char *tagStart,*tagEnd;
	    int tagLength;
	    
	    for (; *end && !isalpha(*end); end++);
	    tagStart = end;
	    for (; *end && (isalpha(*end) || *end == '_'); end++);
	    tagEnd = end;
	    for (; *end && *end == ' '; end++);
	    next = *end ? end++ : end;

	    tagLength = tagEnd-tagStart;
	    if (tagLength == 0)
		wafeWarn(XmRXmString, "Ignoring empty tag", NULL,NULL,NULL);
	    else
	    if (tagLength == 2 && *tagStart == 'l' && *(tagStart+1) == 'r')
		dir = XmSTRING_DIRECTION_L_TO_R;
	    else
	    if (tagLength == 2 && *tagStart == 'r' && *(tagStart+1) == 'l')
		dir = XmSTRING_DIRECTION_R_TO_L;
	    else
		{
		wafeStringClear(cs);
		wafeStringAppendN(cs,tagStart,tagLength);
		csv = wafeStringValue(cs);
		}
	    }
	} /* for */

    if (!result) 
       result = XmStringSegmentCreate(wafe_EMPTY, csv, dir, False);

    return result;
    }


static XmStringTable
wafeCvtStringToXmStringTable(inString)
char * inString;
    {
    int argc;
    char ** argv;
    XmString *strTable, *t;
    int i;

    Tcl_SplitList(wafeInterpreter,inString, &argc,&argv);
    t = strTable = (XmString *)XtMalloc((argc+1)*sizeof(XmString));

    for ( i = 0; i < argc; i++, t++ )
	if (!(*t = wafeCvtStringToXmString(argv[i])))
	    {
	    wafeConvWarn("wafeCvtStringToXmStringTable", argv[i],XmRXmString);
	    XtFree((char *)argv);
	    return NULL;
	    }
    *t = NULL;

    XtFree((char *)argv);
    return (XmStringTable) strTable;
    }


/* Queries a XmString Value and translates it to a valid input string */

void
wafeCvtXmString2String(ws,compStr,returnTags)
wafeString    ws;
XmString      compStr;
Boolean       returnTags;
    {
    XmStringContext    context;
    XmStringDirection  dir,
                       lastDir = XmSTRING_DIRECTION_L_TO_R;
    char               *ptr;
    Boolean            firstCharSet = True;
    char              *text;
    XmStringCharSet    tag;
    XmStringComponentType unknown_tag;
    XmStringComponentType type;
    unsigned short     unknown_length;
    unsigned char     *unknown_value;

    DBUG_ENTER("wafeCvtXmString2String");

    if (!XmStringInitContext(&context, compStr))
	{
	wafeWarn("motif", "Could not obtain String Context", NULL,NULL,NULL);
	DBUG_VOID_RETURN;
	}

    while ((type = XmStringGetNextComponent(context, &text, &tag, &dir, 
					    &unknown_tag,&unknown_length,
					    &unknown_value))
	   != XmSTRING_COMPONENT_END)
	{

	DBUG_PRINT("motif", ("type %d, dir %d, u_tag %d",
			     type, dir, unknown_tag));

	switch (type)
	    {
	case XmSTRING_COMPONENT_TEXT:
#ifdef MOTIF12
	case XmSTRING_COMPONENT_LOCALE_TEXT:
#endif
	    if (returnTags)
		{
		char *t = text;
		DBUG_PRINT("motif", ("text segment '%s'", text));
		do
		    {
		    for (ptr = t; *ptr && *ptr != '^'; ptr++);
		    wafeStringAppendN(ws, t, ptr-t);
		    if (*ptr == '^') 
			{
			wafeStringAppend(ws, "^^");
			t = ++ptr;
			}
		    } while (*ptr);
		}
	    else
		wafeStringAppend(ws, text);

	    XtFree(text);
	    break;

	case XmSTRING_COMPONENT_SEPARATOR:
	    wafeStringAppendChar(ws, '\n');
	    break;

	case XmSTRING_COMPONENT_DIRECTION:
	    if (returnTags && dir != lastDir)
		{
		if (dir == XmSTRING_DIRECTION_L_TO_R)
		    wafeStringAppend(ws, "^lr ");
		else
		    wafeStringAppend(ws, "^rl ");
		lastDir = dir;
		}
	    break;

        case WAFE_FONTLIST_TAG:
	    DBUG_PRINT("motif",
		       ("firstCharSet %d, tag='%s', defaultCharSet='%s'",
			firstCharSet,tag,defaultCharSet));
	    if (returnTags && !(firstCharSet && 
		  (!strcmp(tag, defaultCharSet) || 
		   !strcmp(tag, XmFONTLIST_DEFAULT_TAG)
		   ))
		)
		{
		wafeStringAppendChar(ws, '^');
		wafeStringAppend(ws, tag);
		wafeStringAppendChar(ws, ' ');
		firstCharSet = False;
		}
	    XtFree(tag);
	    break;

	case XmSTRING_COMPONENT_UNKNOWN:
	    wafeWarn("motif", "Unknown component in XmString ignored!",
		     NULL,NULL,NULL);
	    break;
	    }
	
	}
    
    XmStringFreeContext(context);
    DBUG_VOID_RETURN;
    }


void
wafeStringAppendXmEscaped(ws,compStr)
wafeString ws;
XmString   compStr;
    {
    wafeStringStruct   ws0_struct;
    wafeString         ws0 = &ws0_struct;
    wafeStringInit(ws0);
    wafeCvtXmString2String(ws0,compStr,True);
    wafeStringAppendEscaped(ws,wafeStringValue(ws0),wafeStringLength(ws0));
    wafeStringClear(ws0);
    }

static int
currentStringTableSize () 
    {
    int count = 0;
    if (wafeCurrentWidget && wafeCurrentAttrib)
	    {
	    /* try hard to figure out what the length of the XmStringTable is.
	     *
	     * i have tried before the following code, which was not reliable; 
	     * if somebody knows a better way, how to determine the number of 
	     * items in a XmStringTable please, let me know
	     *
	     *  for (; strTable[count] && 
	     *         ((unsigned)strTable[count] & 0xffff0000) && 
	     *       *strTable[count] == 0xdf; count++) 
	     */
	
	    if (XtClass(wafeCurrentWidget) == xmListWidgetClass)
		{
		if (wafeCurrentAttrib == qitems)
		    XtVaGetValues(wafeCurrentWidget, 
				  XmNitemCount, &count, NULL);
		else 
		    if (wafeCurrentAttrib == qselectedItems)
			XtVaGetValues(wafeCurrentWidget, 
				      XmNselectedItemCount, &count, NULL);
		}
	    else
		wafeWarn(XmRXmString,
			 "No XmStringTables known for class %s",
			 (XtClass(wafeCurrentWidget)->core_class.class_name),
			 NULL,NULL);
	    }
	else
	    wafeWarn(XmRXmString,"Cannot determine size of XmStringTable",
		     NULL,NULL,NULL);
    return count;
    }


String
wafeCvtXmStringTable2String(count,strTable)
int           count;
XmStringTable strTable;
    {
    char     **temp, **cPtr;
    XmString  *ptr;
    char      *result;
    int        i;
    wafeStringStruct   ws_struct;
    wafeString         ws = &ws_struct;

    DBUG_ENTER("wafeCvtXmStringTable2String");

    wafeStringInit(ws);
    
    if (count == -1)
	count = currentStringTableSize();

    temp = (char **)XtMalloc(count*sizeof(char *));
    for (ptr=strTable, cPtr=temp, i=count; i>0; ptr++, cPtr++, i--)
	{
	wafeCvtXmString2String(ws,*ptr,True);
	*cPtr = XtNewString(wafeStringValue(ws));
	wafeStringClear(ws);
	}

    result = Tcl_Merge(count, temp);
    for (cPtr = temp, i=count; i>0; cPtr++, i--)
	XtFree(*cPtr);

    XtFree((char *)temp);
    DBUG_RETURN (result);
    }

void
wafeStringAppendXmStringTableEscaped(ws,count,strTable)
wafeString    ws;
int           count;
XmStringTable strTable;
    {
    XmString  *ptr;
    int        i;
    wafeStringStruct   ws0_struct;
    wafeString         ws0 = &ws0_struct;

    DBUG_ENTER("wafeCvtXmStringTable2StringEscaped");

    if (count == -1)
	count = currentStringTableSize();

    DBUG_PRINT(XmRXmString,("count %d",count));
    
    if (count>0)
	{
	wafeStringInit(ws0);    
	for (ptr=strTable, i=count; i>0; ptr++, i--)
	    {
	    wafeCvtXmString2String(ws0,*ptr,True);
	    wafeStringAppendListItemEscaped(ws,wafeStringValue(ws0));
	    wafeStringClear(ws0);
	    }

	ws->length--;
	ws->buffer[ws->length] = 0;
	}

    DBUG_VOID_RETURN;
    }

/*
 * Two converter function wrappers for the *2String functions, which are
 * called by getValues
 */

static Boolean
CvtXmStringToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    wafeStringStruct   ws_struct;
    wafeString         ws = &ws_struct;

    DBUG_ENTER("CvtXmStringToString");
    wafeStringInit(ws);
    wafeCvtXmString2String(ws,(XmString)(fromVal->addr),True);
    toVal->addr = XtNewString(wafeStringValue(ws));
    toVal->size = wafeStringLength(ws); 
    wafeStringClear(ws);
    DBUG_RETURN(True);
    }


static Boolean
CvtXmStringTableToString(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static char *result;
    DBUG_ENTER("CvtXmStringTableToString");
    result = wafeCvtXmStringTable2String(-1,(XmStringTable)(fromVal->addr));
    toVal->addr = result;
    toVal->size = 1; /* it should not matter either */
    DBUG_RETURN(True);
    }


static void
freeXmStringTable(table)
XmStringTable  table;
    {
    XmStringTable t = table;
    while (*t != NULL)
	XmStringFree(*t++);
    XtFree((char *)table);
    }	


Boolean
CvtStringToXmStrings(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    int               argc, count;
    char            **argv;
    XmString         *ptr;
    static XmString  *result;

    DBUG_ENTER("CvtStringToXmStrings");

    if (Tcl_SplitList(wafeInterpreter,(char*)fromVal->addr, &argc, &argv)
	!= TCL_OK)
	{
	wafeWarn("CvtStringToXmStrings", wafeInterpreter->result,
		 NULL,NULL,NULL);
	return False;
	}


    result = (XmString *)XtMalloc((argc+1)*sizeof(XmString));
    for(count = 0, ptr = result; count < argc; count++, ptr++)
	{
	if ((*ptr = wafeCvtStringToXmString(argv[count],NULL,0)) == NULL)
	    {
	    XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr,
					     XmRString);
	    XtFree((char *)result);
	    XtFree((char *)argv);
	    return False;
	    }
	}
    *ptr = NULL;
    XtFree((char *)argv);

    if (toVal->addr)
	{
	wafeWarn("CvtStringToXmStrings", 
		 "somebody else called CvtStringToXmStrings",
		 NULL,NULL,NULL);
	
	if (toVal->size < sizeof(XmString *))
	    {
	    toVal->size = sizeof(XmString *);
	    XtFree((char *)result);
	    DBUG_RETURN(False);
	    }

	toVal->size = sizeof(XmString *);
	*(XmString **)(toVal->addr) = result;
	DBUG_RETURN(True);
	}

    toVal->size = sizeof(XmString **);
    toVal->addr = (caddr_t)&result;
    wafeMMreplace(NULL,NULL, wafeCurrentAttrib,
		  (char *)result, freeXmStringTable);
    DBUG_RETURN(True);
    }


Boolean
CvtStringToXmString(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static XmString  result;
    DBUG_ENTER("CvtStringToXmString");

    DBUG_PRINT("CvtStringToXmString",
	       ("CvtStringToXmString: <%s> (toval: %p %d)\n",
		fromVal->addr, toVal->addr, toVal->size));


    if ((result = wafeCvtStringToXmString((char *)fromVal->addr, NULL, 0)) == NULL)
	{
	XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr,
					 XmRXmString);
	DBUG_RETURN(False);
	}

    if (toVal->addr)
	{
	if (toVal->size < sizeof(XmString))
	    {
	    toVal->size = sizeof(XmString);
	    XmStringFree(result);
	    DBUG_RETURN(False);
	    }

	toVal->size = sizeof(XmString);
	*(XmString *)(toVal->addr) = result;
	DBUG_RETURN(True);
	}

    toVal->size = sizeof(XmString *);
    toVal->addr = (XtPointer)result;

    wafeMMreplace(NULL,NULL, wafeCurrentAttrib,
		  (char *)result, (freeProc)XmStringFree);
    DBUG_RETURN(True);
    }


static Boolean
CvtStringToLong(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    long result;

    if (sscanf((char *)fromVal->addr, "%ld", &result) == 1)
	{
	CONVERSION_DONE(long, result);
	}
    else
	return False;
    }


#include <Xm/Protocols.h>
static void
wafeAddProtocol(w, property, protocol)
Widget   w;
Atom     property, protocol;
    {
    XmAddProtocols(w,property,&protocol,1);
    }

static void
protocolCallbackProc(w, clientData, callData)
Widget w;
XtPointer clientData;
XtPointer callData;
    {
    DBUG_ENTER("protocolCallbackProc");
    wafeExecCallbackProc(w, clientData, callData);
    DBUG_VOID_RETURN;
    }

static void
wafeAddProtocolCallback(w, property, protocol, string)
Widget   w;
Atom     property, protocol;
String   string;
    {
    char *charp = XtMalloc(strlen(string)+1+sizeof(XrmQuark));

    *(XrmQuark *)charp = (XrmQuark)0;
    strcpy((char *)charp + sizeof(XrmQuark), (char *)string);
    XmAddProtocolCallback(w, property, protocol, 
			  protocolCallbackProc, 
			  (XtPointer)charp);
    }

int
wafeModifyVerifyCBset(doit, currInsert, startPos, endPos, string)
Boolean doit;
long currInsert, startPos, endPos;
String string;
    {
    XmTextVerifyCallbackStruct *cbs = 
	(XmTextVerifyCallbackStruct *)wafeCurrentCallData;
    int newLength =  strlen(string);

    DBUG_ENTER("wafeModifyVerifyCBset");
    
    if (!cbs || cbs->reason !=  XmCR_MODIFYING_TEXT_VALUE) 
	DBUG_RETURN(wafeSetError("calling wafeModifyVerifyCBset is only valid from a modifyVerifyCallback",NULL,NULL,NULL));

    cbs->doit = doit;

    if (doit)
	{
	if (currInsert>=0) cbs->newInsert    = currInsert;
	if (startPos>=0)   cbs->startPos     = startPos;
	if (endPos>=0)     cbs->endPos       = endPos;

	if (newLength>0) 
	    {
	    if (newLength >= cbs->text->length) 
		cbs->text->ptr = XtRealloc(cbs->text->ptr,newLength+1);
	    
	    strcpy(cbs->text->ptr, string);
	    cbs->text->length = newLength;
	    }
	else 
	    {
	    if (cbs->text->length>0) 
		XtFree(cbs->text->ptr);
	    cbs->text->ptr    = NULL;
	    cbs->text->length = 0;
	    }
	}

    DBUG_RETURN(TCL_OK);
    }

#include <Xm/FileSB.h>

static void
fileSearchProc(w, searchData)
Widget  w;
XmFileSelectionBoxCallbackStruct *searchData;
    {
    char *cmd;
    DBUG_ENTER("fileSearchProc");
    if ((cmd = wafeMMgetValue(w, qfileSearchProc, NULL, False)))
	wafeExecCallbackProc(w, (XtPointer)cmd, searchData);

    DBUG_VOID_RETURN;
    }

static void
dirSearchProc(w, searchData)
Widget  w;
XmFileSelectionBoxCallbackStruct *searchData;
    {
    char *cmd;
    DBUG_ENTER("dirSearchProc");
    if ((cmd = wafeMMgetValue(w, qdirSearchProc, NULL, False)))
	wafeExecCallbackProc(w, (XtPointer)cmd, searchData);

    DBUG_VOID_RETURN;
    }



Boolean
CvtStringToFileSearchProc(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    if (wafeCurrentAttrib == qfileSearchProc || 
	wafeCurrentAttrib == qdirSearchProc   ) 
	{
	char *charp = XtMalloc(strlen(fromVal->addr)+1+sizeof(XrmQuark));
	XtPointer proc = (wafeCurrentAttrib == qfileSearchProc) ? 
		(XtPointer)fileSearchProc : 
                (XtPointer)dirSearchProc;

	*(XrmQuark *)charp = wafeCurrentAttrib;
	strcpy((char *)charp + sizeof(XrmQuark), (char *)fromVal->addr);
	wafeMMreplace(NULL, NULL, wafeCurrentAttrib,
		      (char *)charp, XtFree);

	CONVERSION_DONE(XtPointer, proc);
	} 
    else 
	return False;
    }


int
XmGetString(w,resource)
Widget w;
String resource;
    {
    XrmQuark qResName   = XrmStringToQuark(resource);
    XrmQuark qType;
    
    if (!(qType = wafeGetQTypeOfAttribute(XtClass(w),
					  ParentWidget(w),qResName,NULL)))
	return wafeSetError("widget %s has no resource %s",
			    wafeWidgetToName(w), resource, NULL);

    if (qType == qXmString) 
	{
	XmString s;
	wafeStringStruct   ws_struct;
	wafeString         ws = &ws_struct;
	wafeStringInit(ws);
	XtVaGetValues(w,resource,&s,NULL);
	wafeCvtXmString2String(ws, s, False);
	Tcl_SetResult(wafeInterpreter, wafeStringValue(ws), TCL_VOLATILE);
	wafeStringClear(ws);
	}
    else 
    if (qType == qString) 
	{
	String returnString = NULL;
	XtVaGetValues(w,resource,&returnString,NULL);
	Tcl_SetResult(wafeInterpreter, returnString, TCL_VOLATILE);
	}
    else
	{
	return wafeSetError("resource %s is not of type String or XmString",
			    resource, NULL, NULL);
	/* maybe we should handle XmStringTables here as well */
	}
    return TCL_OK;
    }
