#> The HTML Widget can be compiled with Athena or Motif versions of Wafe.

$PACKAGE = "HTML";

~handles 
	HTML

#include <errno.h>
#include <HTML.h>
#define hTMLWidgetClass htmlWidgetClass
#ifndef X_NOT_STDC_ENV
#include <stdlib.h>
#else
char *malloc(), *realloc(), *calloc();
#endif

~require
gifread.inc

~require
xpmread.inc

~require
html.inc
	quark "pointerMotionCallback"
	privateQuark imageList
	privateString HTMLWidget
	conv XtRString WbCPointerMotionCallback None CvtStringToHTMLmotionCallbackProc

#> The 'HTML' widget class can be used to display HTML (HyperText
#> Markup Language) documents (which may contain references to
#> graphics in form of GIF or XPM). When needed scrollbars are added.

~widgetClass
HTML
	include <HTML.h>
	createCmd crtHtmlWidget
	anchor t EscapedString: \
		((WbAnchorCallbackData *)callData)->text \
			# text
	anchor h EscapedString: \
		((WbAnchorCallbackData *)callData)->href \
			# hypertext reference
	anchor i int: \
		((WbAnchorCallbackData *)callData)->element_id \
			# element id
	submitForm h EscapedString: \
		((WbFormCallbackData *)callData)->href \
			# hypertext reference
	submitForm n stringTable: \
		((WbFormCallbackData *)callData)->attribute_count, \
		((WbFormCallbackData *)callData)->attribute_names \
			# attribute names
	submitForm v stringTable: \
		((WbFormCallbackData *)callData)->attribute_count, \
		((WbFormCallbackData *)callData)->attribute_values \
			# attribute values
 	pointerMotion h EscapedString: \
		(String)callData		# hypertext reference
 	link h EscapedString: \
		((LinkInfo *)callData)->href 	# hypertext reference
 	link r EscapedString: \
		((LinkInfo *)callData)->role 	# role

#> The function 'HTMLGetText' is a convenience function to return the
#> text of the HTML document as a plain ascii text string.  When the
#> 2nd argument is two or larger, Postscript is returned. The font
#> used is encoded in the pretty parameter: 
#>   * pretty = 2: Times
#>   * pretty = 3: Helvetica
#>   * pretty = 4: New century schoolbook
#>   * pretty = 5: Lucida Bright

(String) VString
HTMLGetText
	in: HTMLWidget     # HTML Widget
	in: int            # Pretty Code 0-5

#> The function 'HTMLGetText' is a convenience function to return the
#> text of the HTML document as a single white space separated string,
#> with pointers to the various start and end points of selections.

(String) VString
HTMLGetTextAndSelection
	in: HTMLWidget    # HTML Widget
	out: String       # Selection starts
	out: String       # Selection ends
	out: String       # Insertion Points

#> The function 'HTMLGetHRefs' returns the HREFs of all active anchors in
#> the document. Function returns an array of strings and fills num_hrefs
#> passed. If there are no HREFs an empty string is returned .

(String) DString
hTMLGetHRefs vulgo HTMLGetHRefs
	in: HTMLWidget    # HTML Widget

#> The function 'HTMLPositionToId' returns the element id of the element
#> nearest to the x,y coordinates passed in.  If there is no element
#> there, return the first element in the line we are on.  If there we
#> are on no line, either return the beginning, or the end of the
#> document.

int
HTMLPositionToId
	in: HTMLWidget    # HTML Widget
	in: int           # x Coordinate
	in: int           # y Coordinate

#> The function 'HTMLIdToPosition' returns the position of the element
#> based on the element id passed in.  Function returns 1 on success
#> and fills in x,y pixel values.  If there is no such element, x=0,
#> y=0 and -1 is returned.

int 
HTMLIdToPosition
	in: HTMLWidget     # HTML Widget
	in: int	           # Element ID
	out: int           # x Coordinate
	out: int           # y Coordinate

#> The function 'HTMLAnchorToPosition' returns the position of the
#> anchor based on the anchor NAME passed.  Function returns 1 on
#> success and fills in x,y pixel values.  If there is no such
#> element, x=0, y=0 and -1 is returned.

int 
HTMLAnchorToPosition
	in: HTMLWidget     # HTML Widget
	in: String         # Anchor's name
	out: int           # x Coordinate
	out: int           # y Coordinate

#> The procedure 'HTMLClearSelection' clears the current selection.

void
HTMLClearSelection
	in: HTMLWidget     # HTML Widget

#> The procedure 'HTMLSetSelection' sets the current selection
#> based on the ElementRefs passed in. Both refs must be valid (and contain
#> the integers id and pos)

void 
HTMLSetSelection
	in: HTMLWidget         # HTML Widget
	in: ElementRef         # start
	in: ElementRef	       # end


#> The procedure 'HTMLSetText' sets the raw text into the widget and
#> forces a reparse and a reformat.  If String is passed in as NULL
#> that text is unchanged, if a pointer points to an empty string,
#> that text is set to NULL; Also pass an element ID to set the view
#> area to that section of the new text.  Finally, and an anchor NAME
#> can be provided as last arguemnt to scroll to the position of the
#> new text.

void 
HTMLSetText	
	in: HTMLWidget         # HTML Widget
	in: String             # Text
	in: String	       # Header Text
	in: String	       # Footer Text
	in: int		       # element_id
	in: String	       # target_anchor
	const: NULL

#> The function 'HTMLSearchText' is used to search the text of the
#> HTML document as a single white space separated string. Linefeeds
#> are converted into spaces.
#> 
#> Takes a pattern, pointers to the start and end blocks to store the
#> start and end of the match into.  Start is also used as the location to
#> start the search from for incremental searching.  If start is an invalid
#> position (id = 0).  Default start is the beginning of the document for
#> forward searching, and the end of the document for backwards searching.
#> The backward and caseless parameters I hope are self-explanatory.
#> 
#> returns 1 on success
#>      (and the start and end positions of the match).
#> returns -1 otherwise (and start and end are unchanged).

#define searchtext(w, s, instart, outstart, outend, back, sens) \
	HTMLSearchText(w, s, instart, outend, back, sens); \
	(*outstart).id = (*instart).id; (*outstart).pos = (*instart).pos; 

int 
searchtext vulgo HTMLSearchText
	in: HTMLWidget         # HTML Widget
	in: String             # Pattern
	in: ElementRef         # Start
	out: ElementRef        # Result: Start
	out: ElementRef        # Result: End
	in: int		       # Backward
	in: int		       # Case Sensitive


#> The procedure 'HTMLGotoId' is used to position the element
#> based on the element id passed at the top of the viewing area.
#> A passed in id of 0 means goto the top.

void
HTMLGotoId
	in: HTMLWidget		# HTML Widget
	in: int 		# Element ID

#> The function 'HTMLAnchorToId' returns the element id of the anchor
#> based on the anchor NAME passed.  Function returns id on success.
#> If there is no such element, 0 is returned.

int
HTMLAnchorToId
	in: HTMLWidget		# HTML Widget
	in: String		# Anchor string

#
# experimental Wafe functions
#

Boolean
HTMLIdToElement
	in: HTMLWidget		# HTML Widget
	in: int	       		# Element ID
	out: HTMLElementRecord* # Element Record

void
HTMLsetElementBg
	in: HTMLWidget 		# HTML Widget
	in: int	       		# Element ID
	in: String              # backgroundColor

#> The procedure 'HTMLRetestAnchors' is used to redraw all active
#> anchors in the document.  

void 
HTMLRetestAnchors
	in: HTMLWidget		# HTML Widget
	const: NULL

#(String) DString
#HTMLgetElementRecords
#	in: HTMLWidget		# HTML Widget

#> The function 'HTMLgetMarkUp' returns a list of markup elements where
#> each element has the form <type offset text>, where type specifies
#> the type of markup (text or various tags), offset is the byte
#> offset of the text in the raw html text, and text is the text
#> element.

(String) DString
HTMLgetMarkUp
	in: HTMLWidget		# HTML Widget

