#> The Commands described in this section are these introduced by
#> Motif Version 1.2. Note that in Wafe versions compiled with Motif 1.2
#> the commands from sections Motif 1.1 and Motif 1.2 are available.

$PACKAGE = "MOTIF12";

#include <X11/Shell.h>
#include <Xm/RepType.h>
#include <Xm/Text.h>
#include <Xm/ScrolledW.h>

~handles 
	MOTIF12


~require
motif12.inc
	conv XtRString XmRDropTransfers None CvtStringToDropTransfers
	conv XtRString XmRCallbackProc  None CvtStringToCallbackProc
	conv XtRString "SelectionCallbackProc" None CvtStringToSelectionCallbackProc
	conv XtRString "ConvertSelectionIncrProc" None CvtStringToConvertSelectionIncrProc
	conv XtRString XmCDragOperations None CvtStringToDragOperations
	conv XtRString XmRDropSiteOperations None CvtStringToDragOperations
	conv XtRString XmRTransferStatus None CvtStringToTransferStatus
	init XmRepTypeInstallTearOffModelConverter();
	quark XmNdragProc
	quark XmNdropProc
	quark XmNtransferProc
	quark XmNconvertProc


#include <Xm/DragDrop.h>

~objectClass 
XmDropSiteManager
	include <Xm/DragDrop.h>
  	addres XmNanimationMask        XmRPixmap
 	addRes XmNanimationPixmap      XmRPixmap
	addRes XmNanimationPixmapDepth XmRInt
	addRes XmNanimationStyle       XmRAnimationStyle
	addRes XmNdragProc             XmRCallbackProc
	addRes XmNdropProc             XmRCallbackProc
	addRes XmNdropRectangles       XmRRectangleList
	addRes XmNdropSiteActivity     XmRDropSiteActivity
	addRes XmNdropSiteOperations   XmRDropSiteOperations
	addRes XmNdropSiteType         XmRDropSiteType
	addRes XmNimportTargets        XmRAtomList
	addRes XmNnumRectangles        XmRCardinal
	addRes XmNnumImportTargets     XmRCardinal
	dragProc c WidgetID: \
		(WidgetID)((XmDragProcCallbackStruct *)callData)->dragContext 	# dragContext
	dragProc x Position: \
		((XmDragProcCallbackStruct *)callData)->x 		# x position
	dragProc y Position: \
		((XmDragProcCallbackStruct *)callData)->y	 	# y position
	dragProc o int: \
		((XmDragProcCallbackStruct *)callData)->operation 	# operation
	dragProc O int: \
		((XmDragProcCallbackStruct *)callData)->operations 	# operations


~widgetClass
XmDragContext
	dropProc c WidgetID: \
		(WidgetID)((XmDropProcCallbackStruct *)callData)->dragContext 	# dragContext
	dropProc x Position: \
		((XmDropProcCallbackStruct *)callData)->x 		# x position
	dropProc y Position: \
		((XmDropProcCallbackStruct *)callData)->y	 	# y position
	dropProc o int: \
		((XmDropProcCallbackStruct *)callData)->operation 	# operation
	dropProc O int: \
		((XmDropProcCallbackStruct *)callData)->operations 	# operations
	convertProc t String: \
		(String)callData					# target widget
	addRes XmNconvertProc "ConvertSelectionIncrProc"
	addRes XmNdragOperations XmCDragOperations

~objectClass
XmDropTransfer
	addRes XmNtransferProc "SelectionCallbackProc"
	transferProc d WidgetID: \
		(WidgetID)((dropTransferCallbackStruct *)callData)->dest	# destination widget
	transferProc v String: \
		(String)((dropTransferCallbackStruct *)callData)->value		# value
	
	
#define convertSpecialResources(command,w,class,argc,argv) {\
    ArgList           args; \
    int               numArgs; \
    XtInitializeWidgetClass(class); \
    if (wafeConvert(ParentWidget(w), class, \
		argv, &argc, &args, &numArgs, w)) { \
	command(w, args, numArgs); \
	wafeCurrentAttribList = NULL; \
	XtFree((String)args); \
	} \
    } 


void
convertSpecialResources vulgo XmDropSiteRegister 
	const: XmDropSiteRegister
	in: Widget		# Widget to be registered
	const: xmDropSiteManagerObjectClass
	in: [args avp]          # drop site resources

void
convertSpecialResources vulgo XmDropSiteUpdate
	const: XmDropSiteUpdate
	in: Widget		# Drop site to be modified
	const: xmDropSiteManagerObjectClass
	in: [args avp]          # drop site resources

void
XmDropSiteUnregister
	in: Widget		# Widget to be unregistered

void
XmDropSiteStartUpdate
	in: Widget		# Widget to identify shell with multiple drop sites

void
XmDropSiteEndUpdate
	in: Widget		# Widget to identify shell with multiple drop sites


#define createDnDWidget4(c,w,x,y) c(w,args,numArgs)
#define createDnDWidget5(c,w,e,x,y) c(w,e,args,numArgs)

WidgetID (WidgetID)
createDnDWidget4 vulgo XmDropTransferStart
        pre: { ArgList args; int numArgs; \
	       currentDragContext = localVar1; \
               wafeConvert(localVar1,xmDropTransferObjectClass,argvArg,&argc,&args,&numArgs, NULL);
        const: XmDropTransferStart
	in: Widget		# Drag Context
	in: [args avp]          # Drop Transfer Resources
        post: wafeMMsetAttribList((Widget)returnVar); \
	      wafeCurrentAttribList = NULL; \
	      XtAddCallback((Widget)returnVar,XtNdestroyCallback,CBfreeAttribs,NULL); \
	      XtFree((char*)args); }

WidgetID (WidgetID)
createDnDWidget5 vulgo XmDragStart
        pre: { ArgList args; int numArgs; \
               wafeConvert(localVar1,xmDragContextClass,argvArg,&argc,&args,&numArgs, NULL);
        const: XmDragStart
	in: Widget		# Widget (source for drag and drop)
	const: wafeCurrentEvent
	in: [args avp]          # Drag Context Resources
        post: wafeMMsetAttribList((Widget)returnVar); \
	      wafeCurrentAttribList = NULL; \
	      XtAddCallback((Widget)returnVar,XtNdestroyCallback,CBfreeAttribs,NULL); \
	      XtFree((char*)args); }

#	      XtVaSetValues((Widget)returnVar,XmNconvertProc,convertSelectionIncrProc); 

# ... seems broken, but we don't need it ...
# void
# XmDropTransferAdd
#	in: XmDropTransferObject
#	in: XmDropTransferEntryRec*
#	in: int

void
XmChangeColor
	in: Widget		# widget
	in: Pixel		# color string for background

void
XmTextDisableRedisplay
	in: XmTextWidget 	# XmText widget

Boolean
XmTextFindString
      	in: XmTextWidget        # XmText widget
	in: XmTextPosition	# start
	in: String		# search string
	in: XmTextDirection	# TEXT_FORWARD | TEXT_BACKWARD
	out: XmTextPosition	# startposition of the found string

void
XmTextEnableRedisplay
	in: XmTextWidget 	# XmText widget

void
XmScrollVisible
	in: XmScrolledWindowWidget	# scrolled window
	in: Widget			# widget to be made visible
	in: Dimension			# left-right margin for positioning
	in: Dimension			# top-botton margin for positioning
