/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 * 
 */

/*
 * This file was generated by genc.
 * Be aware that modifications of this file will be lost,
 * when genc is executed!

Creation: Sun Feb 26 00:02:37 EST 1995 on mohegan
Author: genc
Version: 1.0.8

 */

#define ATHENA_C
#include <wafe.h>
/*
static _Xconst Proc_signature cmds[];
static WidgetCreate_signature wccs[];
*/
#ifdef ATHENA
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#ifdef PRER6
#include <X11/Xaw/Clock.h>
#endif
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Grip.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
#ifdef PRER6
#include <X11/Xaw/Logo.h>
#endif
#ifdef PRER6
#include <X11/Xaw/Mailbox.h>
#endif
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/StripChart.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Viewport.h>
 extern XrmQuark qjumpProc;
 extern XrmQuark qscrollProc;
 extern XrmQuark qradioData;
 extern XrmQuark qlist;
 extern XrmQuark qlongest;
 extern XrmQuark qnumberStrings;

/* treat me like a -*- c -*- program */

#include "wafe_quarks.h"

#define MAX_ITEM_LENGTH 200
/* KLUDGE KLUDGE KLUDGE for callbacks provided via resource mechanisms */
#define setQuark(resName,quark) \
    XtVaGetValues(newWidget, (resName), &callbackList, NULL); \
    if (callbackList && \
	callbackList->callback == (XtCallbackProc)wafeExecCallbackProc) \
	*(XrmQuark *)callbackList->closure = (quark)

/****************************************************************************
 *    FUNCTION:  name2Sink, name2Source
 *                                                                          
 *    Arguments: string containing an instance's name
 *    Returns:   source/sink widget of named text widget
 *                                                                          
 *****************************************************************************/

static Widget 
name2Sink(string)
char * string;
    {
    Widget localVar1, sink = NULL;

    if (!(localVar1 = name2Widget(string)))
	{
	wafeConvWarn("name2Sink",string,XtRWidget);
	return(NULL);
	}

    XtVaGetValues(localVar1, XtNtextSink, &sink, NULL);
    return(sink);
    }

/************** list widget support routines ******/
#include <X11/Xaw/List.h>

static int
listChange(w, nitems, longest, resize, argc, argv)
Widget     w;
int        nitems;
int        longest;
int        resize;
int           argc;
char        **argv;
    {
    FILE    *fp;
    int      i, size=0;
    char   **list, **count, *offset;
    char     buffer [MAX_ITEM_LENGTH];
    static _Xconst String procName = "listChange";
    
    DBUG_ENTER(procName);
    
    if (!strcmp(argv[0], "List"))
	{
	  if (argc != 2)
	      {
	      wafeWarn(procName, "wrong number of arguments",
		       NULL,NULL,NULL);
	      DBUG_RETURN(TCL_ERROR);
	      }

	  if (Tcl_SplitList(wafeInterpreter,argv[1], &nitems, &list) != TCL_OK)
	      {
	      wafeWarn(procName, wafeInterpreter->result,
		       NULL,NULL,NULL);
	      DBUG_RETURN(TCL_ERROR);
	      }
	  }
    else 
    if (!strcmp(argv[0], "Arg"))
	{
        for (i = 1; i < argc; i++) 
	    size += strlen(argv[i])+1;
	
	list = count = (char **)XtMalloc((argc)*sizeof(char *)+size); 
	offset = (char *)list + (argc)*sizeof(char *);

	for (i = 1; i < argc; i++)
	    {
	    *count = offset;
	    strcpy(offset,argv[i]);
	    offset += strlen(argv[i])+1;
	    count++;
	    }

	*count = NULL;
	}
    else
    if (!strcmp(argv[0], "File"))
	{
	char **tmpList, **saveStart;

	if (argc != 2)
	    {
	    wafeWarn(procName, "wrong number of arguments",
		       NULL,NULL,NULL);
	    DBUG_RETURN(TCL_ERROR);
	    }

	if (!(fp = fopen(argv[1], "r")))
	    {
	    wafeWarn(procName, "Couldn't open File %s",
		       argv[1],NULL,NULL);
	    DBUG_RETURN(TCL_ERROR);
	    }

	saveStart = tmpList = count = (char **)XtMalloc(10*sizeof(char *));
	i = 0;

	while (fgets(buffer, 200, fp))
	    {
	    int len = strlen(buffer);
	    *count = XtNewString(buffer);
	    size += len + 1;
	    *(*count + len - 1) = '\0';
	    count++; i++;
	    if (!(i % 10))
		{
		DBUG_PRINT("ListWidget", ("Realloc"));
		saveStart = tmpList = (char**)XtRealloc((char *)tmpList,
						(i + 10)* sizeof(char *));
		count = tmpList + i;
		}
	    }
	*count = NULL;

	/* make it the list a single memory chunk to be 
         * compatible with the rest 
         */
	list = count = (char **)XtMalloc((i+1)*sizeof(char *)+size); 
	offset = (char *)list + (i+1)*sizeof(char *);

	while (*tmpList)
	    {
	    *count = offset;
	    strcpy(offset,*tmpList);
	    offset += strlen(*tmpList)+1;
	    XtFree(*tmpList);
	    tmpList++;
	    count++;
	    }
	*count = NULL;

        XtFree((char*)saveStart);
	}

    XawListChange(w, list, nitems, longest, resize);
    wafeMMreplace(w, NULL, qPointer, (char *)list,XtFree);

    DBUG_RETURN(TCL_OK);
    }

  
static void
listAppend(list, argc, argv)
Widget        list;
int           argc;
char        **argv;
    {
    char   **srcPtr, **trgtPtr;
    char   **newArray, **oldArray;
    int      nitems = 0;
    int      count;
    Boolean  resize;
    DBUG_ENTER("listAppend");
 
    XtVaGetValues(list, XtNlist, &oldArray, NULL);
    XtVaGetValues(list, XtNresize, &resize, NULL);
     
    for (srcPtr = oldArray; *srcPtr != NULL; srcPtr++)
	{
	nitems++;
	DBUG_PRINT("ListWidget", ("Checking %d", nitems));
	}

    newArray = (char **)XtMalloc((nitems * sizeof(char*)) + argc + 1);

    for(srcPtr = oldArray, trgtPtr = newArray; 
	*srcPtr != NULL; 
	srcPtr++, trgtPtr++)
	{          
	*trgtPtr = XtNewString(*srcPtr);
	DBUG_PRINT("ListWidget", ("Copied: <%s>", *trgtPtr));
	XtFree(*srcPtr);
	}

    XtFree((char *)oldArray);

    for (count = 0; count < argc; count++)
	{
	*trgtPtr = XtNewString(argv[count]);
	DBUG_PRINT("ListWidget", ("Added: <%s>", *trgtPtr));
	trgtPtr++;
	}

    *trgtPtr = NULL;

    XawListChange(list, newArray, 0, 0, resize);
    }


static Widget
listCreate(parent, name, args, numArgs)
Widget   parent;
char     *name;
ArgList  args;
Cardinal numArgs;
    {
    XtCallbackList callbackList = NULL;
    Widget newWidget = XtCreateWidget(name, listWidgetClass, 
				      parent, args, numArgs);
    setQuark(XtNcallback,qcallback);
    return(newWidget);
    }

void
wafeCheckListWidgetResources(numArgs,args, resetted,
			     mustResetNumberStrings, mustResetLongest)
int         numArgs;
ArgList     args;
Boolean     resetted;
Boolean    *mustResetNumberStrings;
Boolean    *mustResetLongest;
    {
    int i;
    Boolean     hasList;
    Boolean     hasNumberStrings;
#ifdef PRER6
    Boolean     hasLongest = False;
#endif

    hasList = hasNumberStrings = False;

    for (i = 0; i< numArgs; i++)
	{
	char *resName = args[i].name;
	if (*resName == 'l' && strcmp(resName,XtNlist) == 0)
	    hasList = True;
#ifdef PRER6
	else 
	if (*resName == 'l' && strcmp(resName,XtNlongest) == 0)
	    hasList = True;
#endif
	else 
	if (*resName == 'n' && strcmp(resName,XtNnumberStrings) == 0)
	    hasNumberStrings = True;
	}

    *mustResetNumberStrings = 
      (hasList || resetted) && !hasNumberStrings;
#ifdef PRER6
    *mustResetLongest =
      (hasList || resetted) && !hasLongest;
#endif
    }



/******************** strip chart specific code ***************/
#include <X11/Xaw/StripChart.h>

typedef struct _scInfo
     {
     double            value;
     Widget            widget;
     struct _scInfo   *next;
     } scInfo, *scInfoPtr;

static scInfoPtr scBegin = NULL;

static void 
stripChartSet(sCWidget, value)
Widget  sCWidget;
double  value;
     {
     scInfoPtr   countPtr;

     if (!scBegin)         /* No Stripchart widgets exists yet*/
          {
	  wafeWarn("scSet", "No stripChart widget exists yet",
		   NULL,NULL,NULL);
          return;
          }

     for (countPtr = scBegin; 
          countPtr->widget != sCWidget && countPtr->next != NULL;
          countPtr = countPtr->next);

     if ((countPtr->next == NULL) && countPtr->widget != sCWidget)
          {
	  wafeWarn("scSet", "stripChart widget %s unknown", 
		   XtName(sCWidget),NULL,NULL);
          return;
          }

     DBUG_PRINT("sc",("Setting = '%s' to %f", XtName(countPtr->widget),value));

     countPtr->value = value;
     }


static void
scQueryProc(w, clientData, value)
Widget    w;
XtPointer clientData;
XtPointer value;
     {
     scInfoPtr   countPtr;

     DBUG_ENTER("scQuery");

     for (countPtr = scBegin; countPtr->widget != w;
          countPtr = countPtr->next);

     DBUG_PRINT("sc",("Name = '%s', value = %f", 
		      XtName(countPtr->widget), countPtr->value));
/*
      fprintf(stderr,"float = %f\n",countPtr->value);
 */
     *((double*)value) = countPtr->value;

     DBUG_VOID_RETURN;
     }

static Widget
stripChartCreate(parent, name, args, numArgs)
Widget   parent;
char     *name;
ArgList  args;
Cardinal numArgs;
    {
    Widget newWidget;
    
    scInfoPtr  countPtr = (scInfoPtr)XtNew(scInfo);
    countPtr->next   = scBegin;
    countPtr->value  = 0.0;  /* default value */
    countPtr->widget = 
      newWidget = 
	XtCreateWidget(name, stripChartWidgetClass, parent, args, numArgs);
    scBegin = countPtr;
    XtAddCallback(newWidget, XtNgetValue, scQueryProc, NULL);  

    return(newWidget);
    }


/************** scrollbar widget support routines ******/
#include <X11/Xaw/Scrollbar.h>

static Widget
scrollbarCreate(parent, name, args, numArgs)
Widget   parent;
char     *name;
ArgList  args;
Cardinal numArgs;
    {
    XtCallbackList callbackList = NULL;
    Widget newWidget = XtCreateWidget(name, scrollbarWidgetClass, 
				      parent, args, numArgs);
    setQuark(XtNjumpProc,qjumpProc);
    setQuark(XtNscrollProc,qscrollProc);
    return(newWidget);
    }

#include <X11/Xaw/AsciiText.h>

static Boolean
CvtEditTypeToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    if ((XawTextEditType)fromVal->addr == XawtextEdit) 
	{
	toVal->addr = XtNewString(XtEtextEdit);
	toVal->size = 5;
	} 
    else if ((XawTextEditType)fromVal->addr == XawtextRead) 
	{
	toVal->addr = XtNewString(XtEtextRead);
	toVal->size = 5;
	} 
    else if ((XawTextEditType)fromVal->addr == XawtextAppend) 
	{
	toVal->addr = XtNewString(XtEtextAppend);
	toVal->size = 7;
	}
    else 
	return False;
    
    return True;
    }

static Boolean
CvtAsciiTypeToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    if ((XawAsciiType)fromVal->addr == XawAsciiFile) 
	{
	toVal->addr = XtNewString(XtNfile);
	toVal->size = 5;
	} 
    else if ((XawAsciiType)fromVal->addr == XawAsciiString) 
	{
	toVal->addr = XtNewString(XtNstring);
	toVal->size = 7;
	} 
    else 
	return False;
    
    return True;
    }




static int cmd_XawAsciiSave();
static int cmd_XawAsciiSaveAsFile();
static int cmd_XawAsciiSourceChanged();
static int cmd_XawAsciiSourceFreeString();
static int cmd_XawDialogGetValueString();
static int cmd_XawFormDoLayout();
static int cmd_XawListAppend();
static int cmd_XawListChange();
static int cmd_XawListHighlight();
static int cmd_XawListShowCurrent();
static int cmd_XawListUnhighlight();
static int cmd_XawPanedAllowResize();
static int cmd_XawPanedGetMinMax();
static int cmd_XawPanedGetNumSub();
static int cmd_XawPanedSetMinMax();
static int cmd_XawPanedSetRefigureMode();
static int cmd_XawScrollbarSetThumb();
static int cmd_XawSimpleMenuAddGlobalActions();
static int cmd_XawSimpleMenuClearActiveEntry();
static int cmd_XawSimpleMenuGetActiveEntry();
static int cmd_XawStripChartSet();
static int cmd_XawTextDisableRedisplay();
static int cmd_XawTextDisplay();
static int cmd_XawTextDisplayCaret();
static int cmd_XawTextEnableRedisplay();
static int cmd_XawTextGetInsertionPoint();
static int cmd_XawTextGetSelectionPos();
static int cmd_XawTextInvalidate();
static int cmd_XawTextSearch();
static int cmd_XawTextSetInsertionPoint();
static int cmd_XawTextSetSelection();
static int cmd_XawTextSetSelectionArray();
static int cmd_XawTextSinkFindDistance();
static int cmd_XawTextSinkMaxHeight();
static int cmd_XawTextSinkMaxLines();
static int cmd_XawTextSinkSetTabs();
static int cmd_XawTextSourceRead();
static int cmd_XawTextSourceScan();
static int cmd_XawTextTopPosition();
static int cmd_XawTextReplace();
static int cmd_XawTextUnsetSelection();
static int cmd_XawToggleChangeRadioGroup();
static int cmd_XawToggleGetCurrent();
static int cmd_XawToggleSetCurrent();
static int cmd_XawToggleSetRadioData();
static int cmd_XawToggleUnsetCurrent();
#if !defined(PRER5) || defined(XAW3D)
static int cmd_XawViewportSetCoordinates();
#else
#define cmd_XawViewportSetCoordinates NULL
#endif
#if !defined(PRER5) || defined(XAW3D)
static int cmd_XawViewportSetLocation();
#else
#define cmd_XawViewportSetLocation NULL
#endif

static _Xconst Proc_signature cmds[] = {
    { "XawAsciiSave", cmd_XawAsciiSave },
    { "XawAsciiSaveAsFile", cmd_XawAsciiSaveAsFile },
    { "XawAsciiSourceChanged", cmd_XawAsciiSourceChanged },
    { "XawAsciiSourceFreeString", cmd_XawAsciiSourceFreeString },
    { "XawDialogGetValueString", cmd_XawDialogGetValueString },
    { "XawFormDoLayout", cmd_XawFormDoLayout },
    { "XawListAppend", cmd_XawListAppend },
    { "XawListChange", cmd_XawListChange },
    { "XawListHighlight", cmd_XawListHighlight },
    { "XawListShowCurrent", cmd_XawListShowCurrent },
    { "XawListUnhighlight", cmd_XawListUnhighlight },
    { "XawPanedAllowResize", cmd_XawPanedAllowResize },
    { "XawPanedGetMinMax", cmd_XawPanedGetMinMax },
    { "XawPanedGetNumSub", cmd_XawPanedGetNumSub },
    { "XawPanedSetMinMax", cmd_XawPanedSetMinMax },
    { "XawPanedSetRefigureMode", cmd_XawPanedSetRefigureMode },
    { "XawScrollbarSetThumb", cmd_XawScrollbarSetThumb },
    { "scSet", cmd_XawStripChartSet }, /* alias */
    { "XawSimpleMenuAddGlobalActions", cmd_XawSimpleMenuAddGlobalActions },
    { "XawSimpleMenuClearActiveEntry", cmd_XawSimpleMenuClearActiveEntry },
    { "XawSimpleMenuGetActiveEntry", cmd_XawSimpleMenuGetActiveEntry },
    { "XawStripChartSet", cmd_XawStripChartSet },
    { "XawTextDisableRedisplay", cmd_XawTextDisableRedisplay },
    { "XawTextDisplay", cmd_XawTextDisplay },
    { "XawTextDisplayCaret", cmd_XawTextDisplayCaret },
    { "XawTextEnableRedisplay", cmd_XawTextEnableRedisplay },
    { "XawTextGetInsertionPoint", cmd_XawTextGetInsertionPoint },
    { "XawTextGetSelectionPos", cmd_XawTextGetSelectionPos },
    { "XawTextInvalidate", cmd_XawTextInvalidate },
    { "XawTextSearch", cmd_XawTextSearch },
    { "XawTextSetInsertionPoint", cmd_XawTextSetInsertionPoint },
    { "XawTextSetSelection", cmd_XawTextSetSelection },
    { "XawTextSetSelectionArray", cmd_XawTextSetSelectionArray },
    { "XawTextSinkFindDistance", cmd_XawTextSinkFindDistance },
    { "XawTextSinkMaxHeight", cmd_XawTextSinkMaxHeight },
    { "XawTextSinkMaxLines", cmd_XawTextSinkMaxLines },
    { "XawTextSinkSetTabs", cmd_XawTextSinkSetTabs },
    { "XawTextSourceRead", cmd_XawTextSourceRead },
    { "XawTextSourceScan", cmd_XawTextSourceScan },
    { "XawTextTopPosition", cmd_XawTextTopPosition },
    { "XawTextReplace", cmd_XawTextReplace },
    { "XawTextUnsetSelection", cmd_XawTextUnsetSelection },
    { "XawToggleChangeRadioGroup", cmd_XawToggleChangeRadioGroup },
    { "XawToggleGetCurrent", cmd_XawToggleGetCurrent },
    { "XawToggleSetCurrent", cmd_XawToggleSetCurrent },
    { "XawToggleSetRadioData", cmd_XawToggleSetRadioData },
    { "XawToggleUnsetCurrent", cmd_XawToggleUnsetCurrent },
    { "XawViewportSetCoordinates", cmd_XawViewportSetCoordinates },
    { "XawViewportSetLocation", cmd_XawViewportSetLocation },
    { NULL, NULL }
    };

static WidgetCreate_signature wccs[] = {
    { "Text",NULL,NULL,False },
    { "Box",NULL,NULL,False },
    { "Clock",NULL,NULL,False },
    { "Command",NULL,NULL,False },
    { "Dialog",NULL,NULL,False },
    { "Form",NULL,NULL,False },
    { "Grip",NULL,NULL,False },
    { "Label",NULL,NULL,False },
    { "List",NULL,listCreate,False },
    { "Logo",NULL,NULL,False },
    { "Mailbox",NULL,NULL,False },
    { "MenuButton",NULL,NULL,False },
    { "Paned",NULL,NULL,False },
    { "Scrollbar",NULL,scrollbarCreate,False },
    { "Simple",NULL,NULL,False },
    { "SimpleMenu",NULL,XtCreatePopupShell,True },
    { "Sme",NULL,NULL,False },
    { "SmeBSB",NULL,NULL,False },
    { "SmeLine",NULL,NULL,False },
    { "StripChart",NULL,stripChartCreate,False },
    { "Toggle",NULL,NULL,False },
    { "Viewport",NULL,NULL,False },
    { NULL,NULL,NULL,False }
    };

static _Xconst String pkgs[] = {
     "ATHENA",
#ifdef XAW3D
     "XAW3D",
#endif
    NULL
     };


 static _Xconst String WS_AsciiTextWidget = "AsciiTextWidget";
 static _Xconst String WS_ListWidget = "ListWidget";
 static _Xconst String WS_PanedWidget = "PanedWidget";
 static _Xconst String WS_SimpleMenuWidget = "SimpleMenuWidget";
 static _Xconst String WS_TextSink = "TextSink";
 static _Xconst String WS_ToggleWidget = "ToggleWidget";
 static _Xconst String WS_ViewportWidget = "ViewportWidget";
 static _Xconst String WS_XawTextPosition = "XawTextPosition";
 static _Xconst String WS_XawTextScanDirection = "XawTextScanDirection";
 static _Xconst String WS_Left = "Left";
 static _Xconst String WS_left = "left";
 static _Xconst String WS_Right = "Right";
 static _Xconst String WS_right = "right";
 static _Xconst String WS_returnVar = "returnVar";
#define WS_Text wccs[0].name
#define WS_XawAsciiSave cmds[0].name
/* 
 * Boolean
 * XawAsciiSave
 * 	in: XawTextGetSource(AsciiTextWidget)	# ascii text widget
 */

static int 
cmd_XawAsciiSave(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     returnVar = XawAsciiSave(XawTextGetSource(localVar1));

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawAsciiSaveAsFile cmds[1].name
/* 
 * Boolean
 * XawAsciiSaveAsFile
 *         in: XawTextGetSource(AsciiTextWidget)	# ascii text widget
 *         in: String			        # file name
 */

static int 
cmd_XawAsciiSaveAsFile(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = XawAsciiSaveAsFile(XawTextGetSource(localVar1),argv[2]);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawAsciiSourceChanged cmds[2].name
/* 
 * Boolean
 * XawAsciiSourceChanged 
 * 	in: XawTextGetSource(AsciiTextWidget)	# ascii text widget
 */

static int 
cmd_XawAsciiSourceChanged(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     returnVar = XawAsciiSourceChanged(XawTextGetSource(localVar1));

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawAsciiSourceFreeString cmds[3].name
/* 
 * void
 * XawAsciiSourceFreeString
 * 	in: XawTextGetSource(AsciiTextWidget)	# ascii text widget
 */

static int 
cmd_XawAsciiSourceFreeString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     XawAsciiSourceFreeString(XawTextGetSource(localVar1));

     DBUG_RETURN (TCL_OK);
     }



#define WS_Box wccs[1].name
#define WS_Clock wccs[2].name
#define WS_Command wccs[3].name
#define WS_Dialog wccs[4].name
#define WS_XawDialogGetValueString cmds[4].name
/* 
 * (String) VString
 * XawDialogGetValueString
 * 	in: DialogWidget		# dialog widget
 */

static int 
cmd_XawDialogGetValueString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],dialogWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, "DialogWidget"));

     returnVar = XawDialogGetValueString(localVar1);

     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_Form wccs[5].name
#define WS_XawFormDoLayout cmds[5].name
/* 
 * void
 * XawFormDoLayout
 * 	in: FormWidget			# form widget
 * 	in: Boolean			# boolean
 */

static int 
cmd_XawFormDoLayout(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],formWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, "FormWidget"));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRBoolean));

     XawFormDoLayout(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_Grip wccs[6].name
#define WS_Label wccs[7].name
#define WS_List wccs[8].name
#define WS_XawListAppend cmds[6].name
/* 
 * void
 * listAppend vulgo XawListAppend
 * 	in: ListWidget			# list widget
 * 	in: [args]			# items
 */

static int 
cmd_XawListAppend(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_ListWidget));

     argc -= 2;
     listAppend(localVar1,argc,&argv[2]);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawListChange cmds[7].name
/* 
 * void
 * listChange vulgo XawListChange
 * 	in: ListWidget			# list widget
 * 	in: int				# number of items
 * 	in: int				# longest
 * 	in: int				# resize
 * 	in: [args]			# List list | Arg items | File filename
 */

static int 
cmd_XawListChange(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER(argv[0]);  

     if (argc < 6) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],5));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_ListWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[14]));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, wafeStrings[14]));

     if (!(sscanf(argv[4], wafeStrings[7], &localVar4)))
         DBUG_RETURN (wafeConvError(argc, argv, 4 ,NULL, wafeStrings[14]));

     argc -= 5;
     listChange(localVar1,localVar2,localVar3,localVar4,argc,&argv[5]);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawListHighlight cmds[8].name
/* 
 * void
 * XawListHighlight
 * 	in: ListWidget			# list widget
 * 	in: int				# item number
 */

static int 
cmd_XawListHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_ListWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[14]));

     XawListHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawListShowCurrent cmds[9].name
/* 
 * XawListReturnStruct *
 * XawListShowCurrent
 * 	in: ListWidget			# list widget
 */

static int 
cmd_XawListShowCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawListReturnStruct * returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_ListWidget));

     returnVar = XawListShowCurrent(localVar1);

     if (returnVar == NULL) { DBUG_RETURN (TCL_ERROR); }

     Tcl_SetVar2(wafeInterpreter,WS_returnVar,"string",returnVar->string ? returnVar->string :wafe_EMPTY,0);

     sprintf(conversionBuffer, wafeStrings[7], returnVar->list_index);

     Tcl_SetVar2(wafeInterpreter,WS_returnVar,"list_index",conversionBuffer,0);
     Tcl_SetResult(comInterpreter, WS_returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawListUnhighlight cmds[10].name
/* 
 * void
 * XawListUnhighlight
 * 	in: ListWidget			# list widget
 */

static int 
cmd_XawListUnhighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],listWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_ListWidget));

     XawListUnhighlight(localVar1);

     DBUG_RETURN (TCL_OK);
     }



#define WS_Logo wccs[9].name
#define WS_Mailbox wccs[10].name
#define WS_MenuButton wccs[11].name
#define WS_Paned wccs[12].name
#define WS_XawPanedAllowResize cmds[11].name
/* 
 * void
 * XawPanedAllowResize
 * 	in: Widget			# child of paned widget
 * 	in: Boolean			# boolean
 */

static int 
cmd_XawPanedAllowResize(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRBoolean));

     XawPanedAllowResize(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawPanedGetMinMax cmds[12].name
/* 
 * void
 * XawPanedGetMinMax
 * 	in: Widget			# child of paned widget
 * 	out: int			# min
 * 	out: int			# max
 */

static int 
cmd_XawPanedGetMinMax(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

     XawPanedGetMinMax(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, wafeStrings[7], localVar2);

     Tcl_SetVar(wafeInterpreter,argv[2],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[7], localVar3);

     Tcl_SetVar(wafeInterpreter,argv[3],conversionBuffer,0);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawPanedGetNumSub cmds[13].name
/* 
 * int
 * XawPanedGetNumSub
 * 	in: PanedWidget			# paned widget
 */

static int 
cmd_XawPanedGetNumSub(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],panedWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_PanedWidget));

     returnVar = XawPanedGetNumSub(localVar1);

     sprintf(conversionBuffer, wafeStrings[7], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawPanedSetMinMax cmds[14].name
/* 
 * void
 * XawPanedSetMinMax
 * 	in: Widget			# child of a paned widget
 * 	in: int				# min
 * 	in: int				# max
 */

static int 
cmd_XawPanedSetMinMax(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, XtRWidget));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[14]));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, wafeStrings[14]));

     XawPanedSetMinMax(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawPanedSetRefigureMode cmds[15].name
/* 
 * void 
 * XawPanedSetRefigureMode
 * 	in: PanedWidget			# paned widget
 * 	in: Boolean			# boolean
 */

static int 
cmd_XawPanedSetRefigureMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],panedWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_PanedWidget));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRBoolean));

     XawPanedSetRefigureMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_Scrollbar wccs[13].name
#define WS_XawScrollbarSetThumb cmds[16].name
/* 
 * void
 * XawScrollbarSetThumb
 * 	in: ScrollbarWidget		# Scrollbar widget
 * 	in: float			# top
 * 	in: float			# shown
 */

static int 
cmd_XawScrollbarSetThumb(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float localVar2;
     float localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],scrollbarWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, "ScrollbarWidget"));

     if (!(sscanf(argv[2], wafeStrings[13], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[15]));

     if (!(sscanf(argv[3], wafeStrings[13], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, wafeStrings[15]));

     XawScrollbarSetThumb(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }



#define WS_Simple wccs[14].name
#define WS_SimpleMenu wccs[15].name
#define WS_XawSimpleMenuAddGlobalActions cmds[17].name
/* 
 * void 
 * XawSimpleMenuAddGlobalActions
 * 	const: wafeAppContext
 */

static int 
cmd_XawSimpleMenuAddGlobalActions(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {

     DBUG_ENTER(argv[0]);  

     if (argc != 1) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],0));

     XawSimpleMenuAddGlobalActions(wafeAppContext);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawSimpleMenuClearActiveEntry cmds[18].name
/* 
 * void 
 * XawSimpleMenuClearActiveEntry
 * 	in: SimpleMenuWidget		# widget
 */

static int 
cmd_XawSimpleMenuClearActiveEntry(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],simpleMenuWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_SimpleMenuWidget));

     XawSimpleMenuClearActiveEntry(localVar1);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawSimpleMenuGetActiveEntry cmds[19].name
/* 
 * WidgetID (WidgetID)
 * XawSimpleMenuGetActiveEntry
 * 	in: SimpleMenuWidget		# widget
 */

static int 
cmd_XawSimpleMenuGetActiveEntry(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     WidgetID returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],simpleMenuWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_SimpleMenuWidget));

     returnVar = (WidgetID) XawSimpleMenuGetActiveEntry(localVar1);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_Sme wccs[16].name
#define WS_SmeBSB wccs[17].name
#define WS_SmeLine wccs[18].name
#define WS_StripChart wccs[19].name
#define WS_XawStripChartSet cmds[20].name
/* 
 * void
 * stripChartSet vulgo XawStripChartSet
 * 	in: StripChartWidget		# strip chart widget
 * 	in: double			# value
 */

static int 
cmd_XawStripChartSet(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     double localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],stripChartWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, "StripChartWidget"));

     if (!(sscanf(argv[2], wafeStrings[12], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[16]));

     stripChartSet(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextDisableRedisplay cmds[21].name
/* 
 * void
 * XawTextDisableRedisplay
 * 	in: AsciiTextWidget		# ascii text widget
 */

static int 
cmd_XawTextDisableRedisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     XawTextDisableRedisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextDisplay cmds[22].name
/* 
 * void
 * XawTextDisplay
 * 	in: AsciiTextWidget		# ascii text widget
 */

static int 
cmd_XawTextDisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     XawTextDisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextDisplayCaret cmds[23].name
/* 
 * void
 * XawTextDisplayCaret
 * 	in: AsciiTextWidget		# ascii text widget
 * 	in: Boolean			# boolean
 */

static int 
cmd_XawTextDisplayCaret(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRBoolean));

     XawTextDisplayCaret(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextEnableRedisplay cmds[24].name
/* 
 * void
 * XawTextEnableRedisplay
 * 	in: AsciiTextWidget		# ascii text widget
 */

static int 
cmd_XawTextEnableRedisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     XawTextEnableRedisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextGetInsertionPoint cmds[25].name
/* 
 * XawTextPosition
 * XawTextGetInsertionPoint
 * 	in: AsciiTextWidget		# ascii text widget
 */

static int 
cmd_XawTextGetInsertionPoint(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     returnVar = XawTextGetInsertionPoint(localVar1);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextGetSelectionPos cmds[26].name
/* 
 * void 
 * XawTextGetSelectionPos
 *         in: AsciiTextWidget 		# ascii text widget
 *         out: XawTextPosition		# variable name for start position
 *         out: XawTextPosition 		# variable name for end position
 */

static int 
cmd_XawTextGetSelectionPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     XawTextGetSelectionPos(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, wafeStrings[9], localVar2);

     Tcl_SetVar(wafeInterpreter,argv[2],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[9], localVar3);

     Tcl_SetVar(wafeInterpreter,argv[3],conversionBuffer,0);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextInvalidate cmds[27].name
/* 
 * void
 * XawTextInvalidate
 * 	in: AsciiTextWidget		# ascii text widget
 * 	in: XawTextPosition		# start position
 * 	in: XawTextPosition		# end position
 */

static int 
cmd_XawTextInvalidate(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, WS_XawTextPosition));

     if (!(sscanf(argv[3], wafeStrings[9], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, WS_XawTextPosition));

     XawTextInvalidate(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextSearch cmds[28].name
/* 
 * XawTextPosition
 * XawTextSearch
 * 	in: AsciiTextWidget		# ascii text widget
 * 	in: XawTextScanDirection	# scan direction ('left' or 'right')
 * 	in: XawTextBlock		# text block
 */

static int 
cmd_XawTextSearch(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextScanDirection localVar2;
     XawTextBlock localVar3;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     if (!strcmp(argv[2], WS_left)) 
         localVar2 = XawsdLeft;
     else
     if (!strcmp(argv[2], WS_right)) 
         localVar2 = XawsdRight;
     else
     if (!strcmp(argv[2], WS_Left)) 
         localVar2 = XawsdLeft;
     else
     if (!strcmp(argv[2], WS_Right)) 
         localVar2 = XawsdRight;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 2,NULL, WS_XawTextScanDirection));


     { char *charp;
         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[3],"firstPos", 0)))
               {
               wafeNoVarCompError(argc,argv,3,"firstPos");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, wafeStrings[7], &localVar3.firstPos)))
             DBUG_RETURN(wafeConvError(argc, argv, 3,"firstPos" ,wafeStrings[14]));

         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[3],"length", 0)))
               {
               wafeNoVarCompError(argc,argv,3,"length");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, wafeStrings[7], &localVar3.length)))
             DBUG_RETURN(wafeConvError(argc, argv, 3,"length" ,wafeStrings[14]));

         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[3],"ptr", 0)))
               {
               wafeNoVarCompError(argc,argv,3,"ptr");
               DBUG_RETURN (TCL_ERROR);
               }
         localVar3.ptr = charp;
     }

     returnVar = XawTextSearch(localVar1,localVar2,&localVar3);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextSetInsertionPoint cmds[29].name
/* 
 * void
 * XawTextSetInsertionPoint
 * 	in: AsciiTextWidget		# ascii text widget
 * 	in: XawTextPosition		# position
 */

static int 
cmd_XawTextSetInsertionPoint(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, WS_XawTextPosition));

     XawTextSetInsertionPoint(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextSetSelection cmds[30].name
/* 
 * void 
 * XawTextSetSelection
 *         in: AsciiTextWidget 		# ascii text widget
 *         in: XawTextPosition		# begin position
 *         in: XawTextPosition 		# end position
 */

static int 
cmd_XawTextSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, WS_XawTextPosition));

     if (!(sscanf(argv[3], wafeStrings[9], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, WS_XawTextPosition));

     XawTextSetSelection(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextSetSelectionArray cmds[31].name
/* 
 * void
 * XawTextSetSelectionArray
 * 	in: AsciiTextWidget		# ascii text widget
 * 	in: [XawTextSelectType]		# selection array
 */

static int 
cmd_XawTextSetSelectionArray(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextSelectType * localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     {    XawTextSelectType *ptr;
          argv += 2;
          localVar2 = ptr =
             (XawTextSelectType *)XtMalloc((argc-2)*sizeof(XawTextSelectType));

          while (*argv)
             {
             if (!strcmp(*argv, "selectAll")) 
                 *ptr = XawselectAll;
             else
             if (!strcmp(*argv, "selectChar")) 
                 *ptr = XawselectChar;
             else
             if (!strcmp(*argv, "selectLine")) 
                 *ptr = XawselectLine;
             else
             if (!strcmp(*argv, "selectNull")) 
                 *ptr = XawselectNull;
             else
             if (!strcmp(*argv, "selectParagraph")) 
                 *ptr = XawselectParagraph;
             else
             if (!strcmp(*argv, "selectPosition")) 
                 *ptr = XawselectPosition;
             else
             if (!strcmp(*argv, "selectWord")) 
                 *ptr = XawselectWord;
             else
                 DBUG_RETURN(wafeConvError(argc,argv, 2,NULL, "XawTextSelectType"));


          ptr ++; argv++;
          }
     }
     XawTextSetSelectionArray(localVar1,localVar2);
     wafeMMreplace(localVar1,NULL,WafePermStringToQuark("XawTextSetSelectionArray"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextSinkFindDistance cmds[32].name
/* 
 * void
 * XawTextSinkFindDistance
 * 	in: (Widget)TextSink		# ascii text widget
 * 	in: XawTextPosition		# from position
 *         in: int				# reference location (in pixel)
 * 	in: XawTextPosition		# to position
 * 	out: int			# resulting width (in pixel)
 * 	out: XawTextPosition		# distance in positions
 * 	out: int			# resulting height (in pixel)
 */

static int 
cmd_XawTextSinkFindDistance(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     int localVar3;
     XawTextPosition localVar4;
     int localVar5;
     XawTextPosition localVar6;
     int localVar7;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 8) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],7));

     if (!(localVar1 = (Widget) name2Sink(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_TextSink));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, WS_XawTextPosition));

     if (!(sscanf(argv[3], wafeStrings[7], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, wafeStrings[14]));

     if (!(sscanf(argv[4], wafeStrings[9], &localVar4)))
         DBUG_RETURN (wafeConvError(argc, argv, 4 ,NULL, WS_XawTextPosition));

     XawTextSinkFindDistance(localVar1,localVar2,localVar3,localVar4,&localVar5,&localVar6,&localVar7);

     sprintf(conversionBuffer, wafeStrings[7], localVar5);

     Tcl_SetVar(wafeInterpreter,argv[5],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[9], localVar6);

     Tcl_SetVar(wafeInterpreter,argv[6],conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[7], localVar7);

     Tcl_SetVar(wafeInterpreter,argv[7],conversionBuffer,0);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextSinkMaxHeight cmds[33].name
/* 
 * int
 * XawTextSinkMaxHeight
 * 	in: (Widget)TextSink 		# ascii text widget
 * 	in: int				# lines
 */

static int 
cmd_XawTextSinkMaxHeight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Sink(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_TextSink));

     if (!(sscanf(argv[2], wafeStrings[7], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[14]));

     returnVar = XawTextSinkMaxHeight(localVar1,localVar2);

     sprintf(conversionBuffer, wafeStrings[7], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextSinkMaxLines cmds[34].name
/* 
 * int
 * XawTextSinkMaxLines
 * 	in: (Widget)TextSink		# ascii text widget
 * 	in: Dimension			# height
 */

static int 
cmd_XawTextSinkMaxLines(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Dimension localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 = (Widget) name2Sink(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_TextSink));

     if (!(sscanf(argv[2], wafeStrings[11], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRDimension));

     returnVar = XawTextSinkMaxLines(localVar1,localVar2);

     sprintf(conversionBuffer, wafeStrings[7], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextSinkSetTabs cmds[35].name
/* 
 * void
 * XawTextSinkSetTabs
 * 	in: (Widget)TextSink		# ascii text widget
 * 	const: argc-2
 * 	in: [int]			# tabs
 */

static int 
cmd_XawTextSinkSetTabs(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int * localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 = (Widget) name2Sink(argv[1])))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_TextSink));

     {    int *ptr;
          argv += 2;
          localVar2 = ptr =
             (int *)XtMalloc((argc-2)*sizeof(int));

          while (*argv)
             {
             if (!(sscanf(*argv, wafeStrings[7], &*ptr)))
                 DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[14]));

          ptr ++; argv++;
          }
     }
     XawTextSinkSetTabs(localVar1,argc-2,localVar2);
     wafeMMreplace(localVar1,NULL,WafePermStringToQuark("XawTextSinkSetTabs"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextSourceRead cmds[36].name
/* 
 * XawTextPosition
 * XawTextSourceRead 
 * 	in: XawTextGetSource(AsciiTextWidget)	# ascii text widget
 * 	in: XawTextPosition		# position
 * 	out: XawTextBlock		# variable name for text block
 * 	in: int				# length
 */

static int 
cmd_XawTextSourceRead(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextBlock localVar3;
     int localVar4;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, WS_XawTextPosition));

     if (!(sscanf(argv[4], wafeStrings[7], &localVar4)))
         DBUG_RETURN (wafeConvError(argc, argv, 4 ,NULL, wafeStrings[14]));

     returnVar = XawTextSourceRead(XawTextGetSource(localVar1),localVar2,&localVar3,localVar4);

     
     sprintf(conversionBuffer, wafeStrings[7], localVar3.firstPos);

     Tcl_SetVar2(wafeInterpreter,argv[3],"firstPos",conversionBuffer,0);

     sprintf(conversionBuffer, wafeStrings[7], localVar3.length);

     Tcl_SetVar2(wafeInterpreter,argv[3],"length",conversionBuffer,0);

     Tcl_SetVar2(wafeInterpreter,argv[3],"ptr",localVar3.ptr ? localVar3.ptr :wafe_EMPTY,0);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextSourceScan cmds[37].name
/* 
 * XawTextPosition
 * XawTextSourceScan
 * 	in: XawTextGetSource(AsciiTextWidget)	# ascii text widget
 * 	in: XawTextPosition		# position
 * 	in: XawTextScanType		# boundary type
 * 	in: XawTextScanDirection	# scan direction
 * 	in: int				# count
 * 	in: Boolean			# include (boolean)
 */

static int 
cmd_XawTextSourceScan(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextScanType localVar3;
     XawTextScanDirection localVar4;
     int localVar5;
     Boolean localVar6;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 7) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],6));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, WS_XawTextPosition));

     if (!strcmp(argv[3], "position")) 
         localVar3 = XawstPositions;
     else
     if (!strcmp(argv[3], "whiteSpace")) 
         localVar3 = XawstWhiteSpace;
     else
     if (!strcmp(argv[3], "EOL")) 
         localVar3 = XawstEOL;
     else
     if (!strcmp(argv[3], "paragraph")) 
         localVar3 = XawstParagraph;
     else
     if (!strcmp(argv[3], "all")) 
         localVar3 = XawstAll;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 3,NULL, "XawTextScanType"));


     if (!strcmp(argv[4], WS_left)) 
         localVar4 = XawsdLeft;
     else
     if (!strcmp(argv[4], WS_right)) 
         localVar4 = XawsdRight;
     else
     if (!strcmp(argv[4], WS_Left)) 
         localVar4 = XawsdLeft;
     else
     if (!strcmp(argv[4], WS_Right)) 
         localVar4 = XawsdRight;
     else
         DBUG_RETURN(wafeConvError(argc,argv, 4,NULL, WS_XawTextScanDirection));


     if (!(sscanf(argv[5], wafeStrings[7], &localVar5)))
         DBUG_RETURN (wafeConvError(argc, argv, 5 ,NULL, wafeStrings[14]));

     if (!(wafeGetBoolean(argv[6],&localVar6)))
         DBUG_RETURN (wafeConvError(argc, argv, 6 ,NULL, XtRBoolean));

     returnVar = XawTextSourceScan(XawTextGetSource(localVar1),localVar2,localVar3,localVar4,localVar5,localVar6);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextTopPosition cmds[38].name
/* 
 * XawTextPosition
 * XawTextTopPosition
 * 	in: AsciiTextWidget		# ascii text widget
 */

static int 
cmd_XawTextTopPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     returnVar = XawTextTopPosition(localVar1);

     sprintf(conversionBuffer, wafeStrings[9], returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextReplace cmds[39].name
/* 
 * (int) ReplaceVal 
 * XawTextReplace
 *         in: AsciiTextWidget		# ascii text widget
 *         in: XawTextPosition 		# from position
 *         in: XawTextPosition 		# to position
 *         in: XawTextBlock		# text block
 */

static int 
cmd_XawTextReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;
     XawTextBlock localVar4;
     int returnVar;
     char *staticResultString;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],4));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     if (!(sscanf(argv[2], wafeStrings[9], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, WS_XawTextPosition));

     if (!(sscanf(argv[3], wafeStrings[9], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, WS_XawTextPosition));

     { char *charp;
         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[4],"firstPos", 0)))
               {
               wafeNoVarCompError(argc,argv,4,"firstPos");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, wafeStrings[7], &localVar4.firstPos)))
             DBUG_RETURN(wafeConvError(argc, argv, 4,"firstPos" ,wafeStrings[14]));

         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[4],"length", 0)))
               {
               wafeNoVarCompError(argc,argv,4,"length");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, wafeStrings[7], &localVar4.length)))
             DBUG_RETURN(wafeConvError(argc, argv, 4,"length" ,wafeStrings[14]));

         if (!(charp=Tcl_GetVar2(wafeInterpreter,argv[4],"ptr", 0)))
               {
               wafeNoVarCompError(argc,argv,4,"ptr");
               DBUG_RETURN (TCL_ERROR);
               }
         localVar4.ptr = charp;
     }

     returnVar = XawTextReplace(localVar1,localVar2,localVar3,&localVar4);

     if (returnVar == XawEditDone) 
         staticResultString = "editDone";
     else if (returnVar == XawPositionError) 
         staticResultString = "positionError";
     else if (returnVar == XawEditError) 
         staticResultString = "editError";
     else 
         staticResultString = "UNKNOWN";

     Tcl_SetResult(comInterpreter, staticResultString, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawTextUnsetSelection cmds[40].name
/* 
 * void 
 * XawTextUnsetSelection
 *         in: AsciiTextWidget 		# ascii text widget
 */

static int 
cmd_XawTextUnsetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],asciiTextWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_AsciiTextWidget));

     XawTextUnsetSelection(localVar1);

     DBUG_RETURN (TCL_OK);
     }



#define WS_Toggle wccs[20].name
#define WS_XawToggleChangeRadioGroup cmds[41].name
/* 
 * void
 * XawToggleChangeRadioGroup
 * 	in: ToggleWidget	   # toggle widget
 * 	in: NULL | ToggleWidget    # NULL | any toggle widget of a radio group
 */

static int 
cmd_XawToggleChangeRadioGroup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_ToggleWidget));

     if (!strcmp(argv[2], wafeStrings[3])) 
         localVar2 = NULL;
     else
         if (!(localVar2 =  name2WidgetOfClass(argv[2],toggleWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, WS_ToggleWidget));

     XawToggleChangeRadioGroup(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawToggleGetCurrent cmds[42].name
/* 
 * XrmQuark (XrmQuark)
 * XawToggleGetCurrent
 * 	in: ToggleWidget	   # any toggle widget of a radio group
 */

static int 
cmd_XawToggleGetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XrmQuark returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_ToggleWidget));

     returnVar = (XrmQuark) XawToggleGetCurrent(localVar1);

     Tcl_SetResult(comInterpreter, XrmQuarkToString(returnVar), TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawToggleSetCurrent cmds[43].name
/* 
 * void
 * XawToggleSetCurrent
 * 	in: ToggleWidget	   # any toggle widget of a radio group
 * 	in: (XtPointer)XrmQuark		   # radio data
 */

static int 
cmd_XawToggleSetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XtPointer localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_ToggleWidget));

     if (!(localVar2 = (XtPointer) XrmStringToQuark(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[26]));

     XawToggleSetCurrent(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define toggleSetRadioData(w, q) XtVaSetValues(w, XtNradioData, q, NULL)

#define WS_XawToggleSetRadioData cmds[44].name
/* 
 * void
 * toggleSetRadioData vulgo XawToggleSetRadioData
 * 	in: ToggleWidget	   # toggle widget
 *         in: XrmQuark	   	   # radio data
 */

static int 
cmd_XawToggleSetRadioData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XrmQuark localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_ToggleWidget));

     if (!(localVar2 = (XrmQuark) XrmStringToQuark(argv[2])))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[26]));

     toggleSetRadioData(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }



#define WS_XawToggleUnsetCurrent cmds[45].name
/* 
 * void
 * XawToggleUnsetCurrent
 * 	in: ToggleWidget	   #  any toggle widget of a radio group
 */

static int 
cmd_XawToggleUnsetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],toggleWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_ToggleWidget));

     XawToggleUnsetCurrent(localVar1);

     DBUG_RETURN (TCL_OK);
     }



#define WS_Viewport wccs[21].name
#define WS_XawViewportSetCoordinates cmds[46].name
/* 
 * hint: R5|XAW3D
 * void
 * XawViewportSetCoordinates
 * 	in: ViewportWidget		# Viewport Widget
 * 	in: Position			# x position
 * 	in: Position			# y position
 */
#if !defined(PRER5) || defined(XAW3D)

static int 
cmd_XawViewportSetCoordinates(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],viewportWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_ViewportWidget));

     if (!(sscanf(argv[2], wafeStrings[8], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, XtRPosition));

     if (!(sscanf(argv[3], wafeStrings[8], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, XtRPosition));

     XawViewportSetCoordinates(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }
#else
#define cmd_XawViewportSetCoordinates NULL

#endif

#define WS_XawViewportSetLocation cmds[47].name
/* 
 * hint: R5|XAW3D
 * void
 * XawViewportSetLocation
 * 	in: ViewportWidget		# Viewport Widget
 * 	in: double			# x offset 
 * 	in: double			# y offset

 */
#if !defined(PRER5) || defined(XAW3D)

static int 
cmd_XawViewportSetLocation(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     double localVar2;
     double localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2WidgetOfClass(argv[1],viewportWidgetClass)))
         DBUG_RETURN (wafeConvError(argc, argv, 1 ,NULL, WS_ViewportWidget));

     if (!(sscanf(argv[2], wafeStrings[12], &localVar2)))
         DBUG_RETURN (wafeConvError(argc, argv, 2 ,NULL, wafeStrings[16]));

     if (!(sscanf(argv[3], wafeStrings[12], &localVar3)))
         DBUG_RETURN (wafeConvError(argc, argv, 3 ,NULL, wafeStrings[16]));

     XawViewportSetLocation(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }
#else
#define cmd_XawViewportSetLocation NULL

#endif

#endif  /* of ifdef ATHENA */

void
wafeInitialize_ATHENA()
{
#ifdef ATHENA
 wccs[0].wClass = asciiTextWidgetClass; /* not a constant! */
 wccs[1].wClass = boxWidgetClass; /* not a constant! */
#ifdef PRER6
 wccs[2].wClass = clockWidgetClass; /* not a constant! */
#endif
 wccs[3].wClass = commandWidgetClass; /* not a constant! */
 wccs[4].wClass = dialogWidgetClass; /* not a constant! */
 wccs[5].wClass = formWidgetClass; /* not a constant! */
 wccs[6].wClass = gripWidgetClass; /* not a constant! */
 wccs[7].wClass = labelWidgetClass; /* not a constant! */
 wccs[8].wClass = listWidgetClass; /* not a constant! */
#ifdef PRER6
 wccs[9].wClass = logoWidgetClass; /* not a constant! */
#endif
#ifdef PRER6
 wccs[10].wClass = mailboxWidgetClass; /* not a constant! */
#endif
 wccs[11].wClass = menuButtonWidgetClass; /* not a constant! */
 wccs[12].wClass = panedWidgetClass; /* not a constant! */
 wccs[13].wClass = scrollbarWidgetClass; /* not a constant! */
 wccs[14].wClass = simpleWidgetClass; /* not a constant! */
 wccs[15].wClass = simpleMenuWidgetClass; /* not a constant! */
 wccs[16].wClass = smeObjectClass; /* not a constant! */
 wccs[17].wClass = smeBSBObjectClass; /* not a constant! */
 wccs[18].wClass = smeLineObjectClass; /* not a constant! */
 wccs[19].wClass = stripChartWidgetClass; /* not a constant! */
 wccs[20].wClass = toggleWidgetClass; /* not a constant! */
 wccs[21].wClass = viewportWidgetClass; /* not a constant! */
 qjumpProc = WafePermStringToQuark("jumpProc");
 qscrollProc = WafePermStringToQuark("scrollProc");
 qradioData = WafePermStringToQuark("radioData");
 qlist = WafePermStringToQuark("list");
 qlongest = WafePermStringToQuark("longest");
 qnumberStrings = WafePermStringToQuark("numberStrings");
 XtSetTypeConverter(XtREditMode, XtRString,
	(XtTypeConverter)CvtEditTypeToString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRAsciiType, XtRString,
	(XtTypeConverter)CvtAsciiTypeToString, 
	NULL, 0, XtCacheNone, NULL);
 wafeCreateTclCmds(pkgs,wccs,cmds);
#endif /* of ifdef ATHENA */
}
