/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Fri Dec  3 21:45:02 EST 1993 on syllog2.watson.ibm.com
 * Author: genc
 * Version: 0.95999999999999996

 */
#ifdef ATHENAR5

#define ATHENAR5_C

#include "wafe.h"                             
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>
#include <X11/Xaw/Tree.h>
#include <X11/Xaw/Repeater.h>

extern void portholeCallbackProc();
extern void pannerCallbackProc();

#define XawTalk(pa, po, ch) XtAddCallback(po, XtNreportCallback, portholeCallbackProc, (XtPointer) pa); XtAddCallback(pa, XtNreportCallback, pannerCallbackProc, (XtPointer) ch)

/* 
 * void
 * XawTalk
 * 	in: PannerWidget	# panner
 * 	in: PortholeWidget	# porthole
 * 	in: Widget		# managed widget
 */

int 
com_XawTalk(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     Widget localVar3;

     DBUG_ENTER("XawTalk");  

     if (argc != 4) 
	 {
	 argcError("XawTalk","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],pannerWidgetClass,"Panner")))
          {
          convError("XawTalk","1",argv[1],"PannerWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 =  name2WidgetOfClass(argv[2],portholeWidgetClass,"Porthole")))
          {
          convError("XawTalk","2",argv[2],"PortholeWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar3 = (Widget) name2Widget(argv[3])))
          {
          convError("XawTalk","3",argv[3],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTalk(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTreeForceLayout
 * 	in: TreeWidget		# tree Widget

 */

int 
com_XawTreeForceLayout(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("XawTreeForceLayout");  

     if (argc != 2) 
	 {
	 argcError("XawTreeForceLayout","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],treeWidgetClass,"Tree")))
          {
          convError("XawTreeForceLayout","1",argv[1],"TreeWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTreeForceLayout(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#else
#include "wafe.h"
#endif

void
Initialize_XawR5Gen()
{
#ifdef ATHENAR5
 createWidgetCommand("Panner",pannerWidgetClass,NULL,False);
 createWidgetCommand("Porthole",portholeWidgetClass,NULL,False);
 createWidgetCommand("Repeater",repeaterWidgetClass,NULL,False);
 createWidgetCommand("Tree",treeWidgetClass,NULL,False);
#ifdef XAWR5
 strcat(wafePackages,"XAWR5 ");
#endif
 Tcl_CreateCommand(wafeInterpreter, "XawTalk", com_XawTalk, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XawTreeForceLayout", com_XawTreeForceLayout, NULL, NULL);

#else
 createWidgetCommand("Panner",NULL,NULL,False);
 createWidgetCommand("Porthole",NULL,NULL,False);
 createWidgetCommand("Repeater",NULL,NULL,False);
 createWidgetCommand("Tree",NULL,NULL,False);
#endif
}
