/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Fri Dec  3 21:45:49 EST 1993 on syllog2.watson.ibm.com
 * Author: genc
 * Version: 0.95999999999999996

 */
#ifdef PLOTTER

#define PLOTTER_C

#include "wafe.h"

#include <X11/At/Axis.h>
#include <X11/At/BarPlot.h>
#include <X11/At/LabelAxis.h>
#include <X11/At/LinePlot.h>
#include <X11/At/Plot.h>
#include <X11/At/Plotter.h>
#include <X11/At/TextPlot.h>
#include <X11/At/XYAxis.h>
#include <X11/At/XYLinePlot.h>
#define castXtPointer(x) (XtPointer)(x)

/* 
 * void
 * AtBarPlotAttachData
 *         in: AtBarPlotWidget		# bar plot widget
 * 	in: castXtPointer([float])	# floats
 * 	const: AtFloat
 * 	const: sizeof(float)
 * 	const: 1
 * 	const: argc-2
 */

int 
com_AtBarPlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float * localVar2;

     DBUG_ENTER("AtBarPlotAttachData");  

     if (argc < 3) 
	 {
	 argcError("AtBarPlotAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],atBarPlotWidgetClass,"AtBarPlot")))
          {
          convError("AtBarPlotAttachData","1",argv[1],"AtBarPlotWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    float *ptr;
          argv += 2;
          localVar2 = ptr =
             (float *)XtMalloc((argc-2)*sizeof(float));

          while (*argv)
             {
             if (!(sscanf(*argv, "%f", &*ptr)))
                  {
                  convError("AtBarPlotAttachData","2",*argv,"float");
                  DBUG_RETURN (TCL_ERROR);
                  }

          ptr ++; argv++;
          }
     }
     AtBarPlotAttachData(localVar1,castXtPointer(localVar2),AtFloat,sizeof(float),1,argc-2);
     MMreplace(MMgetAttribList(localVar1),WafePermStringToQuark("AtBarPlotAttachData"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * AtLabelAxisAttachData
 *         in: AtLabelAxisWidget		# label axis wiget
 * 	in: [char *]			# strings
 * 	const: sizeof(String)
 * 	const: 1
 * 	const: argc-2
 */

int 
com_AtLabelAxisAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * * localVar2;

     DBUG_ENTER("AtLabelAxisAttachData");  

     if (argc < 3) 
	 {
	 argcError("AtLabelAxisAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],atLabelAxisWidgetClass,"AtLabelAxis")))
          {
          convError("AtLabelAxisAttachData","1",argv[1],"AtLabelAxisWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    char * *ptr;
          argv += 2;
          localVar2 = ptr =
             (char * *)XtMalloc((argc-2)*sizeof(char *));

          while (*argv)
             {
             *ptr = XtNewString(*argv);
          ptr ++; argv++;
          }
     }
     AtLabelAxisAttachData(localVar1,localVar2,sizeof(String),1,argc-2);
     MMreplace(MMgetAttribList(localVar1),WafePermStringToQuark("AtLabelAxisAttachData"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * AtLinePlotAttachData
 *         in: AtLinePlotWidget		# line plot widget
 * 	in: castXtPointer([float])	# floats
 * 	const: AtFloat
 * 	const: sizeof(float)
 * 	const: 1
 * 	const: argc-2
 */

int 
com_AtLinePlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float * localVar2;

     DBUG_ENTER("AtLinePlotAttachData");  

     if (argc < 3) 
	 {
	 argcError("AtLinePlotAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],atLinePlotWidgetClass,"AtLinePlot")))
          {
          convError("AtLinePlotAttachData","1",argv[1],"AtLinePlotWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    float *ptr;
          argv += 2;
          localVar2 = ptr =
             (float *)XtMalloc((argc-2)*sizeof(float));

          while (*argv)
             {
             if (!(sscanf(*argv, "%f", &*ptr)))
                  {
                  convError("AtLinePlotAttachData","2",*argv,"float");
                  DBUG_RETURN (TCL_ERROR);
                  }

          ptr ++; argv++;
          }
     }
     AtLinePlotAttachData(localVar1,castXtPointer(localVar2),AtFloat,sizeof(float),1,argc-2);
     MMreplace(MMgetAttribList(localVar1),WafePermStringToQuark("AtLinePlotAttachData"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * AtPlotterGeneratePostscript
 *         in: char *            		       # file name
 *         in: (AtPlotterWidget)AtPlotterWidget   # plotter widget
 * 	in: char *            		       # title
 * 	in: int               		       # bounding box: x1
 * 	in: int              		       # bounding box: y1
 * 	in: int               		       # bounding box: x2
 * 	in: int               		       # bounding box: y2
 * 	in: Boolean           		       # landscape
 */

int 
com_AtPlotterGeneratePostscript(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar2;
     int localVar4;
     int localVar5;
     int localVar6;
     int localVar7;
     Boolean localVar8;

     DBUG_ENTER("AtPlotterGeneratePostscript");  

     if (argc != 9) 
	 {
	 argcError("AtPlotterGeneratePostscript","",8,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     if (!(localVar2 =  name2WidgetOfClass(argv[2],atPlotterWidgetClass,"AtPlotter")))
          {
          convError("AtPlotterGeneratePostscript","2",argv[2],"AtPlotterWidget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("AtPlotterGeneratePostscript","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[5], "%d", &localVar5)))
          {
          convError("AtPlotterGeneratePostscript","5",argv[5],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[6], "%d", &localVar6)))
          {
          convError("AtPlotterGeneratePostscript","6",argv[6],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[7], "%d", &localVar7)))
          {
          convError("AtPlotterGeneratePostscript","7",argv[7],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[8], "true")) 
         localVar8 = 1;
     else
     if (!strcmp(argv[8], "false")) 
         localVar8 = 0;
     else
         {
         convError("AtPlotterGeneratePostscript","8",argv[8],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     AtPlotterGeneratePostscript(argv[1],localVar2,argv[3],localVar4,localVar5,localVar6,localVar7,localVar8);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * ******* begin required file <AtHandCraft.inc> *******
 */
/* yes, it is really  -*-C-*-  */

void
xyLinePlotAttachData(w,argc,argv)
Widget    w;
int       argc;
char    **argv;
     {
     int count;
     float *x,*xarray, *y,*yarray;

     x = xarray = (float *)XtMalloc(sizeof(float)*argc);
     y = yarray = (float *)XtMalloc(sizeof(float)*argc);

     for (count = 0; count < argc; count++,x++,y++)
         {
         if (!(sscanf(argv[count],"%f/%f",x,y)))
              {
              convError("xyLinePlotAttachData","in array", argv[count],"x/y");
              return;
              }
          }

     AtXYLinePlotAttachData(w,
			    (XtPointer)xarray, AtFloat, sizeof(float),
			    (XtPointer)yarray, AtFloat, sizeof(float),
			    1,argc);

     MMreplace(MMgetAttribList(w),WafePermStringToQuark("LinePlotXData"),
	       (char*)xarray,XtFree);
     MMreplace(MMgetAttribList(w),WafePermStringToQuark("LinePlotYData"),
	       (char*)yarray,XtFree);
     }     



/* 
 * ******* end required file <AtHandCraft.inc> *******
 */
/* 
 * void
 * xyLinePlotAttachData vulgo AtXYLinePlotAttachData
 *         in: AtXYLinePlotWidget		# xyLine plot widget
 * 	in: [args]			# pairs of floats (xfloat/yfloat)

 */

int 
com_AtXYLinePlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("AtXYLinePlotAttachData");  

     if (argc < 3) 
	 {
	 argcError("AtXYLinePlotAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],atXYLinePlotWidgetClass,"AtXYLinePlot")))
          {
          convError("AtXYLinePlotAttachData","1",argv[1],"AtXYLinePlotWidget");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 2;
     xyLinePlotAttachData(localVar1,argc,&argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


#else
#include "wafe.h"
#endif

void
Initialize_AtGen()
{
#ifdef PLOTTER
 createWidgetCommand("AtAxis",atAxisWidgetClass,NULL,False);
 createWidgetCommand("AtBarPlot",atBarPlotWidgetClass,NULL,False);
 createWidgetCommand("AtLabelAxis",atLabelAxisWidgetClass,NULL,False);
 createWidgetCommand("AtLinePlot",atLinePlotWidgetClass,NULL,False);
 createWidgetCommand("AtPlotter",atPlotterWidgetClass,NULL,False);
 createWidgetCommand("AtTextPlot",atTextPlotWidgetClass,NULL,False);
 createWidgetCommand("AtXYAxis",atXYAxisWidgetClass,NULL,False);
 createWidgetCommand("AtXYLinePlot",atXYLinePlotWidgetClass,NULL,False);
#ifdef PLOTTER
 strcat(wafePackages,"PLOTTER ");
#endif
 Tcl_CreateCommand(wafeInterpreter, "AtBarPlotAttachData", com_AtBarPlotAttachData, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "AtLabelAxisAttachData", com_AtLabelAxisAttachData, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "AtLinePlotAttachData", com_AtLinePlotAttachData, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "AtPlotterGeneratePostscript", com_AtPlotterGeneratePostscript, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "AtXYLinePlotAttachData", com_AtXYLinePlotAttachData, NULL, NULL);

#else
#endif
}
