/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser
 * Version: 0.9
 */


#include <stdio.h>

#include <X11/Intrinsic.h>

#include <X11/StringDefs.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xmu/Drawing.h>
#include <X11/Shell.h>


#define CONVERTERS

#include "wafe.h"

#define done(address, type) \
        { (*toVal).size = sizeof(type); (*toVal).addr = (caddr_t) address; }

/* using non-caching converter for names to widget
   thanx Christian Holzbaur
 */

#define	newDone(type, value) \
	{							\
	    if (toVal->addr != NULL) {				\
		if (toVal->size < sizeof(type)) {		\
		    toVal->size = sizeof(type);			\
		    return False;				\
		}						\
		*(type*)(toVal->addr) = (value);		\
	    }							\
	    else {						\
		static type static_val;				\
		static_val = (value);				\
		toVal->addr = (XtPointer)&static_val;		\
	    }							\
	    toVal->size = sizeof(type);				\
	    return True;					\
	}

Boolean
CvtStringToWidget(dpy, args, num_args, fromVal, toVal, 
		  converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    Widget w = NULL;
    char *name = (char *)fromVal->addr;
    
    if (*name && !(w = name2Widget(name)))
	{
	XtDisplayStringConversionWarning(dpy, (String)name, XtRWidget);
	return False;
	}
    else
	newDone(Widget, w);
    }



/* convert string to callback: gustaf Sat Jul 11 15:09:12 MET DST 1992 */
Boolean
CvtStringToCallback(dpy, args, num_args, fromVal, toVal,
		    converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    XtCallbackList callback_list;
    char * charp = XtCalloc(
			    sizeof(XtCallbackList)*2 +
			    sizeof(XtCallbackRec[2]) +
			    sizeof(XrmQuark) +
			    strlen((char *)fromVal->addr) + 1 
			    ,1);
/*
 fprintf(stderr,"StringToCallback was called\n");
*/
    *(XtCallbackList*)charp = (XtCallbackList)(charp+sizeof(XtCallbackList)*2);
    *(XtCallbackList*)(charp+sizeof(XtCallbackList)) = NULL;
    callback_list = *(XtCallbackList*)charp;
    callback_list->callback = (XtCallbackProc)execCallbackProc;
    callback_list->closure = 
	charp + sizeof(XtCallbackList)*2 + sizeof(XtCallbackRec[2]);
/*
    fprintf(stderr,"charp %p, callback_list %p, callback_list->closure %p\n",
	    charp, callback_list, callback_list->closure);
*/
    *(XrmQuark *)callback_list->closure = currentAttrib;
    strcpy((char *)callback_list->closure + sizeof(XrmQuark), 
	   (char *)fromVal->addr);

    toVal->size = sizeof(XtCallbackList);
    toVal->addr = (caddr_t)charp;

    MMreplace(currentAttribList, currentAttrib, (char *)charp, XtFree);
/*
    {int i; char *p;
     for(p=charp,i=0; i<=
			    sizeof(XtCallbackList)*2 +
			    sizeof(XtCallbackRec[2]) +
			    sizeof(XrmQuark) +
			    strlen((char *)fromVal->addr) + 1 ;
	 i++,p++) fprintf(stderr,"%x[%c] ",*p & 0xff,*p & 0xff);
       fprintf(stderr,"\n");
   }
*/
    return True;
    }


/* convert string to Pointer: gustaf Sat Jul 11 15:09:12 MET DST 1992 */
Boolean
CvtStringToPointer(dpy, args, num_args, fromVal, toVal,
		   converter_data)
Display *dpy;
XrmValue *args;
Cardinal *num_args;
XrmValue *fromVal;
XrmValue *toVal;
XtPointer *converter_data;
    {
    static int argc;
    static char ** argv;
    
    Tcl_SplitList(interpreter,(char*)fromVal->addr, &argc,&argv);
/*
   {int i; for(i=0;i<argc;i++)   { fprintf(stderr,"%p -- %d: %s %p\n",argv,i,argv[i],argv[i]); }}
*/
    toVal->size = sizeof(char **);
    toVal->addr = (caddr_t)&argv;

    MMreplace(currentAttribList, currentAttrib, (char *)argv,XtFree);
    return True;
    }


