$PACKAGE = "MOTIF11";

~handles 
	MOTIF11

#include <stdio.h>

#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Shell.h>

#include "wafe.h"                             

~require
motif.inc
	conv XtRString "XmString"      None CvtStringToXmString  XmStringFree
	conv XtRString "XmStringTable" None CvtStringToXmStrings freeStringTab
	conv XtRString "Window"        None CvtStringToWidget    None
	conv XtRString "MenuWidget"    None CvtStringToWidget    None
	conv "XmString" XtRString      None CvtXmStringToString  None
	conv "XmStringTable" XtRString None CvtXmStringTableToString  None
	init compStringInit()
	init XtAddConverter (XmRString, XmRUnitType, XmCvtStringToUnitType, NULL, 0);


~widgetClass
XmArrowButton
	include <Xm/ArrowB.h>
	activateCallback c int: \
		((XmArrowButtonCallbackStruct *)callData)->click_count # click count


~gadgetClass
XmArrowButtonGadget
	include <Xm/ArrowBG.h>
	activateCallback c int: \
		((XmArrowButtonCallbackStruct *)callData)->click_count # click count


~widgetClass
XmBulletinBoard
	include <Xm/BulletinB.h>

~pseudoWidgetClass
XmBulletinBoardDialog
	className XmDialogShell
	createCmd XmCreateBulletinBoardDialog

~widgetClass
XmCascadeButton
	include <Xm/CascadeB.h>

~gadgetClass
XmCascadeButtonGadget
	include <Xm/CascadeBG.h>

void 
XmCascadeButtonGadgetHighlight
	in: Widget           # cascadeButtonGadget to be highlighted
	in: Boolean          # highlight (bool)

void 
XmCascadeButtonHighlight
	in: Widget           # widget to be highlighted
	in: Boolean          # highlight (bool)

~widgetClass
XmCommand
	include <Xm/Command.h>
	commandChanged|commandEntered s EscapedXmString: \
		((XmCommandCallbackStruct *)callData)->value # command string

void
XmCommandAppendValue
	in: Widget           # command widget 
	in: XmString         # command string
	post: XmStringFree(localVar2);

void
XmCommandError
	in: Widget           # command widget 
	in: XmString         # error message
	post: XmStringFree(localVar2);



~widgetClass
XmDialogShell
	include <Xm/DialogS.h>

~widgetClass
XmDrawingArea
        include <Xm/DrawingA.h>
	expose|input|resize W Window: \
		((XmDrawingAreaCallbackStruct *)callData)->window # window


~widgetClass
XmDrawnButton
        include <Xm/DrawnB.h>
	activate c int: \
		((XmDrawnButtonCallbackStruct *)callData)->click_count # click count
	expose|resize w Window: \
		((XmDrawnButtonCallbackStruct *)callData)->window # window



~widgetClass
XmFileSelectionBox
	include <Xm/FileSB.h>
	okCallback|noMatchCallback|applyCallback d EscapedXmString: \
		((XmFileSelectionBoxCallbackStruct *)callData)->dir \
			# base directory
	okCallback|noMatchCallback|applyCallback p EscapedXmString: \
		((XmFileSelectionBoxCallbackStruct *)callData)->pattern \
			# search pattern
	okCallback|noMatchCallback|applyCallback m EscapedXmString: \
		((XmFileSelectionBoxCallbackStruct *)callData)->mask \
			# value of dirMask
	okCallback|noMatchCallback|applyCallback s EscapedXmString: \
		((XmFileSelectionBoxCallbackStruct *)callData)->value \
			# value of dirSpec


Widget
XmFileSelectionBoxGetChild
	in: Widget			# message box widget
	in: (unsigned char)XmChild 	# child reference

~pseudoWidgetClass
XmFileSelectionDialog
	className XmDialogShell
	createCmd XmCreateFileSelectionDialog

void
XmFileSelectionDoSearch
	in: Widget			# file selection box
	in: XmString			# directory mask

~widgetClass
XmForm
	include <Xm/Form.h>

~pseudoWidgetClass 
XmFormDialog
	className XmDialogShell
	createCmd XmCreateFormDialog

~widgetClass
XmFrame
        include <Xm/Frame.h>

~pseudoWidgetClass
XmInformationDialog
	className XmDialogShell
	createCmd XmCreateInformationDialog

~widgetClass 
XmLabel
	include <Xm/Label.h>

~gadgetClass 
XmLabelGadget
	include <Xm/LabelG.h>

~widgetClass
XmList
	include <Xm/List.h>
	browseSelection|defaultAction|singleSelection s EscapedXmString: \
		((XmListCallbackStruct *)callData)->item \
			# selected item
	browseSelection|defaultAction|singleSelection p EscapedXmString: \
		((XmListCallbackStruct *)callData)->item_position \
			# item position
	extendedSelection|multipleSelection S XmStringTable: \
		((XmListCallbackStruct *)callData)->selected_item_count, \
		((XmListCallbackStruct *)callData)->selected_items \
			# selected items
	extendedSelection|multipleSelection P intArray: \
		((XmListCallbackStruct *)callData)->selected_item_count, \
		((XmListCallbackStruct *)callData)->selected_item_positions \
			# selected item positions
	browseSelection|defaultAction|extendedSelection|multipleSelection|singleSelection t int: \
		((XmListCallbackStruct *)callData)->selection_type \
			# selection type


~widgetClass 
XmMainWindow
	include <Xm/MainW.h>

void
XmMainWindowSetAreas
	in: NULL | Widget	# main window widget
	in: NULL | Widget	# menu bar widget
	in: NULL | Widget	# command window widget
	in: NULL | Widget	# horizontal scrollbar widget
	in: NULL | Widget	# vertical scrollbar widget
	in: NULL | Widget	# work region widget

~pseudoWidgetClass 
XmMenuBar
	className XmRowColumn
	createCmd XmCreateMenuBar

~widgetClass
XmMenuShell
        include <Xm/MenuShell.h>

~widgetClass 
XmMessageBox
	include <Xm/MessageB.h>

Widget
XmMessageBoxGetChild
	in: Widget			# message box widget
	in: (unsigned char)XmChild 	# child reference

~pseudoWidgetClass 
XmMessageDialog
	className XmMessageBox
	createCmd XmCreateMessageDialog

~pseudoWidgetClass
XmOptionMenu
	className XmRowColumn
	createCmd XmCreateOptionMenu

~widgetClass
XmPanedWindow
        include <Xm/PanedW.h>

~pseudoWidgetClass 
XmPopupMenu
	className XmRowColumn
	createCmd XmCreatePopupMenu

~pseudoWidgetClass
XmPromptDialog
	className XmDialogShell
	createCmd XmCreatePromptDialog

~pseudoWidgetClass 
XmPulldownMenu
	className XmRowColumn
	createCmd XmCreatePulldownMenu

~widgetClass
XmPushButton
	include <Xm/PushB.h>
	activate c int: \
		((XmPushButtonCallbackStruct*)callData)->click_count \
			# click count

~gadgetClass
XmPushButtonGadget
	include <Xm/PushBG.h>
	activateCallback c int: \
		((XmPushButtonCallbackStruct*)callData)->click_count \
			# click count

~pseudoWidgetClass
XmQuestionDialog
	className XmDialogShell
	createCmd XmCreateQuestionDialog

~pseudoWidgetClass 
XmRadioBox
	className XmRowColumn
	createCmd XmCreateRadioBox

~widgetClass 
XmRowColumn
	include <Xm/RowColumn.h>

~widgetClass
XmScale
        include <Xm/Scale.h>
	drag|valueChanged v int: \
		((XmScaleCallbackStruct *)callData)->value # value



~widgetClass
XmScrollBar
        include <Xm/ScrollBar.h>
        toBottom|toTop p int: \
                ((XmScrollBarCallbackStruct *)callData)->pixel # pixel
        decrement|drag|increment|pageDecrement|pageIncrement|toBottom|toTop|valueChanged v int: \
                ((XmScrollBarCallbackStruct *)callData)->value # value

~pseudoWidgetClass
XmScrolledList
	className XmList
	createCmd XmCreateScrolledList

~pseudoWidgetClass 
XmScrolledText
	className XmText
	createCmd XmCreateScrolledText

~widgetClass
XmScrolledWindow
        include <Xm/ScrolledW.h>

~widgetClass
XmSelectionBox
        include <Xm/SelectioB.h>
	apply|noMatch|ok v EscapedXmString: \
		((XmSelectionBoxCallbackStruct *)callData)->value # value


~pseudoWidgetClass
XmSelectionDialog
	className XmDialogShell
	createCmd XmCreateSelectionDialog

~widgetClass 
XmSeparator
	include <Xm/Separator.h>

~gadgetClass 
XmSeparatorGadget
	include <Xm/SeparatoG.h>

~pseudoWidgetClass
XmSimpleCheckBox
	className XmRowColumn
	createCmd XmCreateSimpleCheckBox

~pseudoWidgetClass
XmSimpleMenuBar
	className XmRowColumn
        createCmd XmCreateSimpleMenuBar

~pseudoWidgetClass
XmSimpleOptionMenu
        className XmRowColumn
        createCmd XmCreateSimpleOptionMenu

~pseudoWidgetClass
XmSimplePopupMenu
        className XmRowColumn
        createCmd XmCreateSimplePopupMenu

~pseudoWidgetClass
XmSimplePulldownMenu
        className XmRowColumn
        createCmd XmCreateSimplePulldownMenu

~pseudoWidgetClass
XmSimpleRadioBox
        className XmRowColumn
        createCmd XmCreateSimpleRadioBox

~widgetClass 
XmText
	include <Xm/Text.h>
	addRes pendingDelete Boolean
	addRes selectionArray Pointer
	addRes selectionArrayCount Int
	addRes selectThreshold Int
	addRes blinkRate Int
	addRes columns Short
	addRes cursorPositionVisible Boolean
	addRes fontList FontList
	addRes rows Short
	addRes resizeHeight Boolean
	addRes resizeWidth Boolean
	addRes wordWrap Boolean
	addRes scrollHorizontal Boolean
	addRes scrollLeftSide Boolean
	addRes scrollTopSide Boolean
	addRes scrollVertical Boolean
        losingFocus|modifyVerify|motionVerify c XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)->currInsert \
			# position insert cursor
        losingFocus|modifyVerify|motionVerify n XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)->newInsert \
			# new position of insert cursor
        losingFocus|modifyVerify s XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)->startPos \
			# startPos
        losingFocus|modifyVerify e XmTextPosition: \
                ((XmTextVerifyCallbackStruct *)callData)-> endPos \
			# endPos
        modifyVerify t EscapedString: \
                ((XmTextVerifyCallbackStruct *)callData)->text->ptr \
			# text

~widgetClass 
XmTextField
	include <Xm/TextF.h>

~widgetClass 
XmToggleButton
	include <Xm/ToggleB.h>
	valueChangedCallback s int: \
		((XmToggleButtonCallbackStruct *)callData)->set # state

Boolean
XmToggleButtonGetState
	in: Widget		# toggle button widget

void
XmToggleButtonSetState
	in: Widget		# toggle button widget
	in: Boolean		# state (bool)
	in: Boolean             # notify (bool)

~gadgetClass 
XmToggleButtonGadget
	include <Xm/ToggleBG.h>
	valueChangedCallback s int: \
		((XmToggleButtonCallbackStruct *)callData)->set # state

Boolean
XmToggleButtonGadgetGetState
	in: Widget		# toggle button widget

void
XmToggleButtonGadgetSetState
	in: Widget		# toggle button gadget
	in: Boolean		# state (bool)
	in: Boolean             # notify (bool)

#### Misc Widget Functions ####

void
XmAddTabGroup
	in: Widget        # widget to be added

~pseudoWidgetClass
XmWarningDialog
        className XmDialogShell
        createCmd XmCreateWarningDialog

~pseudoWidgetClass
XmWorkingDialog
        className XmDialogShell
        createCmd XmCreateWorkingDialog

