/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Tue Jun 15 04:25:32 MET DST 1993 on dec4.wu-wien.ac.at
 * Author: genc
 * Version: 0.92
 */
#ifdef PLOTTER
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "wafe.h"

#include <X11/At/Axis.h>
#include <X11/At/BarPlot.h>
#include <X11/At/LabelAxis.h>
#include <X11/At/LinePlot.h>
#include <X11/At/Plot.h>
#include <X11/At/Plotter.h>
#include <X11/At/TextPlot.h>
#include <X11/At/XYAxis.h>
#include <X11/At/XYLinePlot.h>
#define castXtPointer(x) (XtPointer)(x)

/* 
 * void
 * AtBarPlotAttachData vulgo barPlotAttachData
 *         in: Widget			# bar plot widget
 * 	in: castXtPointer([float])	# floats
 * 	const: AtFloat
 * 	const: sizeof(float)
 * 	const: 1
 * 	const: argc-2
 */

int 
com_barPlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float * localVar2;

     DBUG_ENTER("barPlotAttachData");  

     if (argc < 3) 
	 {
	 argcError("barPlotAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("barPlotAttachData","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    float *ptr;
          argv += 2;
          localVar2 = ptr =
             (float *)XtMalloc((argc-2)*sizeof(float));

          while (*argv)
             {
             if (!(sscanf(*argv, "%f", &*ptr)))
                  {
                  convError("barPlotAttachData","2",*argv,"float");
                  DBUG_RETURN (TCL_ERROR);
                  }

          ptr ++; argv++;
          }
     }
     AtBarPlotAttachData(localVar1,castXtPointer(localVar2),AtFloat,sizeof(float),1,argc-2);
     MMreplace(MMgetAttribList(localVar1),XrmStringToQuark("barPlotAttachData"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * AtLabelAxisAttachData vulgo labelAxisAttachData
 *         in: Widget			# label axis wiget
 * 	in: [char *]			# strings
 * 	const: sizeof(String)
 * 	const: 1
 * 	const: argc-2
 */

int 
com_labelAxisAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * * localVar2;

     DBUG_ENTER("labelAxisAttachData");  

     if (argc < 3) 
	 {
	 argcError("labelAxisAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("labelAxisAttachData","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    char * *ptr;
          argv += 2;
          localVar2 = ptr =
             (char * *)XtMalloc((argc-2)*sizeof(char *));

          while (*argv)
             {
             *ptr = XtNewString(*argv);
          ptr ++; argv++;
          }
     }
     AtLabelAxisAttachData(localVar1,localVar2,sizeof(String),1,argc-2);
     MMreplace(MMgetAttribList(localVar1),XrmStringToQuark("labelAxisAttachData"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * AtLinePlotAttachData vulgo linePlotAttachData
 *         in: Widget			# line plot widget
 * 	in: castXtPointer([float])	# floats
 * 	const: AtFloat
 * 	const: sizeof(float)
 * 	const: 1
 * 	const: argc-2
 */

int 
com_linePlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float * localVar2;

     DBUG_ENTER("linePlotAttachData");  

     if (argc < 3) 
	 {
	 argcError("linePlotAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("linePlotAttachData","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    float *ptr;
          argv += 2;
          localVar2 = ptr =
             (float *)XtMalloc((argc-2)*sizeof(float));

          while (*argv)
             {
             if (!(sscanf(*argv, "%f", &*ptr)))
                  {
                  convError("linePlotAttachData","2",*argv,"float");
                  DBUG_RETURN (TCL_ERROR);
                  }

          ptr ++; argv++;
          }
     }
     AtLinePlotAttachData(localVar1,castXtPointer(localVar2),AtFloat,sizeof(float),1,argc-2);
     MMreplace(MMgetAttribList(localVar1),XrmStringToQuark("linePlotAttachData"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * AtPlotterGeneratePostscript vulgo plotterGeneratePostscript
 *         in: char *            		# file name
 *         in: (AtPlotterWidget)Widget     # plotter widget
 * 	in: char *            		# title
 * 	in: int               		# bounding box: x1
 * 	in: int              		# bounding box: y1
 * 	in: int               		# bounding box: x2
 * 	in: int               		# bounding box: y2
 * 	in: Boolean           		# landscape
 */

int 
com_plotterGeneratePostscript(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     char * localVar1;
     AtPlotterWidget localVar2;
     char * localVar3;
     int localVar4;
     int localVar5;
     int localVar6;
     int localVar7;
     Boolean localVar8;

     DBUG_ENTER("plotterGeneratePostscript");  

     if (argc != 9) 
	 {
	 argcError("plotterGeneratePostscript","",8,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     if (!(localVar2 = (AtPlotterWidget) name2Widget(argv[2])))
          {
          convError("plotterGeneratePostscript","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("plotterGeneratePostscript","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[5], "%d", &localVar5)))
          {
          convError("plotterGeneratePostscript","5",argv[5],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[6], "%d", &localVar6)))
          {
          convError("plotterGeneratePostscript","6",argv[6],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[7], "%d", &localVar7)))
          {
          convError("plotterGeneratePostscript","7",argv[7],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[8], "true")) 
         localVar8 = 1;
     else
     if (!strcmp(argv[8], "false")) 
         localVar8 = 0;
     else
         {
         convError("plotterGeneratePostscript","8",argv[8],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     AtPlotterGeneratePostscript(argv[1],localVar2,argv[3],localVar4,localVar5,localVar6,localVar7,localVar8);

     DBUG_RETURN (TCL_OK);
     }     


/* yes, it is really  -*-C-*-  */

void
xyLinePlotAttachData(w,argc,argv)
Widget    w;
int       argc;
char    **argv;
     {
     int count;
     float *x,*xarray, *y,*yarray;

     x = xarray = (float *)XtMalloc(sizeof(float)*argc);
     y = yarray = (float *)XtMalloc(sizeof(float)*argc);

     for (count = 0; count < argc; count++,x++,y++)
         {
         if (!(sscanf(argv[count],"%f/%f",x,y)))
              {
              convError("barPlotAttachData","in array", argv[count],"x/y");
              return;
              }
	 }

     AtXYLinePlotAttachData(w,
			    (XtPointer)xarray, AtFloat, sizeof(float),
			    (XtPointer)yarray, AtFloat, sizeof(float),
			    1,argc);

     MMreplace(MMgetAttribList(w),XrmStringToQuark("LinePlotXData"),
	       (char*)xarray,XtFree);
     MMreplace(MMgetAttribList(w),XrmStringToQuark("LinePlotYData"),
	       (char*)yarray,XtFree);
     }     



/* 
 * void
 * xyLinePlotAttachData
 *         in: Widget			# xyLine plot widget
 * 	in: [args]			# pair of floats (xfloat/yfloat)

 */

int 
com_xyLinePlotAttachData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("xyLinePlotAttachData");  

     if (argc < 3) 
	 {
	 argcError("xyLinePlotAttachData","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("xyLinePlotAttachData","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 2;
     xyLinePlotAttachData(localVar1,argc,&argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


#else
#include <string.h>
#endif

void
Initialize_AtGen()
{
#ifdef PLOTTER
 createWidgetCommand("axis",atAxisWidgetClass,NULL);
 createWidgetCommand("barPlot",atBarPlotWidgetClass,NULL);
 createWidgetCommand("labelAxis",atLabelAxisWidgetClass,NULL);
 createWidgetCommand("linePlot",atLinePlotWidgetClass,NULL);
 createWidgetCommand("plotter",atPlotterWidgetClass,NULL);
 createWidgetCommand("textPlot",atTextPlotWidgetClass,NULL);
 createWidgetCommand("xyAxis",atXYAxisWidgetClass,NULL);
 createWidgetCommand("xyLinePlot",atXYLinePlotWidgetClass,NULL);
#ifdef PLOTTER
 strcat(packages,"PLOTTER ");
#endif
 Tcl_CreateCommand(interpreter, "barPlotAttachData", com_barPlotAttachData, NULL, NULL);
 Tcl_CreateCommand(interpreter, "labelAxisAttachData", com_labelAxisAttachData, NULL, NULL);
 Tcl_CreateCommand(interpreter, "linePlotAttachData", com_linePlotAttachData, NULL, NULL);
 Tcl_CreateCommand(interpreter, "plotterGeneratePostscript", com_plotterGeneratePostscript, NULL, NULL);
 Tcl_CreateCommand(interpreter, "xyLinePlotAttachData", com_xyLinePlotAttachData, NULL, NULL);

#else
#endif
}
