#define XT

$PACKAGE = "XT";

~handles
	XPM

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "wafe.h"                             

#include <X11/Shell.h>
#include <X11/Xatom.h>

~require
	basic.inc

~require 
	Xt.inc

void
XtAppAddTimeOut vulgo addTimeOut
	const: appContext 
	in: unsigned long		# time interval in ms
	const: timerProc
	in: XtNewString(String)		# tcl command

void
action
	in: Widget			# widget
	in: (int)TranslationModifier	# override | augment | replace
        in: XtTranslations		# translatontable

~widgetClass
applicationShell
	createCmd XtAppCreateShell

void
XBell
	in: XtDisplay(Widget)		# widget to determine display
	in: int				# percent (-100 = off, 0 .. 100)

void
callActionProc
	in: Widget			# widget
	in: String			# event type
	in: String			# action
	in: [args opt]			# args

void
callCallbacks
	in: Widget			# widget
	in: String			# callback
	in: [args]			# optional float and value 

extern positionCallbackProc();
extern positionCursorCallbackProc();

void
callback
	in: Widget			# widget
	in: String			# callback resource
        in: XtCallbackProc		# none | exclusive | nonexclusive | popdown | position | positionCursor
        in: XtNewString(String)		# string


void
XtDestroyWidget
	callmultiple
		in: MMfreeGarbage(Widget)	# widgets

#include <X11/IntrinsicP.h>
#define getClass(widget) (XtClass(widget)->core_class.class_name)

String
getClass
	in: Widget				# widget

int
getResourceList
	in: Widget				# widget
	out: String *				# varname for output of reslist
	end: XtFree((String)localVar2);

XrmQuark
getQTypeOfAttribute vulgo getTypeOfAttribute
	in: XtClass(Widget)			# widget
	const: ParentWidget(localVar1)
	in: XrmStringToQuark(String)		# attribute

String
getValue
	in: Widget			# widget
	in: XrmQuark			# attribute
	free: freeProc

(int) GrabReturns
XtGrabPointer
	in: Widget			# widget
	in: Boolean			# true | false
        const: NoEventMask
	in: (int) SyncAsync		# pointer mode (sync | async)
	in: (int) SyncAsync             # keyboard mode (sync | async)
	in: None | XtWindow(Widget)	# None | confine widget
	const: None
	const: CurrentTime

(int) GrabReturns
XtGrabKeyboard
	in: Widget			# widget
	in: Boolean			# true | false
	in: (int) SyncAsync		# pointer mode (sync | async)
	in: (int) SyncAsync		# keyboard mode (sync | async)
	const: CurrentTime


#define installAccelerators(destination,source,table) \
	{ XtVaSetValues(source, XtNaccelerators, table, NULL); \
          XtInstallAccelerators(destination, source);}

void
installAccelerators
	in: Widget			# destination
	in: Widget			# source
	in: XtAccelerators		# table

void
XtManageChild
	callmultiple
		in: Widget		# widgets

void
XtMapWidget
	callmultiple
		in: Widget		# widgets

#define mergeResources(localVar1,argc,argv) { \
     XrmDatabase    dispDb, newDb = NULL; \
     int            i; \
     char         **v = argv; \
     dispDb = XtDatabase(XtDisplay(localVar1)); \
     for (i = 0; i < argc; i+=2) \
          XrmPutStringResource(&newDb, v[i], v[i+1]); \
     XrmMergeDatabases(newDb, &dispDb);}

void 
mergeResources
	in: Widget			# widget to determine display
	in: [args even] 		# resource value pairs

~widgetClass
overrideShell
	createCmd XtCreatePopupShell

void
XtPopdown
        in: Widget			# shell widget

void
XtPopup
        in: Widget			# widget
        in: XtGrabKind			# none | nonexclusive | exclusive

void
XtPopupSpringLoaded
        in: Widget			# shell widget

void
realizeWidgets vulgo realize

void
XtRemoveAllCallbacks
	in: Widget			# widget
	in: String			# callback name

void
XtSetKeyboardFocus
	in: Widget			# from widget tree
	in: None|Widget			# to widget | None

#define setValues(w,argc,argv) {\
    ArgList           args; \
    int               numArgs; \
    if (convert(ParentWidget(w), XtClass(w), \
		argv, argc, &args, &numArgs, w)) { \
	XtSetValues(w, args, numArgs); \
	XtFree((String)args); \
	} \
    } 

void
setValues
	in: Widget			# widget
	in: [args even]			# resource value pairs

#define ptr(w) &(w)

Boolean 
XSetWMProtocols
	const: XtDisplay(localVar1)
	in: XtWindow(Widget)		# Shell Widget
	in: ptr((Atom)WM_PROTOCOLS)	# WM\_TAKE\_FOCUS | WM\_SAVE\_YOURSELF | WM\_DELETE\_WINDOW
	const: 1

~widgetClass
topLevelShell
	createCmd XtCreatePopupShell

~widgetClass
transientShell
	createCmd XtCreatePopupShell

void
XtTranslateCoords
	in: Widget			# widget
	in: Position    		# widget x
	in: Position    		# widget y
	out: Position   		# variable name for root x
	out: Position   		# variable name for root y

void
XtUngrabPointer
	in: Widget			# widget with active pointer grab
	const: CurrentTime

void
XtUngrabKeyboard
	in: Widget			# widget with active keyboard grab
	const: CurrentTime

void
XtUnmanageChild
	callmultiple
		in: Widget		# widgets

void
XtUnmapWidget
	callmultiple
		in: Widget		# widgets

void
XtUnrealizeWidget
	callmultiple
		in: Widget		# widgets










#####  selection handling #####

void
XtDisownSelection
	const: topLevel
	const: XA_PRIMARY
	const: CurrentTime

extern void getSelectionValueProc();

void
XtGetSelectionValue
	const: topLevel
	const: XA_PRIMARY
	const: XA_STRING
	const: getSelectionValueProc
	in: XtNewString(String)		# Tcl command
	const: CurrentTime


Boolean
ownSelection
	in: XtNewString(String) # string to be put into selection
	in: NULL | String 	# NULL | loseSelection TCL-command
	in: NULL | String 	# NULL | doneSelection TCL-command


# get the PRIMARY selection, put it into Cut Buffer 0 and fetch it ...

String
XFetchBytes
	pre: { int bytes; \
		XConvertSelection(XtDisplay(localVar1), XA_PRIMARY, \
			XA_STRING, XA_CUT_BUFFER0, \
			DefaultRootWindow(XtDisplay(localVar1)), \
			CurrentTime); 
	in: XtDisplay(Widget) 		# widget to determine display
        const:  &bytes
	post: }
	end: XtFree(returnVar);

void
XConvertSelection
	in: XtDisplay(Widget)		# widget to determine display
	const: XA_PRIMARY
	const: XA_STRING
	in: Atom			# target buffer number
	const: DefaultRootWindow(XtDisplay(topLevel))
	const: CurrentTime


void
XStoreBuffer
	in: XtDisplay(Widget)		# widget to determine display
	in: String			# String
	const: strlen(argv[1])
	in: int				# buffer number (1-7)


String
XFetchBuffer
	in: XtDisplay(Widget)		# widget to determine display
	const: &nbytes
	in: int				# buffer number (1-7)
	pre: {int nbytes;
	post: }
	end: XtFree(returnVar);



~alias 
	sV setValues
	gV getValue

#####  XPM related commands #####

hint: XPM
~require 
xpm.inc
	conv XtRString XtRPixmap ByDisplay CvtStringToPixmapOrBitmap None \
						True-Boolean
	conv XtRString XtRBitmap ByDisplay CvtStringToPixmapOrBitmap None 

hint: XPM
void
setIconPixmap
	in: Widget			# Shell Widget (eg topLevel)
	in: String			# pixmap file

hint: XPM
void
changePixmap
	in: Widget			# widget
	in: String			# resource
	in: String			# pixmap file

