/* yes buddy, it is a -*- c -*- program! */

 /*
    * This file contains a new converter procedure and xpm support procedures:
    *
    *    A new StringToBitmap Converter, which is also able to convert
    *    Pixmaps (suffix .xpm). First it searches for a valid BitmapFile
    *    under the given filename; if the file format is invalid, it
    *    tries to interpret it as a pixmap file.
    */ 


#ifdef XPM
#include <xpm.h>
#include <X11/extensions/shape.h>
#include <unistd.h>

 /* Create a linked list, which keeps track of all created pixmaps,
  * so that we can destroy Colorcells, if they are not longer needed.
  * Only the changePixmap command will use this feature, so pixmaps which
  * are set with setValues are still cached as usual!
  * Note that setting a pixmap with setValues therefore implies loosing these 
  * colorcells for the application's lifetime!
  */

typedef struct _PixmapInfo
     {
     Pixmap                pm;              /* Pixmap              */
     Widget                widget;          /* Widget              */
     XpmAttributes         *attribPtr;      /* Colorcells, etc     */
     char                 *pmName;          /* The filename..      */
     struct _PixmapInfo   *next;
     }  PIXMAPINFO, *PIXMAPINFOPTR;

PIXMAPINFOPTR  pixmapListHead = NULL;


void
changePixmap(w,resource,fname)
Widget     w;
String     resource;
String     fname;
    {
    Colormap        cmap;
    Pixmap          death, pixmap, mask;
    Screen         *screen;
    Display        *dpy;
    int             screenNum;
    int             returnVal;
    unsigned int    depth;
    XpmAttributes  *attribPtr;
    PIXMAPINFOPTR   pptr, cptr;
    
    dpy = XtDisplay(w);
    screen = DefaultScreenOfDisplay(dpy);
    screenNum = DefaultScreen(dpy);
    depth = DefaultDepth(dpy, DefaultScreen(dpy));

    /* Get pixmap adress and colormap of the pixmap, which will be destroyed  */
    
    XtVaGetValues(w, resource,     &death, 
		  XtNcolormap, &cmap, NULL);

  /* Search the list of pixmaps to find out wether the specified pixmap's 
      * resources are to be freed - which is the case when it was created by
      * this procedure.
      */

    if (pixmapListHead)
	{
	for (pptr = pixmapListHead; pptr != NULL; pptr = pptr->next)
	    {
	    if ((pptr->pm == death) && (pptr->widget == w))
		{
		if (!strcmp(pptr->pmName, fname))
		    {
		    DBUG_PRINT("pixmap",
			       ("You are about to set the same pixmap!"));
		    return;
		    }

		/* Set pixmap to "None" => destroying will be save */
		XtVaSetValues(w, resource, None, NULL);

		/* Take destroyed Pixmap from pixmaplist and deallocate memory */
		DBUG_PRINT("pixmap",
			   ("found pixmap %s of widget %s, %d colors freed", 
			    resource, XtName(w), pptr->attribPtr->npixels));

		XFreePixmap(XtDisplay(w), death);
		if (pptr->attribPtr->depth > 1) 
		    XFreeColors(XtDisplay(w), cmap, pptr->attribPtr->pixels, 
				pptr->attribPtr->npixels, 0);

		XpmFreeAttributes(pptr->attribPtr);

		DBUG_PRINT("pixmap", ("Managing the List"));
		if (pptr == pixmapListHead)
		    {
		    XtFree((char *)pixmapListHead);
		    pixmapListHead = NULL;
		    }
		else
		    {
		    for(cptr = pixmapListHead; 
			cptr->next != pptr; 
			cptr = cptr->next);
		    
		    if (pptr->next == NULL)     /* last Pixmap in list */
			cptr->next = NULL;
		    else                        /* not last Pixmap in list */
			cptr->next = pptr->next;

		    XtFree((char *)pptr);
		    }
		}
	    }
	}

    /* If the new pixmap's filename is None, => don't create new entry. */

    if (!strcmp(fname, "None"))
	{
	DBUG_PRINT("pixmap",
		   ("Setting %s %s to None", XtName(w), resource));
	XtVaSetValues(w, resource, None, NULL);
	return;
	}
    if (!strcmp(fname, "Unspecified"))
	{
	DBUG_PRINT("pixmap",
		   ("Setting %s %s to Unspecified", XtName(w), resource));
	XtVaSetValues(w, resource, XtUnspecifiedPixmap, NULL);
	return;
	}
    if (!strcmp(fname, "ParentRelative"))
	{
	DBUG_PRINT("pixmap",
		   ("Setting %s %s to ParentRelative", XtName(w), resource));
	XtVaSetValues(w, resource, ParentRelative, NULL);
	return;
	}

    /* Now convert the new Pixmap-File, create a new element of the list 
         * and fill it with information.
         */

    attribPtr = (XpmAttributes *)XtCalloc(sizeof(XpmAttributes), sizeof(char));
    attribPtr->valuemask = XpmReturnPixels | XpmDepth | XpmReturnInfos;
    attribPtr->depth = DefaultDepthOfScreen(DefaultScreenOfDisplay(XtDisplay(w)));

    returnVal = XpmReadFileToPixmap(dpy, RootWindow(dpy, screenNum), 
				    fname, &pixmap, &mask, attribPtr); 

    if (returnVal == XpmSuccess)
	{
	if (!pixmapListHead)   /* First Pixmap */
	    {
	    cptr = 
		pixmapListHead = 
		    (PIXMAPINFOPTR)XtMalloc(sizeof(PIXMAPINFO));
	    pixmapListHead->next = NULL;
	    }
	else
	    {
	    for(cptr = pixmapListHead; cptr->next != NULL; cptr = cptr->next);
	    cptr->next = (PIXMAPINFOPTR)XtMalloc(sizeof(PIXMAPINFO));
	    cptr = cptr->next;
	    cptr->next = NULL;
	    }

	cptr->widget = w;
	cptr->pm = pixmap;
	cptr->pmName = XtNewString(fname);
	cptr->attribPtr = attribPtr;

	DBUG_PRINT("pixmap", 
		   ("%d colorcells are used for %s\n", 
		    cptr->attribPtr->npixels, cptr->pmName));
     
	XtVaSetValues(w, resource, pixmap, NULL);

	if XtWindow(w) 
	      XShapeCombineMask(XtDisplay(w), XtWindow(w), ShapeBounding,
			      0, 0, mask, ShapeSet);

	DBUG_PRINT("pixmap", ("Conversion OK, new Pixmap was set"));
	return;
	}
    else
	{
	fprintf(stderr, "Wafe(changePixmap): Couldn't convert\n");
	XpmFreeAttributes(attribPtr);
	return;
	}
    }     

void
setIconPixmap(w,fname)
Widget   w;
String   fname;
    {
    Window        iconWindow;
    Pixmap        pixmap, mask;
    int           iconWidth, iconHeight;
    XpmAttributes attrib;
    Window        root;
    Display      *dpy;
    Pixel         bpix;

    dpy = XtDisplay(w);
    root = RootWindow(dpy, DefaultScreen(dpy));
    bpix = XBlackPixelOfScreen(DefaultScreenOfDisplay(dpy));
    attrib.valuemask = XpmReturnInfos;

    if (XpmReadFileToPixmap(dpy, root, fname, &pixmap, &mask, &attrib) 
	!= XpmSuccess)
	{
	fprintf(stderr, "Wafe(setIconPixmap): couldn't convert %s to pixmap\n",
		fname);
	return;
	}
    
    iconWidth = attrib.width;
    iconHeight = attrib.height;
    iconWindow = XCreateSimpleWindow(dpy, root, 0, 0, 
				     iconWidth, iconHeight, 1, bpix, bpix);

    XSetWindowBackgroundPixmap(dpy, iconWindow, pixmap);
    XShapeCombineMask(dpy, iconWindow, ShapeBounding,
			  0, 0, mask, ShapeSet);
    
    XtVaSetValues(w, XtNiconWindow, iconWindow, NULL);
    return;
    }


#define done(address, type) \
        { (*toVal).size = sizeof(type); (*toVal).addr = (caddr_t) address; }
               

Boolean
CvtStringToPixmapOrBitmap(dpy, args, num_args, fromVal, toVal,
		   converter_data)
Display *dpy;
XrmValuePtr args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer *converter_data;
    {
    static Pixmap    pixmap;               /* static for cvt magic */
    Pixmap           dummy;
    String           name;
    Screen          *screen;
    int              screenNum;
/*
    XrmDatabase      db;
 */
    String           fn = NULL;
    unsigned int     width, height;
    int              xhot, yhot;
    unsigned char   *data;
    XpmAttributes   *attributePtr;
    int              returnValue;
    PIXMAPINFOPTR    pptr, cptr;
    Boolean          toPixmap = *num_args>0;

    pixmap = NULL;
    name   = (String)fromVal->addr;
/*
    fprintf(stderr,"i am converting <%s> to %s\n",   
	  name, toPixmap ? "Pixmap" : "Bitmap");
 */
    screen = DefaultScreenOfDisplay(dpy);
    screenNum = DefaultScreen(dpy);
    
    if (strcmp(name, "None") == 0) 
        {
        pixmap = None;
        done(&pixmap, Pixmap);
        return True;
        }

    if (strcmp(name, "ParentRelative") == 0 && toPixmap) 
        {
        pixmap = ParentRelative;
        done(&pixmap, Pixmap);
        return True;
        }

    if (strcmp(name, "Unspecified") == 0 && toPixmap) 
        {
        pixmap = XtUnspecifiedPixmap;
        done(&pixmap, Pixmap);
        return True;
        }

    if (!toPixmap) 
        {
	pixmap = XmuLocateBitmapFile(screen, name,
				     NULL, 0, NULL, NULL, NULL, NULL);
        }

#ifndef PRER5

    if (pixmap == None) 
        {
/*
        db = XrmGetDatabase(dpy);
        XrmSetDatabase(dpy, XtScreenDatabase(screen));
 */
        if (access(name, R_OK) == 0)
            fn = name;

        if (!fn)
            {
            fn = XtResolvePathname(dpy, "bitmaps", name, "", NULL, NULL, 0, NULL);
	    /* fprintf(stderr,"1 read bitmap from <%s>  <%s>\n",fn,name); */
            }

        if (!fn)
            {
            fn = XtResolvePathname(dpy, "", name, ".xbm", NULL, NULL, 0, NULL);
	    /* fprintf(stderr,"2 read bitmap from <%s>  <%s>\n",fn,name); */
            }
/*
	XrmSetDatabase(dpy, db);
 */
	if (fn &&
	    XmuReadBitmapDataFromFile(fn, &width, &height, &data,
				      &xhot, &yhot) == BitmapSuccess) 
	    {
	    pixmap = XCreatePixmapFromBitmapData(dpy,
				 RootWindowOfScreen(screen),
				 (char *) data, width, height, 1, 0, 
				 DefaultDepth(dpy, DefaultScreen(dpy)));
	    XFree((char *)data);
            if (name!=fn) XtFree(fn);
	    }
        }
#endif

    if (pixmap != None) 
        {
	/* fprintf(stderr,"must be a bitmap x%p\n", pixmap); */
        done (&pixmap, Pixmap);
	return True;
        } 
    else 
        {
        if ((returnValue = XpmReadFileToPixmap(dpy, RootWindow(dpy, screenNum),
				name, &pixmap, &dummy, NULL)) != XpmSuccess)
	    {
	    XtStringConversionWarning(name, "Pixmap");
	    fprintf(stderr, "Wafe(convertPixmap): XPM-Error-Code: %d\n", 
		    returnValue);
	    return False;
	    }
        else 
	    {
/*	    fprintf(stderr, "the pixmap is... %p\n", pixmap);*/
	    done (&pixmap, Pixmap);
	    return True;
	    }
	}
#endif
    }




