#include <dbug.h>
#include <tcl.h>

#define SEND(x) write(toClient, x ,strlen(x)); write(toClient, "\n", 1)
#define ParentWidget(w) ((w) != topLevel ? XtParent(w) : (w))
#define Nil(Typ)        ((Typ *) 0)     /* Make Lint happy */




#ifndef PRER5
#define IFCONVERTANDSTORE(w, from,inp, to,outp) \
	if(XtConvertAndStore(w, from, & inp, to, & outp))
#else
#define IFCONVERTANDSTORE(w, from, inp, to, outp) \
	  XtConvert(w, from, & inp, to, & outp); \
	    if (outp.addr)
#endif

#if NeedFunctionPrototypes
#define COM_PROTOTYPE(com_tcl) \
	extern int com_tcl(ClientData, Tcl_Interp*, int, char**);
#else
#define COM_PROTOTYPE(com_tcl) extern int com_tcl();
#endif


#define MESSAGE_COMMAND_LENGTH	4096
#define INT_AS_STRING 		10
#define FLOAT_AS_STRING		20
#define MAX_NAME_LEN		30
#define MAX_TYPE_LEN		30
#define INT_ARRAY_IN_BYTES	4096

#define BUF_SIZE		65536
#define COMBUFSIZE		65536
#define STDIN_BUF_SIZE		1024
#define STDERR_BUF_SIZE		1024


#define YES                    1
#define NO                     0


/* 
 * global variables 
 * 
 */

#ifdef MAIN 
#define WAFE_EXTERN
#define INITIALIZE(var,value) var = value
#else
#define WAFE_EXTERN extern
#define INITIALIZE(var, value) var
#endif



WAFE_EXTERN char INITIALIZE(ONE[],"1");
WAFE_EXTERN char INITIALIZE(ZERO[],"0");

WAFE_EXTERN char INITIALIZE(*comBuffer, NULL);

WAFE_EXTERN Tcl_Interp    *interpreter; /* tcl-interpreter for the whole app */
WAFE_EXTERN XtAppContext   appContext;  /* application context               */
WAFE_EXTERN Widget         topLevel;    /* top level window                  */

WAFE_EXTERN int INITIALIZE(pid, 0);     /* Process-ID of child process       */

WAFE_EXTERN int            comWafe;     /* Extra communication channel       */
WAFE_EXTERN int            comClient;
WAFE_EXTERN int            toClient;    /* Standard Communication Channel    */
WAFE_EXTERN int            fromClient;  /* Standard Communication Channel    */
WAFE_EXTERN int            errorClient; /* For error messages of application */

WAFE_EXTERN int INITIALIZE(directMode, False); /* Flags for the different Modes  */
WAFE_EXTERN int INITIALIZE(fileMode, False);
WAFE_EXTERN int INITIALIZE(inputMode, False);
WAFE_EXTERN char INITIALIZE(promptChar, '%');

WAFE_EXTERN XrmQuark       currentAttrib;

WAFE_EXTERN char           class[50];
WAFE_EXTERN char           application[100];
WAFE_EXTERN char           packages[100];

/* user defineable handlers */
#define STDIN 0
#define STDOUT 1
#define STDERR 2
#define XIOERR 3
#define HANDLERMAX XIOERR+1
WAFE_EXTERN char *tclHandlers[HANDLERMAX];


typedef struct _MMattribList
        {
        XrmQuark               attribute;
        char                  *value;
        struct _MMattribList  *next;
        } MMattribList, *MMattribListPtr;


typedef struct _WidgetListItem
        {
        Widget                widget;
        XtPointer             info;
        struct _WidgetListItem *next;
        } WidgetListItem, *WidgetListPtr;


typedef struct _STRINFO
        {
        char                *addr;
        Widget               widget;
        char                *attribute;
        struct _STRINFO     *next;
        } STRINFO, *STRINFOPTR;

WAFE_EXTERN STRINFO STRINFOroot;
WAFE_EXTERN STRINFOPTR strHead;
WAFE_EXTERN MMattribListPtr currentStrInfo;
WAFE_EXTERN WidgetListPtr MMwidgetListHead;
WAFE_EXTERN WidgetListPtr widgetTrees;

typedef void (*freeProc)(
#if NeedFunctionPrototypes
    char *
#endif			 
);

WAFE_EXTERN Widget name2Widget(
#if NeedFunctionPrototypes
     char *
#endif
);

WAFE_EXTERN Widget name2Sink(
#if NeedFunctionPrototypes
     char *
#endif
);

WAFE_EXTERN char * intsToTcl(
#if NeedFunctionPrototypes
     int, int ** 
#endif
);

WAFE_EXTERN Widget name2Source(
#if NeedFunctionPrototypes
     char *
#endif
);

WAFE_EXTERN void MMreplace(
#if NeedFunctionPrototypes
    MMattribListPtr *, XrmQuark, char *, freeProc
#endif
);

WAFE_EXTERN MMattribListPtr * MMgetAttribList(
#if NeedFunctionPrototypes
    Widget
#endif
);

WAFE_EXTERN Widget MMfreeGarbage(
#if NeedFunctionPrototypes
     Widget
#endif
);


/* 
  * Declare some useful Quarks as globals here, they are initialized in main ...
  */

WAFE_EXTERN XrmQuark qString;
WAFE_EXTERN XrmQuark qCallback; 
WAFE_EXTERN XrmQuark qPointer;  /* obsolete */
WAFE_EXTERN XrmQuark qInt; 
WAFE_EXTERN XrmQuark qDimension; 
WAFE_EXTERN XrmQuark qCardinal; 
WAFE_EXTERN XrmQuark qPosition; 
WAFE_EXTERN XrmQuark qFloat; 
WAFE_EXTERN XrmQuark qDouble; 
WAFE_EXTERN XrmQuark qBoolean; 
WAFE_EXTERN XrmQuark qWidgetList; 


void
execCallbackProc(
#if NeedFunctionPrototypes
    Widget, XtPointer, XtPointer
#endif
);

/*
 * This  is our version of Xt's XtResource structure, containing only the
 * name of the resource in quark representation and the type as string and 
 * as Quark as well..
 * Compare to resList2QTypeList in wafe.c. RESINFO maintains a global
 * List, consisting of several lists, one for each WidgetClass!
 */

typedef struct _QType
     {
     XrmQuark qName;
     char *type;
     XrmQuark  qType;
     struct _QType *next;
     } QType, *QTypeList;

/*
 * Some Widgets have subparts or subobjects providing ressources,
 * which are not visible to XtGetResourceList(). For each of them
 * we create a static list containing attribute/type pairs, as defined by
 * the following structure. Anyone who knows a more elegant solution
 * **PLEASE** email it to us!!
 */

typedef struct
    {
    char *resource_name;
    char *resource_type;
    } addResInfo;



#ifndef CONVERTERS
/*
 * Functions from file CONVERTERS.C
 */

extern XtTypeConverter CvtStringToWidget(
#if NeedFunctionPrototypes
     Display*,XrmValue*,Cardinal*,XrmValue*,XrmValue*,XtPointer*
#endif
);

extern void CvtStringToCallback(
#if NeedFunctionPrototypes
     XrmValuePtr, Cardinal *, XrmValuePtr, XrmValuePtr
#endif
);

extern void CvtStringToPointer(
#if NeedFunctionPrototypes
     XrmValuePtr, Cardinal *, XrmValuePtr, XrmValuePtr
#endif
);

#endif


#ifdef MAIN     
                        /*  *****  VISIBLE ONLY IN WAFE.C  *****  */

typedef struct _RESINFO
     {
     WidgetClass       wClass;
     QTypeList         resources;
     Cardinal          num;
     struct _RESINFO  *next;
     } RESINFO, *RESINFOPTR;

RESINFOPTR  resourceList = NULL;
RESINFOPTR  constraintList = NULL;

WAFE_EXTERN Cardinal getResOfClass(
#if NeedFunctionPrototypes
     WidgetClass, QTypeList *
#endif
);

WAFE_EXTERN Cardinal getConOfClass(
#if NeedFunctionPrototypes
     WidgetClass,QTypeList *
#endif
);


/*
 * Declare the additional application resource:
 * initCom (Class InitCom) can be used to start an interpreter
 */

typedef struct {
    String  init_com;
  }AppData, *AppDataPtr;

AppData    app_data;

static XtResource resources[] = 
     {
     "initCom",
     "InitCom",
     XtRString,
     sizeof(String),
     XtOffset(AppDataPtr, init_com),
     XtRImmediate,
     "noCom",
     };


extern void execActionProc(
#if NeedFunctionPrototypes
     Widget, XEvent *, char **, Cardinal *
#endif
);

COM_PROTOTYPE(com_mergeResources)
COM_PROTOTYPE(com_setValues)
COM_PROTOTYPE(com_getValues)
COM_PROTOTYPE(com_callback)
COM_PROTOTYPE(com_callCallbacks)
COM_PROTOTYPE(com_callActionProc)
COM_PROTOTYPE(com_setCommunicationVariable)
COM_PROTOTYPE(com_getChannel)
COM_PROTOTYPE(com_getResourceList)

/*
 * The following function returnes the address from the corresponding
 * attribute/type list.
 */

addResInfo *
getAddRes(
#if NeedFunctionPrototypes
     WidgetClass, Cardinal *
#endif
);

/*
 * The following function returnes the address from the corresponding
 * attribute/type list.
 */

freeProc
getFreeFunc (
#if NeedFunctionPrototypes
     char *
#endif
);


/* 
 * These are the extern declarations and prototypings for all functions 
 * and tcl-commands concerning handlers.
 * The source code can be found in the file HANDLERS.C
 */

extern void getInput(
#if NeedFunctionPrototypes
     XtPointer, int*, XtInputId*
#endif
);

extern void communicationHandlerProc(
#if NeedFunctionPrototypes
     XtPointer, int*, XtInputId*
#endif
);

extern void stdinHandlerProc(
#if NeedFunctionPrototypes
     XtPointer, int*, XtInputId*
#endif
);

COM_PROTOTYPE(com_stdinHandler)
COM_PROTOTYPE(com_unregisterStdinHandler)

extern void stderrHandlerProc(
#if NeedFunctionPrototypes
     XtPointer, int*, XtInputId*
#endif
);

COM_PROTOTYPE(com_stderrHandler)
COM_PROTOTYPE(com_unregisterStderrHandler)
COM_PROTOTYPE(com_stdoutHandler)
COM_PROTOTYPE(com_unregisterStdoutHandler)
COM_PROTOTYPE(com_addTimeOut)


extern void timerProc(
#if NeedFunctionPrototypes
     XtPointer, XtIntervalId *
#endif
);



/*
 * Functions from file STRIPCHART.C
 */

COM_PROTOTYPE(com_stripChart)

/*
 * Functions from file LIST.C
 */

COM_PROTOTYPE(com_listAppend)
COM_PROTOTYPE(com_listChange)

#ifdef XEDW
COM_PROTOTYPE(com_edwListChange)
#endif

/*
 * Functions and extern variables from file ASCIITEXT.C
 */

COM_PROTOTYPE(com_asciiTextAppend)

extern XtResource textResList[];

/*
 * Functions from file SELECTION.C
 */

COM_PROTOTYPE(com_ownSelection)

/*
 * The following functions are used to generate the different widget commands,
 * depending on your version of X11. They are located in ATHENAWIDGETS.C, 
 * TREE.C and TALK.C. 
 */

void createWidgetCommands(
#if NeedFunctionPrototypes
     char *, WidgetClass
#endif
);


/* here is still #ifdef MAIN */

#else

/* here is #ifndef MAIN */

/*************************************************************************
 * The following is for for all files eccept wafe.c                   
 *************************************************************************/ 

void
convError (
#if NeedFunctionPrototypes
	   char*, char*, char*, char*
#endif
);

extern void scSet(
#if NeedFunctionPrototypes
     Widget, double
#endif
);

void
argcError (
#if NeedFunctionPrototypes
	   char*, char*, int, int
#endif
);

void
noVarCompError (
#if NeedFunctionPrototypes
	   char*, char*, char*
#endif
);

extern int convert(
#if NeedFunctionPrototypes
     Widget, WidgetClass, char**, int, ArgList*, int*, Widget
#endif
);

extern char *getTypeOfAttribute(
#if NeedFunctionPrototypes
     WidgetClass, Widget, char *
#endif
);

extern XrmQuark getQTypeOfAttribute(
#if NeedFunctionPrototypes
     WidgetClass, Widget, XrmQuark
#endif
);

#ifdef RDD
#include "rdd.h"
extern void rddDropCallbackProc(
#if NeedFunctionPrototypes
      Widget, char *, RddCallbackStruct *
#endif
);
#endif


#endif

