/* make emcas happy -*-C-*-  make emacs happy */

#include <ctype.h>

#define MAX_STRING_SEGMENT 4096
#define MAX_FORMAT_LEN 50


XmStringCharSet    defaultCharSet;


/*
 * Initialize the default character Set variable!
 */

void
compStringInit()
    {
    XmString          dummy;
    XmStringContext   strContext;
    char              *text;
    XmStringDirection dummyDir;
    Boolean           dummySep;    
    
    dummy = XmStringCreateSimple("dummy");

    if (!XmStringInitContext(&strContext, dummy))
	{
	fprintf(stderr, "Wafe(motif): Couldn't create string Context\n");
	exit(-1);
	}

    XmStringGetNextSegment(strContext, &text, &defaultCharSet, 
			   &dummyDir, &dummySep);
    XtFree(text);
    XmStringFree(dummy);
/*
    fprintf(stderr, "Setting defaultCharSet to %s\n", defaultCharSet);
 */
    }



/*
 * Utility function: Creates a new compound string segment, appends it to an existing
 * XmString. Does NOT create a segement if the string is empty!
 */

XmString
compStringAppend(oldCompStr, text, charSet, dir, sep)
XmString           oldCompStr;
char              *text;
XmStringCharSet    charSet;
XmStringDirection  dir;
Boolean            sep;
    {
    XmString  addSeg, newString;
    
    if (*text == '\0' && sep)
	return(oldCompStr);

/*
    fprintf(stderr, "Generated segment with <%s>\n", text);
 */

    if (!oldCompStr)
	return(XmStringSegmentCreate(text, charSet, dir, sep));
    else
	{
	addSeg = XmStringSegmentCreate(text, charSet, dir, sep);
	newString = XmStringConcat(oldCompStr, addSeg);
	XmStringFree(addSeg);
	XmStringFree(oldCompStr);
	return(newString);
	}
    }

XmString    
stringToXmString(inString)
char  *inString;
    {
    char               segBuf[MAX_STRING_SEGMENT];
    char               formatBuf[MAX_FORMAT_LEN];
    XmStringCharSet    charSet = XmSTRING_DEFAULT_CHARSET; 
    XmStringDirection  dir = XmSTRING_DIRECTION_L_TO_R;
    XmString           result = NULL;
    char              *segPtr = segBuf;
    char              *ptr = inString;
    char              *top;
    
/*
    fprintf(stderr, "Converting string <%s>\n", inString);
*/
    top = ptr + strlen(inString);
    *segPtr = '\0';
    while (ptr < top)
	{
	switch (*ptr)
	    {
	    case '\n':
	    /* NewLine: Finish current segment */

	    *segPtr = '\0';
            result = compStringAppend(result, segBuf, charSet, dir, True);
	    segPtr = segBuf;
	    ptr++;
	    break;
	    
	    case '^':
            /* Enter command mode */
	    ptr++;

	    if (ptr == top)
		{
		fprintf(stderr, 
		    "Wafe(XmString Conversion): Cannot handle trailing '^'\n");
		return NULL;
		}

	    if (*ptr == '^')
		{
		/* Two ^ => leave command mode, insert one ^ */
		*segPtr++ = '^';
		ptr++;
		}
	    else
		if (!isalpha(*ptr))
		    {
                    /* ^ + whatever not alphabetic => ignore ^ */
		    *segPtr++ = *ptr++;
		    }
		else
		    {
		    char   *comPtr = formatBuf;
		    
		    /* Terminate current segment */
		    *segPtr = '\0';
		    result = compStringAppend(result, segBuf, 
					      charSet, dir, True);
		    segPtr = segBuf;
				
		    /* Extract command */
		    while ((isalnum(*ptr) 
			    || (*ptr == '-') 
			    || (*ptr == '_')) 
			   && (ptr <= top))
			*comPtr++ = *ptr++;

		    *comPtr = '\0';
/*
		    fprintf(stderr, "Parsed command <%s>\n", formatBuf);
 */
		    if (!strcmp(formatBuf, "lr"))
			dir = XmSTRING_DIRECTION_L_TO_R;		    
		    else
			if (!strcmp(formatBuf, "rl"))
			    dir = XmSTRING_DIRECTION_R_TO_L;
			else
			    charSet = XtNewString(formatBuf);

		    if (*ptr == ' ')
			ptr++;
		    }
	    break;
	    	    
	    default:
	    *segPtr++ = *ptr++;
	    break;

	    } /* switch */	    
	} /* while */

    *segPtr = '\0';
    result = compStringAppend(result, segBuf, charSet, dir, False);

    return result;
    }

/* Queries a XmString Value and translates it to a valid input string */

char *
xmString2String(compStr)
XmString      compStr;
    {
    XmStringContext    strContext;
    char               *text;
    XmStringCharSet    charSet, 
                       lastCharSet = defaultCharSet;
    XmStringDirection  dir, 
                       lastDir = XmSTRING_DIRECTION_L_TO_R;
    Boolean            sep;
    char               *result, *ptr;
    
    if (!XmStringInitContext(&strContext, compStr))
	{
	fprintf(stderr, "Wafe(motif): Couldn't create string Context\n");
	return(NULL);
	}

    result = ptr = XtMalloc(XmStringLength(compStr)); /* ??? */

    while (XmStringGetNextSegment(strContext, &text, &charSet, &dir, &sep))
	{
	char *textPtr = text;

	/* This means: If there are no changes in charSet or direction, just make a newline
	            * but don't do it, if this is the first segment */
	if ((!strcmp(charSet, lastCharSet)) 
	    && (dir == lastDir) 
	    && (result != ptr))
	    *ptr++ = '\n'; 
	
	if (strcmp(charSet, lastCharSet)) 
	    {
            *ptr++ = '^';
	    strcpy(ptr, charSet);
	    ptr+= strlen(charSet);
	    *ptr++ = ' ';
	    lastCharSet = charSet;
	    }

	if (dir != lastDir) 
	    {
	    if (dir == XmSTRING_DIRECTION_L_TO_R)
		strcpy(ptr, "^lr ");
	    else
		strcpy(ptr, "^rl ");		
	    ptr+=4;
	    lastDir = dir;
	    }	    

	while (*textPtr != '\0')
	    {
	    if (*textPtr == '^')
		{
		strcpy(ptr, "^^");
		ptr +=2;
		textPtr++;
		}
	    else
		*ptr++ = *textPtr++;
	    }
	}
    *ptr = '\0';
    XmStringFreeContext(strContext);
    return(result);
    }


char *
xmStringTable2String(count,strTable)
int           count;
XmStringTable strTable;
    {
    char    **temp, **cPtr;
    XmString  *ptr = strTable;
    char      *result;
    int        i;

    if (!count && strTable)
	while(*ptr++)
	    count++;

    temp = (char **)XtMalloc(count*sizeof(char *));
    for (ptr=strTable, cPtr=temp, i=count; i>0; ptr++, cPtr++, i--)
	*cPtr = xmString2String(*ptr);

    result = Tcl_Merge(count, temp);
    
    for (ptr = strTable, i=count; i>0; ptr++, i--)
	XtFree(*ptr);
    
    return(result); 
    }

/*
 * Two converter function wrappers for the *2String functions, which are 
 * called by getValues
 */

Boolean
CvtXmStringToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    static char *result;

    result = xmString2String((XmString)(fromVal->addr));
    toVal->addr = result;
    toVal->size = 1; /* if nobody else uses this converter it shouldn't matter anyway */
    return(True);
    }


Boolean
CvtXmStringTableToString(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static char *result;
    
    result = xmStringTable2String(0,(XmStringTable)(fromVal->addr));
    fprintf(stderr, "Conversion done, res:%s\n", result);
    toVal->addr = result;
    toVal->size = 1; /* it should not matter either */
    return(True);
    }


void
freeStringTab(table)
XmStringTable  table;
    {
    while (*table != NULL)
	XmStringFree(*table++);
    }	    
    


Boolean
CvtStringToXmStrings(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    int               argc, count;
    char            **argv;
    XmString         *ptr;
    static XmString  *result;

    if (Tcl_SplitList(interpreter,(char*)fromVal->addr, &argc, &argv) 
	!= TCL_OK)
	{
	fprintf(stderr, "Wafe(XmStringTableConversion): %s\n", 
		interpreter->result);
	XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr, 
					 "XmString");
	return False;
	}
	
    result = (XmString *)XtMalloc(argc*sizeof(XmString));
    for(count = 0, ptr = result; count < argc; count++, ptr++) 
	if ((*ptr = stringToXmString(argv[count])) == NULL)
	    {
	    XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr, 
					     "XmString");
	    return False;
	    }
    toVal->size = sizeof(XmString **);
    toVal->addr = (caddr_t)&result;

    MMreplace(&currentStrInfo, currentAttrib, (char *)&result, freeStringTab);

    return True;
    }


Boolean
CvtStringToXmString(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static XmString  result;
    
    if ((result =  stringToXmString((char *)fromVal->addr)) == NULL)
	{
	XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr, 
					 "XmString");
	return False;
	}
    
    toVal->size = sizeof(XmString *);
    toVal->addr = (caddr_t)&result;

    MMreplace(&currentStrInfo, currentAttrib, (char *)&result, XmStringFree);
    return True;
    }








