/*   this is also -*- C -*- */

/*
#include "rdd.h"
*/

char              *communicationHandlerVarname = NULL;
char              *communicationHandlerCommand = NULL;
int                communicationHandlerLength = 0;
int                communicationCount = 0;

char               inputBuffer[BUF_SIZE+1];
int                leftBytes = 0;      


void
getInput(client_data, fid, xid)
XtPointer   client_data;          /* PromptMode True oder False  */
int         *fid;
XtInputId   *xid;
    {
    char   *bufferPtr = inputBuffer + leftBytes;
    char   *firstPtr = inputBuffer;
    char   *secondPtr = inputBuffer;
    int     readBytes;
    Boolean overFlowFlag = True;

    DBUG_ENTER("getInput");

    if ((readBytes = read(*fid, bufferPtr, BUF_SIZE - leftBytes)) == -1)
	perror("Wafe: Communication error: ");

    *(bufferPtr + readBytes) = '\0';
    leftBytes = 0;

    DBUG_PRINT("socketAll", 
               ("BufferContents are:\n>>%s<<", bufferPtr));     

    if (!readBytes)
	{
	fprintf(stderr, "Wafe: EOF-Condition on fromClient - Channel\n");
	exit(1);
	}    
 
    do
	{
	while ((*firstPtr != '\n') && (*firstPtr != '\0'))
	    *firstPtr++;

	if (*firstPtr == '\n')
	    {
	    *firstPtr = '\0';     /* One tcl-command is ready */
	    
	    overFlowFlag = False;

	    DBUG_PRINT("socket", 
		       ("Parsed Command >%s<", secondPtr));

	    if (client_data)      /* Standard Mode - prompt character is checked */
		{               
		if (*secondPtr == promptChar) 
		    {
		    if(Tcl_Eval(interpreter,secondPtr+1,0,NULL) == TCL_ERROR)
			fprintf(stderr, "%s\n", interpreter->result);
		    }
		else 
		    {
		    if (tclHandlers[STDOUT])
			{                    
			Tcl_SetVar(interpreter, "STDOUT", secondPtr, 
				   TCL_GLOBAL_ONLY);

			if (Tcl_Eval(interpreter, tclHandlers[STDOUT], 
				     0, NULL) == TCL_ERROR)
			    fprintf(stderr, "%s\n", interpreter->result);
			}
		    else
			fprintf(stdout, "%s\n", secondPtr);	 
		    }
		} 
	    else                  /* Don't look for Prompt character */  
		{                 
		if (Tcl_Eval(interpreter, secondPtr, 0, NULL) == TCL_ERROR)
		    fprintf(stderr, "%s\n", interpreter->result);
		}
	    
	    firstPtr++;
	    
	    if (*firstPtr == '\0')      
		{
		DBUG_VOID_RETURN;
		}
	    else
		secondPtr = firstPtr;                  
	    }
	} while (*firstPtr != '\0');

    if (overFlowFlag)
	{
	fprintf(stderr, "Wafe(main): Uncomplete command or communication buffer overflow, >%s<\n", secondPtr);
	exit(-1);
	}

     /* if this one is the last command in the buffer and
      * it is not terminated with a \n => do buffering 
      */

    DBUG_PRINT("socket", ("uncomplete command : %s", secondPtr)); 

    strcpy(inputBuffer, secondPtr);
    leftBytes = strlen(secondPtr);

    DBUG_VOID_RETURN;
    }


void
stdinHandlerProc(client_data, fid, xid)
XtPointer   client_data; /* Prompt-Mode: True oder False */
int         *fid;
XtInputId   *xid;
    {
    int     readBytes;
    char    stdinBuffer[STDIN_BUF_SIZE];

    DBUG_ENTER("getInputFromStdin");

    if ((readBytes = read(*fid, stdinBuffer, STDIN_BUF_SIZE)) == -1)
	perror("getInput");

    if (!readBytes)
	{
	DBUG_PRINT("handler",
		   ("EOF - condition on stdin"));
	DBUG_VOID_RETURN;
	}

    if (tclHandlers[STDIN])
	{
	Tcl_SetVar(interpreter, "STDIN", stdinBuffer, TCL_GLOBAL_ONLY);
	
	if (Tcl_Eval(interpreter, tclHandlers[STDIN], 0, NULL) 
	    == TCL_ERROR)
	    fprintf(stderr, "%s\n", interpreter->result);
	}
    else
	write(toClient, stdinBuffer, readBytes);

    DBUG_VOID_RETURN;
    }


void
stderrHandlerProc(clientData, fid, xid)
XtPointer    clientData;
int         *fid;
XtInputId   *xid;
    {   
    int     readBytes;
    char    stderrBuffer[STDERR_BUF_SIZE];

    DBUG_ENTER("stderrHandlerProc");

    if ((readBytes = read(*fid, stderrBuffer, STDERR_BUF_SIZE)) == -1)
	perror("stderrHandlerProc");

    *(stderrBuffer + readBytes) = '\0';

    if (!readBytes)
	{
	DBUG_PRINT("handler",
		   ("EOF - condition on stderr"));
	DBUG_VOID_RETURN;
	}

    if (tclHandlers[STDERR])
	{
	Tcl_SetVar(interpreter, "STDERR", stderrBuffer, TCL_GLOBAL_ONLY);
	
	if (Tcl_Eval(interpreter, tclHandlers[STDERR],
		     0, NULL) == TCL_ERROR)
	    fprintf(stderr, "%s\n", interpreter->result);
	}
    else
	fprintf(stderr, "%s", stderrBuffer);

    DBUG_VOID_RETURN;
    }



void
communicationHandlerProc(clientData, fid, xid)
XtPointer    clientData;
int         *fid;
XtInputId   *xid;
    {   
    int     readBytes;
    char    localComBuffer[COMBUFSIZE+1];

    DBUG_ENTER("communicationHandlerProc");
    
    if ((readBytes = read(*fid, localComBuffer, COMBUFSIZE)) == -1)
	perror("communicationHandlerProc");

#ifdef TUNNELDEBUG
    fprintf(stderr, "HandlerProc: I read %d Bytes\n", readBytes); 
#endif

    *(localComBuffer + readBytes) = '\0';

    communicationCount += readBytes;

#ifdef TUNNELDEBUG
    fprintf(stderr, "HandlerProc: This makes now %d Bytes total\n", 
	    communicationCount); 
#endif

    if (!readBytes)
	{
	DBUG_PRINT("handler",
		     ("EOF - condition on communication channel"));
	DBUG_VOID_RETURN;
	}

    if (!comBuffer)
	{
	comBuffer = XtNewString(localComBuffer);
	}
    else
	{
	comBuffer = XtRealloc(comBuffer, strlen(comBuffer) + readBytes + 1);
	strcat(comBuffer, localComBuffer);
	}
    
    if ((communicationHandlerCommand) && (communicationHandlerLength <= communicationCount))
	{
#ifdef TUNNELDEBUG
	fprintf(stderr, "HandlerProc: we got it %d <= %d, executing %s\n", 
		communicationHandlerLength, communicationCount,
		communicationHandlerCommand); 
#endif
	if (!comBuffer)
	    Tcl_SetVar(interpreter, communicationHandlerVarname, "", TCL_GLOBAL_ONLY);
	else
	    {
	    (void)Tcl_UnsetVar(interpreter, communicationHandlerVarname, 0);
	    Tcl_SetVar(interpreter, communicationHandlerVarname, comBuffer, 
		       TCL_GLOBAL_ONLY);
	    XtFree(comBuffer);
	    comBuffer = NULL;
	       }

          if (Tcl_Eval(interpreter, communicationHandlerCommand, 0, NULL) 
	      == TCL_ERROR)
	      fprintf(stderr, "Wafe(setCommunicationVariable): %s\n", 
		      interpreter->result);
          
	XtFree(communicationHandlerVarname);
	XtFree(communicationHandlerCommand);
	communicationCount = 0;
	communicationHandlerLength = 0;
	communicationHandlerCommand = NULL;
	}
    else
	{
#ifdef TUNNELDEBUG
	fprintf(stderr, "HandlerProc: I do nothing, Data is not complete %d <= %d!\n",
		communicationHandlerLength,communicationCount);
#endif
	}
    DBUG_VOID_RETURN;
     }

void
setCommunicationVariable(varName,length,command)
String   varName;
int      length;
String   command;
    {

    communicationHandlerVarname = varName;
    communicationHandlerLength = length;
    communicationHandlerCommand = command;

#ifdef TUNNELDEBUG
    fprintf(stderr, "Command: setting communicationHandlerLength = %d\n",
	    communicationHandlerLength);

    fprintf(stderr, "Command: communicationHandlerLength %d <= communicationCount(global): %d\n", 
	    communicationHandlerLength, communicationCount);
#endif

    if (communicationHandlerLength <= communicationCount)
	{ 
#ifdef TUNNELDEBUG
	fprintf(stderr, "Command: data available, executing <%s>\n", 
		communicationHandlerCommand); 
#endif
	if (!comBuffer)
	    Tcl_SetVar(interpreter, communicationHandlerVarname, 
		       "", TCL_GLOBAL_ONLY);
	else
	    {
	    (void)Tcl_UnsetVar(interpreter, communicationHandlerVarname, 0);
	    if (communicationHandlerLength < communicationCount) 
		{
		char saveChar;

		saveChar = comBuffer[communicationHandlerLength+1];
#ifdef TUNNELDEBUG
		fprintf(stderr, "Command: MORE THAN WE NEED! c=<%d>\n",
			(int)saveChar);
#endif
		comBuffer[communicationHandlerLength+1] = '\0';
		Tcl_SetVar(interpreter, communicationHandlerVarname, 
			   comBuffer, TCL_GLOBAL_ONLY);
		comBuffer[communicationHandlerLength+1] = saveChar;

		memcpy(comBuffer,&comBuffer[communicationHandlerLength],
		       communicationCount-communicationHandlerLength);
		communicationCount = communicationCount - 
		    communicationHandlerLength;
		} 
	    else 
		{
		Tcl_SetVar(interpreter, communicationHandlerVarname, 
			   comBuffer, TCL_GLOBAL_ONLY);
		communicationCount = 0;
		XtFree(comBuffer);
		comBuffer = NULL;
		}
	    }  

	if (Tcl_Eval(interpreter, communicationHandlerCommand, 0, NULL) == 
	    TCL_ERROR)
	    fprintf(stderr, "Wafe(setCommunicationVariable): %s\n", 
		    interpreter->result);
          
	XtFree(communicationHandlerVarname);
	XtFree(communicationHandlerCommand);
	communicationHandlerLength = 0;
	communicationHandlerCommand = NULL;
#ifdef TUNNELDEBUG
	fprintf(stderr, "Command: setting command and length to NULL\n"); 
#endif
	}
    else
	{
#ifdef TUNNELDEBUG
	fprintf(stderr, "Command: I do nothing, because Data is not yet complete!\n");
#endif
	}
    }


/*
 *  The following command is used to access the Drag'n Drop library 
 */

void
rddDropCallbackProc(w, command, info)
Widget   w;
char     *command;
RddCallbackStruct   *info;
     {
     char *message;

     message = (char *)XtMalloc(info->len + 1);
     strncpy(message, info->data, info->len);
     *(message + info->len) = '\0';

     Tcl_SetVar(interpreter, "DROP", message, TCL_GLOBAL_ONLY);
     XtFree(message);

     if (Tcl_Eval(interpreter, command, 0, NULL) == TCL_ERROR)
          fprintf(stderr, "Wafe(rddDropCallback): %s\n", interpreter->result);
    }
     


/*
 @handlerType = (
	    "stdin", STDIN,
	    "stdout", STDOUT,
	    "stderr", STDERR,
	    "xioerr", XIOERR,
		  );
*/

void 
doregister(handlerType,string)
int handlerType;
char *string;
    {

    switch(handlerType)
	{
    case STDIN: 
	if (directMode)
	    {
	    fprintf(stderr, "Warning: No input-handler in this mode!");
	    return;
	    }
	break;
	
    case STDOUT:
	if (directMode)
	    {
	    fprintf(stderr, "Warning: No output-handler in this mode!");
	    return;
	    }
	break;

    case STDERR:
	if ((directMode) || (fileMode))
	    {
	    fprintf(stderr, "Warning: No error-handler in this mode!");
	    return;
	    }
	break;

    default:
	break;
	}

    if (tclHandlers[handlerType]) 
	XtFree(tclHandlers[handlerType]);

    tclHandlers[handlerType] = XtNewString(string);
    } 



void 
unregister(handlerType)
int handlerType;
    {
    if (!tclHandlers[handlerType]) 
	fprintf(stderr, "Wafe(unregister): Warning, no handler registered!\n");
    else 
	XtFree(tclHandlers[handlerType]);
    }
     

