/* das ist ein -*- C -*- Programm */

void
realizeWidgets()
    {
    WidgetListPtr ptr = widgetTrees;
    while(ptr) 
	{
	XtRealizeWidget(ptr->widget);
	ptr = ptr->next;
	}
    }

void
callCallbacks(w, callback, argc,argv)
Widget   w;
String   callback;
int      argc;
char   **argv;
    {
    float   f;
    if (argc == 0)
	XtCallCallbacks(w, callback, NULL);
    else
	{
	if (!strcmp(argv[0], "float"))
	    {
	    sscanf(argv[1], "%f", &f);
	    XtCallCallbacks(w, callback, (XtPointer)&f);
	    }
	else
	    {
	    fprintf(stderr, "Wafe(callCallbacks): Wrong type: %s\n", argv[1]);
	    }
	}
    }


void
callActionProc(w, eventType, action, argc, argv)
Widget         w;
String         eventType;
String         action;
int            argc;
char         **argv;
    {
    char          *token;
    XEvent         event;
    Display       *display;
    Window         win, root, child;
    int            x, y, xR, yR;
    unsigned int   state, button, keycode;

    display = XtDisplay(topLevel);
    win = XtWindow(w);

    if (!strcmp(eventType, ""))
	{
	event.type = 0;
	event.xany.display = display;
	event.xany.window = win;
	}
    else
	{
	token = strtok(eventType, " ");
	if (strcmp(token, "type"))
	    {
	    fprintf(stderr, 
		    "Wafe(callActionProc): Missing type, aborting\n");
	    return;
	    }

	XQueryPointer(display, win, &root, &child, &xR, &yR, &x, &y, &state);

	token = strtok(NULL, " ");
	if (!strcmp(token, "buttonEvent"))
	    {
	    token = strtok(NULL, " ");
	    if (!strcmp(token, "button"))
		{
		token = strtok(NULL, " ");
		if (!strcmp(token, "button1"))
		    button = Button1;
		else
                if (!strcmp(token, "button2"))
		    button = Button2;
                else
                if (!strcmp(token, "button3"))
		    button = Button3;
		else
                if (!strcmp(token, "button4"))
		    button = Button4;
		else
                if (!strcmp(token, "button5"))
		    button = Button5;
		else
		    {
		    fprintf(stderr, 
			    "Wafe(callActionProc): Unknown Button, %s\n", 
			    token);
		    return;
		    }
		}
	    else
		{
		fprintf(stderr, 
			"Wafe(callActionProc): This event field (%s) can't be specified", token);
		return;
		}

	    event.type = ButtonPress;
	    event.xbutton.display = display;
	    event.xbutton.window = win;
	    event.xbutton.root = root;
	    event.xbutton.subwindow = child;
	    event.xbutton.x = x;
	    event.xbutton.y = y;
	    event.xbutton.x_root = xR;
	    event.xbutton.y_root = yR;
	    event.xbutton.state = state;
	    event.xbutton.button = button;
	    }
	else if(!strcmp(token, "keyEvent"))
	    {
	    token = strtok(NULL, " ");
	    if (!strcmp(token, "key"))
		{                   
		token = strtok(NULL, " ");
		keycode = XKeysymToKeycode(display, XStringToKeysym(token));
		}
	    else
		{
		fprintf(stderr, "Wafe(callActionProc): This event field (%s) can't be specified", token);
		return;
		}

	    event.type = KeyPress;
	    event.xkey.display = display;
	    event.xkey.window = win;
	    event.xkey.root = root;
	    event.xkey.subwindow = child;
	    event.xkey.x = x;
	    event.xkey.y = y;
	    event.xkey.x_root = xR;
	    event.xkey.y_root = yR;
	    event.xkey.state = state;
	    event.xkey.keycode = keycode;
	    }
	else
	    {
	    fprintf(stderr, 
		    "Wafe(callActionProc): This event type can't be specified\n");
	    return;
	    }                    
	}

    XtCallActionProc(w, action, &event, argv, argc);
    return;
    }
 
