.TH xwafeora 1
.SH NAME
.PP
xwafeora \- an x-based oracle front end with updates

.SH SYNOPSIS
.PP
\f3xwafeora\f1 
[\f3-a \f2 application name\f1] 
[\f3-b \f2 database id\f1] 
[\f3-c \f2colormode\f1] 
[\f3-h \f1] 
[\f3-O \f2folder table\f1] 
[\f3-o \f2folder name\f1] 

.SH DESCRIPTION
.PP

\fIxwafeora\fP is an x-based Oracle front end which connects to an
Oracle database via SQL-Net and allows to retrieve, update and delete
entries from the database.  xwafeora is a \fIwafe\fP application (see
manual page wafeapp) written in oraperl. Note that you need to have
Oracle and oraperl installed on your system in order to use this application.

.SH OPTIONS
.PP
In addition to the standard toolkit options such as
-display, -name, -geometry, -iconic, -xrm etc. (see manual page X)
xwafeora accepts  the following options:
.TP
\f3-a \f2application name\f1
start xwafeora with a special setup. The distribution contains the
setup for the application names \fIPaper\fP, \fIAblage\fP and \fIOrdner\fP.
The default application is "Paper".
.TP
[\f3-b \f2 database id\f1] 
connect to the given database which is given in the  form 
"userid/passwd@T:hostname:oracleId".
.TP
\f3-c \f2colormode\f1
start xwafeora using the given color-mode (for details see manual page
wafeapp); color modes are for example \fImono\fP, \fIblueish\fP or \fIwheat-ish\fP.

.TP
\f3-h\f1
show a short usage message.

.TP
\f3-O \f2folder Table\f1
if the application uses a folder (see below) use the given table.

.TP
\f3-o \f2folder name\f1
if the application uses a folder start with the given default value 
for the folder.

.TP
\f3-v\f1
start in verbose mode and show database interaction.



.SH "LAYOUT and INTERACTION" 

.PP 

xwafeora is an Oracle front-end allowing updates on database scheme
which can be discriminated in EER terminology as a single entity type
 with with distinct predicate defined subtypes (the discriminant
attribute is the value in the folder field). xwafeora allows multi
valued attributes.

The distribution contains the definitions and the SQL-plus scripts to
create the tables for the sample applications "filing management" (in
German "Ablage") and "paper base".

If xwafeora is started without the -a option, the paper application is
started. The top line of the application is the info line. Below you
will find a clock, the title of the application and the current user.
If a picture of the current user can be found, it will be displayed as
well (see FACES section in the manual page for xwafemail).

Under this header is the \fIdata entry section\fP. The search in the
database is always performed according to the value in the folder
field (labeled "Ordner") and the current field, which is highlighted.
It is possible to jump forward from input field to input field by
using the tab key (or the shift tab key for the reverse direction), or
to jump directly to a field by clicking in this field with the left
mouse button (Btn1). To start a search in the database something may be
entered in the current field (or not) and Ctrl-s or the <search> button
is pressed. If a few characters are typed in, the search will be
performed for entries starting with the given string. If the string
starts wit a "%" character, the given string will be searched also
within the field contents. It might be a good strategy to start
xwafeora with the -v option and to study the SQL-queries generated.
If there exist several solutions for the given query, the keys page-up
or page-down (or clicking on the upward or downward pointing arrow on
the right bottom of the application) may be used to show the next or
previous entry. The owner of each entry is displayed toward the left
bottom of the application. If available, a picture of the owner will
be displayed.

If the left mouse button is pressed on the label "Ordner", a pull down
menu is displayed with possible contents of this field. the last entry
("*") means that the search should be performed over all folders.

If a string is typed into a string and either Ctrl-tab or the button
<vervollstaendigen> is pressed xwafeora searches for possible
completions of this field. if only one completion is possible, the
field is completed. If several completions are possible, a menu pops
up (containing maximal 20 entries), from which possible completions
might be selected.

The button <Ordner> from the button row calls as a subprocess an
xwafeora application to administer the folders. If this subprocess is
terminated (by pressing the <exit> icon on the left bottom) the folder
pull down menu is updated.

For each folder the group id of authorized users is kept in the
database, who might add entries to the database.  To add a new entry
the required fields have to be filled out and the button <NeuAnlagen>
has to be pressed. Now it is checked if the required fields are typed
in, the contents of the multi valued fields "Autoren", "Keywords" and
"Herausgeber" are split by using the information of the application
parameter block (see below). The contents of the fields "Autoren" and
"Herausgeber" are normalized (i.e. the abbreviation of the first name
and the second name are reordered if necessary), a new id is created
(Dokumentnummer) and the required modification in the database are
performed. 

Every user who might change or delete the entries he owns. The
application allows also to define the guru property for selected
users, who will be authorized to add, change and delete without
restrictions. 

If the button Ctrl-p is pressed, the current entry will be shown in
a po pup shell in the form of a bibitem.

 
.SH CONFIGURATION PARAMETER BLOCK

Each application is controlled by a highly configurable application
parameter block, where the fields of the application, the database and
name names etc are defined. It is possible to specify the type of the
fields, the length, if the fields are multi valued, required, multi
line fields, if the should be incremented automatically etc. The
actual layout, the widget tree and the SQL-queries are computed from
this parameter block.  Within the given scope (one entity type with
subtypes) it is very easy to generate additional applications.

.SH "KEY BINDINGS"
.PP
\fIKey bindings the data entry section:\fP
.TP 13
<Btn1>
goto field
.TP
<Key>Prior
previous entry
.TP
<Key>Next
next entry
.TP
<Key>Tab
next field
.TP
Shift<Key>Tab
previous field
.TP
Ctrl<Key>Tab
complete
.TP
<Key>Select
clear to end of paragraph
.TP
<Key>Home
begin of field
.TP
<Key>p
show entry in bibitem format
.TP
<Key>s
search


.SH "ENVIRONMENT VARIABLES"
.PP
.TP 13
WAFELIB
location of the wafe library (typically /usr/lib/X11/wafe)

.SH "PERL VARIABLES"
.PP
Wafe (Perl-) Variables from $WAFELIB/system.waferc or $HOME/.waferc:
.TP 13
$wafeoraDB{$app}
default database for application $app to connect with
.TP
$buttonFont
typically used as font for buttons
.TP
$textFont
fixed spaced text font
.TP
$buttonAtts
attributes used for buttons
.TP
$backGround
back ground color
.TP
$highLight
attributes for emphasized text portions (typically colors)
.TP
$roColors
attributes for non emphasized text (typically colors)
.TP
$infoColors
attributes of the info line (typically colors)
.TP
$menueAtts 
attributes of pull down menues (typically colors)
.TP
%textResources
default resources for text widgets
.TP
@textActions
default actions for text widgets

.SH FILES 
.PP
.EX 0
$WAFELIB/system.waferc
$HOME/.waferc
.EE
.SH "SEE ALSO"
.PP
wafe(n),
wafeapp(n),
X(1),
xwafemail(n),
xwafenews(n),
xwafeftp(n),
xwafeora(n),
xwafetel(n),
xdirtree(n),
xdirtree(n),
xprojektor(n),
xbm(n),
xwafemc(n),
xruptimes(n),
xnetstats(n),
xiostats(n),
xvmstats(n),
xwafeping(n),
xwafecf(n)

.SH COPYRIGHT
.PP
 Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
.EX 0
     Wirtschaftsuniversitaet Wien, 
     Abteilung fuer Wirtschaftsinformatik
     Augasse 2-6, 
     A-1090 Vienna, Austria
     neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
.EE
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appears in all copies and that both that
copyright notice and this permission notice appear in all supporting
documentation.  This software is provided "as is" without expressed or
implied warranty.
.PP
.SH AUTHORS
.PP
Gustaf Neumann, Stefan Nusser
