.TH xdirtree 1
.SH NAME
.PP
xdirtree \- an x-based directory structure visualizer

.SH SYNOPSIS
.PP
\f3xdirtree\f1 [\f3-c \f2colormode\f1] 
[\f3-h\f1] 
\f3start directory\f1

.SH DESCRIPTION
.PP

\fIxdirtree\fP is an x-based visualizer for directory trees. It allows
the user to explore the directory structures of a Unix system
incrementally. Certain portions of the tree may be included or
excluded. Note that only directories are displayed by this program,
files are never included in the tree.

.SH OPTIONS
.PP
In addition to the standard toolkit options such as
-display, -name, -geometry, -iconic, -xrm etc. (see manual page X)
xdirtree accepts  the following options:
.TP
\f3-c \f2colormode\f1
start xdirtree using the given color-mode (for details see manual page
wafeapp); color modes are for example \fImono\fP, \fIblueish\fP or \fIwheat-ish\fP.

.TP
\f3-h\f1
show a short usage message.

.PP 
If no \fIstart directory\fP is given "\fI/usr/local\fP" is assumed.

.SH "LAYOUT and INTERACTION" 

.PP 
When xdirtree is started the user will see an X application containing
the the start directory and the directories immediately below it.
 
Clicking with the left mouse button (Btn1) on a directory label tries
to expand the directory tree by searching for subdirectories from that
given node.  

Clicking with the right mouse button (Btn3) on a node deletes the node
and the subtree underneath it. \fIxdirtree\fP does NEVER delete files
or directories from disk, it does only exclude it from the display!
Clicking with the right mouse button to the root of the tree
terminates the application.

Clicking with the middle mouse button (Btn2) on a node deletes all
immediate the neighbors of that node ("show only").

.SH "KEY BINDINGS"
.PP
\fIKey bindings for nodes of the directory tree:\fP
.TP 13
<Btn1>
expand tree
.TP
<Btn2> 
concentrate on branch
.TP
<Btn3> 
delete branch


.SH "ENVIRONMENT VARIABLES"
.PP
.TP 13
WAFELIB
location of the wafe library (typically /usr/lib/X11/wafe)

.SH "PERL VARIABLES"
.PP
Wafe (Perl-) Variables from $WAFELIB/system.waferc or $HOME/.waferc:
.TP 13
$buttonFont
typically used as font for buttons
.TP
$buttonAtts
attributes used for buttons
.TP
$backGround
back ground color
.TP
$roColors
attributes for non emphasized text (typically colors)

.SH FILES 
.PP
.EX 0
$WAFELIB/system.waferc
$HOME/.waferc
.EE
.SH "SEE ALSO"
.PP
wafe(n),
wafeapp(n),
X(1),
xwafemail(n),
xwafenews(n),
xwafeftp(n),
xwafeora(n),
xwafetel(n),
xdirtree(n),
xdirtree(n),
xprojektor(n),
xbm(n),
xwafemc(n),
xruptimes(n),
xnetstats(n),
xiostats(n),
xvmstats(n),
xwafeping(n),
xwafecf(n)

.SH COPYRIGHT
.PP
 Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
.EX 0
     Wirtschaftsuniversitaet Wien, 
     Abteilung fuer Wirtschaftsinformatik
     Augasse 2-6, 
     A-1090 Vienna, Austria
     neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
.EE
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appears in all copies and that both that
copyright notice and this permission notice appear in all supporting
documentation.  This software is provided "as is" without expressed or
implied warranty.
.PP
.SH AUTHORS
.PP
Gustaf Neumann, Stefan Nusser
