.TH xwafeftp 1
.SH NAME
.PP
xwafeftp \- an x-based ftp front end

.SH SYNOPSIS
.PP
\f3xwafeftp\f1 [\f3-c \f2colormode\f1] 
[\f3-h\f1] 

.SH DESCRIPTION
.PP

\fIxwafeftp\fP is an x-based ftp front end which connects to an
anonymous ftp server and allows to retrieve or to read from the
server. xwafeftp is a \fIwafe\fP application (see manual page wafeapp)
written in Perl. 

.SH OPTIONS
.PP
In addition to the standard toolkit options such as
-display, -name, -geometry, -iconic, -xrm etc. (see manual page X)
xwafeftp accepts  the following options:
.TP
\f3-c \f2colormode\f1
start xwafeftp using the given color-mode (for details see manual page
wafeapp); color modes are for example \fImono\fP, \fIblueish\fP or \fIwheat-ish\fP.

.TP
\f3-h\f1
show a short usage message.


.SH "LAYOUT and INTERACTION" 

.PP 
When xwafeftp is started the user will see an X front end with a
header section and a listing section. The top most line of the
application is an information line, where the user is informed about
the actions the program takes.

The \fIheader\fP section contains a field for the name of the ftp
server to which the front end tries to connect. By clicking into the
string "FTP-Server" a pull down menue is activated from which the
user might choose a server. When a server is selected, xwafeftp tries
to connect to the server, logs in using the user anme and the host
name as password and shows its top level directory in the
listing section. In addition the directory field is updated. The
button \fIup\fP may be used to change to the  directory above the
current directory. For the top level directory this button is set
insensitive. 

The ftp mode may be changed by the \fIFTP-Mode\fP pull down menu.
When xwafeftp is started the ftp-mode \fIas Guessed\fP is used, where
the xwafeftp transfers files marked with the text bitmap in ascii mode and
the other files in binary mode. The pull down menues \fISort-Mode\fP
and \fIOrder\fP can be used to change the order of the entries in the
file listing.

The \fIlisting\fP section shows the files in the current directory of
the ftp server. Subdirectories are visualized with a folder bitmap,
ordinary files are attached with the text, compressed, execute or
picture bitmap. Clicking with the left mouse button (Btn1) on a line
with the folder bitmap opens this directory on the server, and the
file listing is refreshed with the new current directory.  Clicking
with the left mouse button on a line with an ordinary file highlights
the current line and and marks it for transfer. Clicking again on the
same file unmarks it. When several files are marked the the \fIftp\fP
button may be used to transfer the marked files. Transferred files are
transferred to the directory $HOME/incoming. If the directory is
changed (by clicking on a line with the folder bitmap, or pressing the
up button, or by typing in a different directory name in the
directory field), all marked files are unmarked (and not transferred).

IF the middle mouse button (Btn2) is clicked on a line with the text
bitmap (such as on a README file), the file is transferred and
displayed in a pop up shell.


.SH "KEY BINDINGS"
.PP
\fIKey bindings in the file listing listing:\fP
.TP 13
<Btn1>
mark file for transfer or change to directory
.TP
<Btn2> 
transfer ascii file and display it in a pop up shell for reading
.TP
<Btn3> 
go one directory level up
.TP
<Key>Up
scroll one line up if listing is longer than viewport.
.TP
<Key>Down
scroll one line down if listing is longer than viewport.
.TP
<Key>Prior
scroll one page up if listing is longer than viewport.
.TP
<Key>Next
scroll one page down if listing is longer than viewport.
.TP

.SH "ENVIRONMENT VARIABLES"
.PP
.TP 13
WAFELIB
location of the wafe library (typically /usr/lib/X11/wafe)
.TP
HOME
login directory of the current user
.TP
HOST
fully qualified host name (including domain)
.TP
USER
login name of the current user
.TP
TMPDIR
directory for temporary files. If  not specified, /tmp is used

.SH "PERL VARIABLES"
.PP
Wafe (Perl-) Variables from $WAFELIB/system.waferc or $HOME/.waferc:
.TP 13
@ftpServers
a Perl array of anonymous ftp servers used for the pull down menue
.TP
$boldFont
typically used for bold labels
.TP
$normalFont
typically used for labels or proportional text
.TP
$buttonFont
typically used as font for buttons
.TP
$textFont
fixed spaced text font
.TP
$buttonAtts
attributes used for buttons
.TP
$backGround
back ground color
.TP
$highLight
attributes for emphasized text portions (typically colors)
.TP
$roColors
attributes for non emphasized text (typically colors)
.TP
$infoColors
attributes of the info line (typically colors)
.TP
$menueAtts 
attributes of pull down menues (typically colors)
.TP
@textActions
default actions for text widgets

.SH FILES 
.PP
.EX 0
$HOME/incoming
$WAFELIB/system.waferc
$HOME/.waferc
.EE
.SH "SEE ALSO"
.PP
wafe(n),
wafeapp(n),
X(1),
xwafemail(n),
xwafenews(n),
xwafeftp(n),
xwafeora(n),
xwafetel(n),
xdirtree(n),
xdirtree(n),
xprojektor(n),
xbm(n),
xwafemc(n),
xruptimes(n),
xnetstats(n),
xiostats(n),
xvmstats(n),
xwafeping(n),
xwafecf(n)

.SH COPYRIGHT
.PP
 Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
.EX 0
     Wirtschaftsuniversitaet Wien, 
     Abteilung fuer Wirtschaftsinformatik
     Augasse 2-6, 
     A-1090 Vienna, Austria
     neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
.EE
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appears in all copies and that both that
copyright notice and this permission notice appear in all supporting
documentation.  This software is provided "as is" without expressed or
implied warranty.
.PP
.SH AUTHORS
.PP
Gustaf Neumann, Stefan Nusser
