/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser
 * Version: 0.9
 */

/*
 * Additional code for asciiText Widget
 *
 */

#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Text.h>

#include "wafe.h"

int
com_asciiTextAppend(clientData, comInterpreter, argc, argv)
ClientData     clientData;
Tcl_Interp    *comInterpreter;
int            argc;
char         **argv;
     {
     Widget    text;
     char     *string;
     char     *newString;

     DBUG_ENTER("asciiTextAppend");

     if (argc != 3)
          {
          fprintf(stderr, "asciiTextAppend: Wrong # of Args");
          DBUG_RETURN(TCL_ERROR);
          }

     if (!(text = name2Widget(argv[1])))
          DBUG_RETURN(TCL_ERROR);

     XtVaGetValues(text, XtNstring, &string, NULL);

     if (string)
          {
          newString = XtMalloc(strlen(string) + strlen(argv[2]) +2);
          strcpy(newString, string);
          strcat(newString, argv[2]);  
	  }
     else
          newString = XtNewString(argv[2]);

     XtVaSetValues(text, XtNstring, newString, NULL);

     XtFree(newString);

     DBUG_RETURN(TCL_OK);
     }
     
