#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

/* All R4 include Files */

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Grip.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/StripChart.h>
#include <X11/Xaw/Clock.h>
#include <X11/Xaw/Logo.h>

#include <X11/Xaw/Toggle.h>

#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Mailbox.h>

#include <X11/Xaw/AsciiText.h>

#include <X11/Xaw/Box.h>

#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <X11/Shell.h>

#include "wafe.h"

/* R5 includefiles if necessary */

#ifndef PRER5

#include <X11/Xaw/Porthole.h>
#include <X11/Xaw/Tree.h>
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Repeater.h>

#endif

extern void scInit(
#if NeedFunctionPrototypes
Widget, char*
#endif
); 

extern void checkArgs4String(
#if NeedFunctionPrototypes
Widget, ArgList, int
#endif
);

/*
 * The following defines the number of elements in the resourceList, which is used 
 * to associate the WidgetClass with the resourceList as returned by 
 * XtGetResourceList. It must NEVER be less than the number of widgets plus one!!
 */

#define RESLISTELEMENTS 35

typedef struct 
     {
     WidgetClass         *wClass;
     XtResourceList     resources;
     } RESINFO;

RESINFO  resourceList[RESLISTELEMENTS];


typedef struct _WidgetInfo
     {
     char          *name;
     WidgetClass   *wClass;
     }  WIDGETINFO;



/* This lists will be used to creat the different widget commands.
 */

WIDGETINFO  widgetsR4[30] = {                           /* *** R4 widgets ***/
     {"command",          &commandWidgetClass},         /* SIMPLE WIDGETS */
     {"grip",             &gripWidgetClass},
     {"label",            &labelWidgetClass},
     {"list",             &listWidgetClass},
     {"stripChart",&stripChartWidgetClass},
     {"mailbox",          &mailboxWidgetClass},
     {"scrollbar",        &scrollbarWidgetClass},
     {"simple",           &simpleWidgetClass},
     {"clock",           &clockWidgetClass},
     {"logo",           &logoWidgetClass},
     {"toggle",           &toggleWidgetClass},
     {"simpleMenu",       &simpleMenuWidgetClass},     /* MENU WIDGETS */
     {"smeBSB",           &smeBSBObjectClass},
     {"smeLine",          &smeLineObjectClass},
     {"sme",              &smeObjectClass},
     {"menuButton",       &menuButtonWidgetClass},
     {"asciiText",        &asciiTextWidgetClass},      /* TEXT WIDGET */
     {"box",              &boxWidgetClass},            /* COMPOSITE WIDGETS */
     {"dialog",           &dialogWidgetClass},         /* CONSTRAINT WIDGETS */
     {"form",             &formWidgetClass},
     {"paned",            &panedWidgetClass},
     {"viewport",         &viewportWidgetClass},
     {"transientShell",   &transientShellWidgetClass}, /* SHELL WIDGETS */ 
     {"overrideShell",    &overrideShellWidgetClass},
     {"topLevelShell",    &topLevelShellWidgetClass},
     {NULL,               NULL}};

#ifndef PRER5

WIDGETINFO widgetsR5[5] = {                            /* *** R5 widgets ***/
     {"panner",           &pannerWidgetClass},
     {"repeater",         &repeaterWidgetClass},   
     {"porthole",         &portholeWidgetClass},
     {"tree",             &treeWidgetClass},
     {NULL,               NULL}};

#endif











