/*
** ui_tools.c
**
*/
#include <stdio.h>
#if SYSV_INCLUDES
#	include <memory.h>
#endif
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xew/Frame.h>
#include <X11/Xew/TextEd.h>

#include "ui_tools.h"

/*
** ***************************************************************
** For documentation of the global UI_ functions, see "ui_tools.h"
** ***************************************************************
*/
void UI_Quit(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	XtDestroyApplicationContext(XtWidgetToApplicationContext(w));
	exit(0);
    }

void UI_Popdown(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	while (!XtIsShell(w))
		w = XtParent(w);
	XtPopdown(w);
    }

/*
** UI_PopupCentered (modified from MIT editres client)
*/
void UI_PopupCentered(event, w, mode)
XEvent * event;
Widget w;
XtGrabKind mode;
    {
	Boolean get_from_cursor = FALSE;
	Arg args[5];
	Cardinal num_args;
	Dimension width, height, b_width;
	Position x0, y0;
	int x, y, max_x, max_y;
	
	XtRealizeWidget(w);
	
	num_args = 0;
	XtSetArg(args[num_args], XtNwidth, &width); num_args++;
	XtSetArg(args[num_args], XtNheight, &height); num_args++;
	XtSetArg(args[num_args], XtNborderWidth, &b_width); num_args++;
	XtSetArg(args[num_args], XtNx, &x0); num_args++;
	XtSetArg(args[num_args], XtNy, &y0); num_args++;
	XtGetValues(w, args, num_args);

	if (x0 <= 0 || y0 <= 0)
	    {
		if (event == NULL)
			get_from_cursor = TRUE;
		else
		    {
			switch (event->type)
			    {
			    case ButtonPress:
			    case ButtonRelease:
				x = event->xbutton.x_root;
				y = event->xbutton.y_root;
				break;
			    case KeyPress:
			    case KeyRelease:
				x = event->xkey.x_root;
				y = event->xkey.y_root;
				break;
			    default:
				get_from_cursor = TRUE;
				break;
			    }
		    }
		if (get_from_cursor)
		    {
			Window root, child;
			int win_x, win_y;
			unsigned int mask;

			XQueryPointer(XtDisplay(w), XtWindow(w), &root,
				      &child, &x, &y, &win_x, &win_y, &mask);
		    }
		width += 2 * b_width;
		height += 2 * b_width;
		x -= ((int) width/2);
		if (x < 0) 
			x = 0;
		if ( x > (max_x = (int) (XtScreen(w)->width - width)) )
			x = max_x;
		y -= ( (Position) height/2 );
		if (y < 0) 
			y = 0;
		if ( y > (max_y = (int) (XtScreen(w)->height - height)) )
			y = max_y;
		num_args = 0;
		XtSetArg(args[num_args], XtNx, x); num_args++;
		XtSetArg(args[num_args], XtNy, y); num_args++;
		XtSetValues(w, args, num_args);
	    }
	XtPopup(w, mode);
    }

void UI_WarningMessage(parent, panel,
		     name, type, class, defaultp, params, num_params)
Widget parent;
UI_PanelDef *panel;
String name, type, class, defaultp;
String *params;
Cardinal *num_params;
    {
	char buffer[1000];
	static char message[1000];
	
	XtGetErrorDatabaseText(name,type,class,defaultp,buffer,sizeof(buffer));
	if (params && num_params && *num_params > 0)
	    {
		int i = *num_params, j;
		String par[10];
		if (i > 10)
			i = 10;
		for (j = 0; j < i; j++)
			par[j] = params[j];
		while (i < 10)
			par[i++] = NULL;
		sprintf(message, buffer,
			par[0], par[1], par[2], par[3], par[4],
			par[5], par[6], par[7], par[8], par[9]);
	    }
	else
		strncpy((char *)message, buffer, sizeof(message));
	panel->heading = message;
	UI_PopupPanel(parent, (XtPointer)panel, (XtPointer)NULL);
    }

static void RelayAction(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	Widget target = (Widget)client_data;
	XeNotifyCallbackData *data = (XeNotifyCallbackData *)call_data;
	if (!target || !data || data->reason != XeCR_NOTIFY)
    		return;
       	if (data->num_params > 0)
	      	XtCallActionProc(target, data->params[0], data->event,
				 data->params+1, data->num_params - 1);
    }

static void ToggleNotify(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
       	Arg tmp[1];
       	Boolean state;

	XtSetArg(tmp[0], XtNinvertShadow, (call_data != NULL));
	XtSetValues(w, tmp, 1);
    }
	
static Widget CreateToggleElement(parent, name, args, n)
Widget parent;
char *name;
Arg *args;
int n;
    {
	Widget box, toggle;

	XtSetArg(args[n], XtNallowEdit, False); ++n;
	box = XtCreateManagedWidget
		("toggleBox", xeTextEdWidgetClass, parent, args, n);
	XeTextDisableDisplay(box);      
	n = 0;
	XtSetArg(args[n], XtNlabel, " "); ++n;
	toggle = XtCreateManagedWidget
		("toggleButton", toggleWidgetClass, box, args, n);
       	XtAddCallback(toggle, XtNcallback, ToggleNotify, (XtPointer)NULL);
	XeTextInsert(box, name, strlen(name));       
	XtInstallAccelerators(box, toggle);
	XtAddCallback(box,XtNnotifyCallback,RelayAction,(XtPointer)toggle);
	XeTextEnableDisplay(box);      
	return toggle;
    }

/*
** CreateInputElement
*/
static Widget CreateInputElement(parent, prompt, init, args, n)
Widget parent;
char *prompt, *init;
Arg *args;
int n;
    {
	Widget box, input;

	XtSetArg(args[n], XtNallowEdit, False); ++n;
	box = XtCreateManagedWidget
		("inputBox", xeTextEdWidgetClass, parent, args, n);
	XeTextDisableDisplay(box);      
	XeTextInsert(box, prompt, strlen(prompt));      
	n = 0;
	XtSetArg(args[n], XtNresize, True); ++n;
	XtSetArg(args[n], XtNexportFormat, XeTextExport_STRING); ++n;
	if (init)
	    {
		XtSetArg(args[n], XtNcontentString, init); ++n;
		XtSetArg(args[n], XtNcontentLength, strlen(init)); ++n;
	    }
#ifdef USING_MOTIF_122
	input = XeCreateMotifTextEd("inputArea", box, args, n);
#else

	input = XtCreateManagedWidget
		("inputArea", xeTextEdWidgetClass, box, args, n);
#endif
	XtSetKeyboardFocus(box, input);
	XeTextEnableDisplay(box);
	return input;
    }

/*
** GetXtArgVal
**	Do the magic (Ugh?) juggling with XrmValue and return a proper
**	XtArgVal
*/
XtArgVal GetXtArgVal(from)
XrmValue *from;
    {
	if (from->size == 0)
		return 0;
	/* Ugh.. --msa */
	if (sizeof(XtArgVal) < from->size)
		return (XtArgVal)from->addr;
	else if (from->size == sizeof(long))
		return (XtArgVal)(*(long *)from->addr);
	else if (from->size == sizeof(int))
		return (XtArgVal)(*(int *)from->addr);
	else if (from->size == sizeof(short))
		return (XtArgVal)(*(short *)from->addr);
	else if (from->size == sizeof(char))
		return (XtArgVal)(*(char *)from->addr);
	else if (from->size == sizeof(XtPointer))
		return (XtArgVal)*((XtPointer *)from->addr);
	return (XtArgVal)(*(char **)from->addr);
    }

/*
** GetResourceList
**	Get all resources applicable to the widget. Combine normal
**	and constraint resources into a single table.
*/
static void GetResourceList(w, rlist, num)
Widget w;
XtResourceList  *rlist;
Cardinal *num;
    {
	XtResourceList clist = NULL;
	Cardinal cnum = 0;

	XtGetResourceList(XtClass(w), rlist, num);
	if (XtParent(w) != NULL)
		XtGetConstraintResourceList(XtClass(XtParent(w)),&clist,&cnum);
	if (*num == 0 || *rlist == NULL)
	    {
		*rlist = clist;
		*num = cnum;
	    }
	else if (cnum > 0)
	    {
		*rlist = (XtResourceList)XtRealloc
			((char *)*rlist, sizeof(**rlist) * (*num + cnum));
		memcpy((char*)(*rlist+*num),(char*)clist,sizeof(**rlist)*cnum);
		*num += cnum;
		XtFree((char *)clist);
	    }
    }

typedef struct BigVal
    {
	struct BigVal *next;
	char value[100];
    } BigVal;

/*
** ConvertXtArgVal
**	arg->value is a pointer to string which must be converted to the
**	real resource value.
**
**	Return FALSE, if convert fails.
*/
static int ConvertXtArgVal(w, rlist, num, arg, big)
Widget w;		/* Widget context */
XtResourceList *rlist;	/* Resource List */
Cardinal *num;		/* Number of resources */
Arg *arg;		/* Arg to process */
BigVal **big;
    {
	XrmValue from, to;
	XtResourceList r, last;

	from.size = strlen((char *)arg->value)+1;
	from.addr = (XtPointer)arg->value;
	arg->value = 0;
	
	if (!*rlist)
		GetResourceList(w, rlist, num);
	if (*rlist == NULL || *num == 0)
		return;
	/*
	** Locate the resource to find out the representation size
	*/
	for (r = *rlist, last = &r[*num]; r < last; r++)
		if (strcmp(arg->name, r->resource_name) == 0)
		    {
			XtArgVal tmp;

			if (r->resource_size > sizeof(XtArgVal))
			    {
				BigVal *b = (BigVal *)XtMalloc
					(XtOffsetOf(BigVal, value[0]) +
					 r->resource_size);
				b->next = *big;
				*big = b;
				to.size = r->resource_size;
				to.addr = (XtPointer)&b->value[0];
			    }
			else
			    {
				to.size = sizeof(XtArgVal);
				to.addr = (XtPointer)&tmp;
			    }
			if (!XtConvertAndStore(w, XtRString, &from,
					       r->resource_type, &to))
				return False;
			arg->value = GetXtArgVal(&to);
			break;
		    }
	return True;
    }


void UI_AcceptPanel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	UI_PanelDef *panel = (UI_PanelDef *)client_data;
	UI_ElementDef *r;
	XtArgVal value;
	int need_convert;
	String s;
	Arg args[20];
	int n, i;
	XtResourceList resources = NULL;
	Cardinal num_resources = 0;
	BigVal *big_values = NULL, *big;

	static long null_value = 0;

	if (!panel || !panel->target)
		return;	/* Nothing to load */

	value = 0;
	need_convert = 0;
	s = NULL;
	n = 0;
	for (r = panel->elements; r && r->op != UI_EndOp; ++r)
		switch (r->op)
		    {
		    case UI_InputOp:
			value = 0;
			need_convert = 0;
			if (r->widget)
			    {
				long length;
				XtFree((char *)s);
				s = XeTextGetString(r->widget, &length);
				value = (XtArgVal)(s ? s : "");
				need_convert = True;
			    }
			break;
		    case UI_ToggleOp:
			value = 0;
			need_convert = 0;
			/* Fall to RADIO handling */
		    case UI_RadioOp:
			if (r->widget)
			    {
				Arg tmp[1];
				Boolean state;

				XtSetArg(tmp[0], XtNstate, &state);
				XtGetValues(r->widget, tmp, 1);
				if (state)
					value = r->data;
			    }
			break;
		    case UI_LoadOp:
			if (r->name)
			    {
				if (n == XtNumber(args))
				    {
					XtSetValues(panel->target, args, n);
					n = 0;
				    }
				args[n].name = r->name;
				args[n].value = value;
				if (!need_convert ||
				    ConvertXtArgVal
				    (panel->target, &resources,
				     &num_resources, &args[n], &big_values))
					n += 1;
			    }
			break;
		    default:
			break;
		    }
	if (n && panel->target)
		XtSetValues(panel->target, args, n);
	while (big_values)
	    {
		BigVal *b = big_values->next;
		XtFree((char *)big_values);
		big_values = b;
	    }
	XtFree((char *)s);
	XtFree((char *)resources);
    }


int UI_GetStrings(panel, str, num_str)
UI_PanelDef *panel;
char **str;
int num_str;
    {
	int n = 0;
	UI_ElementDef *r;

	if (!panel || str == NULL)
		return 0; /* Hmf! an error in application, most likely --msa */
	for (r = panel->elements; r && r->op != UI_EndOp && n < num_str; ++r)
		if (r->op == UI_InputOp)
		    {
			long length;
			if (r->widget)
				*str++ = XeTextGetString(r->widget, &length);
			else
				*str++ = NULL;
			n += 1;
		    }
	return n;
    }
/*
** SetElementValue
**	Initialize panel element value from the widget resource
*/
static void SetElementValue(w, r, p, rlist, num)
Widget w;
UI_ElementDef *r;	/* UI_LoadOp element pointer */
UI_ElementDef *p;	/* p < r, points to some source element */
XtResourceList *rlist;
Cardinal *num;
    {
	XtPointer value;
	Widget t = p->widget;
	char buf[20];
	XtResourceList rl, last;
	XtArgVal argval;
	XrmValue ref, to;

	if (p == NULL || r->name == NULL || !w || !t)
		return;	/* Nothing to load. */
	if (!*rlist)
		GetResourceList(w, rlist, num);
	if (*rlist == NULL || *num == 0)
		return;
	/*
	** Locate the resource to find out the representation size
	*/
	for (rl = *rlist, last = &rl[*num];;)
		if (strcmp(r->name, rl->resource_name) == 0)
			break;
		else if (++rl == last)
			return; /* No resource found */
	value = (XtPointer)XtMalloc(rl->resource_size);
	XtVaGetValues(w, r->name, value, NULL);
	ref.size = rl->resource_size;
	ref.addr = value;
	argval = GetXtArgVal(&ref);
	switch (p->op)
	    {
	    case UI_ToggleOp:
	    case UI_RadioOp:
		/*
		** Set matching radio/toggle button
		*/
		while (p < r && p->data != argval)
			p++;
		if (p == r)
			XawToggleUnsetCurrent(t);
		else
			XawToggleSetCurrent(t, p);
		break;
	    case UI_InputOp:
		/*
		** Load resource value into input element
		*/
		to.size = 0;
		to.addr = NULL;
		if (!XtConvertAndStore(w, rl->resource_type, &ref,
				       XtRString, &to))
			printf("Failed to convert %s to %s\n",
			       rl->resource_type, XtRString);
		XeTextReplace(t, 0L, 200000L, (char *)to.addr, to.size);
		break;
	    default:
		break;
	    }
	XtFree((char *)value);
    }


/*
** UI_SetToggles
**	This functions goes through panel and attempts to match the
**	initial values of the toggle/radio groups with the actual
**	resource settings in effect.
**
**	This function is a kludge, works only if toggle/radio and load
**	operations follow a specific pattern used by this application.
*/
void UI_SetToggles(panel)
UI_PanelDef *panel;
    {
	UI_ElementDef *r, *p;
	XtResourceList resources = NULL;
	Cardinal num_resources = 0;

	for (r = panel->elements, p = NULL; r && r->op != UI_EndOp; ++r)
		switch (r->op)
		    {
		    case UI_InputOp:
			p = r;
			break;
		    case UI_ToggleOp:
			p = r;
			break;
		    case UI_LoadOp:
			SetElementValue(panel->target, r, p,
					&resources, &num_resources);
			p = NULL;
			break;
		    default:
			break;
		    }
	XtFree((char *)resources);
    }

static Widget CreateElementPanel(parent, name, definition)
Widget parent;
char *name;
UI_ElementDef *definition;
    {
	Arg args[20];
	int n;
	Widget panel, pane, radio = 0;
	char *s;
	UI_ElementDef *r;

	n = 0;
	XtSetArg(args[n], XtNlayoutPath, 0); ++n;
	pane = panel = XtCreateManagedWidget
		(name, xeFrameWidgetClass, parent, args, n);
	for (r = definition; r && r->name; r++)
		switch (r->op)
		    {
		    case UI_PaneOp:
			n = 0;
			XtSetArg(args[n], XtNlayoutPath, 270); ++n;
			pane = XtCreateManagedWidget
				("pane", xeFrameWidgetClass, panel, args, n);
			/* FALL THROUGH TO LABEL Handling */
		    case UI_LabelOp:
			n = 0;
			XtSetArg(args[n],XtNcontentString,r->name); ++n;
			XtSetArg(args[n],XtNcontentLength,strlen(r->name));++n;
			r->widget = XtCreateManagedWidget
				("labelBox", xeTextWidgetClass, pane, args, n);
			break;
		    case UI_ToggleOp:
		    case UI_RadioOp:
			n = 0;
			r->widget = CreateToggleElement(pane,r->name,args,n);
			n = 0;
			XtSetArg(args[n], XtNradioData, r); ++n;
			XtSetValues(r->widget, args, n);
			XawToggleChangeRadioGroup
				(r->widget,
				 r->op == UI_RadioOp ? radio : r->widget);
			radio = r->widget;
			break;
		    case UI_InputOp:
			n = 0;
			r->widget = CreateInputElement
				(pane, r->name, NULL, args, n);
			break;
			
		    default:
			break;
		    }
	return panel;
    }

static Widget CreateBottomPanel(parent, name, actions)
Widget parent;
char *name;
UI_ActionDef *actions;
    {
	int n;
	Arg args[3];
	Widget box, but;
	int have_popdown = 0;
	XtCallbackProc callback;

	n = 0;
	XtSetArg(args[n], XtNlayoutPath, 0); ++n;
	box = XtCreateManagedWidget(name, xeFrameWidgetClass,parent,args,n);
	for (;actions && actions->name; ++actions)
	    {
		n = 0;
		XtSetArg(args[n], XtNlabel, actions->name); ++n;
		but = XtCreateManagedWidget
			("actionBox", commandWidgetClass, box, args, n);
		callback = actions->callback;
		/*
		** if callback is not given, assume this is to be the popdown
		** action with user defined label (this gives the application
		** a way to override the default popdown label "ok".
		*/
		if (callback == NULL)
		    {
			callback = UI_Popdown;
			have_popdown = 1;
		    }
		XtAddCallback(but,XtNcallback,callback,actions->client_data);
	    }
	/*
	** Implicitly add "popdown" button, if not added by the user
	*/
	if (!have_popdown)
	    {
		n = 0;
		XtSetArg(args[n], XtNlabel, "ok"); ++n;
		but = XtCreateManagedWidget
			("actionBox", commandWidgetClass, box, args, n);
		XtAddCallback(but, XtNcallback, UI_Popdown, (XtPointer)parent);
	    }
    }

void UI_PopupPanel(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
    {
	UI_PanelDef *panel = (UI_PanelDef *)client_data;
	Widget close, pane;
	Cardinal n;
	Arg args[2];
	char *label;

	if (panel->heading)
		label = panel->heading;
	else if (panel->target)
		label = XtName(panel->target);
	else
		label = panel->name;
	if (!panel->shell)
	    {
		/*
		** Some widgets just cannot work as popup parents for
		** some reason.. just lookup for shell and hope it works
		** ... (maybe someday I get to know why... --msa)
		*/
		while (XtParent(w) && !XtIsShell(w))
			w = XtParent(w);
		panel->shell = XtCreatePopupShell
			(panel->name, transientShellWidgetClass, w, NULL, 0);
		n = 0;
		XtSetArg(args[n], XtNlayoutPath, 270); ++n;
		pane = XtCreateManagedWidget
			("panel", xeFrameWidgetClass, panel->shell, args, n);
		n = 0;
		XtSetArg(args[n], XtNlabel, label); ++n;
		panel->label = XtCreateManagedWidget
			("top",labelWidgetClass, pane, args, n);
		CreateElementPanel(pane, "middle", panel->elements);
		CreateBottomPanel(pane, "bottom", panel->actions);
		UI_SetToggles(panel);
	    }
	else if (label && panel->label)
	    {
		n = 0;
		XtSetArg(args[n], XtNlabel, label); ++n;
		XtSetValues(panel->label, args, n);
	    }
	UI_PopupCentered(NULL, panel->shell, XtGrabNone);
    }

void UI_CreateMenu(parent, menu)
Widget parent;
UI_MenuDef *menu;
    {
	UI_MenuItemDef *item = menu->items;

	menu->button = XtVaCreateManagedWidget
		("menuButton", menuButtonWidgetClass, parent,
		 XtNlabel, menu->name,
		 (XtPointer)NULL);
	menu->menu = XtCreatePopupShell
		("menu", simpleMenuWidgetClass, menu->button, NULL, 0);
	for ( ;item->name; item++)
	    {
		item->entry = XtCreateManagedWidget
			(item->name, smeBSBObjectClass, menu->menu, NULL, 0);
		XtAddCallback(item->entry, XtNcallback, item->callback,
			      item->client_data);
	    }
    }

/*
** ***********************************
** RESOURCE VALUE TO STRING CONVERTERS
** ***********************************
** These converters are quick and dirty. Not much consideration has been
** put into efficiency or error conditions, overflow of the temporary
** string buffer (cvt_buf) is not prevented (it just should not happen!)
*/

static char cvt_buf[1000];
static int  cvt_guard = -1; /* ..just if someone wants to detect overflow */

/*
** CtStringDone
**	A common return function for all String converters.
**
**	The string parameter 's' must really be a pointer to static
**	storage!!!
*/
static Boolean CvtStringDone(s, to)
char *s;
XrmValue *to;
    {
	int n = strlen(s) + 1;

	if (to->addr != NULL)
	    {
		if (to->size < n)
		    {
			to->size = n;
			return False;
		    }
		memcpy((char *)to->addr, s, n);
	    }
	else
		to->addr = s;
	to->size = n;
	return True;
    }

Boolean CvtInt_String(display, args, num_args, from, to, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from, *to;
XtPointer *converter_data;
    {
	sprintf(cvt_buf, "%d", (int)GetXtArgVal(from));
	return CvtStringDone(cvt_buf, to);
    }

Boolean CvtLong_String(display, args, num_args, from, to, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from, *to;
XtPointer *converter_data;
    {
	sprintf(cvt_buf, "%ld", (long)GetXtArgVal(from));
	return CvtStringDone(cvt_buf, to);
    }


Boolean CvtPixel_String(display, args, num_args, from, to, converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from, *to;
XtPointer *converter_data;
    {
	Colormap cmap;
	XColor query;
	
	if (*num_args > 0)
	    {
		cmap = *((Colormap *)args[0].addr);
		query.pixel = (long)GetXtArgVal(from);
		XQueryColor(display, cmap, &query);
		sprintf(cvt_buf, "#%4.4X%4.4X%4.4X",
			(int)query.red, (int)query.green, (int)query.blue);
		return CvtStringDone(cvt_buf, to);
	    }
	else
		return CvtStringDone("<Error>", to);
    }

Boolean CvtItemization_String(display, args, num_args, from, to,converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from, *to;
XtPointer *converter_data;
    {
	XeItemization *item = (XeItemization *)GetXtArgVal(from);

	if (item == NULL)
		return CvtStringDone("none", to);
	sprintf(cvt_buf, "%s,%d,%d",
		item->identifier_alignment == XeAlignment_START ? "start":
		item->identifier_alignment == XeAlignment_END ? "end" :
		"none",
		(int)item->identifier_start_offset,
		(int)item->identifier_end_offset);
	return CvtStringDone(cvt_buf, to);
    }


Boolean CvtLineLayoutTable_String
	(display, args, num_args, from, to,converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from, *to;
XtPointer *converter_data;
    {
	XeTabStop *tabs = (XeTabStop *)GetXtArgVal(from);
	char *s;
	int i;

	if (tabs == NULL)
		return CvtStringDone("", to);
	for (s = cvt_buf, i = 0; tabs[i].reference >= 0; ++i)
	    {
		if (i)
			*s++ = ';';
		sprintf(s, "%d", (int)tabs[i].position);
		s += strlen(s);
		if (tabs[i].reference != (i + 1))
		    {
			sprintf(s, "#%d", (int)tabs[i].reference);
			s += strlen(s);
		    }
		if (tabs[i].alignment == XeAlignment_START)
			continue;
		sprintf(s, ",%s",
			tabs[i].alignment == XeAlignment_AROUND ? "around":
			tabs[i].alignment == XeAlignment_CENTER ? "center":
			tabs[i].alignment == XeAlignment_END ? "end" :
			"start");
		s += strlen(s);
		if (tabs[i].alignment == XeAlignment_AROUND)
		    {
			sprintf(s, ",\"%s\"", tabs[i].alignment_string);
			s += strlen(s);
		    }
	    }
	*s = 0;
	return CvtStringDone(cvt_buf, to);
    }

Boolean CvtFramePosition_String(display,args,num_args,from,to,converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from, *to;
XtPointer *converter_data;
    {
	char *s;
	XeFramePosition *pos = (XeFramePosition *)from->addr;

	if (pos == NULL)
		s = "";
	else if (pos->type == XeFramePositionType_FIXED)
	    {
		sprintf(cvt_buf, "%d,%d", (int)pos->x, (int)pos->y);
		s = cvt_buf;
	    }
	else if (pos->type == XeFramePositionType_REVERSE)
		s = "reverse";
	else if (pos->type == XeFramePositionType_NORMAL)
		s = "normal";
	else if (pos->type == XeFramePositionType_INLINE)
		s = "inline";
	else if (pos->type == XeFramePositionType_START)
		s = "start";
	else if (pos->type == XeFramePositionType_END)
		s = "end";
	else
		s = "unknown";
	return CvtStringDone(s, to);
    }

Boolean CvtFrameAlignment_String(display,args,num_args,from,to,converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from, *to;
XtPointer *converter_data;
    {
	char *s;
	XeFrameAlignment *align = (XeFrameAlignment *)from->addr;
	if (align == NULL)
		s = "";
	else if (*align == XeFrameAlignment_RIGHT)
		s = "right";
	else if (*align == XeFrameAlignment_CENTER)
		s = "center";
	else if (*align == XeFrameAlignment_LEFT)
		s = "left";
	else if (*align == XeFrameAlignment_TOP)
		s = "top";
	else if (*align == XeFrameAlignment_BOTTOM)
		s = "bottom";
	else if (*align == XeFrameAlignment_ABOVE)
		s = "above";
	else if (*align == XeFrameAlignment_AROUND)
		s = "around";
	else if (*align == XeFrameAlignment_BELOW)
		s = "below";
	else
		s = "uknown";
	return CvtStringDone(s, to);
    }

Boolean CvtFrameDimension_String(display,args,num_args,from,to,converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from, *to;
XtPointer *converter_data;
    {
	XeFrameDimension *dim = (XeFrameDimension *)from->addr;

	if (dim == NULL)
		return CvtStringDone("max", to);
	else if (dim->value > 0)
		sprintf(cvt_buf, "%d", (int)dim->value);
	else
		sprintf(cvt_buf, "%s,%d,%d",
			dim->value == XeFrameDimension_RULE_A ? "rule-a" :
			dim->value == XeFrameDimension_RULE_B ? "rule-b" :
			"max",
			(int)dim->min, (int)dim->max);
	return CvtStringDone(cvt_buf, to);
    }

Boolean CvtFrameBorder_String(display,args,num_args,from,to,converter_data)
Display *display;
XrmValue *args;
Cardinal *num_args;
XrmValue *from, *to;
XtPointer *converter_data;
    {
	XeFrameBorder *border = (XeFrameBorder *)from->addr;
	XColor query;

	if (border == NULL)
		return CvtStringDone("", to);
	sprintf(cvt_buf, "%s,%d,%d,#%2.2X%2.2X%2.2X",
		border->type == XeBorderType_SOLID ? "solid" :
		border->type == XeBorderType_DASHED ? "dashed" :
		border->type == XeBorderType_DOT ? "dot" :
		border->type == XeBorderType_DASH_DOT ? "dash-dot" :
		border->type == XeBorderType_DASH_DOT_DOT ? "dash-dot-dot" :
		border->type == XeBorderType_SHADOW ? "shadow" :
		"invisible",
		(int)border->width,
		(int)border->space,
		(int)border->color[0],
		(int)border->color[1],
		(int)border->color[2]);
	return CvtStringDone(cvt_buf, to);
    }

/*
** UI_Initialize
**	Currently this is only needed to register some type converters
*/
void UI_Initialize(app)
XtAppContext app;
    {
	static XtConvertArgRec cvt_pixel[] =
	    {
		{XtResourceString, (XtPointer)XtNcolormap, sizeof(Colormap)},
	    };
	
	XtAppSetTypeConverter
		(app, XtRInt, XtRString, CvtInt_String,
		 (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL);
	XtAppSetTypeConverter
		(app, XtRLong, XtRString, CvtLong_String,
		 (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL);
	XtAppSetTypeConverter
		(app, XtRDimension, XtRString, CvtInt_String,
		 (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL);
	XtAppSetTypeConverter
		(app, XtRPosition, XtRString, CvtInt_String,
		 (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL);
	XtAppSetTypeConverter
		(app, XtRPixel, XtRString, CvtPixel_String,
		 cvt_pixel,XtNumber(cvt_pixel),XtCacheNone,(XtDestructor)NULL);
	XtAppSetTypeConverter
		(app, XtRXeItemization, XtRString, CvtItemization_String,
		 (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL);
	XtAppSetTypeConverter
		(app,XtRXeLineLayoutTable,XtRString,CvtLineLayoutTable_String,
		 (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL);
	XtAppSetTypeConverter
		(app, XeRFrameDimension, XtRString, CvtFrameDimension_String,
		 (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL);
	XtAppSetTypeConverter
		(app, XeRFramePosition, XtRString, CvtFramePosition_String,
		 (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL);
	XtAppSetTypeConverter
		(app, XeRFrameAlignment, XtRString, CvtFrameAlignment_String,
		 (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL);
	XtAppSetTypeConverter
		(app, XeRFrameBorder, XtRString, CvtFrameBorder_String,
		 (XtConvertArgList)NULL, 0, XtCacheNone, (XtDestructor)NULL);
    }





