/*
** text_panel.c
**	This file simply exists to save maintenance problems. It is just
**	included into demo programs that require easy access to text
**	resources.
*/

static UI_ElementDef text_list[] =
    {
	UI_PANE(" "),
	UI_TOGGLE("wrap lines",		True),
	UI_LOAD(XtNformat),
	UI_TOGGLE("proportional spacing", True),
	UI_LOAD(XtNproportional),
	UI_INPUT("line spacing:"),
	UI_LOAD(XtNlineSpacing),
	UI_INPUT("indentation:"),
	UI_LOAD(XtNindentation),
	UI_INPUT("first line offset:"),
	UI_LOAD(XtNfirstLineOffset),
	UI_INPUT("itemization:"),
	UI_LOAD(XtNitemization),
	UI_INPUT("line layout table:"),
	UI_LOAD(XtNlineLayoutTable),
	UI_INPUT("column width:"),
	UI_LOAD(XtNcolumnWidth),
	UI_PANE("Default Alignment:"),
	UI_TOGGLE("start (ragged right)",XeAlignment_START),
	UI_RADIO("end (ragged left)",	XeAlignment_END),
	UI_RADIO("centered",		XeAlignment_CENTER),
	UI_RADIO("justified",		XeAlignment_JUSTIFIED),
	UI_LOAD(XtNalignment),

	UI_LABEL("Framed rendition:"),
	UI_INPUT("left: "),
	UI_LOAD(XtNframeLeftRendition),
	UI_INPUT("right: "),
	UI_LOAD(XtNframeRightRendition),
	UI_INPUT("top: "),
	UI_LOAD(XtNframeTopRendition),
	UI_INPUT("bottom: "),
	UI_LOAD(XtNframeBottomRendition),

	UI_TOGGLE("invert shadow",	True),
	UI_LOAD(XtNframeInvertShadow),

	UI_PANE("Export format:"),
	UI_TOGGLE("string",		XeTextExport_STRING),
	UI_RADIO("string (F)",		XeTextExport_STRING_F),
	UI_RADIO("character odif",	XeTextExport_ODIF),
	UI_RADIO("character odif (F)",	XeTextExport_ODIF_F),
	UI_RADIO("character odif (FP)",	XeTextExport_ODIF_FP),
	UI_LOAD(XtNexportFormat),
	UI_END(),
    };

extern UI_PanelDef text_resources;

static UI_ActionDef text_actions[] =
    {
	{"set",	UI_AcceptPanel,	(XtPointer)&text_resources},
	{"close"},
	{NULL,},
    };


static UI_PanelDef text_resources =
    {
	"Paragraph settings",
	text_list,
	text_actions,
    };
